/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.menu;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.menu.model.ItemCreator;
import sk.adonikeoffice.epicchat.lib.menu.tool.Tool;

final class ToggleableTool {
    private final ItemStack item;
    private boolean playerHasTool = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ToggleableTool(Object unparsed) {
        if (unparsed != null) {
            if (unparsed instanceof ItemStack) {
                this.item = (ItemStack)unparsed;
                return;
            } else if (unparsed instanceof Tool) {
                this.item = ((Tool)unparsed).getItem();
                return;
            } else if (unparsed instanceof Number && ((Number)unparsed).intValue() == 0) {
                this.item = new ItemStack(Material.AIR);
                return;
            } else {
                if (!(unparsed instanceof Class) || !Tool.class.isAssignableFrom((Class)unparsed)) throw new FoException("Unknown tool: " + unparsed + " (we only accept ItemStack, Tool's instance or 0 for air)");
                this.item = ((Tool)ReflectionUtil.invokeStatic((Class)unparsed, "getInstance", new Object[0])).getItem();
            }
            return;
        } else {
            this.item = new ItemStack(Material.AIR);
        }
    }

    ItemStack get(Player player) {
        this.update(player);
        return this.playerHasTool ? this.getToolWhenHas() : this.getToolWhenHasnt();
    }

    private void update(Player pl) {
        this.playerHasTool = pl.getOpenInventory().getBottomInventory().containsAtLeast(this.item, 1);
    }

    private ItemStack getToolWhenHas() {
        return ItemCreator.of(this.item).glow(true).lore("", "&6You already have this item.", "&6Click to take it away.").makeMenuTool();
    }

    private ItemStack getToolWhenHasnt() {
        return this.item;
    }

    void giveOrTake(Player player) {
        PlayerInventory inv = player.getInventory();
        this.playerHasTool = !this.playerHasTool;
        if (this.playerHasTool) {
            inv.addItem(new ItemStack[]{this.item});
        } else {
            inv.removeItem(new ItemStack[]{this.item});
        }
    }

    boolean equals(ItemStack item) {
        return this.getToolWhenHas().isSimilar(item) || this.getToolWhenHasnt().isSimilar(item);
    }

    public String toString() {
        return "Toggleable{" + this.item.getType() + "}";
    }
}

