/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.menu;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.menu.Menu;
import sk.adonikeoffice.epicchat.lib.menu.ToggleableTool;
import sk.adonikeoffice.epicchat.lib.menu.tool.Tool;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;

public abstract class MenuTools
extends Menu {
    private final List<ToggleableTool> tools = this.compile0(this.compileTools());

    protected MenuTools() {
        this(null);
    }

    protected MenuTools(Menu parent) {
        super(parent);
        int items = this.tools.size();
        int pages = items < 9 ? 9 : (items < 18 ? 18 : (items < 27 ? 27 : (items < 36 ? 36 : 45)));
        this.setSize(pages);
        this.setTitle(SimpleLocalization.Menu.TITLE_TOOLS);
    }

    protected abstract Object[] compileTools();

    protected Object[] lookupTools(Class<? extends Tool> extendingClass) {
        ArrayList instances = new ArrayList();
        for (Class<? extends Tool> clazz : ReflectionUtil.getClasses((Plugin)SimplePlugin.getInstance(), extendingClass)) {
            try {
                Object instance = ReflectionUtil.getFieldContent(clazz, "instance", null);
                instances.add(instance);
            }
            catch (Throwable throwable) {}
        }
        return instances.toArray();
    }

    private final List<ToggleableTool> compile0(Object ... tools) {
        ArrayList<ToggleableTool> list = new ArrayList<ToggleableTool>();
        if (tools != null) {
            for (Object tool : tools) {
                list.add(new ToggleableTool(tool));
            }
        }
        return list;
    }

    @Override
    public final ItemStack getItemAt(int slot) {
        return slot < this.tools.size() ? this.tools.get(slot).get(this.getViewer()) : null;
    }

    @Override
    public final void onMenuClick(Player pl, int slot, InventoryAction action, ClickType click, ItemStack cursor, ItemStack item, boolean cancelled) {
        ToggleableTool tool;
        ItemStack it = this.getItemAt(slot);
        ToggleableTool toggleableTool = tool = it != null ? this.findTool(it) : null;
        if (tool != null) {
            tool.giveOrTake(pl);
            this.restartMenu();
        }
    }

    private final ToggleableTool findTool(ItemStack item) {
        for (ToggleableTool h : this.tools) {
            if (!h.equals(item)) continue;
            return h;
        }
        return null;
    }

    @Override
    protected int getInfoButtonPosition() {
        return this.getSize() - 1;
    }

    @Override
    protected String[] getInfo() {
        return null;
    }

    public static final void display(Player player, Class<? extends Tool> pluginToolClasses, String ... description) {
        MenuTools.of(pluginToolClasses, description).displayTo(player);
    }

    public static final MenuTools of(final Class<? extends Tool> pluginToolClasses, final String ... description) {
        return new MenuTools(){

            @Override
            protected Object[] compileTools() {
                return this.lookupTools(pluginToolClasses);
            }

            @Override
            protected String[] getInfo() {
                return description;
            }
        };
    }
}

