/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.menu;

import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import sk.adonikeoffice.epicchat.lib.MathUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.menu.Menu;
import sk.adonikeoffice.epicchat.lib.menu.button.Button;
import sk.adonikeoffice.epicchat.lib.menu.model.ItemCreator;
import sk.adonikeoffice.epicchat.lib.menu.model.MenuQuantity;
import sk.adonikeoffice.epicchat.lib.model.Replacer;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;

public interface MenuQuantitable {
    @NonNull
    public MenuQuantity getQuantity();

    public void setQuantity(@NonNull MenuQuantity var1);

    default public String getCurrentQuantityPercent() {
        double percent = this.getQuantity().getAmountPercent();
        return (this.allowDecimalQuantities() ? MathUtil.formatTwoDigits(percent) : String.valueOf((int)percent)) + (this.quantitiesArePercents() ? "%" : "");
    }

    @Deprecated
    default public int getNextQuantity(ClickType clickType) {
        return (int)Math.round(this.getNextQuantityPercent(clickType));
    }

    default public double getNextQuantityDouble(ClickType clickType) {
        return clickType == ClickType.LEFT ? -this.getQuantity().getAmountDouble() : this.getQuantity().getAmountDouble();
    }

    default public double getNextQuantityPercent(ClickType clickType) {
        return clickType == ClickType.LEFT ? -this.getQuantity().getAmountPercent() : this.getQuantity().getAmountPercent();
    }

    @Deprecated
    default public Button getEditQuantityButton(Menu menu) {
        return this.getQuantityButton(menu);
    }

    default public Button getQuantityButton(final Menu menu) {
        return new Button(){

            @Override
            public final void onClickedInMenu(Player player, Menu clickedMenu, ClickType clickType) {
                MenuQuantity nextQuantity = clickType == ClickType.LEFT ? MenuQuantitable.this.getQuantity().previous(MenuQuantitable.this.allowDecimalQuantities()) : MenuQuantitable.this.getQuantity().next(MenuQuantitable.this.allowDecimalQuantities());
                Valid.checkNotNull((Object)nextQuantity, "Next quantity cannot be null. Current: " + (Object)((Object)MenuQuantitable.this.getQuantity()) + " Click: " + clickType);
                MenuQuantitable.this.setQuantity(nextQuantity);
                menu.restartMenu("&9Editing quantity set to " + MenuQuantitable.this.getCurrentQuantityPercent());
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(CompMaterial.STRING, "Edit Quantity: &7" + MenuQuantitable.this.getCurrentQuantityPercent(), "", "&8< &7Left click to decrease", "&8> &7Right click to increase").make();
            }
        };
    }

    default public int getQuantityButtonPosition() {
        return ((Menu)((Object)this)).getBottomCenterSlot();
    }

    default public boolean allowDecimalQuantities() {
        return false;
    }

    default public boolean quantitiesArePercents() {
        return false;
    }

    default public ItemStack addLevelToItem(ItemStack item, int level) {
        return this.addLevelToItem(item, String.valueOf(level));
    }

    default public ItemStack addLevelToItem(ItemStack item, String level) {
        List<String> dropChanceLore = Replacer.replaceArray(Arrays.asList("", "&7" + this.getLevelLoreLabel() + ": &6{level}", "", "   &8(Mouse click)", "  &7&l< &4-{quantity}    &2+{quantity} &7&l>"), "level", level, "quantity", this.getCurrentQuantityPercent());
        return ItemCreator.of(item.clone()).clearLore().lore(dropChanceLore).makeMenuTool();
    }

    default public String getLevelLoreLabel() {
        return "Current level";
    }
}

