/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.menu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MathUtil;
import sk.adonikeoffice.epicchat.lib.PlayerUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.menu.Menu;
import sk.adonikeoffice.epicchat.lib.menu.button.Button;
import sk.adonikeoffice.epicchat.lib.menu.model.InventoryDrawer;
import sk.adonikeoffice.epicchat.lib.menu.model.ItemCreator;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;

public abstract class MenuPagged<T>
extends Menu {
    private static CompMaterial activePageButton = CompMaterial.LIME_DYE;
    private static CompMaterial inactivePageButton = CompMaterial.GRAY_DYE;
    private final List<Integer> slots;
    private final Iterable<T> items;
    private final Integer manualPageSize;
    private final Map<Integer, List<T>> pages = new HashMap<Integer, List<T>>();
    private int currentPage = 1;
    private Button nextButton;
    private Button prevButton;

    protected MenuPagged(T ... items) {
        this(null, null, null, Arrays.asList(items), false);
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
    }

    protected MenuPagged(Iterable<T> items) {
        this(null, null, null, items, false);
    }

    protected MenuPagged(Menu parent, T ... items) {
        this(null, parent, null, Arrays.asList(items), false);
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
    }

    protected MenuPagged(Menu parent, Iterable<T> items) {
        this(null, parent, null, items, false);
    }

    protected MenuPagged(List<Integer> slots, Iterable<T> items) {
        this(null, null, slots, items, false);
    }

    protected MenuPagged(Menu parent, List<Integer> slots, Iterable<T> items) {
        this((Integer)null, parent, slots, items, false);
    }

    protected MenuPagged(Menu parent, Iterable<T> items, boolean returnMakesNewInstance) {
        this(null, parent, null, items, returnMakesNewInstance);
    }

    protected MenuPagged(Menu parent, List<Integer> slots, Iterable<T> items, boolean returnMakesNewInstance) {
        this((Integer)null, parent, slots, items, returnMakesNewInstance);
    }

    protected MenuPagged(int pageSize, T ... items) {
        this((Integer)pageSize, null, null, Arrays.asList(items), false);
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
    }

    protected MenuPagged(int pageSize, Iterable<T> items) {
        this((Integer)pageSize, null, null, items, false);
    }

    protected MenuPagged(int pageSize, List<Integer> slots, Iterable<T> items) {
        this((Integer)pageSize, (Menu)null, slots, items, false);
    }

    protected MenuPagged(int pageSize, Menu parent, T ... items) {
        this((Integer)pageSize, parent, null, Arrays.asList(items), false);
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
    }

    protected MenuPagged(int pageSize, Menu parent, Iterable<T> items) {
        this((Integer)pageSize, parent, null, items, false);
    }

    protected MenuPagged(int pageSize, Menu parent, Iterable<T> items, boolean returnMakesNewInstance) {
        this((Integer)pageSize, parent, null, items, returnMakesNewInstance);
    }

    private MenuPagged(Integer pageSize, Menu parent, List<Integer> slots, Iterable<T> items, boolean returnMakesNewInstance) {
        super(parent, returnMakesNewInstance);
        this.slots = slots != null ? slots : new ArrayList();
        this.items = items;
        this.manualPageSize = pageSize;
        this.calculatePages();
        this.setButtons();
    }

    private void calculatePages() {
        int autoPageSize;
        int items = this.getItemAmount(this.items);
        if (this.slots.isEmpty()) {
            autoPageSize = this.manualPageSize != null ? this.manualPageSize : (items <= 9 ? 9 : (items <= 18 ? 18 : (items <= 27 ? 27 : (items <= 36 ? 36 : 45))));
            for (int i = 0; i < autoPageSize; ++i) {
                this.slots.add(i);
            }
            this.setSize(9 + autoPageSize);
        } else {
            autoPageSize = this.slots.size();
        }
        this.pages.clear();
        this.pages.putAll(Common.fillPages(autoPageSize, this.items));
    }

    private int getItemAmount(Iterable<T> pages) {
        int amount = 0;
        for (T t : pages) {
            ++amount;
        }
        return amount;
    }

    private void setButtons() {
        boolean hasPages = this.pages.size() > 1;
        this.prevButton = hasPages ? this.formPreviousButton() : Button.makeEmpty();
        this.nextButton = hasPages ? this.formNextButton() : Button.makeEmpty();
    }

    public Button formPreviousButton() {
        return new Button(){
            final boolean canGo;
            {
                this.canGo = MenuPagged.this.currentPage > 1;
            }

            @Override
            public void onClickedInMenu(Player player, Menu menu, ClickType click) {
                if (this.canGo) {
                    MenuPagged.this.currentPage = MathUtil.range(MenuPagged.this.currentPage - 1, 1, MenuPagged.this.pages.size());
                    MenuPagged.this.updatePage();
                }
            }

            @Override
            public ItemStack getItem() {
                int previousPage = MenuPagged.this.currentPage - 1;
                return ItemCreator.of(this.canGo ? activePageButton : inactivePageButton).name(previousPage == 0 ? SimpleLocalization.Menu.PAGE_FIRST : SimpleLocalization.Menu.PAGE_PREVIOUS.replace("{page}", String.valueOf(previousPage))).make();
            }
        };
    }

    public Button formNextButton() {
        return new Button(){
            final boolean canGo;
            {
                this.canGo = MenuPagged.this.currentPage < MenuPagged.this.pages.size();
            }

            @Override
            public void onClickedInMenu(Player player, Menu menu, ClickType click) {
                if (this.canGo) {
                    MenuPagged.this.currentPage = MathUtil.range(MenuPagged.this.currentPage + 1, 1, MenuPagged.this.pages.size());
                    MenuPagged.this.updatePage();
                }
            }

            @Override
            public ItemStack getItem() {
                boolean lastPage = MenuPagged.this.currentPage == MenuPagged.this.pages.size();
                return ItemCreator.of(this.canGo ? activePageButton : inactivePageButton).name(lastPage ? SimpleLocalization.Menu.PAGE_LAST : SimpleLocalization.Menu.PAGE_NEXT.replace("{page}", String.valueOf(MenuPagged.this.currentPage + 1))).make();
            }
        };
    }

    private void updatePage() {
        this.setButtons();
        this.restartMenu();
        Menu.getSound().play(this.getViewer());
        PlayerUtil.updateInventoryTitle(this.getViewer(), this.compileTitle0());
    }

    private String compileTitle0() {
        boolean canAddNumbers = this.addPageNumbers() && this.pages.size() > 1;
        return "&0" + this.getTitle() + (canAddNumbers ? " &8" + this.currentPage + "/" + this.pages.size() : "");
    }

    @Override
    protected final void onDisplay(InventoryDrawer drawer) {
        drawer.setTitle(this.compileTitle0());
        this.onPostDisplay(drawer);
    }

    @Override
    void onRestart() {
        this.calculatePages();
    }

    protected void onPostDisplay(InventoryDrawer drawer) {
    }

    protected abstract ItemStack convertToItemStack(T var1);

    protected abstract void onPageClick(Player var1, T var2, ClickType var3);

    protected boolean addPageNumbers() {
        return true;
    }

    protected boolean isEmpty() {
        return this.pages.isEmpty() || this.pages.get(0).isEmpty();
    }

    @Override
    public ItemStack getItemAt(int slot) {
        T object;
        if (this.slots.contains(slot) && this.slots.indexOf(slot) < this.getCurrentPageItems().size() && (object = this.getCurrentPageItems().get(this.slots.indexOf(slot))) != null) {
            return this.convertToItemStack(object);
        }
        if (slot == this.getPreviousButtonPosition()) {
            return this.prevButton.getItem();
        }
        if (slot == this.getNextButtonPosition()) {
            return this.nextButton.getItem();
        }
        return null;
    }

    protected int getPreviousButtonPosition() {
        return this.getSize() - 6;
    }

    protected int getNextButtonPosition() {
        return this.getSize() - 4;
    }

    @Override
    public final void onMenuClick(Player player, int slot, InventoryAction action, ClickType click, ItemStack cursor, ItemStack clicked, boolean cancelled) {
        T obj;
        if (this.slots.contains(slot) && this.slots.indexOf(slot) < this.getCurrentPageItems().size() && (obj = this.getCurrentPageItems().get(this.slots.indexOf(slot))) != null) {
            InventoryType prevType = player.getOpenInventory().getType();
            this.onPageClick(player, obj, click);
            if (prevType == player.getOpenInventory().getType()) {
                player.getOpenInventory().getTopInventory().setItem(slot, this.getItemAt(slot));
            }
        }
    }

    @Override
    public final void onButtonClick(Player player, int slot, InventoryAction action, ClickType click, Button button) {
        super.onButtonClick(player, slot, action, click, button);
    }

    @Override
    public final void onMenuClick(Player player, int slot, ItemStack clicked) {
        throw new FoException("Simplest click unsupported");
    }

    private List<T> getCurrentPageItems() {
        Valid.checkBoolean(this.pages.containsKey(this.currentPage - 1), "The menu has only " + this.pages.size() + " pages, not " + this.currentPage + "!", new Object[0]);
        return this.pages.get(this.currentPage - 1);
    }

    public static CompMaterial getActivePageButton() {
        return activePageButton;
    }

    public static void setActivePageButton(CompMaterial activePageButton) {
        MenuPagged.activePageButton = activePageButton;
    }

    public static CompMaterial getInactivePageButton() {
        return inactivePageButton;
    }

    public static void setInactivePageButton(CompMaterial inactivePageButton) {
        MenuPagged.inactivePageButton = inactivePageButton;
    }

    public List<Integer> getSlots() {
        return this.slots;
    }

    public Map<Integer, List<T>> getPages() {
        return this.pages;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }
}

