/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.menu;

import java.util.Iterator;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.menu.Menu;
import sk.adonikeoffice.epicchat.lib.menu.button.Button;
import sk.adonikeoffice.epicchat.lib.menu.model.MenuClickLocation;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;

public final class MenuListener
implements Listener {
    public MenuListener() {
        try {
            Class.forName("org.bukkit.event.player.PlayerSwapHandItemsEvent");
            Common.registerEvents(new OffHandListener());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Class.forName("org.bukkit.event.inventory.InventoryDragEvent");
            Common.registerEvents(new DragListener());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onMenuClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Menu menu = Menu.getMenu(player);
        if (menu != null) {
            menu.handleClose(event.getInventory());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onMenuClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Menu menu = Menu.getMenu(player);
        if (menu != null) {
            ItemStack slotItem = event.getCurrentItem();
            ItemStack cursor = event.getCursor();
            Inventory clickedInv = Remain.getClickedInventory(event);
            InventoryAction action = event.getAction();
            MenuClickLocation whereClicked = clickedInv != null ? (clickedInv.getType() == InventoryType.CHEST ? MenuClickLocation.MENU : MenuClickLocation.PLAYER_INVENTORY) : MenuClickLocation.OUTSIDE;
            boolean allowed = menu.isActionAllowed(whereClicked, event.getSlot(), slotItem, cursor, action);
            if (action.toString().contains("PICKUP") || action.toString().contains("PLACE") || action.toString().equals("SWAP_WITH_CURSOR") || action == InventoryAction.CLONE_STACK) {
                if (whereClicked == MenuClickLocation.MENU) {
                    try {
                        Button button = menu.getButton(slotItem);
                        if (button != null) {
                            menu.onButtonClick(player, event.getSlot(), action, event.getClick(), button);
                        } else {
                            menu.onMenuClick(player, event.getSlot(), action, event.getClick(), cursor, slotItem, !allowed);
                        }
                    }
                    catch (Throwable t) {
                        Common.tell((CommandSender)player, SimpleLocalization.Menu.ERROR);
                        player.closeInventory();
                        Common.error(t, "Error clicking in menu " + menu);
                    }
                }
                if (!allowed) {
                    event.setResult(Event.Result.DENY);
                    player.updateInventory();
                }
            } else if (action == InventoryAction.MOVE_TO_OTHER_INVENTORY || whereClicked != MenuClickLocation.PLAYER_INVENTORY) {
                event.setResult(Event.Result.DENY);
                player.updateInventory();
                if (player.getGameMode() == GameMode.CREATIVE && event.getClick().toString().equals("SWAP_OFFHAND")) {
                    player.getInventory().setItemInOffHand(null);
                }
            }
        }
    }

    private static final class OffHandListener
    implements Listener {
        private OffHandListener() {
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void onSwapItems(PlayerSwapHandItemsEvent event) {
            if (Menu.getMenu(event.getPlayer()) != null) {
                event.setCancelled(true);
            }
        }
    }

    private static final class DragListener
    implements Listener {
        private DragListener() {
        }

        @EventHandler
        public void onInventoryDragTop(InventoryDragEvent event) {
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            Player player = (Player)event.getWhoClicked();
            Menu menu = Menu.getMenu(player);
            if (menu != null && event.getView().getType() == InventoryType.CHEST) {
                int size = event.getView().getTopInventory().getSize();
                Iterator iterator = event.getRawSlots().iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    if (slot > size) continue;
                    ItemStack cursor = Common.getOrDefault(event.getCursor(), event.getOldCursor());
                    if (menu.isActionAllowed(MenuClickLocation.MENU, slot, (ItemStack)event.getNewItems().get(slot), cursor, InventoryAction.PLACE_SOME)) continue;
                    event.setCancelled(true);
                    return;
                }
            }
        }
    }
}

