/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.menu;

import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MathUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.StrictMap;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.menu.Menu;
import sk.adonikeoffice.epicchat.lib.menu.MenuContainer;
import sk.adonikeoffice.epicchat.lib.menu.MenuQuantitable;
import sk.adonikeoffice.epicchat.lib.menu.button.Button;
import sk.adonikeoffice.epicchat.lib.menu.model.ItemCreator;
import sk.adonikeoffice.epicchat.lib.menu.model.MenuClickLocation;
import sk.adonikeoffice.epicchat.lib.menu.model.MenuQuantity;
import sk.adonikeoffice.epicchat.lib.model.Tuple;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;

public abstract class MenuContainerChances
extends Menu
implements MenuQuantitable {
    private final StrictMap<Integer, Double> editedDropChances = new StrictMap();
    private final Button changeModeButton;
    private MenuQuantity quantity = MenuQuantity.ONE;
    private EditMode mode = EditMode.ITEM;

    protected MenuContainerChances(Menu parent) {
        this(parent, false);
    }

    protected MenuContainerChances(Menu parent, boolean returnMakesNewInstance) {
        super(parent, returnMakesNewInstance);
        this.setSize(27);
        this.changeModeButton = new Button(){

            @Override
            public void onClickedInMenu(Player player, Menu menu, ClickType click) {
                MenuContainerChances instance = MenuContainerChances.this;
                instance.onMenuClose(player, player.getOpenInventory().getTopInventory());
                instance.mode = MenuContainerChances.this.mode.next();
                instance.setTitle("&0Editing " + instance.mode.getKey());
                instance.restartMenu();
            }

            @Override
            public ItemStack getItem() {
                boolean chances = MenuContainerChances.this.mode == EditMode.CHANCE;
                return ItemCreator.of(chances ? CompMaterial.GOLD_NUGGET : CompMaterial.CHEST, "Editing " + MenuContainerChances.this.mode.getKey(), "", "&7Click to edit " + MenuContainerChances.this.mode.next().getKey().toLowerCase() + ".").glow(chances).make();
            }
        };
    }

    @Override
    public int getQuantityButtonPosition() {
        return this.mode == EditMode.ITEM ? -1 : MenuQuantitable.super.getQuantityButtonPosition();
    }

    @Override
    public boolean allowDecimalQuantities() {
        return false;
    }

    @Override
    public final ItemStack getItemAt(int slot) {
        if (slot == this.getChangeModeButtonPosition()) {
            return this.changeModeButton.getItem();
        }
        ItemStack customDrop = this.getDropAt(slot);
        if (customDrop != null) {
            if (this.mode == EditMode.ITEM || !this.canEditItem(slot)) {
                return customDrop;
            }
            double dropChance = this.mode == EditMode.ITEM ? this.getDropChance(slot) : this.editedDropChances.getOrDefault(slot, this.getDropChance(slot)).doubleValue();
            String level = MathUtil.formatTwoDigits(100.0 * dropChance) + "%";
            return this.addLevelToItem(customDrop, level);
        }
        if (slot > this.getSize() - 9) {
            return MenuContainer.BOTTOM_BAR_FILLER_ITEM;
        }
        return NO_ITEM;
    }

    protected int getChangeModeButtonPosition() {
        return this.getSize() - 2;
    }

    @Override
    public String getLevelLoreLabel() {
        return "Drop chance";
    }

    @Override
    public final boolean quantitiesArePercents() {
        return true;
    }

    protected abstract ItemStack getDropAt(int var1);

    protected abstract double getDropChance(int var1);

    @Override
    public final boolean isActionAllowed(MenuClickLocation location, int slot, ItemStack clicked, ItemStack cursor, InventoryAction action) {
        if (this.mode == EditMode.CHANCE) {
            return false;
        }
        if (location != MenuClickLocation.MENU) {
            return true;
        }
        if (!this.canEditItem(location, slot, clicked, cursor, action)) {
            return false;
        }
        return slot < this.getSize() - 9;
    }

    protected boolean canEditItem(MenuClickLocation location, int slot, ItemStack clicked, ItemStack cursor, InventoryAction action) {
        return this.canEditItem(slot);
    }

    protected boolean canEditItem(int slot) {
        return true;
    }

    @Override
    protected final void onMenuClick(Player player, int slot, InventoryAction action, ClickType click, ItemStack cursor, ItemStack clicked, boolean cancelled) {
        if (this.mode == EditMode.CHANCE && this.canEditItem(slot) && slot < this.getSize() - 9) {
            if (clicked == null) {
                return;
            }
            double chance = this.editedDropChances.getOrDefault(slot, this.getDropChance(slot));
            double next = this.getNextQuantityDouble(click);
            double newChance = MathUtil.range(chance + next, 0.0, 1.0);
            this.editedDropChances.override(slot, newChance);
            this.setItem(slot, this.getItemAt(slot));
        }
    }

    @Override
    protected final void onMenuClick(Player player, int slot, ItemStack clicked) {
        throw new FoException("unsupported call");
    }

    @Override
    protected final void onMenuClose(Player player, Inventory inventory) {
        StrictMap<Integer, Tuple<ItemStack, Double>> items = new StrictMap<Integer, Tuple<ItemStack, Double>>();
        for (int slot = 0; slot < this.getSize() - 9; ++slot) {
            boolean placed = false;
            if (this.canEditItem(slot)) {
                ItemStack item = this.mode == EditMode.ITEM ? inventory.getItem(slot) : this.getDropAt(slot);
                Double dropChance = this.editedDropChances.getOrDefault(slot, this.getDropChance(slot));
                if (item != null && !CompMaterial.isAir(item)) {
                    Valid.checkNotNull(dropChance, "Drop chances cannot be null on slot " + slot + " for " + item);
                    items.put(slot, new Tuple<ItemStack, Double>(item, dropChance));
                    placed = true;
                }
            }
            if (placed) continue;
            items.put(slot, null);
        }
        this.onMenuClose(items);
    }

    protected abstract void onMenuClose(StrictMap<Integer, Tuple<ItemStack, Double>> var1);

    @Override
    protected String[] getInfo() {
        if (this.mode == EditMode.ITEM) {
            return new String[]{"This menu allows you to drop", "items to this container.", "", "Simply &2drag and drop &7items", "from your inventory here."};
        }
        return new String[]{"This menu allows you to edit drop", "chances for items in this container.", "", "&2Right or left click &7on items", "to adjust their drop chance."};
    }

    @Override
    public MenuQuantity getQuantity() {
        return this.quantity;
    }

    @Override
    public void setQuantity(MenuQuantity quantity) {
        this.quantity = quantity;
    }

    protected EditMode getMode() {
        return this.mode;
    }

    public static enum EditMode {
        ITEM("Items"),
        CHANCE("Drop Chances");

        private final String key;

        private EditMode next() {
            return Common.getNext(this, EditMode.values(), true);
        }

        private EditMode(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

