/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.menu;

import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import sk.adonikeoffice.epicchat.lib.collection.StrictMap;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.menu.Menu;
import sk.adonikeoffice.epicchat.lib.menu.model.ItemCreator;
import sk.adonikeoffice.epicchat.lib.menu.model.MenuClickLocation;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;

public abstract class MenuContainer
extends Menu {
    protected static final ItemStack BOTTOM_BAR_FILLER_ITEM = ItemCreator.of(CompMaterial.LIGHT_GRAY_STAINED_GLASS_PANE, " ", new String[0]).make();

    protected MenuContainer(Menu parent) {
        super(parent);
        this.setSize(27);
    }

    @Override
    public final ItemStack getItemAt(int slot) {
        ItemStack customDrop = this.getDropAt(slot);
        if (customDrop != null) {
            return customDrop;
        }
        if (slot > this.getSize() - 9) {
            return BOTTOM_BAR_FILLER_ITEM;
        }
        return NO_ITEM;
    }

    @Override
    public final boolean isActionAllowed(MenuClickLocation location, int slot, ItemStack clicked, ItemStack cursor, InventoryAction action) {
        if (location != MenuClickLocation.MENU) {
            return true;
        }
        if (slot >= this.getSize() - 9) {
            return false;
        }
        return this.canEditItem(location, slot, clicked, cursor, action);
    }

    protected boolean canEditItem(MenuClickLocation location, int slot, ItemStack clicked, ItemStack cursor, InventoryAction action) {
        return this.canEditItem(slot);
    }

    protected boolean canEditItem(int slot) {
        return true;
    }

    protected abstract ItemStack getDropAt(int var1);

    @Override
    protected final void onMenuClick(Player player, int slot, InventoryAction action, ClickType clickType, ItemStack cursor, ItemStack clicked, boolean cancelled) {
        if (this.canEditItem(slot) && slot < this.getSize() - 9) {
            clicked = this.onItemClick(slot, clickType, clicked);
            this.setItem(slot, clicked);
        }
    }

    @Override
    protected final void onMenuClick(Player player, int slot, ItemStack clicked) {
        throw new FoException("unsupported call");
    }

    protected ItemStack onItemClick(int slot, ClickType clickType, @Nullable ItemStack item) {
        return item;
    }

    @Override
    protected final void onMenuClose(Player player, Inventory inventory) {
        StrictMap<Integer, ItemStack> items = new StrictMap<Integer, ItemStack>();
        for (int slot = 0; slot < this.getSize() - 9; ++slot) {
            if (!this.canEditItem(slot)) continue;
            ItemStack item = inventory.getItem(slot);
            items.put(slot, item);
        }
        this.onMenuClose(items);
    }

    protected abstract void onMenuClose(StrictMap<Integer, ItemStack> var1);

    @Override
    protected String[] getInfo() {
        return new String[]{"This menu allows you to drop", "items to this container.", "", "Simply &2drag and drop &7items", "from your inventory here."};
    }
}

