/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.menu;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.ItemUtil;
import sk.adonikeoffice.epicchat.lib.Messenger;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.PlayerUtil;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.constants.FoConstants;
import sk.adonikeoffice.epicchat.lib.event.MenuCloseEvent;
import sk.adonikeoffice.epicchat.lib.event.MenuOpenEvent;
import sk.adonikeoffice.epicchat.lib.exception.EventHandledException;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.menu.MenuQuantitable;
import sk.adonikeoffice.epicchat.lib.menu.button.Button;
import sk.adonikeoffice.epicchat.lib.menu.button.ButtonReturnBack;
import sk.adonikeoffice.epicchat.lib.menu.button.StartPosition;
import sk.adonikeoffice.epicchat.lib.menu.button.annotation.Position;
import sk.adonikeoffice.epicchat.lib.menu.model.InventoryDrawer;
import sk.adonikeoffice.epicchat.lib.menu.model.ItemCreator;
import sk.adonikeoffice.epicchat.lib.menu.model.MenuClickLocation;
import sk.adonikeoffice.epicchat.lib.model.SimpleSound;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.remain.CompSound;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;

public abstract class Menu {
    @Nullable
    private static SimpleSound sound = new SimpleSound(CompSound.NOTE_STICKS.getSound(), 0.4f);
    private static boolean titleAnimationEnabled = true;
    private static int titleAnimationDurationTicks = 20;
    protected static final ItemStack NO_ITEM = null;
    private final Map<Button, Position> registeredButtons = new HashMap<Button, Position>();
    private boolean buttonsRegistered = false;
    private final Menu parent;
    private final Button returnButton;
    private String title = "&0Menu";
    private Integer size = 27;
    private Player viewer;
    private boolean slotNumbersVisible;
    private boolean opened = false;
    private boolean closed = false;
    @Nullable
    private final Button quantityButton;

    protected Menu() {
        this(null);
    }

    protected Menu(Menu parent) {
        this(parent, false);
    }

    protected Menu(Menu parent, boolean returnMakesNewInstance) {
        this.parent = parent;
        this.returnButton = parent != null ? new ButtonReturnBack(parent, returnMakesNewInstance) : Button.makeEmpty();
        this.quantityButton = this instanceof MenuQuantitable ? ((MenuQuantitable)((Object)this)).getQuantityButton(this) : Button.makeEmpty();
    }

    public static final Menu getMenu(Player player) {
        return Menu.getMenu0(player, FoConstants.NBT.TAG_MENU_CURRENT);
    }

    public static final Menu getPreviousMenu(Player player) {
        return Menu.getMenu0(player, FoConstants.NBT.TAG_MENU_PREVIOUS);
    }

    @Nullable
    public static final Menu getLastClosedMenu(Player player) {
        if (player.hasMetadata(FoConstants.NBT.TAG_MENU_LAST_CLOSED)) {
            Menu menu = (Menu)((MetadataValue)player.getMetadata(FoConstants.NBT.TAG_MENU_LAST_CLOSED).get(0)).value();
            return menu;
        }
        return null;
    }

    private static Menu getMenu0(Player player, String tag) {
        if (player.hasMetadata(tag)) {
            Menu menu = (Menu)((MetadataValue)player.getMetadata(tag).get(0)).value();
            Valid.checkNotNull(menu, "Menu missing from " + player.getName() + "'s metadata '" + tag + "' tag!");
            return menu;
        }
        return null;
    }

    final void registerButtons() {
        this.registeredButtons.clear();
        List<Button> buttons = this.getButtonsToAutoRegister();
        if (buttons != null) {
            HashMap<Button, Object> buttonsRemapped = new HashMap<Button, Object>();
            for (Button button : buttons) {
                buttonsRemapped.put(button, null);
            }
            this.registeredButtons.putAll(buttonsRemapped);
        }
        Class<?> lookup = this.getClass();
        do {
            for (Field f : lookup.getDeclaredFields()) {
                this.registerButton0(f);
            }
        } while (Menu.class.isAssignableFrom(lookup = lookup.getSuperclass()));
    }

    private void registerButton0(Field field) {
        field.setAccessible(true);
        Class<?> type = field.getType();
        if (Button.class.isAssignableFrom(type)) {
            Button button = (Button)ReflectionUtil.getFieldContent(field, this);
            Valid.checkNotNull(button, "Null button field named " + field.getName() + " in " + this);
            Position position = field.getAnnotation(Position.class);
            if (!(button instanceof Button.DummyButton)) {
                this.registeredButtons.put(button, position);
            }
        } else if (Button[].class.isAssignableFrom(type)) {
            throw new FoException("Button[] is no longer supported in menu for " + this.getClass());
        }
    }

    private final void registerButtonsIfHasnt() {
        if (!this.buttonsRegistered) {
            this.registerButtons();
            this.buttonsRegistered = true;
        }
    }

    protected List<Button> getButtonsToAutoRegister() {
        return null;
    }

    protected final Button getButton(ItemStack fromItem) {
        this.registerButtonsIfHasnt();
        if (fromItem != null) {
            for (Button button : this.registeredButtons.keySet()) {
                Valid.checkNotNull(button, "Menu button is null at " + this.getClass().getSimpleName());
                ItemStack item = button.getItem();
                Valid.checkNotNull(item, "Menu " + this.getTitle() + " contained button " + button.getClass().getSimpleName() + " with empty item!");
                if (!ItemUtil.isSimilar(fromItem, item)) continue;
                return button;
            }
        }
        return null;
    }

    public Menu newInstance() {
        try {
            return (Menu)ReflectionUtil.instantiate(this.getClass());
        }
        catch (Throwable t) {
            try {
                Object parent = this.getClass().getMethod("getParent", new Class[0]).invoke(this.getClass(), new Object[0]);
                if (parent != null) {
                    return (Menu)ReflectionUtil.instantiate(this.getClass(), parent);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            t.printStackTrace();
            throw new FoException("Could not instantiate menu of " + this.getClass() + ", override the method 'newInstance()' or ensure you have a public constructor which takes only one parameter ");
        }
    }

    public final void displayTo(Player player) {
        Menu previous;
        Valid.checkNotNull(this.size, "Size not set in " + this + " (call setSize in your constructor)");
        Valid.checkNotNull(this.title, "Title not set in " + this + " (call setTitle in your constructor)");
        if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_5)) {
            String error = "Displaying menus require Minecraft 1.5.2 or greater.";
            if (Messenger.ENABLED) {
                Messenger.error((CommandSender)player, "Displaying menus require Minecraft 1.5.2 or greater.");
            } else {
                Common.tell((CommandSender)player, "Displaying menus require Minecraft 1.5.2 or greater.");
            }
            return;
        }
        this.viewer = player;
        this.registerButtonsIfHasnt();
        InventoryDrawer drawer = InventoryDrawer.of(this.size, this.title);
        this.compileItems().forEach((slot, item) -> drawer.setItem((int)slot, (ItemStack)item));
        this.onDisplay(drawer);
        this.debugSlotNumbers(drawer);
        if (!Common.callEvent(new MenuOpenEvent(this, drawer, player))) {
            return;
        }
        if (player.isConversing()) {
            player.sendRawMessage(Common.colorize(SimpleLocalization.Menu.CANNOT_OPEN_DURING_CONVERSATION));
            return;
        }
        if (sound != null) {
            sound.play(player);
        }
        if ((previous = Menu.getMenu(player)) != null) {
            player.setMetadata(FoConstants.NBT.TAG_MENU_PREVIOUS, (MetadataValue)new FixedMetadataValue((Plugin)SimplePlugin.getInstance(), (Object)previous));
        }
        Common.runLater(1, () -> {
            try {
                drawer.display(player);
            }
            catch (Throwable t) {
                Common.error(t, "Error opening menu " + this);
                return;
            }
            player.setMetadata(FoConstants.NBT.TAG_MENU_CURRENT, (MetadataValue)new FixedMetadataValue((Plugin)SimplePlugin.getInstance(), (Object)this));
            this.opened = true;
        });
    }

    private void debugSlotNumbers(InventoryDrawer drawer) {
        if (this.slotNumbersVisible) {
            for (int slot = 0; slot < drawer.getSize(); ++slot) {
                ItemStack item = drawer.getItem(slot);
                if (item != null) continue;
                drawer.setItem(slot, ItemCreator.of(CompMaterial.LIGHT_GRAY_STAINED_GLASS_PANE, "Slot " + slot, new String[0]).make());
            }
        }
    }

    protected void onDisplay(InventoryDrawer drawer) {
    }

    public final void restartMenu() {
        this.restartMenu(null);
    }

    public final void restartMenu(String animatedTitle) {
        Player player = this.getViewer();
        Valid.checkNotNull(player, "Cannot restartMenu if it was not yet shown to a player! Menu: " + this);
        Inventory inventory = player.getOpenInventory().getTopInventory();
        Valid.checkBoolean(inventory.getType() == InventoryType.CHEST, player.getName() + "'s inventory closed in the meanwhile (now == " + inventory.getType() + ").", new Object[0]);
        this.registerButtons();
        this.onRestart();
        ItemStack[] content = inventory.getContents();
        Map<Integer, ItemStack> newContent = this.compileItems();
        for (int i = 0; i < content.length; ++i) {
            content[i] = newContent.get(i);
        }
        inventory.setContents(content);
        if (animatedTitle != null) {
            this.animateTitle(animatedTitle);
        }
    }

    void onRestart() {
    }

    private Map<Integer, ItemStack> compileItems() {
        int slot;
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        boolean hasReturnButton = this.addReturnButton() && !(this.returnButton instanceof Button.DummyButton);
        for (int slot2 = 0; slot2 < this.size; ++slot2) {
            ItemStack item = this.getItemAt(slot2);
            if (item != null && CompMaterial.isAir(item)) {
                item = null;
            }
            items.put(slot2, item);
        }
        for (Map.Entry<Button, Position> entry : this.registeredButtons.entrySet()) {
            Button button = entry.getKey();
            Position position = entry.getValue();
            if (position == null) continue;
            int slot3 = position.value();
            StartPosition startPosition = position.start();
            if (startPosition == StartPosition.CENTER) {
                slot3 += this.getCenterSlot();
            } else if (startPosition == StartPosition.BOTTOM_CENTER) {
                slot3 += this.getSize() - 5;
            } else if (startPosition == StartPosition.BOTTOM_LEFT) {
                slot3 += this.getSize() - (hasReturnButton ? 2 : 1);
            } else if (startPosition == StartPosition.TOP_LEFT) {
                slot3 += 0;
            } else {
                throw new FoException("Does not know how to implement button position's Slot." + (Object)((Object)startPosition));
            }
            items.put(slot3, button.getItem());
        }
        if (this instanceof MenuQuantitable && (slot = ((MenuQuantitable)((Object)this)).getQuantityButtonPosition()) != -1) {
            items.put(slot, this.quantityButton.getItem());
        }
        if (this.addInfoButton() && this.getInfo() != null) {
            items.put(this.getInfoButtonPosition(), Button.makeInfo(this.getInfo()).getItem());
        }
        if (hasReturnButton) {
            items.put(this.getReturnButtonPosition(), this.returnButton.getItem());
        }
        return items;
    }

    public final void tell(String ... messages) {
        Common.tell((CommandSender)this.viewer, messages);
    }

    public final void tellInfo(String message) {
        Messenger.info((CommandSender)this.viewer, message);
    }

    public final void tellSuccess(String message) {
        Messenger.success((CommandSender)this.viewer, message);
    }

    public final void tellWarn(String message) {
        Messenger.warn((CommandSender)this.viewer, message);
    }

    public final void tellError(String message) {
        Messenger.error((CommandSender)this.viewer, message);
    }

    public final void tellQuestion(String message) {
        Messenger.question((CommandSender)this.viewer, message);
    }

    public final void tellAnnounce(String message) {
        Messenger.announce((CommandSender)this.viewer, message);
    }

    public final void animateTitle(String title) {
        if (titleAnimationEnabled) {
            PlayerUtil.updateInventoryTitle(this, this.getViewer(), title, this.getTitle(), titleAnimationDurationTicks);
        }
    }

    protected final void animate(int periodTicks, MenuRunnable task) {
        Common.runTimer(2, periodTicks, (Runnable)this.wrapAnimation(task));
    }

    protected final void animateAsync(int periodTicks, MenuRunnable task) {
        Common.runTimerAsync(2, periodTicks, (Runnable)this.wrapAnimation(task));
    }

    private BukkitRunnable wrapAnimation(final MenuRunnable task) {
        return new BukkitRunnable(){

            public void run() {
                if (Menu.this.closed) {
                    this.cancel();
                    return;
                }
                try {
                    task.run();
                }
                catch (EventHandledException ex) {
                    this.cancel();
                }
            }
        };
    }

    public ItemStack getItemAt(int slot) {
        return NO_ITEM;
    }

    protected int getInfoButtonPosition() {
        return this.size - 9;
    }

    protected boolean addReturnButton() {
        return true;
    }

    protected boolean addInfoButton() {
        return true;
    }

    protected int getReturnButtonPosition() {
        return this.size - 1;
    }

    protected final int getCenterSlot() {
        int pos = this.size / 2;
        return this.size % 2 == 1 ? pos : pos - 5;
    }

    protected final int getBottomCenterSlot() {
        return this.size - 5;
    }

    protected boolean isActionAllowed(MenuClickLocation location, int slot, @Nullable ItemStack clicked, @Nullable ItemStack cursor, InventoryAction action) {
        return this.isActionAllowed(location, slot, clicked, cursor);
    }

    protected boolean isActionAllowed(MenuClickLocation location, int slot, @Nullable ItemStack clicked, @Nullable ItemStack cursor) {
        return false;
    }

    public final String getTitle() {
        return this.title;
    }

    protected final void setTitle(String title) {
        this.title = title;
        if (this.viewer != null && this.opened) {
            PlayerUtil.updateInventoryTitle(this.viewer, title);
        }
    }

    public final Menu getParent() {
        return this.parent;
    }

    public final Integer getSize() {
        return this.size;
    }

    protected final void setSize(Integer size) {
        this.size = size;
    }

    protected String[] getInfo() {
        return null;
    }

    protected final Player getViewer() {
        return this.viewer;
    }

    protected final void setViewer(@NonNull Player viewer) {
        if (viewer == null) {
            throw new NullPointerException("viewer is marked non-null but is null");
        }
        this.viewer = viewer;
    }

    protected final Inventory getInventory() {
        Valid.checkNotNull(this.viewer, "Cannot get inventory when there is no viewer!");
        Inventory topInventory = this.viewer.getOpenInventory().getTopInventory();
        Valid.checkNotNull(topInventory, "Top inventory is null!");
        return topInventory;
    }

    protected final ItemStack[] getContent(int from, int to) {
        ItemStack[] content = this.getInventory().getContents();
        ItemStack[] copy = new ItemStack[content.length];
        for (int i = from; i < copy.length; ++i) {
            ItemStack item = content[i];
            copy[i] = item != null ? item.clone() : null;
        }
        return Arrays.copyOfRange(copy, from, to);
    }

    protected final void setItem(int slot, ItemStack item) {
        Inventory inventory = this.getInventory();
        inventory.setItem(slot, item);
    }

    protected final void setSlotNumbersVisible() {
        this.slotNumbersVisible = true;
    }

    public final boolean isViewing(Player player) {
        Menu menu = Menu.getMenu(player);
        return menu != null && menu.getClass().getName().equals(this.getClass().getName());
    }

    protected void onMenuClick(Player player, int slot, InventoryAction action, ClickType click, ItemStack cursor, ItemStack clicked, boolean cancelled) {
        this.onMenuClick(player, slot, clicked);
    }

    protected void onMenuClick(Player player, int slot, ItemStack clicked) {
    }

    protected void onButtonClick(Player player, int slot, InventoryAction action, ClickType click, Button button) {
        button.onClickedInMenu(player, this, click);
    }

    @Deprecated
    public final void handleClose(Inventory inventory) {
        this.viewer.removeMetadata(FoConstants.NBT.TAG_MENU_CURRENT, (Plugin)SimplePlugin.getInstance());
        this.viewer.setMetadata(FoConstants.NBT.TAG_MENU_LAST_CLOSED, (MetadataValue)new FixedMetadataValue((Plugin)SimplePlugin.getInstance(), (Object)this));
        this.closed = true;
        this.onMenuClose(this.viewer, inventory);
        Common.callEvent(new MenuCloseEvent(this, inventory, this.viewer));
    }

    protected void onMenuClose(Player player, Inventory inventory) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{}";
    }

    @Nullable
    public static SimpleSound getSound() {
        return sound;
    }

    public static void setSound(@Nullable SimpleSound sound) {
        Menu.sound = sound;
    }

    public static boolean isTitleAnimationEnabled() {
        return titleAnimationEnabled;
    }

    public static void setTitleAnimationEnabled(boolean titleAnimationEnabled) {
        Menu.titleAnimationEnabled = titleAnimationEnabled;
    }

    public static void setTitleAnimationDurationTicks(int titleAnimationDurationTicks) {
        Menu.titleAnimationDurationTicks = titleAnimationDurationTicks;
    }

    @FunctionalInterface
    public static interface MenuRunnable
    extends Runnable {
        default public void cancel() {
            throw new EventHandledException();
        }
    }
}

