/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.jsonsimple;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONArray;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONObject;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONParseException;
import sk.adonikeoffice.epicchat.lib.jsonsimple.Jsonable;
import sk.adonikeoffice.epicchat.lib.jsonsimple.Yylex;
import sk.adonikeoffice.epicchat.lib.jsonsimple.Yytoken;

public class JSONParser {
    @Deprecated
    public static JSONParser getInstance() {
        return new JSONParser();
    }

    private JSONParser() {
    }

    @Deprecated
    public static Object parse(Reader reader) throws JSONParseException {
        return JSONParser.deserialize(reader);
    }

    @Deprecated
    public static Object parse(String json) throws JSONParseException {
        return JSONParser.deserialize(json);
    }

    public static Object deserialize(Reader readableDeserializable) throws JSONParseException {
        return JSONParser.deserialize(readableDeserializable, EnumSet.of(DeserializationOptions.ALLOW_JSON_ARRAYS, DeserializationOptions.ALLOW_JSON_OBJECTS, DeserializationOptions.ALLOW_JSON_DATA)).get(0);
    }

    private static JSONArray deserialize(Reader deserializable, Set<DeserializationOptions> flags) throws JSONParseException {
        Yytoken token;
        States currentState;
        Yylex lexer = new Yylex(deserializable);
        int returnCount = 1;
        LinkedList<States> stateStack = new LinkedList<States>();
        LinkedList<Object> valueStack = new LinkedList<Object>();
        stateStack.addLast(States.INITIAL);
        block31: do {
            currentState = JSONParser.popNextState(stateStack);
            token = JSONParser.lexNextToken(lexer);
            block0 : switch (currentState) {
                case DONE: {
                    if (!flags.contains((Object)DeserializationOptions.ALLOW_CONCATENATED_JSON_VALUES) || Yytoken.Types.END.equals((Object)token.getType())) continue block31;
                    ++returnCount;
                }
                case INITIAL: {
                    switch (token.getType()) {
                        case DATUM: {
                            if (flags.contains((Object)DeserializationOptions.ALLOW_JSON_DATA)) {
                                valueStack.addLast(token.getValue());
                                stateStack.addLast(States.DONE);
                                break block0;
                            }
                            throw new JSONParseException(lexer.getPosition(), JSONParseException.Problems.DISALLOWED_TOKEN, token);
                        }
                        case LEFT_BRACE: {
                            if (flags.contains((Object)DeserializationOptions.ALLOW_JSON_OBJECTS)) {
                                valueStack.addLast(new JSONObject());
                                stateStack.addLast(States.PARSING_OBJECT);
                                break block0;
                            }
                            throw new JSONParseException(lexer.getPosition(), JSONParseException.Problems.DISALLOWED_TOKEN, token);
                        }
                        case LEFT_SQUARE: {
                            if (flags.contains((Object)DeserializationOptions.ALLOW_JSON_ARRAYS)) {
                                valueStack.addLast(new JSONArray());
                                stateStack.addLast(States.PARSING_ARRAY);
                                break block0;
                            }
                            throw new JSONParseException(lexer.getPosition(), JSONParseException.Problems.DISALLOWED_TOKEN, token);
                        }
                    }
                    throw new JSONParseException(lexer.getPosition(), JSONParseException.Problems.UNEXPECTED_TOKEN, token);
                }
                case PARSED_ERROR: {
                    throw new JSONParseException(lexer.getPosition(), JSONParseException.Problems.UNEXPECTED_TOKEN, token);
                }
                case PARSING_ARRAY: {
                    switch (token.getType()) {
                        case COMMA: {
                            stateStack.addLast(currentState);
                            break block0;
                        }
                        case DATUM: {
                            JSONArray val = (JSONArray)valueStack.getLast();
                            val.add(token.getValue());
                            stateStack.addLast(currentState);
                            break block0;
                        }
                        case LEFT_BRACE: {
                            JSONArray val = (JSONArray)valueStack.getLast();
                            JSONObject object = new JSONObject();
                            val.add(object);
                            valueStack.addLast(object);
                            stateStack.addLast(currentState);
                            stateStack.addLast(States.PARSING_OBJECT);
                            break block0;
                        }
                        case LEFT_SQUARE: {
                            JSONArray val = (JSONArray)valueStack.getLast();
                            JSONArray array = new JSONArray();
                            val.add(array);
                            valueStack.addLast(array);
                            stateStack.addLast(currentState);
                            stateStack.addLast(States.PARSING_ARRAY);
                            break block0;
                        }
                        case RIGHT_SQUARE: {
                            if (valueStack.size() > returnCount) {
                                valueStack.removeLast();
                                break block0;
                            }
                            stateStack.addLast(States.DONE);
                            break block0;
                        }
                    }
                    throw new JSONParseException(lexer.getPosition(), JSONParseException.Problems.UNEXPECTED_TOKEN, token);
                }
                case PARSING_OBJECT: {
                    String key;
                    switch (token.getType()) {
                        case COMMA: {
                            stateStack.addLast(currentState);
                            break block0;
                        }
                        case DATUM: {
                            if (token.getValue() instanceof String) {
                                key = (String)token.getValue();
                                valueStack.addLast(key);
                                stateStack.addLast(currentState);
                                stateStack.addLast(States.PARSING_ENTRY);
                                break block0;
                            }
                            throw new JSONParseException(lexer.getPosition(), JSONParseException.Problems.UNEXPECTED_TOKEN, token);
                        }
                        case RIGHT_BRACE: {
                            if (valueStack.size() > returnCount) {
                                valueStack.removeLast();
                                break block0;
                            }
                            stateStack.addLast(States.DONE);
                            break block0;
                        }
                    }
                    throw new JSONParseException(lexer.getPosition(), JSONParseException.Problems.UNEXPECTED_TOKEN, token);
                }
                case PARSING_ENTRY: {
                    String key;
                    switch (token.getType()) {
                        case COLON: {
                            stateStack.addLast(currentState);
                            break block0;
                        }
                        case DATUM: {
                            key = (String)valueStack.removeLast();
                            JSONObject parent = (JSONObject)valueStack.getLast();
                            parent.put(key, token.getValue());
                            break block0;
                        }
                        case LEFT_BRACE: {
                            key = (String)valueStack.removeLast();
                            JSONObject parent = (JSONObject)valueStack.getLast();
                            JSONObject object = new JSONObject();
                            parent.put(key, object);
                            valueStack.addLast(object);
                            stateStack.addLast(States.PARSING_OBJECT);
                            break block0;
                        }
                        case LEFT_SQUARE: {
                            key = (String)valueStack.removeLast();
                            JSONObject parent = (JSONObject)valueStack.getLast();
                            JSONArray array = new JSONArray();
                            parent.put(key, array);
                            valueStack.addLast(array);
                            stateStack.addLast(States.PARSING_ARRAY);
                            break block0;
                        }
                    }
                    throw new JSONParseException(lexer.getPosition(), JSONParseException.Problems.UNEXPECTED_TOKEN, token);
                }
            }
        } while (!States.DONE.equals((Object)currentState) || !Yytoken.Types.END.equals((Object)token.getType()));
        return new JSONArray((Collection<?>)valueStack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(@NonNull String deserializable) throws JSONParseException {
        Object returnable;
        if (deserializable == null) {
            throw new NullPointerException("deserializable is marked non-null but is null");
        }
        String trimmed = deserializable.trim();
        if (!trimmed.startsWith("{") || !trimmed.endsWith("}")) {
            return deserializable;
        }
        try (StringReader readableDeserializable = null;){
            readableDeserializable = new StringReader(deserializable);
            returnable = JSONParser.deserialize(readableDeserializable);
        }
        return returnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray deserialize(String deserializable, JSONArray defaultValue) {
        JSONArray returnable;
        try (StringReader readable = null;){
            readable = new StringReader(deserializable);
            returnable = JSONParser.deserialize(readable, EnumSet.of(DeserializationOptions.ALLOW_JSON_ARRAYS)).getArray(0);
        }
        return returnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject deserialize(String deserializable, JSONObject defaultValue) {
        JSONObject returnable;
        try (StringReader readable = null;){
            readable = new StringReader(deserializable);
            returnable = (JSONObject)JSONParser.deserialize(readable, EnumSet.of(DeserializationOptions.ALLOW_JSON_OBJECTS)).getMap(0);
        }
        return returnable;
    }

    public static JSONArray deserializeMany(Reader deserializable) throws JSONParseException {
        return JSONParser.deserialize(deserializable, EnumSet.of(DeserializationOptions.ALLOW_JSON_ARRAYS, DeserializationOptions.ALLOW_JSON_OBJECTS, DeserializationOptions.ALLOW_JSON_DATA, DeserializationOptions.ALLOW_CONCATENATED_JSON_VALUES));
    }

    public static String escape(String escapable) {
        StringBuilder builder = new StringBuilder();
        int characters = escapable.length();
        block9: for (int i = 0; i < characters; ++i) {
            char character = escapable.charAt(i);
            switch (character) {
                case '\"': {
                    builder.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    builder.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    builder.append("\\b");
                    continue block9;
                }
                case '\f': {
                    builder.append("\\f");
                    continue block9;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block9;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block9;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block9;
                }
                default: {
                    if (character >= '\u0000' && character <= '\u001f' || character >= '\u007f' && character <= '\u009f' || character >= '\u2000' && character <= '\u20ff') {
                        String characterHexCode = Integer.toHexString(character);
                        builder.append("\\u");
                        for (int k = 0; k < 4 - characterHexCode.length(); ++k) {
                            builder.append("0");
                        }
                        builder.append(characterHexCode.toUpperCase());
                        continue block9;
                    }
                    builder.append(character);
                }
            }
        }
        return builder.toString();
    }

    private static Yytoken lexNextToken(Yylex lexer) throws JSONParseException {
        Yytoken returnable;
        try {
            returnable = lexer.yylex();
        }
        catch (IOException caught) {
            throw new JSONParseException(-1L, JSONParseException.Problems.UNEXPECTED_EXCEPTION, caught);
        }
        if (returnable == null) {
            returnable = new Yytoken(Yytoken.Types.END, null);
        }
        return returnable;
    }

    private static States popNextState(LinkedList<States> stateStack) {
        if (stateStack.size() > 0) {
            return stateStack.removeLast();
        }
        return States.PARSED_ERROR;
    }

    public static void prettyPrint(Reader readable, Writer writable, String indentation, String newline) throws IOException, JSONParseException {
        Yytoken lexed;
        Yylex lexer = new Yylex(readable);
        int level = 0;
        block7: do {
            lexed = JSONParser.lexNextToken(lexer);
            switch (lexed.getType()) {
                case COLON: {
                    writable.append(lexed.getValue().toString());
                    writable.append(' ');
                    break;
                }
                case COMMA: {
                    int i;
                    writable.append(lexed.getValue().toString());
                    writable.append(newline);
                    for (i = 0; i < level; ++i) {
                        writable.append(indentation);
                    }
                    continue block7;
                }
                case END: {
                    break;
                }
                case LEFT_BRACE: 
                case LEFT_SQUARE: {
                    int i;
                    writable.append(lexed.getValue().toString());
                    writable.append(newline);
                    ++level;
                    for (i = 0; i < level; ++i) {
                        writable.append(indentation);
                    }
                    continue block7;
                }
                case RIGHT_SQUARE: 
                case RIGHT_BRACE: {
                    int i;
                    writable.append(newline);
                    --level;
                    for (i = 0; i < level; ++i) {
                        writable.append(indentation);
                    }
                    writable.append(lexed.getValue().toString());
                    break;
                }
                default: {
                    if (lexed.getValue() == null) {
                        writable.append("null");
                        break;
                    }
                    if (lexed.getValue() instanceof String) {
                        writable.append("\"");
                        writable.append(JSONParser.escape((String)lexed.getValue()));
                        writable.append("\"");
                        break;
                    }
                    writable.append(lexed.getValue().toString());
                }
            }
        } while (!lexed.getType().equals((Object)Yytoken.Types.END));
        writable.flush();
    }

    public static String prettyPrint(String printable) {
        StringWriter writer = new StringWriter();
        try {
            JSONParser.prettyPrint(new StringReader(printable), writer, "\t", "\n");
        }
        catch (IOException iOException) {
        }
        catch (JSONParseException jSONParseException) {
            // empty catch block
        }
        return writer.toString();
    }

    public static String serialize(Object jsonSerializable) {
        StringWriter writableDestination = new StringWriter();
        try {
            JSONParser.serialize(jsonSerializable, writableDestination);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writableDestination.toString();
    }

    public static void serialize(Object jsonSerializable, Writer writableDestination) throws IOException {
        JSONParser.serialize(jsonSerializable, writableDestination, EnumSet.of(SerializationOptions.ALLOW_JSONABLES));
    }

    private static void serialize(Object jsonSerializable, Writer writableDestination, Set<SerializationOptions> flags) throws IOException {
        if (jsonSerializable == null) {
            writableDestination.write("null");
        } else if (jsonSerializable instanceof Jsonable && flags.contains((Object)SerializationOptions.ALLOW_JSONABLES)) {
            ((Jsonable)jsonSerializable).toJson(writableDestination);
        } else if (jsonSerializable instanceof String) {
            writableDestination.write(34);
            writableDestination.write(JSONParser.escape((String)jsonSerializable));
            writableDestination.write(34);
        } else if (jsonSerializable instanceof Character) {
            writableDestination.write(JSONParser.escape(jsonSerializable.toString()));
        } else if (jsonSerializable instanceof Double) {
            if (((Double)jsonSerializable).isInfinite() || ((Double)jsonSerializable).isNaN()) {
                writableDestination.write("null");
            } else {
                writableDestination.write(jsonSerializable.toString());
            }
        } else if (jsonSerializable instanceof Float) {
            if (((Float)jsonSerializable).isInfinite() || ((Float)jsonSerializable).isNaN()) {
                writableDestination.write("null");
            } else {
                writableDestination.write(jsonSerializable.toString());
            }
        } else if (jsonSerializable instanceof Number) {
            writableDestination.write(jsonSerializable.toString());
        } else if (jsonSerializable instanceof Boolean) {
            writableDestination.write(jsonSerializable.toString());
        } else if (jsonSerializable instanceof Map) {
            boolean isFirstEntry = true;
            Iterator entries = ((Map)jsonSerializable).entrySet().iterator();
            writableDestination.write(123);
            while (entries.hasNext()) {
                if (isFirstEntry) {
                    isFirstEntry = false;
                } else {
                    writableDestination.write(44);
                }
                Map.Entry entry = entries.next();
                JSONParser.serialize(entry.getKey(), writableDestination, flags);
                writableDestination.write(58);
                JSONParser.serialize(entry.getValue(), writableDestination, flags);
            }
            writableDestination.write(125);
        } else if (jsonSerializable instanceof Collection) {
            boolean isFirstElement = true;
            Iterator elements = ((Collection)jsonSerializable).iterator();
            writableDestination.write(91);
            while (elements.hasNext()) {
                if (isFirstElement) {
                    isFirstElement = false;
                } else {
                    writableDestination.write(44);
                }
                JSONParser.serialize(elements.next(), writableDestination, flags);
            }
            writableDestination.write(93);
        } else if (jsonSerializable instanceof byte[]) {
            byte[] writableArray = (byte[])jsonSerializable;
            int numberOfElements = writableArray.length;
            writableDestination.write(91);
            for (int i = 0; i < numberOfElements; ++i) {
                if (i == numberOfElements - 1) {
                    JSONParser.serialize(writableArray[i], writableDestination, flags);
                    continue;
                }
                JSONParser.serialize(writableArray[i], writableDestination, flags);
                writableDestination.write(44);
            }
            writableDestination.write(93);
        } else if (jsonSerializable instanceof short[]) {
            short[] writableArray = (short[])jsonSerializable;
            int numberOfElements = writableArray.length;
            writableDestination.write(91);
            for (int i = 0; i < numberOfElements; ++i) {
                if (i == numberOfElements - 1) {
                    JSONParser.serialize(writableArray[i], writableDestination, flags);
                    continue;
                }
                JSONParser.serialize(writableArray[i], writableDestination, flags);
                writableDestination.write(44);
            }
            writableDestination.write(93);
        } else if (jsonSerializable instanceof int[]) {
            int[] writableArray = (int[])jsonSerializable;
            int numberOfElements = writableArray.length;
            writableDestination.write(91);
            for (int i = 0; i < numberOfElements; ++i) {
                if (i == numberOfElements - 1) {
                    JSONParser.serialize(writableArray[i], writableDestination, flags);
                    continue;
                }
                JSONParser.serialize(writableArray[i], writableDestination, flags);
                writableDestination.write(44);
            }
            writableDestination.write(93);
        } else if (jsonSerializable instanceof long[]) {
            long[] writableArray = (long[])jsonSerializable;
            int numberOfElements = writableArray.length;
            writableDestination.write(91);
            for (int i = 0; i < numberOfElements; ++i) {
                if (i == numberOfElements - 1) {
                    JSONParser.serialize(writableArray[i], writableDestination, flags);
                    continue;
                }
                JSONParser.serialize(writableArray[i], writableDestination, flags);
                writableDestination.write(44);
            }
            writableDestination.write(93);
        } else if (jsonSerializable instanceof float[]) {
            float[] writableArray = (float[])jsonSerializable;
            int numberOfElements = writableArray.length;
            writableDestination.write(91);
            for (int i = 0; i < numberOfElements; ++i) {
                if (i == numberOfElements - 1) {
                    JSONParser.serialize(Float.valueOf(writableArray[i]), writableDestination, flags);
                    continue;
                }
                JSONParser.serialize(Float.valueOf(writableArray[i]), writableDestination, flags);
                writableDestination.write(44);
            }
            writableDestination.write(93);
        } else if (jsonSerializable instanceof double[]) {
            double[] writableArray = (double[])jsonSerializable;
            int numberOfElements = writableArray.length;
            writableDestination.write(91);
            for (int i = 0; i < numberOfElements; ++i) {
                if (i == numberOfElements - 1) {
                    JSONParser.serialize(writableArray[i], writableDestination, flags);
                    continue;
                }
                JSONParser.serialize(writableArray[i], writableDestination, flags);
                writableDestination.write(44);
            }
            writableDestination.write(93);
        } else if (jsonSerializable instanceof boolean[]) {
            boolean[] writableArray = (boolean[])jsonSerializable;
            int numberOfElements = writableArray.length;
            writableDestination.write(91);
            for (int i = 0; i < numberOfElements; ++i) {
                if (i == numberOfElements - 1) {
                    JSONParser.serialize(writableArray[i], writableDestination, flags);
                    continue;
                }
                JSONParser.serialize(writableArray[i], writableDestination, flags);
                writableDestination.write(44);
            }
            writableDestination.write(93);
        } else if (jsonSerializable instanceof char[]) {
            char[] writableArray = (char[])jsonSerializable;
            int numberOfElements = writableArray.length;
            writableDestination.write("[\"");
            for (int i = 0; i < numberOfElements; ++i) {
                if (i == numberOfElements - 1) {
                    JSONParser.serialize(Character.valueOf(writableArray[i]), writableDestination, flags);
                    continue;
                }
                JSONParser.serialize(Character.valueOf(writableArray[i]), writableDestination, flags);
                writableDestination.write("\",\"");
            }
            writableDestination.write("\"]");
        } else if (jsonSerializable instanceof Object[]) {
            Object[] writableArray = (Object[])jsonSerializable;
            int numberOfElements = writableArray.length;
            writableDestination.write(91);
            for (int i = 0; i < numberOfElements; ++i) {
                if (i == numberOfElements - 1) {
                    JSONParser.serialize(writableArray[i], writableDestination, flags);
                    continue;
                }
                JSONParser.serialize(writableArray[i], writableDestination, flags);
                writableDestination.write(",");
            }
            writableDestination.write(93);
        } else if (flags.contains((Object)SerializationOptions.ALLOW_INVALIDS)) {
            writableDestination.write(jsonSerializable.toString());
        } else {
            throw new IllegalArgumentException("Encountered a: " + jsonSerializable.getClass().getName() + " as: " + jsonSerializable.toString() + "  that isn't JSON serializable.\n  Try:\n    1) Implementing the Jsonable interface for the object to return valid JSON. If it already does it probably has a bug.\n    2) If you cannot edit the source of the object or couple it with this library consider wrapping it in a class that does implement the Jsonable interface.\n    3) Otherwise convert it to a boolean, null, number, JsonArray, JsonObject, or String value before serializing it.\n    4) If you feel it should have serialized you could use a more tolerant serialization for debugging purposes.");
        }
    }

    public static void serializeCarelessly(Object jsonSerializable, Writer writableDestination) throws IOException {
        JSONParser.serialize(jsonSerializable, writableDestination, EnumSet.of(SerializationOptions.ALLOW_JSONABLES, SerializationOptions.ALLOW_INVALIDS));
    }

    public static void serializeStrictly(Object jsonSerializable, Writer writableDestination) throws IOException {
        JSONParser.serialize(jsonSerializable, writableDestination, EnumSet.noneOf(SerializationOptions.class));
    }

    private static enum DeserializationOptions {
        ALLOW_CONCATENATED_JSON_VALUES,
        ALLOW_JSON_ARRAYS,
        ALLOW_JSON_DATA,
        ALLOW_JSON_OBJECTS;

    }

    private static enum States {
        DONE,
        INITIAL,
        PARSED_ERROR,
        PARSING_ARRAY,
        PARSING_ENTRY,
        PARSING_OBJECT;

    }

    private static enum SerializationOptions {
        ALLOW_INVALIDS,
        ALLOW_JSONABLES;

    }
}

