/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.jsonsimple;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONArray;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONParser;
import sk.adonikeoffice.epicchat.lib.jsonsimple.Jsonable;

public class JSONObject
extends HashMap<String, Object>
implements Jsonable {
    private static final long serialVersionUID = 2L;

    public JSONObject() {
    }

    public JSONObject(Map<String, ?> map) {
        super(map);
    }

    public JSONObject getObject(String key) {
        Object value = this.get(key);
        if (value != null) {
            if (value instanceof JSONObject) {
                return (JSONObject)value;
            }
            if (value instanceof Map) {
                return new JSONObject((Map)value);
            }
        }
        return null;
    }

    public BigDecimal getBigDecimal(String key) {
        Object returnable = this.get(key);
        if (!(returnable instanceof BigDecimal)) {
            if (returnable instanceof Number) {
                returnable = new BigDecimal(returnable.toString());
            } else if (returnable instanceof String) {
                returnable = new BigDecimal((String)returnable);
            }
        }
        return (BigDecimal)returnable;
    }

    public BigDecimal getBigDecimalOrDefault(String key, BigDecimal def) {
        BigDecimal returnable = this.containsKey(key) ? this.get(key) : def;
        if (!(returnable instanceof BigDecimal)) {
            if (returnable instanceof Number) {
                returnable = new BigDecimal(((Object)returnable).toString());
            } else if (returnable instanceof String) {
                returnable = new BigDecimal((String)((Object)returnable));
            }
        }
        return returnable;
    }

    public Boolean getBoolean(String key) {
        Object returnable = this.get(key);
        if (returnable instanceof String) {
            returnable = Boolean.valueOf((String)returnable);
        }
        return (Boolean)returnable;
    }

    public Boolean getBooleanOrDefault(String key, boolean def) {
        Boolean returnable = this.containsKey(key) ? this.get(key) : Boolean.valueOf(def);
        if (returnable instanceof String) {
            returnable = Boolean.valueOf((String)((Object)returnable));
        }
        return returnable;
    }

    public Byte getByte(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).byteValue();
    }

    public Byte getByteOrDefault(String key, byte def) {
        Number returnable = this.containsKey(key) ? this.get(key) : Byte.valueOf(def);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)((Object)returnable));
        }
        return ((Number)returnable).byteValue();
    }

    public JSONArray getArray(String key) {
        Object collection = this.get(key);
        if (collection instanceof JSONArray) {
            return (JSONArray)collection;
        }
        if (collection instanceof Collection) {
            return new JSONArray((Collection<?>)((Collection)collection));
        }
        return null;
    }

    public Double getDouble(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).doubleValue();
    }

    public Double getDoubleOrDefault(String key, double def) {
        Number returnable = this.containsKey(key) ? this.get(key) : Double.valueOf(def);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)((Object)returnable));
        }
        return ((Number)returnable).doubleValue();
    }

    public Integer getInteger(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).intValue();
    }

    public Integer getIntegerOrDefault(String key, int def) {
        Number returnable = this.containsKey(key) ? this.get(key) : Integer.valueOf(def);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)((Object)returnable));
        }
        return ((Number)returnable).intValue();
    }

    public Long getLong(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).longValue();
    }

    public Long getLongOrDefault(String key, long def) {
        Number returnable = this.containsKey(key) ? this.get(key) : Long.valueOf(def);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)((Object)returnable));
        }
        return ((Number)returnable).longValue();
    }

    public <T extends Map<?, ?>> T getMap(String key) {
        return (T)((Map)this.get(key));
    }

    public <T extends Map<?, ?>> T getMapOrDefault(String key, T def) {
        Object returnable = this.containsKey(key) ? this.get(key) : def;
        return returnable;
    }

    public String getString(String key) {
        Object returnable = this.get(key);
        if (returnable instanceof Boolean) {
            returnable = returnable.toString();
        } else if (returnable instanceof Number) {
            returnable = returnable.toString();
        }
        return (String)returnable;
    }

    public String getStringOrDefault(String key, String def) {
        String returnable = this.containsKey(key) ? this.get(key) : def;
        if (returnable instanceof Boolean) {
            returnable = returnable.toString();
        } else if (returnable instanceof Number) {
            returnable = returnable.toString();
        }
        return returnable;
    }

    public JSONObject putAllChain(Map<String, Object> map) {
        this.putAll(map);
        return this;
    }

    public JSONObject putChain(String key, Object value) {
        this.put(key, value);
        return this;
    }

    public Object remove(String key) {
        return this.remove(key);
    }

    public boolean remove(String key, Object value) {
        return this.remove(key, value);
    }

    public void requireKeys(String ... keys) {
        HashSet<String> missing = new HashSet<String>();
        for (String subkey : keys) {
            if (this.containsKey(subkey)) continue;
            missing.add(subkey);
        }
        if (!missing.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String subkey : missing) {
                sb.append(subkey).append(", ");
            }
            sb.setLength(sb.length() - 2);
            String s = missing.size() > 1 ? "s" : "";
            throw new NoSuchElementException("A JsonObject is missing required key" + s + ": " + sb.toString());
        }
    }

    @Override
    public String toJson() {
        StringWriter writable = new StringWriter();
        try {
            this.toJson(writable);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writable.toString();
    }

    @Override
    public void toJson(Writer writable) throws IOException {
        boolean isFirstEntry = true;
        writable.write(123);
        for (Map.Entry entry : this.entrySet()) {
            if (isFirstEntry) {
                isFirstEntry = false;
            } else {
                writable.write(44);
            }
            JSONParser.serialize(entry.getKey(), writable);
            writable.write(58);
            JSONParser.serialize(entry.getValue(), writable);
        }
        writable.write(125);
    }

    @Override
    public String toString() {
        return this.toJson();
    }
}

