/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.jsonsimple;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONObject;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONParser;
import sk.adonikeoffice.epicchat.lib.jsonsimple.Jsonable;

public class JSONArray
extends ArrayList<Object>
implements Jsonable {
    private static final long serialVersionUID = 1L;

    public JSONArray() {
    }

    public JSONArray(Collection<?> collection) {
        super(collection);
    }

    public JSONArray addAllChain(Collection<?> collection) {
        this.addAll(collection);
        return this;
    }

    public JSONArray addAllChain(int index, Collection<?> collection) {
        this.addAll(index, collection);
        return this;
    }

    public JSONArray addChain(int index, Object element) {
        this.add(index, element);
        return this;
    }

    public JSONArray addChain(Object element) {
        this.add(element);
        return this;
    }

    public <T> void asCollection(Collection<T> destination) {
        for (Object o : this) {
            destination.add(o);
        }
    }

    public JSONObject getObject(int index) {
        Object value = this.get(index);
        if (value != null) {
            if (value instanceof JSONObject) {
                return (JSONObject)value;
            }
            if (value instanceof Map) {
                return new JSONObject((Map)value);
            }
        }
        return null;
    }

    public BigDecimal getBigDecimal(int index) {
        Object returnable = this.get(index);
        if (!(returnable instanceof BigDecimal)) {
            if (returnable instanceof Number) {
                returnable = new BigDecimal(returnable.toString());
            } else if (returnable instanceof String) {
                returnable = new BigDecimal((String)returnable);
            }
        }
        return (BigDecimal)returnable;
    }

    public Boolean getBoolean(int index) {
        Object returnable = this.get(index);
        if (returnable instanceof String) {
            returnable = Boolean.valueOf((String)returnable);
        }
        return (Boolean)returnable;
    }

    public Byte getByte(int index) {
        Object returnable = this.get(index);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).byteValue();
    }

    public JSONArray getArray(int index) {
        Object collection = this.get(index);
        if (collection instanceof JSONArray) {
            return (JSONArray)collection;
        }
        if (collection instanceof Collection) {
            return new JSONArray((Collection<?>)((Collection)collection));
        }
        return null;
    }

    public Double getDouble(int index) {
        Object returnable = this.get(index);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).doubleValue();
    }

    public Float getFloat(int index) {
        Object returnable = this.get(index);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return Float.valueOf(((Number)returnable).floatValue());
    }

    public Integer getInteger(int index) {
        Object returnable = this.get(index);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).intValue();
    }

    public Long getLong(int index) {
        Object returnable = this.get(index);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).longValue();
    }

    public <T extends Map<?, ?>> T getMap(int index) {
        return (T)((Map)this.get(index));
    }

    public Short getShort(int index) {
        Object returnable = this.get(index);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).shortValue();
    }

    public String getString(int index) {
        Object returnable = this.get(index);
        if (returnable instanceof Boolean) {
            returnable = returnable.toString();
        } else if (returnable instanceof Number) {
            returnable = returnable.toString();
        }
        return (String)returnable;
    }

    @Override
    public String toJson() {
        StringWriter writable = new StringWriter();
        try {
            this.toJson(writable);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writable.toString();
    }

    @Override
    public void toJson(Writer writable) throws IOException {
        boolean isFirstElement = true;
        Iterator elements = this.iterator();
        writable.write(91);
        while (elements.hasNext()) {
            if (isFirstElement) {
                isFirstElement = false;
            } else {
                writable.write(44);
            }
            JSONParser.serialize(elements.next(), writable);
        }
        writable.write(93);
    }

    public String[] toStringArray() {
        String[] array = new String[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getString(index);
        }
        return array;
    }

    public JSONObject[] toObjectArray() {
        JSONObject[] array = new JSONObject[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getObject(index);
        }
        return array;
    }

    public JSONArray[] toArrayArray() {
        JSONArray[] array = new JSONArray[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getArray(index);
        }
        return array;
    }

    public byte[] toPrimitiveByteArray() {
        byte[] array = new byte[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getByte(index);
        }
        return array;
    }

    public short[] toPrimitiveShortArray() {
        short[] array = new short[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getShort(index);
        }
        return array;
    }

    public int[] toPrimitiveIntArray() {
        int[] array = new int[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getInteger(index);
        }
        return array;
    }

    public long[] toPrimitiveLongArray() {
        long[] array = new long[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getLong(index);
        }
        return array;
    }

    public float[] toPrimitiveFloatArray() {
        float[] array = new float[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getFloat(index).floatValue();
        }
        return array;
    }

    public double[] toPrimitiveDoubleArray() {
        double[] array = new double[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getDouble(index);
        }
        return array;
    }

    public boolean[] toPrimitiveBooleanArray() {
        boolean[] array = new boolean[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getBoolean(index);
        }
        return array;
    }
}

