/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.exception;

import sk.adonikeoffice.epicchat.lib.debug.Debugger;

public class FoException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static boolean errorSavedAutomatically = true;

    public FoException(Throwable t) {
        super(t);
        if (errorSavedAutomatically) {
            Debugger.saveError(t, new String[0]);
        }
    }

    public FoException(String message) {
        super(message);
        if (errorSavedAutomatically) {
            Debugger.saveError(this, message);
        }
    }

    public FoException(String message, Throwable t) {
        this(t, message);
    }

    public FoException(Throwable t, String message) {
        super(message, t);
        if (errorSavedAutomatically) {
            Debugger.saveError(t, message);
        }
    }

    public FoException() {
        if (errorSavedAutomatically) {
            Debugger.saveError(this, new String[0]);
        }
    }

    @Override
    public String getMessage() {
        return "Report: " + super.getMessage();
    }

    public static boolean isErrorSavedAutomatically() {
        return errorSavedAutomatically;
    }

    public static void setErrorSavedAutomatically(boolean errorSavedAutomatically) {
        FoException.errorSavedAutomatically = errorSavedAutomatically;
    }
}

