/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.event;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Messenger;
import sk.adonikeoffice.epicchat.lib.PlayerUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.debug.LagCatcher;
import sk.adonikeoffice.epicchat.lib.exception.EventHandledException;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.model.Variables;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;

public abstract class SimpleListener<T extends Event>
implements Listener,
EventExecutor {
    private final Class<T> eventClass;
    private final EventPriority priority;
    private final boolean ignoreCancelled;
    private T event;

    public SimpleListener(Class<T> event) {
        this(event, EventPriority.NORMAL);
    }

    public SimpleListener(Class<T> event, EventPriority priority) {
        this(event, priority, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(Listener listener, Event event) throws EventException {
        if (!event.getClass().equals(this.eventClass)) {
            return;
        }
        String logName = listener.getClass().getSimpleName() + " listening to " + event.getEventName() + " at " + this.priority + " priority";
        LagCatcher.start(logName);
        try {
            this.event = (Event)this.eventClass.cast(event);
            this.execute(event);
        }
        catch (EventHandledException ex) {
            String[] messages = ex.getMessages();
            boolean cancelled = ex.isCancelled();
            Player player = this.findPlayer();
            if (messages != null && player != null) {
                for (String message : messages) {
                    message = Variables.replace(message, (CommandSender)player);
                    if (Messenger.ENABLED) {
                        Messenger.error((CommandSender)player, message);
                        continue;
                    }
                    Common.tell((CommandSender)player, "&c" + message);
                }
            }
            if (cancelled && event instanceof Cancellable) {
                ((Cancellable)event).setCancelled(true);
            }
        }
        catch (Throwable t) {
            Common.error(t, "Unhandled exception listening to " + this.eventClass.getSimpleName());
        }
        finally {
            LagCatcher.end(logName);
        }
    }

    protected abstract void execute(T var1);

    protected Player findPlayer() {
        Valid.checkNotNull(this.event, "Called findPlayer for null event!");
        if (this.event instanceof PlayerEvent) {
            return ((PlayerEvent)this.event).getPlayer();
        }
        throw new FoException("Called findPlayer but not method not implemented for event " + this.event);
    }

    protected final void checkNotNull(Object toCheck, String ... nullMessages) {
        this.checkBoolean(toCheck != null, nullMessages);
    }

    protected final void checkBoolean(boolean condition, String ... falseMessages) {
        if (!condition) {
            throw new EventHandledException(true, falseMessages);
        }
    }

    protected final void checkPerm(String permission) {
        this.checkPerm(permission, SimpleLocalization.NO_PERMISSION);
    }

    protected final boolean hasPerm(String permission) {
        return PlayerUtil.hasPerm((Permissible)this.findPlayer(), permission);
    }

    protected final void checkPerm(String permission, String falseMessage) {
        Player player = this.findPlayer();
        Valid.checkNotNull(player, "Player cannot be null for " + this.event + "!");
        if (!PlayerUtil.hasPerm((Permissible)player, permission)) {
            throw new EventHandledException(true, falseMessage.replace("{permission}", permission));
        }
    }

    protected final void cancel(String ... messages) {
        throw new EventHandledException(true, messages);
    }

    protected final void cancel() {
        throw new EventHandledException(true, new String[0]);
    }

    protected final void returnTell(String ... messages) {
        throw new EventHandledException(false, messages);
    }

    public final void register() {
        Bukkit.getPluginManager().registerEvent(this.eventClass, (Listener)this, this.priority, (EventExecutor)this, (Plugin)SimplePlugin.getInstance(), this.ignoreCancelled);
    }

    public SimpleListener(Class<T> eventClass, EventPriority priority, boolean ignoreCancelled) {
        this.eventClass = eventClass;
        this.priority = priority;
        this.ignoreCancelled = ignoreCancelled;
    }

    protected T getEvent() {
        return this.event;
    }
}

