/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.debug;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import lombok.NonNull;
import org.bukkit.Bukkit;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.FileUtil;
import sk.adonikeoffice.epicchat.lib.TimeUtil;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.settings.SimpleSettings;

public final class Debugger {
    private static final Map<String, ArrayList<String>> pendingMessages = new HashMap<String, ArrayList<String>>();
    private static boolean debugModeEnabled = false;

    public static void detectDebugMode() {
        if (new File(SimplePlugin.getData(), "debug.lock").exists()) {
            debugModeEnabled = true;
            Bukkit.getLogger().info("Detected debug.lock file, debug features enabled!");
        } else {
            debugModeEnabled = false;
        }
    }

    public static void debug(String section, String ... messages) {
        if (Debugger.isDebugged(section)) {
            for (String message : messages) {
                Debugger.print("[" + section + "] " + message);
            }
        }
    }

    public static void put(String section, String message) {
        if (!Debugger.isDebugged(section)) {
            return;
        }
        ArrayList<String> list = pendingMessages.getOrDefault(section, new ArrayList());
        list.add(message);
        pendingMessages.put(section, list);
    }

    public static void push(String section, String message) {
        Debugger.put(section, message);
        Debugger.push(section);
    }

    public static void push(String section) {
        if (!Debugger.isDebugged(section)) {
            return;
        }
        List parts = pendingMessages.remove(section);
        if (parts == null) {
            return;
        }
        String whole = String.join((CharSequence)"", parts);
        for (String message : whole.split("\n")) {
            Debugger.debug(section, message);
        }
    }

    public static boolean isDebugged(String section) {
        return SimpleSettings.DEBUG_SECTIONS.contains(section) || SimpleSettings.DEBUG_SECTIONS.contains("*");
    }

    public static void saveError(Throwable t, String ... messages) {
        if (Bukkit.getServer() == null) {
            return;
        }
        String systemInfo = "Running " + Bukkit.getName() + " " + Bukkit.getBukkitVersion() + " and Java " + System.getProperty("java.version");
        try {
            ArrayList<String> lines = new ArrayList<String>();
            String header = SimplePlugin.getNamed() + " " + SimplePlugin.getVersion() + " encountered " + Common.article(t.getClass().getSimpleName());
            Debugger.fill(lines, "------------------------------------[ " + TimeUtil.getFormattedDate() + " ]-----------------------------------", header, systemInfo, "Plugins: " + Common.join(Bukkit.getPluginManager().getPlugins(), ", "), "----------------------------------------------------------------------------------------------");
            if (messages != null && !String.join((CharSequence)"", messages).isEmpty()) {
                Debugger.fill(lines, "\nMore Information: ");
                Debugger.fill(lines, messages);
            }
            block2: do {
                Debugger.fill(lines, t == null ? "Unknown error" : t.getClass().getSimpleName() + " " + Common.getOrDefault(t.getMessage(), Common.getOrDefault(t.getLocalizedMessage(), "(Unknown cause)")));
                int count = 0;
                for (StackTraceElement el : t.getStackTrace()) {
                    ++count;
                    String trace = el.toString();
                    if (trace.contains("sun.reflect")) continue;
                    if (count > 6 && trace.startsWith("net.minecraft.server")) continue block2;
                    Debugger.fill(lines, "\t at " + el.toString());
                }
            } while ((t = t.getCause()) != null);
            Debugger.fill(lines, "----------------------------------------------------------------------------------------------", System.lineSeparator());
            Bukkit.getLogger().severe(header + "! Please check your error.log and report this issue with the information in that file. " + systemInfo);
            FileUtil.write("error.log", lines);
        }
        catch (Throwable secondError) {
            Bukkit.getLogger().log(Level.SEVERE, "Got error when saving another error! Saving error:", secondError);
            Bukkit.getLogger().log(Level.SEVERE, "Original error that is not saved:", t);
        }
    }

    private static void fill(List<String> list, String ... messages) {
        list.addAll(Arrays.asList(messages));
    }

    public static List<String> traceRoute(boolean trackLineNumbers) {
        RuntimeException exception = new RuntimeException("I love horses");
        ArrayList<String> paths = new ArrayList<String>();
        for (StackTraceElement el : exception.getStackTrace()) {
            String[] classNames = el.getClassName().split("\\.");
            String className = classNames[classNames.length - 1];
            String line = el.toString();
            if (line.contains("net.minecraft.server") || line.contains("org.bukkit.craftbukkit")) break;
            if (line.contains("org.bukkit.plugin.java.JavaPluginLoader") || line.contains("org.bukkit.plugin.SimplePluginManager") || line.contains("org.bukkit.plugin.JavaPlugin") || paths.contains(className)) continue;
            paths.add(className + "#" + el.getMethodName() + (trackLineNumbers ? "(" + el.getLineNumber() + ")" : ""));
        }
        if (!paths.isEmpty()) {
            paths.remove(0);
        }
        return paths;
    }

    public static void printValues(Object[] values) {
        if (values != null) {
            Debugger.print(Common.consoleLine());
            Debugger.print("Enumeration of " + Common.plural(values.length, values.getClass().getSimpleName().toLowerCase().replace("[]", "")));
            for (int i = 0; i < values.length; ++i) {
                Debugger.print("&8[" + i + "] &7" + values[i]);
            }
        } else {
            Debugger.print("Value are null");
        }
    }

    public static void printStackTrace(String message) {
        StackTraceElement[] trace = new Exception().getStackTrace();
        Debugger.print("!----------------------------------------------------------------------------------------------------------!");
        Debugger.print(message);
        Debugger.print("!----------------------------------------------------------------------------------------------------------!");
        for (int i = 1; i < trace.length; ++i) {
            String line = trace[i].toString();
            if (!Debugger.canPrint(line)) continue;
            Debugger.print("\tat " + line);
        }
        Debugger.print("--------------------------------------------------------------------------------------------------------end-");
    }

    public static void printStackTrace(@NonNull Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        ArrayList<Throwable> causes = new ArrayList<Throwable>();
        if (throwable.getCause() != null) {
            Throwable cause = throwable.getCause();
            do {
                causes.add(cause);
            } while ((cause = cause.getCause()) != null);
        }
        if (throwable instanceof FoException && !causes.isEmpty()) {
            Debugger.print(throwable.getMessage());
        } else {
            Debugger.print(throwable.toString());
            Debugger.printStackTraceElements(throwable);
        }
        if (!causes.isEmpty()) {
            Throwable lastCause = (Throwable)causes.get(causes.size() - 1);
            Debugger.print(lastCause.toString());
            Debugger.printStackTraceElements(lastCause);
        }
    }

    private static void printStackTraceElements(Throwable throwable) {
        for (StackTraceElement element : throwable.getStackTrace()) {
            String line = element.toString();
            if (!Debugger.canPrint(line)) continue;
            Debugger.print("\tat " + line);
        }
    }

    private static boolean canPrint(String message) {
        return !message.contains("net.minecraft") && !message.contains("org.bukkit.craftbukkit") && !message.contains("org.github.paperspigot.ServerScheduler") && !message.contains("nashorn") && !message.contains("javax.script") && !message.contains("org.yaml.snakeyaml") && !message.contains("sun.reflect") && !message.contains("sun.misc") && !message.contains("java.lang.Thread.run") && !message.contains("java.util.concurrent.ThreadPoolExecutor");
    }

    private static void print(String message) {
        System.out.println(message);
    }

    private Debugger() {
    }

    public static boolean isDebugModeEnabled() {
        return debugModeEnabled;
    }
}

