/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import sk.adonikeoffice.epicchat.lib.ChatUtil;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MathUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.database.SimpleDatabase;
import sk.adonikeoffice.epicchat.lib.debug.Debugger;
import sk.adonikeoffice.epicchat.lib.debug.LagCatcher;
import sk.adonikeoffice.epicchat.lib.settings.SimpleSettings;

public abstract class SimpleFlatDatabase<T>
extends SimpleDatabase {
    private boolean isQuerying = false;

    @Override
    protected final void onConnected() {
        Valid.checkBoolean(this.hasVariable("table"), "Please call addVariable in the constructor of your " + this, new Object[0]);
        this.update("CREATE TABLE IF NOT EXISTS {table}(UUID varchar(64), Name text, Data text, Updated bigint, PRIMARY KEY (`UUID`))");
        this.removeOldEntries();
        this.onConnectFinish();
    }

    protected void onConnectFinish() {
    }

    private void removeOldEntries() {
        long threshold = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(this.getExpirationDays());
        this.update("DELETE FROM {table} WHERE Updated < " + threshold + "");
    }

    protected int getExpirationDays() {
        return 90;
    }

    public final void load(Player player, T cache) {
        this.load(player.getUniqueId(), cache, null);
    }

    public final void load(Player player, T cache, @Nullable Runnable runAfterLoad) {
        this.load(player.getUniqueId(), cache, runAfterLoad);
    }

    public final void load(UUID uuid, T cache) {
        this.load(uuid, cache, null);
    }

    public final void load(UUID uuid, T cache, @Nullable Runnable runAfterLoad) {
        if (!this.isLoaded() || this.isQuerying) {
            return;
        }
        LagCatcher.start("mysql");
        this.isQuerying = true;
        Debugger.debug("mysql", "---------------- MySQL - Loading data for " + uuid);
        Common.runAsync(() -> {
            try {
                ResultSet resultSet = this.query("SELECT * FROM {table} WHERE UUID='" + uuid + "'");
                String dataRaw = resultSet.next() ? resultSet.getString("Data") : "{}";
                Debugger.debug("mysql", "JSON: " + dataRaw);
                Common.runLater(() -> {
                    try {
                        SerializedMap data = SerializedMap.fromJson(dataRaw);
                        Debugger.debug("mysql", "Deserialized data: " + data);
                        this.onLoad(data, cache);
                        if (runAfterLoad != null) {
                            runAfterLoad.run();
                        }
                    }
                    catch (Throwable t) {
                        Common.error(t, "Failed to parse loaded data from MySQL!", "UUID: " + uuid, "Raw data: " + dataRaw, "Error: %error");
                    }
                });
            }
            catch (Throwable t) {
                Common.error(t, "Failed to load data from MySQL!", "UUID: " + uuid, "Error: %error");
            }
            finally {
                this.isQuerying = false;
                this.logPerformance("loading");
            }
        });
    }

    protected abstract void onLoad(SerializedMap var1, T var2);

    public final void save(Player player, T cache) {
        this.save(player.getName(), player.getUniqueId(), cache);
    }

    public final void save(String name, UUID uuid, T cache) {
        this.save(name, uuid, cache, null);
    }

    public final void save(Player player, T cache, @Nullable Runnable runAfterSave) {
        this.save(player.getName(), player.getUniqueId(), cache, runAfterSave);
    }

    public final void save(String name, UUID uuid, T cache, @Nullable Runnable runAfterSave) {
        if (!this.isLoaded() || this.isQuerying) {
            return;
        }
        LagCatcher.start("mysql");
        this.isQuerying = true;
        SerializedMap data = this.onSave(cache);
        Debugger.debug("mysql", "---------------- MySQL - Saving data for " + uuid);
        Debugger.debug("mysql", "Raw data: " + data);
        Debugger.debug("mysql", "JSON: " + (data == null ? "null" : data.toJson()));
        Common.runAsync(() -> {
            try {
                if (data == null || data.isEmpty()) {
                    this.update("DELETE FROM {table} WHERE UUID= '" + uuid + "';");
                    if (Debugger.isDebugged("mysql")) {
                        Debugger.debug("mysql", "Data was empty, row has been removed.");
                    }
                } else if (this.isStored(uuid)) {
                    this.update("UPDATE {table} SET Data='" + data.toJson() + "', Updated='" + System.currentTimeMillis() + "' WHERE UUID='" + uuid + "';");
                } else {
                    this.update("INSERT INTO {table}(UUID, Name, Data, Updated) VALUES ('" + uuid + "', '" + name + "', '" + data.toJson() + "', '" + System.currentTimeMillis() + "');");
                }
                if (runAfterSave != null) {
                    Common.runLater(() -> runAfterSave.run());
                }
            }
            catch (Throwable ex) {
                Common.error(ex, "Failed to save data to MySQL!", "UUID: " + uuid, "Error: %error");
            }
            finally {
                this.isQuerying = false;
                this.logPerformance("saving");
            }
        });
    }

    private void logPerformance(String operation) {
        boolean isMainThread = Bukkit.isPrimaryThread();
        LagCatcher.end("mysql", isMainThread ? 10 : MathUtil.atLeast(200, SimpleSettings.LAG_THRESHOLD_MILLIS), ChatUtil.capitalize(operation) + " data to MySQL took {time} ms" + (isMainThread ? " - To prevent slowing the server, " + operation + " can be made async (carefully)" : ""));
    }

    private boolean isStored(@NonNull UUID uuid) throws SQLException {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        ResultSet resultSet = this.query("SELECT * FROM {table} WHERE UUID= '" + uuid.toString() + "'");
        if (resultSet == null) {
            return false;
        }
        if (resultSet.next()) {
            return resultSet.getString("UUID") != null;
        }
        return false;
    }

    protected abstract SerializedMap onSave(T var1);
}

