/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.database;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import lombok.NonNull;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.FileUtil;
import sk.adonikeoffice.epicchat.lib.RandomUtil;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.SerializeUtil;
import sk.adonikeoffice.epicchat.lib.TimeUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.collection.StrictMap;
import sk.adonikeoffice.epicchat.lib.database.DummyResultSet;
import sk.adonikeoffice.epicchat.lib.debug.Debugger;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.model.ConfigSerializable;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public class SimpleDatabase {
    private volatile Connection connection;
    private final StrictMap<String, String> sqlVariables = new StrictMap();
    private String url;
    private LastCredentials lastCredentials;
    private boolean batchUpdateGoingOn = false;
    private boolean connecting = false;
    private Object hikariDataSource;

    public final void connect(String host, int port, String database, String user, String password) {
        this.connect(host, port, database, user, password, null);
    }

    public final void connect(String host, int port, String database, String user, String password, String table) {
        this.connect(host, port, database, user, password, table, true);
    }

    public final void connect(String host, int port, String database, String user, String password, String table, boolean autoReconnect) {
        this.connect("jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=false&useUnicode=yes&characterEncoding=UTF-8&autoReconnect=" + autoReconnect, user, password, table);
    }

    public final void connect(String url) {
        this.connect(url, null, null);
    }

    public final void connect(String url, String user, String password) {
        this.connect(url, user, password, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connect(String url, String user, String password, String table) {
        this.url = url;
        this.connecting = true;
        try {
            if (url.startsWith("jdbc:sqlite")) {
                Class.forName("org.sqlite.JDBC");
                this.connection = DriverManager.getConnection(url);
            } else if (ReflectionUtil.isClassAvailable("com.zaxxer.hikari.HikariConfig")) {
                Object hikariConfig = ReflectionUtil.instantiate("com.zaxxer.hikari.HikariConfig");
                if (url.startsWith("jdbc:mysql://")) {
                    try {
                        ReflectionUtil.invoke("setDriverClassName", hikariConfig, "com.mysql.cj.jdbc.Driver");
                    }
                    catch (Throwable t) {
                        ReflectionUtil.invoke("setDriverClassName", hikariConfig, "com.mysql.jdbc.Driver");
                    }
                } else if (url.startsWith("jdbc:mariadb://")) {
                    ReflectionUtil.invoke("setDriverClassName", hikariConfig, "org.mariadb.jdbc.Driver");
                } else {
                    throw new FoException("Unknown database driver, expected jdbc:mysql or jdbc:mariadb, got: " + url);
                }
                ReflectionUtil.invoke("setJdbcUrl", hikariConfig, url);
                if (user != null) {
                    ReflectionUtil.invoke("setUsername", hikariConfig, user);
                }
                if (password != null) {
                    ReflectionUtil.invoke("setPassword", hikariConfig, password);
                }
                Constructor<?> dataSourceConst = ReflectionUtil.getConstructor("com.zaxxer.hikari.HikariDataSource", hikariConfig.getClass());
                Object hikariSource = ReflectionUtil.instantiate(dataSourceConst, hikariConfig);
                this.hikariDataSource = hikariSource;
                Method getConnection = hikariSource.getClass().getDeclaredMethod("getConnection", new Class[0]);
                try {
                    this.connection = (Connection)ReflectionUtil.invoke(getConnection, hikariSource, new Object[0]);
                }
                catch (Throwable t) {
                    Common.warning("Could not get HikariCP connection, please report this with the information below to github.com/kangarko/foundation");
                    Common.warning("Method: " + getConnection);
                    Common.warning("Arguments: " + Common.join(getConnection.getParameters()));
                    t.printStackTrace();
                }
            } else {
                if (url.startsWith("jdbc:mariadb://") && ReflectionUtil.isClassAvailable("org.mariadb.jdbc.Driver")) {
                    Class.forName("org.mariadb.jdbc.Driver");
                } else if (url.startsWith("jdbc:mysql://") && ReflectionUtil.isClassAvailable("com.mysql.cj.jdbc.Driver")) {
                    Class.forName("com.mysql.cj.jdbc.Driver");
                } else {
                    Common.warning("Your database driver is outdated, switching to MySQL legacy JDBC Driver. If you encounter issues, consider updating your database or switching to MariaDB. You can safely ignore this warning");
                    Class.forName("com.mysql.jdbc.Driver");
                }
                this.connection = user != null && password != null ? DriverManager.getConnection(url, user, password) : DriverManager.getConnection(url);
            }
            this.lastCredentials = new LastCredentials(url, user, password, table);
            this.onConnected();
        }
        catch (Exception ex) {
            if (Common.getOrEmpty(ex.getMessage()).contains("No suitable driver found")) {
                Common.logFramed(true, "Failed to look up database driver! If you had database disabled,", "then enable it and reload - this is expected.", "", "You have have access to your server machine, try installing", "https://mariadb.com/downloads/connectors/connectors-data-access/", "", "If this problem persists after a restart, please contact", "your hosting provider with the error message below.");
            } else {
                Common.logFramed(true, "Failed to connect to database", "URL: " + url, "Error: " + ex.getMessage());
            }
            Remain.sneaky(ex);
        }
        finally {
            this.connecting = false;
        }
    }

    protected final void connectUsingLastCredentials() {
        if (this.lastCredentials != null) {
            this.connect(this.lastCredentials.url, this.lastCredentials.user, this.lastCredentials.password, this.lastCredentials.table);
        }
    }

    protected void onConnected() {
    }

    public final void close(ResultSet resultSet) {
        try {
            if (!resultSet.isClosed()) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            Common.error(e, "Error closing database result set!");
        }
    }

    public final void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
            if (this.hikariDataSource != null) {
                ReflectionUtil.invoke("close", this.hikariDataSource, new Object[0]);
            }
        }
        catch (SQLException e) {
            Common.error(e, "Error closing database connection!");
        }
    }

    protected final void createTable(TableCreator creator) {
        String columns = "";
        for (TableRow column : creator.getColumns()) {
            columns = columns + (columns.isEmpty() ? "" : ", ") + "`" + column.getName() + "` " + column.getDataType();
            if (column.getAutoIncrement() != null && column.getAutoIncrement().booleanValue()) {
                columns = columns + " NOT NULL AUTO_INCREMENT";
            } else if (column.getNotNull() != null && column.getNotNull().booleanValue()) {
                columns = columns + " NOT NULL";
            }
            if (column.getDefaultValue() == null) continue;
            columns = columns + " DEFAULT " + column.getDefaultValue();
        }
        if (creator.getPrimaryColumn() != null) {
            columns = columns + ", PRIMARY KEY (`" + creator.getPrimaryColumn() + "`)";
        }
        try {
            boolean isSQLite = this.url != null && this.url.startsWith("jdbc:sqlite");
            this.update("CREATE TABLE IF NOT EXISTS `" + creator.getName() + "` (" + columns + ")" + (isSQLite ? "" : " DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci") + ";");
        }
        catch (Throwable t) {
            if (t.toString().contains("Unknown collation")) {
                Common.log("You need to update your database driver to support utf8mb4_unicode_520_ci collation. We switched to support unicode using 4 bits length because the previous system only supported 3 bits.");
                Common.log("Some characters such as smiley or Chinese are stored in 4 bits so they would crash the 3-bit database leading to more problems. Most hosting providers have now widely adopted the utf8mb4_unicode_520_ci encoding you seem lacking. Disable database connection or update your driver to fix this.");
            }
            throw t;
        }
    }

    protected final void insert(@NonNull SerializedMap columsAndValues) {
        if (columsAndValues == null) {
            throw new NullPointerException("columsAndValues is marked non-null but is null");
        }
        this.insert("{table}", columsAndValues);
    }

    protected final <T extends ConfigSerializable> void insert(String table, @NonNull T serializableObject) {
        if (serializableObject == null) {
            throw new NullPointerException("serializableObject is marked non-null but is null");
        }
        this.insert(table, serializableObject.serialize());
    }

    protected final void insert(String table, @NonNull SerializedMap columsAndValues) {
        if (columsAndValues == null) {
            throw new NullPointerException("columsAndValues is marked non-null but is null");
        }
        String columns = Common.join(columsAndValues.keySet());
        String values = Common.join(columsAndValues.values(), ", ", value -> value == null || value.equals("NULL") ? "NULL" : "'" + value + "'");
        String duplicateUpdate = Common.join(columsAndValues.entrySet(), ", ", entry -> (String)entry.getKey() + "=VALUES(" + (String)entry.getKey() + ")");
        this.update("INSERT INTO " + this.replaceVariables(table) + " (" + columns + ") VALUES (" + values + ") ON DUPLICATE KEY UPDATE " + duplicateUpdate + ";");
    }

    protected final void insertBatch(@NonNull List<SerializedMap> maps) {
        if (maps == null) {
            throw new NullPointerException("maps is marked non-null but is null");
        }
        this.insertBatch("{table}", maps);
    }

    protected final void insertBatch(String table, @NonNull List<SerializedMap> maps) {
        if (maps == null) {
            throw new NullPointerException("maps is marked non-null but is null");
        }
        ArrayList<String> sqls = new ArrayList<String>();
        for (SerializedMap map : maps) {
            String columns = Common.join(map.keySet());
            String values = Common.join(map.values(), ", ", this::parseValue);
            String duplicateUpdate = Common.join(map.entrySet(), ", ", entry -> (String)entry.getKey() + "=VALUES(" + (String)entry.getKey() + ")");
            sqls.add("INSERT INTO " + table + " (" + columns + ") VALUES (" + values + ") ON DUPLICATE KEY UPDATE " + duplicateUpdate + ";");
        }
        this.batchUpdate(sqls);
    }

    private final String parseValue(Object value) {
        return value == null || value.equals("NULL") ? "NULL" : "'" + SerializeUtil.serialize(SerializeUtil.Mode.YAML, value).toString() + "'";
    }

    protected final void update(String sql) {
        if (!this.connecting) {
            Valid.checkAsync("Updating database must be done async! Call: " + sql);
        }
        this.checkEstablished();
        if (!this.isConnected()) {
            this.connectUsingLastCredentials();
        }
        Valid.checkBoolean(!(sql = this.replaceVariables(sql)).contains("{table}"), "Table not set! Either use connect() method that specifies it or call addVariable(table, 'yourtablename') in your constructor!", new Object[0]);
        Debugger.debug("mysql", "Updating database with: " + sql);
        try (Statement statement = this.connection.createStatement();){
            statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.handleError(e, "Error on updating database with: " + sql);
        }
    }

    protected final void selectAll(String table, ResultReader consumer) {
        this.select(table, "*", consumer);
    }

    protected final void select(String table, String param, ResultReader consumer) {
        if (!this.isLoaded()) {
            return;
        }
        try (ResultSet resultSet = this.query("SELECT " + param + " FROM " + table);){
            while (resultSet.next()) {
                try {
                    consumer.accept(resultSet);
                }
                catch (Throwable t) {
                    Common.log("Error reading a row from table " + table + " with param '" + param + "', aborting...");
                    t.printStackTrace();
                    break;
                }
            }
        }
        catch (Throwable t) {
            Common.error(t, "Error selecting rows from table " + table + " with param '" + param + "'");
        }
    }

    protected final int count(String table, Object ... array) {
        return this.count(table, SerializedMap.ofArray(array));
    }

    protected final int count(String table, SerializedMap conditions) {
        int n;
        block9: {
            Set<String> conditionsList = Common.convertSet(conditions.entrySet(), entry -> (String)entry.getKey() + " = '" + SerializeUtil.serialize(SerializeUtil.Mode.YAML, entry.getValue()) + "'");
            String sql = "SELECT * FROM " + table + (conditionsList.isEmpty() ? "" : " WHERE " + String.join((CharSequence)" AND ", conditionsList)) + ";";
            ResultSet resultSet = this.query(sql);
            try {
                int count = 0;
                while (resultSet.next()) {
                    ++count;
                }
                n = count;
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    Common.throwError(ex, "Unable to count rows!", "Table: " + this.replaceVariables(table), "Conditions: " + conditions, "Query: " + sql);
                    return 0;
                }
            }
            resultSet.close();
        }
        return n;
    }

    protected final ResultSet query(String sql) {
        Valid.checkAsync("Sending database query must be called async, command: " + sql);
        this.checkEstablished();
        if (!this.isConnected()) {
            this.connectUsingLastCredentials();
        }
        sql = this.replaceVariables(sql);
        Debugger.debug("mysql", "Querying database with: " + sql);
        try {
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            return resultSet;
        }
        catch (SQLException ex) {
            if (ex instanceof SQLSyntaxErrorException && ex.getMessage().startsWith("Table") && ex.getMessage().endsWith("doesn't exist")) {
                return new DummyResultSet();
            }
            this.handleError(ex, "Error on querying database with: " + sql);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void batchUpdate(final @NonNull List<String> sqls) {
        if (sqls == null) {
            throw new NullPointerException("sqls is marked non-null but is null");
        }
        if (sqls.size() == 0) {
            return;
        }
        this.checkEstablished();
        if (!this.isConnected()) {
            this.connectUsingLastCredentials();
        }
        try (Statement batchStatement = this.getConnection().createStatement(1005, 1008);){
            int processedCount = sqls.size();
            for (String sql : sqls) {
                batchStatement.addBatch(this.replaceVariables(sql));
            }
            if (processedCount > 10000) {
                Common.log("Updating your database (" + processedCount + " entries)... PLEASE BE PATIENT THIS WILL TAKE " + (processedCount > 50000 ? "10-20 MINUTES" : "5-10 MINUTES") + " - If server will print a crash report, ignore it, update will proceed.");
            }
            this.batchUpdateGoingOn = true;
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (SimpleDatabase.this.batchUpdateGoingOn) {
                        Common.log("Database batch update is still processing, " + RandomUtil.nextItem("keep calm", "stand by", "watch the show", "check your db", "drink water", "call your friend") + " and DO NOT SHUTDOWN YOUR SERVER. (Total size: " + sqls.size() + " queries)");
                    } else {
                        this.cancel();
                    }
                }
            };
            new Timer().scheduleAtFixedRate(task, 30000L, 30000L);
            this.getConnection().setAutoCommit(false);
            try {
                batchStatement.executeBatch();
                this.getConnection().commit();
            }
            catch (Throwable t) {
                task.cancel();
                throw t;
            }
        }
        catch (Throwable t) {
            ArrayList<String> errorLog = new ArrayList<String>();
            errorLog.add(Common.consoleLine());
            errorLog.add(" [" + TimeUtil.getFormattedDateShort() + "] Failed to save batch sql, please contact the plugin author with this file content: " + t);
            errorLog.add(Common.consoleLine());
            for (String statement : sqls) {
                errorLog.add(this.replaceVariables(statement));
            }
            FileUtil.write("sql-error.log", sqls);
            t.printStackTrace();
        }
        finally {
            try {
                this.getConnection().setAutoCommit(true);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            this.batchUpdateGoingOn = false;
        }
    }

    protected final PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkEstablished();
        if (!this.isConnected()) {
            this.connectUsingLastCredentials();
        }
        sql = this.replaceVariables(sql);
        Debugger.debug("mysql", "Preparing statement: " + sql);
        return this.connection.prepareStatement(sql);
    }

    protected final PreparedStatement prepareStatement(String sql, int type, int concurrency) throws SQLException {
        this.checkEstablished();
        if (!this.isConnected()) {
            this.connectUsingLastCredentials();
        }
        sql = this.replaceVariables(sql);
        Debugger.debug("mysql", "Preparing statement: " + sql);
        return this.connection.prepareStatement(sql, type, concurrency);
    }

    protected final boolean isConnected() {
        if (!this.isLoaded()) {
            return false;
        }
        try {
            if (!this.connection.isValid(0)) {
                return false;
            }
        }
        catch (AbstractMethodError | SQLException throwable) {
            // empty catch block
        }
        try {
            return !this.connection.isClosed();
        }
        catch (SQLException ex) {
            return false;
        }
    }

    private void handleError(Throwable t, String fallbackMessage) {
        if (t.toString().contains("Unknown collation")) {
            Common.log("You need to update your database provider driver. We switched to support unicode using 4 bits length because the previous system only supported 3 bits.");
            Common.log("Some characters such as smiley or Chinese are stored in 4 bits so they would crash the 3-bit database leading to more problems. Most hosting providers have now widely adopted the utf8mb4_unicode_520_ci encoding you seem lacking. Disable database connection or update your driver to fix this.");
        } else if (t.toString().contains("Incorrect string value")) {
            Common.log("Attempted to save unicode letters (e.g. coors) to your database with invalid encoding, see https://stackoverflow.com/a/10959780 and adjust it. MariaDB may cause issues, use MySQL 8.0 for best results.");
            t.printStackTrace();
        } else {
            Common.throwError(t, fallbackMessage);
        }
    }

    final boolean hasVariable(String key) {
        return this.sqlVariables.containsKey(key);
    }

    protected final String getTable() {
        this.checkEstablished();
        return Common.getOrEmpty(this.lastCredentials.table);
    }

    private final void checkEstablished() {
        Valid.checkBoolean(this.isLoaded(), "Connection was never established, did you call connect() on " + this + "? Use isLoaded() to check.", new Object[0]);
    }

    public final boolean isLoaded() {
        return this.connection != null;
    }

    protected final void addVariable(String name, String value) {
        this.sqlVariables.put(name, value);
    }

    protected final String replaceVariables(String sql) {
        for (Map.Entry<String, String> entry : this.sqlVariables.entrySet()) {
            sql = sql.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return sql.replace("{table}", this.getTable());
    }

    protected Connection getConnection() {
        return this.connection;
    }

    private final class LastCredentials {
        private final String url;
        private final String user;
        private final String password;
        private final String table;

        public LastCredentials(String url, String user, String password, String table) {
            this.url = url;
            this.user = user;
            this.password = password;
            this.table = table;
        }
    }

    protected static final class TableCreator {
        private final String name;
        private final List<TableRow> columns = new ArrayList<TableRow>();
        private String primaryColumn;

        public TableCreator add(String name, String dataType) {
            this.columns.add(TableRow.builder().name(name).dataType(dataType).build());
            return this;
        }

        public TableCreator addNotNull(String name, String dataType) {
            this.columns.add(TableRow.builder().name(name).dataType(dataType).notNull(true).build());
            return this;
        }

        public TableCreator addAutoIncrement(String name, String dataType) {
            this.columns.add(TableRow.builder().name(name).dataType(dataType).autoIncrement(true).build());
            return this;
        }

        public TableCreator addDefault(String name, String dataType, String def) {
            this.columns.add(TableRow.builder().name(name).dataType(dataType).defaultValue(def).build());
            return this;
        }

        public TableCreator setPrimaryColumn(String primaryColumn) {
            this.primaryColumn = primaryColumn;
            return this;
        }

        public static TableCreator of(String name) {
            return new TableCreator(name);
        }

        public String getName() {
            return this.name;
        }

        public List<TableRow> getColumns() {
            return this.columns;
        }

        public String getPrimaryColumn() {
            return this.primaryColumn;
        }

        public TableCreator(String name) {
            this.name = name;
        }
    }

    private static final class TableRow {
        private final String name;
        private final String dataType;
        private final Boolean notNull;
        private final String defaultValue;
        private final Boolean autoIncrement;

        TableRow(String name, String dataType, Boolean notNull, String defaultValue, Boolean autoIncrement) {
            this.name = name;
            this.dataType = dataType;
            this.notNull = notNull;
            this.defaultValue = defaultValue;
            this.autoIncrement = autoIncrement;
        }

        public static TableRowBuilder builder() {
            return new TableRowBuilder();
        }

        public String getName() {
            return this.name;
        }

        public String getDataType() {
            return this.dataType;
        }

        public Boolean getNotNull() {
            return this.notNull;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public Boolean getAutoIncrement() {
            return this.autoIncrement;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableRow)) {
                return false;
            }
            TableRow other = (TableRow)o;
            Boolean this$notNull = this.getNotNull();
            Boolean other$notNull = other.getNotNull();
            if (this$notNull == null ? other$notNull != null : !((Object)this$notNull).equals(other$notNull)) {
                return false;
            }
            Boolean this$autoIncrement = this.getAutoIncrement();
            Boolean other$autoIncrement = other.getAutoIncrement();
            if (this$autoIncrement == null ? other$autoIncrement != null : !((Object)this$autoIncrement).equals(other$autoIncrement)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$dataType = this.getDataType();
            String other$dataType = other.getDataType();
            if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
                return false;
            }
            String this$defaultValue = this.getDefaultValue();
            String other$defaultValue = other.getDefaultValue();
            return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $notNull = this.getNotNull();
            result = result * 59 + ($notNull == null ? 43 : ((Object)$notNull).hashCode());
            Boolean $autoIncrement = this.getAutoIncrement();
            result = result * 59 + ($autoIncrement == null ? 43 : ((Object)$autoIncrement).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $dataType = this.getDataType();
            result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
            String $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            return result;
        }

        public String toString() {
            return "SimpleDatabase.TableRow(name=" + this.getName() + ", dataType=" + this.getDataType() + ", notNull=" + this.getNotNull() + ", defaultValue=" + this.getDefaultValue() + ", autoIncrement=" + this.getAutoIncrement() + ")";
        }

        public static class TableRowBuilder {
            private String name;
            private String dataType;
            private Boolean notNull;
            private String defaultValue;
            private Boolean autoIncrement;

            TableRowBuilder() {
            }

            public TableRowBuilder name(String name) {
                this.name = name;
                return this;
            }

            public TableRowBuilder dataType(String dataType) {
                this.dataType = dataType;
                return this;
            }

            public TableRowBuilder notNull(Boolean notNull) {
                this.notNull = notNull;
                return this;
            }

            public TableRowBuilder defaultValue(String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            public TableRowBuilder autoIncrement(Boolean autoIncrement) {
                this.autoIncrement = autoIncrement;
                return this;
            }

            public TableRow build() {
                return new TableRow(this.name, this.dataType, this.notNull, this.defaultValue, this.autoIncrement);
            }

            public String toString() {
                return "SimpleDatabase.TableRow.TableRowBuilder(name=" + this.name + ", dataType=" + this.dataType + ", notNull=" + this.notNull + ", defaultValue=" + this.defaultValue + ", autoIncrement=" + this.autoIncrement + ")";
            }
        }
    }

    protected static interface ResultReader {
        public void accept(ResultSet var1) throws SQLException;
    }
}

