/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.conversation;

import java.util.function.Consumer;
import lombok.NonNull;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.conversation.SimplePrompt;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;

public class SimpleStringPrompt
extends SimplePrompt {
    private String question = null;
    private Consumer<String> successAction;

    public SimpleStringPrompt(String question) {
        this(question, null);
    }

    public SimpleStringPrompt(boolean openMenu) {
        super(openMenu);
    }

    @Override
    protected String getPrompt(ConversationContext ctx) {
        Valid.checkNotNull(this.question, "Please either call setQuestion or override getPrompt");
        return this.question;
    }

    @Override
    protected boolean isInputValid(ConversationContext context, String input) {
        return !input.isEmpty();
    }

    @Override
    protected String getFailedValidationText(ConversationContext context, String invalidInput) {
        return SimpleLocalization.Commands.INVALID_STRING.replace("{input}", invalidInput);
    }

    protected Prompt acceptValidatedInput(@NonNull ConversationContext context, @NonNull String input) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (this.successAction != null) {
            this.successAction.accept(input);
        } else {
            this.onValidatedInput(context, input);
        }
        return Prompt.END_OF_CONVERSATION;
    }

    protected void onValidatedInput(ConversationContext context, String input) {
    }

    public static void show(Player player, String question, Consumer<String> successAction) {
        new SimpleStringPrompt(question, successAction).show(player);
    }

    public SimpleStringPrompt() {
    }

    public SimpleStringPrompt(String question, Consumer<String> successAction) {
        this.question = question;
        this.successAction = successAction;
    }

    protected void setQuestion(String question) {
        this.question = question;
    }

    protected void setSuccessAction(Consumer<String> successAction) {
        this.successAction = successAction;
    }
}

