/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.conversation;

import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationPrefix;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.ValidatingPrompt;
import org.bukkit.entity.Player;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Messenger;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.conversation.SimpleConversation;
import sk.adonikeoffice.epicchat.lib.conversation.SimplePrefix;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.menu.Menu;
import sk.adonikeoffice.epicchat.lib.model.Variables;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;

public abstract class SimplePrompt
extends ValidatingPrompt {
    private boolean openMenu = true;
    private Player player = null;

    protected SimplePrompt() {
    }

    protected SimplePrompt(boolean openMenu) {
        this.openMenu = openMenu;
    }

    protected String getCustomPrefix() {
        return null;
    }

    protected boolean isModal() {
        return true;
    }

    protected String getMenuAnimatedTitle() {
        return null;
    }

    public final String getPromptText(ConversationContext context) {
        String prompt = this.getPrompt(context);
        if (!(!Common.getTellPrefix().isEmpty() || !Messenger.ENABLED || prompt.contains(Messenger.getAnnouncePrefix()) || prompt.contains(Messenger.getErrorPrefix()) || prompt.contains(Messenger.getInfoPrefix()) || prompt.contains(Messenger.getQuestionPrefix()) || prompt.contains(Messenger.getSuccessPrefix()) || prompt.contains(Messenger.getWarnPrefix()))) {
            prompt = Messenger.getQuestionPrefix() + prompt;
        }
        return Variables.replace(prompt, (CommandSender)this.getPlayer(context));
    }

    protected abstract String getPrompt(ConversationContext var1);

    protected boolean isInputValid(ConversationContext context, String input) {
        return true;
    }

    protected String getFailedValidationText(ConversationContext context, String invalidInput) {
        return null;
    }

    protected final Player getPlayer(ConversationContext ctx) {
        Valid.checkBoolean(ctx.getForWhom() instanceof Player, "Conversable is not a player but: " + ctx.getForWhom(), new Object[0]);
        return (Player)ctx.getForWhom();
    }

    protected final void tell(String message) {
        Valid.checkNotNull(this.player, "Cannot use tell() when player not yet set!");
        this.tell((Conversable)this.player, message);
    }

    protected final void tell(ConversationContext context, String message) {
        this.tell((Conversable)this.getPlayer(context), message);
    }

    protected final void tell(Conversable conversable, String message) {
        Common.tellConversing(conversable, (this.getCustomPrefix() != null ? this.getCustomPrefix() : "") + message);
    }

    protected final void tellLater(int delayTicks, Conversable conversable, String message) {
        Common.tellLaterConversing(delayTicks, conversable, (this.getCustomPrefix() != null ? this.getCustomPrefix() : "") + message);
    }

    public void onConversationEnd(SimpleConversation conversation, ConversationAbandonedEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Prompt acceptInput(ConversationContext context, String input) {
        try {
            FoException.setErrorSavedAutomatically(false);
            if (this.isInputValid(context, input)) {
                Prompt prompt = this.acceptValidatedInput(context, input);
                return prompt;
            }
            String failPrompt = this.getFailedValidationText(context, input);
            if (failPrompt != null) {
                this.tellLater(1, context.getForWhom(), Variables.replace((Messenger.ENABLED && !failPrompt.contains(Messenger.getErrorPrefix()) ? Messenger.getErrorPrefix() : "") + "&c" + failPrompt, (CommandSender)this.getPlayer(context)));
            }
            SimplePrompt simplePrompt = this;
            return simplePrompt;
        }
        finally {
            FoException.setErrorSavedAutomatically(true);
        }
    }

    public final SimpleConversation show(Player player) {
        Menu menu;
        Valid.checkBoolean(!player.isConversing(), "Player " + player.getName() + " is already conversing! Show them their next prompt in acceptValidatedInput() in " + ((Object)((Object)this)).getClass().getSimpleName() + " instead!", new Object[0]);
        this.player = player;
        SimpleConversation conversation = new SimpleConversation(){

            @Override
            protected Prompt getFirstPrompt() {
                return SimplePrompt.this;
            }

            @Override
            protected boolean isModal() {
                return SimplePrompt.this.isModal();
            }

            @Override
            protected ConversationPrefix getPrefix() {
                String prefix = SimplePrompt.this.getCustomPrefix();
                return prefix != null ? new SimplePrefix(prefix) : super.getPrefix();
            }

            @Override
            public String getMenuAnimatedTitle() {
                return SimplePrompt.this.getMenuAnimatedTitle();
            }

            @Override
            protected void onConversationEnd(ConversationAbandonedEvent event, boolean canceledFromInactivity) {
                String message = canceledFromInactivity ? SimpleLocalization.Conversation.CONVERSATION_CANCELLED_INACTIVE : SimpleLocalization.Conversation.CONVERSATION_CANCELLED;
                Player player = SimplePrompt.this.getPlayer(event.getContext());
                if (!event.gracefulExit()) {
                    if (Messenger.ENABLED) {
                        Messenger.warn((CommandSender)player, message);
                    } else {
                        Common.tell((CommandSender)player, message);
                    }
                }
            }
        };
        if (this.openMenu && (menu = Menu.getMenu(player)) != null) {
            conversation.setMenuToReturnTo(menu);
        }
        conversation.start(player);
        return conversation;
    }

    public static final void show(Player player, SimplePrompt prompt) {
        prompt.show(player);
    }
}

