/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.conversation;

import java.util.function.Consumer;
import lombok.NonNull;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.conversation.SimplePrompt;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;

public class SimpleDecimalPrompt
extends SimplePrompt {
    private String question = null;
    private Consumer<Double> successAction;

    public SimpleDecimalPrompt(String question) {
        this(question, null);
    }

    @Override
    protected String getPrompt(ConversationContext ctx) {
        Valid.checkNotNull(this.question, "Please either call setQuestion or override getPrompt");
        return this.question;
    }

    @Override
    protected boolean isInputValid(ConversationContext context, String input) {
        return Valid.isDecimal(input);
    }

    @Override
    protected String getFailedValidationText(ConversationContext context, String invalidInput) {
        return SimpleLocalization.Commands.INVALID_NUMBER.replace("{input}", invalidInput);
    }

    protected final Prompt acceptValidatedInput(@NonNull ConversationContext context, @NonNull String input) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return this.acceptValidatedInput(context, Double.parseDouble(input));
    }

    protected Prompt acceptValidatedInput(ConversationContext context, double input) {
        if (this.successAction != null) {
            this.successAction.accept(input);
        } else {
            this.onValidatedInput(context, input);
        }
        return Prompt.END_OF_CONVERSATION;
    }

    protected void onValidatedInput(ConversationContext context, double input) {
    }

    public static void show(Player player, String question, Consumer<Double> successAction) {
        new SimpleDecimalPrompt(question, successAction).show(player);
    }

    public SimpleDecimalPrompt() {
    }

    public SimpleDecimalPrompt(String question, Consumer<Double> successAction) {
        this.question = question;
        this.successAction = successAction;
    }

    protected void setQuestion(String question) {
        this.question = question;
    }

    protected void setSuccessAction(Consumer<Double> successAction) {
        this.successAction = successAction;
    }
}

