/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.conversation;

import java.util.concurrent.TimeUnit;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationCanceller;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationPrefix;
import org.bukkit.conversations.InactivityConversationCanceller;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Messenger;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.expiringmap.ExpiringMap;
import sk.adonikeoffice.epicchat.lib.conversation.SimpleCanceller;
import sk.adonikeoffice.epicchat.lib.conversation.SimplePrefix;
import sk.adonikeoffice.epicchat.lib.conversation.SimplePrompt;
import sk.adonikeoffice.epicchat.lib.menu.Menu;
import sk.adonikeoffice.epicchat.lib.model.BoxedMessage;
import sk.adonikeoffice.epicchat.lib.model.Variables;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.CompSound;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;

public abstract class SimpleConversation
implements ConversationAbandonedListener {
    private Menu menuToReturnTo;

    protected SimpleConversation() {
        this(null);
    }

    protected SimpleConversation(Menu menuToReturnTo) {
        this.menuToReturnTo = menuToReturnTo;
    }

    public final void start(Player player) {
        Valid.checkBoolean(!player.isConversing(), "Player " + player.getName() + " is already conversing!", new Object[0]);
        player.closeInventory();
        CustomConversation conversation = new CustomConversation((Conversable)player);
        CustomCanceller canceller = new CustomCanceller();
        canceller.setConversation(conversation);
        conversation.getCancellers().add(canceller);
        conversation.getCancellers().add(this.getCanceller());
        conversation.addConversationAbandonedListener(this);
        conversation.begin();
    }

    protected abstract Prompt getFirstPrompt();

    public final void conversationAbandoned(ConversationAbandonedEvent event) {
        SimplePrompt lastPrompt;
        ConversationContext context = event.getContext();
        Conversable conversing = context.getForWhom();
        Object source = event.getSource();
        boolean timeout = context.getAllSessionData().getOrDefault("FLP#TIMEOUT", false);
        context.getAllSessionData().remove("FLP#TIMEOUT");
        if (source instanceof CustomConversation && (lastPrompt = ((CustomConversation)((Object)source)).getLastSimplePrompt()) != null) {
            lastPrompt.onConversationEnd(this, event);
        }
        this.onConversationEnd(event, timeout);
        if (conversing instanceof Player) {
            Player player = (Player)conversing;
            (event.gracefulExit() ? CompSound.SUCCESSFUL_HIT : CompSound.NOTE_BASS).play((Entity)player, 1.0f, 1.0f);
            if (this.menuToReturnTo != null && this.reopenMenu()) {
                Menu newMenu = this.menuToReturnTo.newInstance();
                newMenu.displayTo(player);
                String title = this.getMenuAnimatedTitle();
                if (title != null) {
                    Common.runLater(2, () -> newMenu.animateTitle(title));
                }
            }
        }
    }

    protected void onConversationEnd(ConversationAbandonedEvent event, boolean canceledFromInactivity) {
        this.onConversationEnd(event);
    }

    protected void onConversationEnd(ConversationAbandonedEvent event) {
    }

    protected ConversationPrefix getPrefix() {
        return new SimplePrefix(!Common.getTellPrefix().isEmpty() ? this.addLastSpace(Common.getTellPrefix()) : "");
    }

    private final String addLastSpace(String prefix) {
        return prefix.endsWith(" ") ? prefix : prefix + " ";
    }

    protected ConversationCanceller getCanceller() {
        return new SimpleCanceller("quit", "cancel", "exit");
    }

    protected boolean insertPrefix() {
        return true;
    }

    protected boolean reopenMenu() {
        return true;
    }

    protected int getTimeout() {
        return 60;
    }

    protected boolean isModal() {
        return true;
    }

    public final void setMenuToReturnTo(Menu menu) {
        this.menuToReturnTo = menu;
    }

    public String getMenuAnimatedTitle() {
        return null;
    }

    protected static final void tellBoxed(int delayTicks, Conversable conversable, String ... messages) {
        Common.runLater(delayTicks, () -> SimpleConversation.tellBoxed(conversable, messages));
    }

    protected static final void tellBoxed(Conversable conversable, String ... messages) {
        BoxedMessage.tell((CommandSender)((Player)conversable), messages);
    }

    protected static final void tell(Conversable conversable, String message) {
        Common.tellConversing(conversable, Variables.replace(message, (CommandSender)((Player)conversable)));
    }

    protected static final void tellLater(int delayTicks, Conversable conversable, String message) {
        Common.tellLaterConversing(delayTicks, conversable, Variables.replace(message, (CommandSender)((Player)conversable)));
    }

    private final class CustomConversation
    extends Conversation {
        private SimplePrompt lastSimplePrompt;

        private CustomConversation(Conversable forWhom) {
            super((Plugin)SimplePlugin.getInstance(), forWhom, SimpleConversation.this.getFirstPrompt());
            this.localEchoEnabled = false;
            this.modal = SimpleConversation.this.isModal();
            if (SimpleConversation.this.insertPrefix() && SimpleConversation.this.getPrefix() != null) {
                this.prefix = SimpleConversation.this.getPrefix();
            }
        }

        public void outputNextPrompt() {
            if (this.currentPrompt == null) {
                try {
                    this.abandon(new ConversationAbandonedEvent((Conversation)this));
                }
                catch (Throwable t) {
                    SimpleConversation.tell(this.context.getForWhom(), (Messenger.ENABLED ? Messenger.getErrorPrefix() : "") + SimpleLocalization.Conversation.CONVERSATION_ERROR);
                    t.printStackTrace();
                }
            } else {
                String promptClass = this.currentPrompt.getClass().getSimpleName();
                String question = this.currentPrompt.getPromptText(this.context);
                try {
                    ExpiringMap askedQuestions = this.context.getAllSessionData().getOrDefault("Asked_" + promptClass, ExpiringMap.builder().expiration(SimpleConversation.this.getTimeout(), TimeUnit.SECONDS).build());
                    if (!askedQuestions.containsKey(question)) {
                        askedQuestions.put(question, null);
                        this.context.setSessionData((Object)("Asked_" + promptClass), askedQuestions);
                        this.context.getForWhom().sendRawMessage(this.prefix.getPrefix(this.context) + question);
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                if (this.currentPrompt instanceof SimplePrompt) {
                    this.lastSimplePrompt = (SimplePrompt)this.currentPrompt;
                }
                if (!this.currentPrompt.blocksForInput(this.context)) {
                    this.currentPrompt = this.currentPrompt.acceptInput(this.context, null);
                    this.outputNextPrompt();
                }
            }
        }

        private SimplePrompt getLastSimplePrompt() {
            return this.lastSimplePrompt;
        }
    }

    private final class CustomCanceller
    extends InactivityConversationCanceller {
        public CustomCanceller() {
            super((Plugin)SimplePlugin.getInstance(), SimpleConversation.this.getTimeout());
        }

        protected void cancelling(Conversation conversation) {
            conversation.getContext().setSessionData((Object)"FLP#TIMEOUT", (Object)true);
        }
    }
}

