/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.command;

import java.util.Arrays;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.command.SimpleCommand;
import sk.adonikeoffice.epicchat.lib.command.SimpleCommandGroup;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;

public abstract class SimpleSubCommand
extends SimpleCommand {
    private final String[] sublabels;
    private String sublabel;

    protected SimpleSubCommand(String sublabel) {
        this(SimpleSubCommand.getMainCommandGroup0(), sublabel);
    }

    private static SimpleCommandGroup getMainCommandGroup0() {
        SimpleCommandGroup main = SimplePlugin.getInstance().getMainCommand();
        Valid.checkNotNull(main, SimplePlugin.getNamed() + " does not define a main command group! You need to put @AutoRegister over your class extending a SimpleCommandGroup that has a no args constructor to register it automatically");
        return main;
    }

    protected SimpleSubCommand(SimpleCommandGroup parent, String sublabel) {
        super(parent.getLabel());
        this.sublabels = sublabel.split("(\\||\\/)");
        Valid.checkBoolean(this.sublabels.length > 0, "Please set at least 1 sublabel", new Object[0]);
        this.sublabel = this.sublabels[0];
        if (this.getRawPermission().equals(SimpleSubCommand.getDefaultPermission())) {
            if (SimplePlugin.getInstance().getMainCommand() != null && SimplePlugin.getInstance().getMainCommand().getLabel().equals(this.getLabel())) {
                this.setPermission(this.getRawPermission().replace("{label}", "{sublabel}"));
            } else {
                this.setPermission(this.getRawPermission() + ".{sublabel}");
            }
        }
    }

    protected boolean showInHelp() {
        return true;
    }

    @Override
    protected String replacePlaceholders(String message) {
        return super.replacePlaceholders(message).replace("{sublabel}", this.getSublabel());
    }

    @Override
    public String toString() {
        return "SubCommand{parent=/" + this.getLabel() + ", label=" + this.getSublabel() + "}";
    }

    @Override
    public final boolean equals(Object obj) {
        return obj instanceof SimpleSubCommand ? Arrays.equals(((SimpleSubCommand)((Object)obj)).sublabels, this.sublabels) : false;
    }

    public String[] getSublabels() {
        return this.sublabels;
    }

    protected void setSublabel(String sublabel) {
        this.sublabel = sublabel;
    }

    protected String getSublabel() {
        return this.sublabel;
    }
}

