/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.command;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MathUtil;
import sk.adonikeoffice.epicchat.lib.Messenger;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.RandomUtil;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.StrictList;
import sk.adonikeoffice.epicchat.lib.command.SimpleCommand;
import sk.adonikeoffice.epicchat.lib.command.SimpleSubCommand;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.model.ChatPaginator;
import sk.adonikeoffice.epicchat.lib.model.Replacer;
import sk.adonikeoffice.epicchat.lib.model.SimpleComponent;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;
import sk.adonikeoffice.epicchat.lib.settings.SimpleSettings;

public abstract class SimpleCommandGroup {
    private final StrictList<SimpleSubCommand> subcommands;
    private SimpleCommand mainCommand;
    private String label;
    private List<String> aliases;
    @Nullable
    protected CommandSender sender;

    protected SimpleCommandGroup() {
        this(SimpleCommandGroup.findMainCommandAliases());
    }

    private static StrictList<String> findMainCommandAliases() {
        StrictList<String> aliases = SimpleSettings.MAIN_COMMAND_ALIASES;
        Valid.checkBoolean(!aliases.isEmpty(), "Called SimpleCommandGroup with no args constructor which uses SimpleSettings' MAIN_COMMAND_ALIASES field WHICH WAS EMPTY. To make this work, make a settings class extending SimpleSettings and write 'Command_Aliases: [/yourmaincommand]' key-value pair with a list of aliases to your settings.yml file.", new Object[0]);
        return aliases;
    }

    protected SimpleCommandGroup(StrictList<String> labelAndAliases) {
        StrictList<String> strictList;
        if (labelAndAliases.size() > 1) {
            strictList = labelAndAliases.range(1);
        } else {
            StrictList<String> strictList2;
            strictList = strictList2;
        }
        this(labelAndAliases.get(0), strictList.getSource());
    }

    protected SimpleCommandGroup(String label, List<String> aliases) {
        this.subcommands = new StrictList();
        this.label = label;
        this.aliases = aliases;
    }

    protected SimpleCommandGroup(String labelAndAliases) {
        this.subcommands = new StrictList();
        String[] split = labelAndAliases.split("(\\||\\/)");
        this.label = split[0];
        this.aliases = split.length > 0 ? Arrays.asList(Arrays.copyOfRange(split, 1, split.length)) : new ArrayList<String>();
    }

    public final void register() {
        Valid.checkBoolean(!this.isRegistered(), "Main command already registered as: " + (Object)((Object)this.mainCommand), new Object[0]);
        this.mainCommand = new MainCommand(this.label);
        if (this.aliases != null) {
            this.mainCommand.setAliases(this.aliases);
        }
        this.mainCommand.register();
        this.registerSubcommands();
        Collections.sort(this.subcommands.getSource(), Comparator.comparing(SimpleSubCommand::getSublabel));
        this.checkSubCommandAliasesCollision();
    }

    private void checkSubCommandAliasesCollision() {
        ArrayList<String> aliases = new ArrayList<String>();
        for (SimpleSubCommand subCommand : this.subcommands) {
            for (String alias : subCommand.getSublabels()) {
                Valid.checkBoolean(!aliases.contains(alias), "Subcommand '/" + this.getLabel() + " " + subCommand.getSublabel() + "' has alias '" + alias + "' that is already in use by another subcommand!", new Object[0]);
                aliases.add(alias);
            }
        }
    }

    public final void unregister() {
        Valid.checkBoolean(this.isRegistered(), "Main command not registered!", new Object[0]);
        this.mainCommand.unregister();
        this.mainCommand = null;
    }

    public final boolean isRegistered() {
        return this.mainCommand != null;
    }

    protected abstract void registerSubcommands();

    protected final void registerSubcommand(SimpleSubCommand command) {
        Valid.checkNotNull((Object)this.mainCommand, "Cannot add subcommands when main command is missing! Call register()");
        if (this.subcommands.contains(command)) {
            this.subcommands.remove(command);
        }
        this.subcommands.add(command);
    }

    protected final void registerSubcommand(Class<? extends SimpleSubCommand> parentClass) {
        for (Class<? extends SimpleSubCommand> clazz : ReflectionUtil.getClasses((Plugin)SimplePlugin.getInstance(), parentClass)) {
            if (Modifier.isAbstract(clazz.getModifiers())) continue;
            Valid.checkBoolean(Modifier.isFinal(clazz.getModifiers()), "Make child of " + parentClass.getSimpleName() + " class " + clazz.getSimpleName() + " final to auto register it!", new Object[0]);
            this.registerSubcommand(ReflectionUtil.instantiate(clazz));
        }
    }

    protected final void registerHelpLine(String ... menuHelp) {
        Valid.checkNotNull((Object)this.mainCommand, "Cannot add subcommands when main command is missing! Call register()");
        this.subcommands.add(new FillerSubCommand(this, menuHelp));
    }

    public void setLabel(String label) {
        Valid.checkBoolean(!this.isRegistered(), "Cannot use setLabel(" + label + ") for already registered command /" + this.getLabel(), new Object[0]);
        this.label = label;
    }

    public void setAliases(List<String> aliases) {
        Valid.checkBoolean(!this.isRegistered(), "Cannot use setAliases(" + aliases + ") for already registered command /" + this.getLabel(), new Object[0]);
        this.aliases = aliases;
    }

    protected List<SimpleComponent> getNoParamsHeader() {
        String credits;
        int foundedYear = SimplePlugin.getInstance().getFoundedYear();
        int yearNow = Calendar.getInstance().get(1);
        ArrayList<String> messages = new ArrayList<String>();
        messages.add("&8" + Common.chatLineSmooth());
        messages.add(this.getHeaderPrefix() + "  " + SimplePlugin.getNamed() + this.getTrademark() + " &7" + SimplePlugin.getVersion());
        messages.add(" ");
        String authors = String.join((CharSequence)", ", SimplePlugin.getInstance().getDescription().getAuthors());
        if (!authors.isEmpty()) {
            messages.add("   &7" + SimpleLocalization.Commands.LABEL_AUTHORS + " &f" + authors + (foundedYear != -1 ? " &7\u00a9 " + foundedYear + (yearNow != foundedYear ? " - " + yearNow : "") : ""));
        }
        if ((credits = this.getCredits()) != null && !credits.isEmpty()) {
            messages.add("   " + credits);
        }
        messages.add("&8" + Common.chatLineSmooth());
        return Common.convert(messages, SimpleComponent::of);
    }

    protected boolean sendHelpIfNoArgs() {
        return false;
    }

    private String getTrademark() {
        return SimplePlugin.getInstance().getDescription().getAuthors().contains("kangarko") ? this.getHeaderPrefix() + "&8\u2122" : "";
    }

    protected String getCredits() {
        return "&7Visit &fmineacademy.org &7for more information.";
    }

    protected List<String> getHelpLabel() {
        return Arrays.asList("help", "?");
    }

    protected String[] getHelpHeader() {
        return new String[]{"&8", "&8" + Common.chatLineSmooth(), this.getHeaderPrefix() + "  " + SimplePlugin.getNamed() + this.getTrademark() + " &7" + SimplePlugin.getVersion(), " ", "&2  [] &f= " + SimpleLocalization.Commands.LABEL_OPTIONAL_ARGS, this.getTheme() + "  <> &f= " + SimpleLocalization.Commands.LABEL_REQUIRED_ARGS, " "};
    }

    protected String getSubcommandDescription() {
        return SimpleLocalization.Commands.LABEL_SUBCOMMAND_DESCRIPTION;
    }

    protected String getHeaderPrefix() {
        return this.getTheme() + "" + ChatColor.BOLD;
    }

    protected ChatColor getTheme() {
        return ChatColor.GOLD;
    }

    protected int getCommandsPerPage() {
        return 12;
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    @Nullable
    public CommandSender getSender() {
        return this.sender;
    }

    public final class MainCommand
    extends SimpleCommand {
        private MainCommand(String label) {
            super(label);
            this.setPermission(null);
            this.setAutoHandleHelp(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onCommand() {
            SimpleCommandGroup.this.sender = this.sender;
            if (this.args.length == 0) {
                if (SimpleCommandGroup.this.sendHelpIfNoArgs()) {
                    this.tellSubcommandsHelp();
                } else {
                    this.tell(SimpleCommandGroup.this.getNoParamsHeader());
                }
                return;
            }
            String argument = this.args[0];
            SimpleSubCommand command = this.findSubcommand(argument);
            if (command != null) {
                String oldSublabel = command.getSublabel();
                try {
                    command.setSublabel(this.args[0]);
                    command.execute(this.sender, this.getLabel(), this.args.length == 1 ? new String[]{} : Arrays.copyOfRange(this.args, 1, this.args.length));
                }
                finally {
                    command.setSublabel(oldSublabel);
                }
            } else if (!SimpleCommandGroup.this.getHelpLabel().isEmpty() && Valid.isInList(argument, SimpleCommandGroup.this.getHelpLabel())) {
                this.tellSubcommandsHelp();
            } else {
                this.returnInvalidArgs();
            }
        }

        protected void tellSubcommandsHelp() {
            Common.runAsync(() -> {
                if (SimpleCommandGroup.this.subcommands.isEmpty()) {
                    if (Messenger.ENABLED) {
                        this.tellError(SimpleLocalization.Commands.HEADER_NO_SUBCOMMANDS);
                    } else {
                        Common.tell(this.sender, SimpleLocalization.Commands.HEADER_NO_SUBCOMMANDS);
                    }
                    return;
                }
                ArrayList<SimpleComponent> lines = new ArrayList<SimpleComponent>();
                boolean atLeast17 = MinecraftVersion.atLeast(MinecraftVersion.V.v1_7);
                for (SimpleSubCommand subcommand : SimpleCommandGroup.this.subcommands) {
                    if (!subcommand.showInHelp() || !this.hasPerm(subcommand.getPermission())) continue;
                    subcommand.sender = this.sender;
                    if (subcommand instanceof FillerSubCommand) {
                        this.tellNoPrefix(((FillerSubCommand)subcommand).getHelpMessages());
                        continue;
                    }
                    String usage = this.colorizeUsage(subcommand.getUsage());
                    String desc = Common.getOrEmpty(subcommand.getDescription());
                    String plainMessage = Replacer.replaceArray(SimpleCommandGroup.this.getSubcommandDescription(), "label", this.getLabel(), "sublabel", (atLeast17 ? "&n" : "") + subcommand.getSublabel() + (atLeast17 ? "&r" : ""), "usage", usage, "description", !desc.isEmpty() && !atLeast17 ? desc : "", "dash", !desc.isEmpty() && !atLeast17 ? "&e-" : "");
                    SimpleComponent line = SimpleComponent.of(plainMessage);
                    if (!desc.isEmpty() && atLeast17) {
                        String command = Common.stripColors(plainMessage).substring(1);
                        ArrayList<String> hover = new ArrayList<String>();
                        hover.add(SimpleLocalization.Commands.HELP_TOOLTIP_DESCRIPTION.replace("{description}", desc));
                        if (subcommand.getPermission() != null) {
                            hover.add(SimpleLocalization.Commands.HELP_TOOLTIP_PERMISSION.replace("{permission}", subcommand.getPermission()));
                        }
                        if (subcommand.getMultilineUsageMessage() != null && subcommand.getMultilineUsageMessage().length > 0) {
                            hover.add(SimpleLocalization.Commands.HELP_TOOLTIP_USAGE);
                            for (String usageLine : subcommand.getMultilineUsageMessage()) {
                                hover.add("&f" + this.replacePlaceholders(this.colorizeUsage(usageLine.replace("{sublabel}", subcommand.getSublabel()))));
                            }
                        } else {
                            hover.add(SimpleLocalization.Commands.HELP_TOOLTIP_USAGE + (usage.isEmpty() ? command : usage));
                        }
                        for (int i = 0; i < hover.size(); ++i) {
                            String hoverLine = String.join((CharSequence)"\n    ", Common.split((String)hover.get(i), 65));
                            hover.set(i, hoverLine);
                        }
                        line.onHover(hover);
                        line.onClickSuggestCmd("/" + this.getLabel() + " " + subcommand.getSublabel());
                    }
                    lines.add(line);
                }
                if (!lines.isEmpty()) {
                    ChatPaginator pages = new ChatPaginator(MathUtil.range(0, lines.size(), SimpleCommandGroup.this.getCommandsPerPage()), ChatColor.DARK_GRAY);
                    if (SimpleCommandGroup.this.getHelpHeader() != null) {
                        pages.setHeader(SimpleCommandGroup.this.getHelpHeader());
                    }
                    pages.setPages(lines);
                    int page = this.args.length > 1 && Valid.isInteger(this.args[1]) ? Integer.parseInt(this.args[1]) : 1;
                    Common.runLater(() -> pages.send(this.sender, page));
                } else if (Messenger.ENABLED) {
                    this.tellError(SimpleLocalization.Commands.HEADER_NO_SUBCOMMANDS_PERMISSION);
                } else {
                    Common.tell(this.sender, SimpleLocalization.Commands.HEADER_NO_SUBCOMMANDS_PERMISSION);
                }
            });
        }

        private String colorizeUsage(String message) {
            return message == null ? "" : message.replace("<", "&6<").replace(">", "&6>&f").replace("[", "&2[").replace("]", "&2]&f").replaceAll(" \\-([a-zA-Z])", " &3-$1");
        }

        private SimpleSubCommand findSubcommand(String label) {
            for (SimpleSubCommand command : SimpleCommandGroup.this.subcommands) {
                if (command instanceof FillerSubCommand) continue;
                for (String alias : command.getSublabels()) {
                    if (!alias.equalsIgnoreCase(label)) continue;
                    return command;
                }
            }
            return null;
        }

        @Override
        public List<String> tabComplete() {
            SimpleSubCommand cmd;
            if (this.args.length == 1) {
                return this.tabCompleteSubcommands(this.sender, this.args[0]);
            }
            if (this.args.length > 1 && (cmd = this.findSubcommand(this.args[0])) != null) {
                return cmd.tabComplete(this.sender, this.getLabel(), Arrays.copyOfRange(this.args, 1, this.args.length));
            }
            return null;
        }

        private List<String> tabCompleteSubcommands(CommandSender sender, String param) {
            param = param.toLowerCase();
            ArrayList<String> tab = new ArrayList<String>();
            for (SimpleSubCommand subcommand : SimpleCommandGroup.this.subcommands) {
                if (!subcommand.showInHelp() || subcommand instanceof FillerSubCommand || !this.hasPerm(subcommand.getPermission())) continue;
                for (String label : subcommand.getSublabels()) {
                    if (label.trim().isEmpty() || !label.startsWith(param)) continue;
                    tab.add(label);
                }
            }
            return tab;
        }
    }

    private final class FillerSubCommand
    extends SimpleSubCommand {
        private final String[] helpMessages;

        private FillerSubCommand(SimpleCommandGroup parent, String ... menuHelp) {
            super(parent, "_" + RandomUtil.nextBetween(1, Short.MAX_VALUE));
            this.helpMessages = menuHelp;
        }

        @Override
        protected void onCommand() {
            throw new FoException("Filler space command cannot be run!");
        }

        public String[] getHelpMessages() {
            return this.helpMessages;
        }
    }
}

