/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.command;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.scheduler.BukkitTask;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Messenger;
import sk.adonikeoffice.epicchat.lib.PlayerUtil;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.TabUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.StrictList;
import sk.adonikeoffice.epicchat.lib.collection.expiringmap.ExpiringMap;
import sk.adonikeoffice.epicchat.lib.command.SimpleCommandGroup;
import sk.adonikeoffice.epicchat.lib.command.SimpleSubCommand;
import sk.adonikeoffice.epicchat.lib.debug.LagCatcher;
import sk.adonikeoffice.epicchat.lib.exception.CommandException;
import sk.adonikeoffice.epicchat.lib.exception.EventHandledException;
import sk.adonikeoffice.epicchat.lib.exception.InvalidCommandArgException;
import sk.adonikeoffice.epicchat.lib.model.ChatPaginator;
import sk.adonikeoffice.epicchat.lib.model.Replacer;
import sk.adonikeoffice.epicchat.lib.model.SimpleComponent;
import sk.adonikeoffice.epicchat.lib.model.SimpleTime;
import sk.adonikeoffice.epicchat.lib.model.Variables;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;

public abstract class SimpleCommand
extends Command {
    protected static final List<String> NO_COMPLETE = Collections.unmodifiableList(new ArrayList());
    private final ExpiringMap<UUID, Long> cooldownMap = ExpiringMap.builder().expiration(30L, TimeUnit.MINUTES).build();
    private final String label;
    private String currentLabel;
    private boolean registered = false;
    private String tellPrefix = null;
    private int minArguments = 0;
    private int cooldownSeconds = 0;
    private String cooldownMessage = null;
    private boolean autoHandleHelp = true;
    protected CommandSender sender;
    protected String[] args;

    protected static final String getDefaultPermission() {
        return SimplePlugin.getNamed().toLowerCase() + ".command.{label}";
    }

    protected SimpleCommand(String label) {
        this(SimpleCommand.parseLabel0(label), SimpleCommand.parseAliases0(label));
    }

    protected SimpleCommand(StrictList<String> labels) {
        this(SimpleCommand.parseLabelList0(labels), labels.size() > 1 ? labels.subList(1, labels.size()) : null);
    }

    protected SimpleCommand(String label, List<String> aliases) {
        super(label);
        Valid.checkBoolean(!(this instanceof CommandExecutor), "Please do not write 'implements CommandExecutor' for /" + super.getLabel() + " cmd, we already have a listener there", new Object[0]);
        Valid.checkBoolean(!(this instanceof TabCompleter), "Please do not write 'implements TabCompleter' for /" + super.getLabel() + " cmd, simply override tabComplete method", new Object[0]);
        this.label = label;
        this.setLabel(label);
        if (aliases != null) {
            this.setAliases(aliases);
        }
        this.setPermission(SimpleCommand.getDefaultPermission());
    }

    private static String parseLabel0(String label) {
        Valid.checkNotNull(label, "Label must not be null!");
        return label.split("(\\||\\/)")[0];
    }

    private static List<String> parseAliases0(String label) {
        String[] aliases = label.split("(\\||\\/)");
        return aliases.length > 0 ? Arrays.asList(Arrays.copyOfRange(aliases, 1, aliases.length)) : new ArrayList<String>();
    }

    private static String parseLabelList0(StrictList<String> labels) {
        Valid.checkBoolean(!labels.isEmpty(), "Command label must not be empty!", new Object[0]);
        return labels.get(0);
    }

    public final void register() {
        this.register(true);
    }

    public final void register(boolean unregisterOldAliases) {
        this.register(true, unregisterOldAliases);
    }

    public final void register(boolean unregisterOldCommand, boolean unregisterOldAliases) {
        Valid.checkBoolean(!(this instanceof SimpleSubCommand), "Sub commands cannot be registered!", new Object[0]);
        Valid.checkBoolean(!this.registered, "The command /" + this.getLabel() + " has already been registered!", new Object[0]);
        if (!this.canRegister()) {
            return;
        }
        PluginCommand oldCommand = Bukkit.getPluginCommand((String)this.getLabel());
        if (oldCommand != null && unregisterOldCommand) {
            Remain.unregisterCommand(oldCommand.getLabel(), unregisterOldAliases);
        }
        Remain.registerCommand(this);
        this.registered = true;
    }

    public final void unregister() {
        Valid.checkBoolean(!(this instanceof SimpleSubCommand), "Sub commands cannot be unregistered!", new Object[0]);
        Valid.checkBoolean(this.registered, "The command /" + this.getLabel() + " is not registered!", new Object[0]);
        Remain.unregisterCommand(this.getLabel());
        this.registered = false;
    }

    protected boolean canRegister() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean execute(CommandSender sender, String label, String[] args) {
        if (SimplePlugin.isReloading() || !SimplePlugin.getInstance().isEnabled()) {
            Common.tell(sender, SimpleLocalization.Commands.USE_WHILE_NULL.replace("{state}", SimplePlugin.isReloading() ? SimpleLocalization.Commands.RELOADING : SimpleLocalization.Commands.DISABLED));
            return false;
        }
        this.sender = sender;
        this.currentLabel = label;
        this.args = args;
        String oldTellPrefix = Common.getTellPrefix();
        if (this.tellPrefix != null) {
            Common.setTellPrefix(this.tellPrefix);
        }
        String sublabel = this instanceof SimpleSubCommand ? " " + ((SimpleSubCommand)this).getSublabel() : "";
        String lagSection = "Command /" + this.getLabel() + sublabel + (args.length > 0 ? " " + String.join((CharSequence)" ", args) : "");
        try {
            if (!(this instanceof SimpleCommandGroup.MainCommand)) {
                LagCatcher.start(lagSection);
            }
            if (this.getPermission() != null) {
                this.checkPerm(this.getPermission());
            }
            if (args.length < this.getMinArguments() || this.autoHandleHelp && args.length == 1 && ("help".equals(args[0]) || "?".equals(args[0]))) {
                Common.runAsync(() -> {
                    String usage = this.getMultilineUsageMessage() != null ? String.join((CharSequence)"\n&c", this.getMultilineUsageMessage()) : (this.getUsage() != null ? this.getUsage() : null);
                    Valid.checkNotNull(usage, "getUsage() nor getMultilineUsageMessage() not implemented for '/" + this.getLabel() + sublabel + "' command!");
                    ChatPaginator paginator = new ChatPaginator(SimpleLocalization.Commands.HEADER_SECONDARY_COLOR);
                    ArrayList<String> pages = new ArrayList<String>();
                    if (!Common.getOrEmpty(this.getDescription()).isEmpty()) {
                        pages.add(this.replacePlaceholders(SimpleLocalization.Commands.LABEL_DESCRIPTION));
                        pages.add(this.replacePlaceholders("&c" + this.getDescription()));
                    }
                    if (this.getMultilineUsageMessage() != null) {
                        pages.add("");
                        pages.add(this.replacePlaceholders(SimpleLocalization.Commands.LABEL_USAGES));
                        for (String usagePart : usage.split("\n")) {
                            pages.add(this.replacePlaceholders("&c" + usagePart));
                        }
                    } else {
                        pages.add("");
                        pages.add(SimpleLocalization.Commands.LABEL_USAGE);
                        pages.add("&c" + this.replacePlaceholders("/" + label + sublabel + (!usage.startsWith("/") ? " " + Common.stripColors(usage) : "")));
                    }
                    paginator.setFoundationHeader(SimpleLocalization.Commands.LABEL_HELP_FOR.replace("{label}", this.getLabel() + sublabel)).setPages(Common.toArray(pages));
                    Common.runLater(() -> paginator.send(sender));
                });
                boolean bl = true;
                return bl;
            }
            if (this.cooldownSeconds > 0) {
                this.handleCooldown();
            }
            this.onCommand();
        }
        catch (InvalidCommandArgException ex) {
            if (this.getMultilineUsageMessage() == null) {
                this.dynamicTellError(ex.getMessage() != null ? ex.getMessage() : SimpleLocalization.Commands.INVALID_SUB_ARGUMENT);
            } else {
                this.dynamicTellError(SimpleLocalization.Commands.INVALID_ARGUMENT_MULTILINE);
                for (String line : this.getMultilineUsageMessage()) {
                    this.tellNoPrefix("&c" + line);
                }
            }
        }
        catch (EventHandledException ex) {
            if (ex.getMessages() != null) {
                this.dynamicTellError(ex.getMessages());
            }
        }
        catch (CommandException ex) {
            if (ex.getMessages() != null) {
                this.dynamicTellError(ex.getMessages());
            }
        }
        catch (Throwable t) {
            this.dynamicTellError(SimpleLocalization.Commands.ERROR.replace("{error}", t.toString()));
            Common.error(t, "Failed to execute command /" + this.getLabel() + sublabel + " " + String.join((CharSequence)" ", args));
        }
        finally {
            Common.setTellPrefix(oldTellPrefix);
            if (!(this instanceof SimpleCommandGroup.MainCommand)) {
                LagCatcher.end(lagSection, 8, "{section} took {time} ms");
            }
        }
        return true;
    }

    private void dynamicTellError(String ... messages) {
        if (Messenger.ENABLED) {
            for (String message : messages) {
                this.tellError(message);
            }
        } else {
            this.tell(messages);
        }
    }

    private void handleCooldown() {
        if (this.isPlayer()) {
            Player player = this.getPlayer();
            long lastRun = this.cooldownMap.getOrDefault(player.getUniqueId(), 0L);
            long difference = (System.currentTimeMillis() - lastRun) / 1000L;
            if (lastRun != 0L) {
                this.checkBoolean(difference > (long)this.cooldownSeconds, Common.getOrDefault(this.cooldownMessage, SimpleLocalization.Commands.COOLDOWN_WAIT).replace("{duration}", String.valueOf((long)this.cooldownSeconds - difference + 1L)));
            }
            this.cooldownMap.put(player.getUniqueId(), System.currentTimeMillis());
        }
    }

    protected abstract void onCommand();

    protected String[] getMultilineUsageMessage() {
        return null;
    }

    protected final void checkConsole() throws CommandException {
        if (!this.isPlayer()) {
            throw new CommandException(new String[]{"&c" + SimpleLocalization.Commands.NO_CONSOLE});
        }
    }

    public final void checkPerm(@NonNull String perm) throws CommandException {
        if (perm == null) {
            throw new NullPointerException("perm is marked non-null but is null");
        }
        if (this.isPlayer() && !this.hasPerm(perm)) {
            throw new CommandException(new String[]{this.getPermissionMessage().replace("{permission}", perm)});
        }
    }

    public final void checkPerm(@NonNull CommandSender sender, @NonNull String perm) throws CommandException {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (perm == null) {
            throw new NullPointerException("perm is marked non-null but is null");
        }
        if (this.isPlayer() && !this.hasPerm(sender, perm)) {
            throw new CommandException(new String[]{this.getPermissionMessage().replace("{permission}", perm)});
        }
    }

    protected final void checkArgs(int minimumLength, String falseMessage) throws CommandException {
        if (this.args.length < minimumLength) {
            this.returnTell((Messenger.ENABLED ? "" : "&c") + falseMessage);
        }
    }

    protected final void checkArgs(boolean condition) {
        this.checkBoolean(condition, SimpleLocalization.Commands.INVALID_ARGUMENT.replace("{label}", this.getLabel()));
    }

    protected final void checkBoolean(boolean value, String falseMessage) throws CommandException {
        if (!value) {
            this.returnTell((Messenger.ENABLED ? "" : "&c") + falseMessage);
        }
    }

    protected final void checkUsage(boolean value) throws CommandException {
        if (!value) {
            this.returnInvalidArgs();
        }
    }

    protected final void checkNotNull(Object value, String messageIfNull) throws CommandException {
        if (value == null) {
            this.returnTell((Messenger.ENABLED ? "" : "&c") + messageIfNull);
        }
    }

    protected final void findOfflinePlayer(String name, Consumer<OfflinePlayer> syncCallback) throws CommandException {
        this.runAsync(() -> {
            OfflinePlayer targetPlayer = Bukkit.getOfflinePlayer((String)name);
            this.checkBoolean(targetPlayer != null && (targetPlayer.isOnline() || targetPlayer.hasPlayedBefore()), SimpleLocalization.Player.NOT_PLAYED_BEFORE.replace("{player}", name));
            this.runLater(() -> syncCallback.accept(targetPlayer));
        });
    }

    protected final void findOfflinePlayer(UUID uniqueId, Consumer<OfflinePlayer> syncCallback) throws CommandException {
        this.runAsync(() -> {
            OfflinePlayer targetPlayer = Remain.getOfflinePlayerByUUID(uniqueId);
            this.checkNotNull(targetPlayer, SimpleLocalization.Player.INVALID_UUID.replace("{uuid}", uniqueId.toString()));
            this.runLater(() -> syncCallback.accept(targetPlayer));
        });
    }

    protected final Player findPlayer(String name) throws CommandException {
        return this.findPlayer(name, SimpleLocalization.Player.NOT_ONLINE);
    }

    protected final Player findPlayer(String name, String falseMessage) throws CommandException {
        Player player = this.findPlayerInternal(name);
        this.checkBoolean(player != null && player.isOnline() && !PlayerUtil.isVanished(player), falseMessage.replace("{player}", name));
        return player;
    }

    protected final Player findPlayerOrSelf(String name) throws CommandException {
        if (name == null) {
            this.checkBoolean(this.isPlayer(), SimpleLocalization.Commands.CONSOLE_MISSING_PLAYER_NAME);
            return this.getPlayer();
        }
        Player player = this.findPlayerInternal(name);
        this.checkBoolean(player != null && player.isOnline(), SimpleLocalization.Player.NOT_ONLINE.replace("{player}", name));
        return player;
    }

    protected Player findPlayerInternal(String name) {
        return Bukkit.getPlayer((String)name);
    }

    protected final SimpleTime findTime(String raw) {
        try {
            return SimpleTime.from(raw);
        }
        catch (IllegalArgumentException ex) {
            this.returnTell(SimpleLocalization.Commands.INVALID_TIME.replace("{input}", raw));
            return null;
        }
    }

    protected final World findWorld(String name) {
        World world = Bukkit.getWorld((String)name);
        this.checkNotNull(world, SimpleLocalization.Commands.INVALID_WORLD.replace("{world}", name).replace("{available}", Common.join(Bukkit.getWorlds())));
        return world;
    }

    protected final CompMaterial findMaterial(String name, String falseMessage) throws CommandException {
        CompMaterial found = CompMaterial.fromString(name);
        this.checkNotNull((Object)found, falseMessage.replace("{enum}", name).replace("{item}", name));
        return found;
    }

    protected final <T extends Enum<T>> T findEnum(Class<T> enumType, String name, String falseMessage) throws CommandException {
        return this.findEnum(enumType, name, null, falseMessage);
    }

    protected final <T extends Enum<T>> T findEnum(Class<T> enumType, String name, Function<T, Boolean> condition, String falseMessage) throws CommandException {
        T found = null;
        try {
            found = ReflectionUtil.lookupEnum(enumType, name);
            if (!condition.apply(found).booleanValue()) {
                found = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.checkNotNull(found, falseMessage.replace("{enum}", name).replace("{available}", Common.join((Enum[])enumType.getEnumConstants())));
        return found;
    }

    protected final int findNumber(int index, int min, int max, String falseMessage) {
        return this.findNumber(Integer.class, index, min, max, falseMessage);
    }

    protected final int findNumber(int index, String falseMessage) {
        return this.findNumber(Integer.class, index, falseMessage);
    }

    protected final <T extends Number> T findNumber(Class<T> numberType, int index, T min, T max, String falseMessage) {
        T number = this.findNumber(numberType, index, falseMessage = falseMessage.replace("{min}", min + "").replace("{max}", max + ""));
        this.checkBoolean(((Comparable)number).compareTo(min) >= 0 && ((Comparable)number).compareTo(max) <= 0, falseMessage);
        return number;
    }

    protected final <T extends Number> T findNumber(Class<T> numberType, int index, String falseMessage) {
        block3: {
            this.checkBoolean(index < this.args.length, falseMessage);
            try {
                return (T)((Number)numberType.getMethod("valueOf", String.class).invoke(null, this.args[index]));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof NumberFormatException) break block3;
                e.printStackTrace();
            }
        }
        throw new CommandException(new String[]{this.replacePlaceholders((Messenger.ENABLED ? "" : "&c") + falseMessage)});
    }

    protected final boolean findBoolean(int index, String invalidMessage) {
        this.checkBoolean(index < this.args.length, invalidMessage);
        if (this.args[index].equalsIgnoreCase("true")) {
            return true;
        }
        if (this.args[index].equalsIgnoreCase("false")) {
            return false;
        }
        throw new CommandException(new String[]{this.replacePlaceholders((Messenger.ENABLED ? "" : "&c") + invalidMessage)});
    }

    protected final boolean hasPerm(String permission) {
        return this.hasPerm(this.sender, permission);
    }

    protected final boolean hasPerm(CommandSender sender, String permission) {
        return permission == null ? true : PlayerUtil.hasPerm((Permissible)sender, permission.replace("{label}", this.getLabel()));
    }

    protected final void tellReplaced(String message, Object ... replacements) {
        this.tell(Replacer.replaceArray(message, replacements));
    }

    protected final void tell(List<SimpleComponent> components) {
        if (components != null) {
            this.tell(components.toArray(new SimpleComponent[components.size()]));
        }
    }

    protected final void tell(SimpleComponent ... components) {
        if (components != null) {
            for (SimpleComponent component : components) {
                component.send(new CommandSender[]{this.sender});
            }
        }
    }

    protected final void tell(Collection<String> messages) {
        if (messages != null) {
            this.tell(messages.toArray(new String[messages.size()]));
        }
    }

    protected final void tellNoPrefix(Collection<String> messages) {
        this.tellNoPrefix(messages.toArray(new String[messages.size()]));
    }

    protected final void tellNoPrefix(String ... messages) {
        String oldLocalPrefix = this.tellPrefix;
        this.tellPrefix = "";
        this.tell(messages);
        this.tellPrefix = oldLocalPrefix;
    }

    protected final void tell(String ... messages) {
        if (messages == null) {
            return;
        }
        String oldTellPrefix = Common.getTellPrefix();
        if (this.tellPrefix != null) {
            Common.setTellPrefix(this.tellPrefix);
        }
        try {
            messages = this.replacePlaceholders(messages);
            if (messages.length > 2) {
                Common.tellNoPrefix(this.sender, messages);
            } else {
                Common.tell(this.sender, messages);
            }
        }
        finally {
            Common.setTellPrefix(oldTellPrefix);
        }
    }

    protected final void tellSuccess(String message) {
        if (message != null) {
            message = this.replacePlaceholders(message);
            Messenger.success(this.sender, message);
        }
    }

    protected final void tellInfo(String message) {
        if (message != null) {
            message = this.replacePlaceholders(message);
            Messenger.info(this.sender, message);
        }
    }

    protected final void tellWarn(String message) {
        if (message != null) {
            message = this.replacePlaceholders(message);
            Messenger.warn(this.sender, message);
        }
    }

    protected final void tellError(String message) {
        if (message != null) {
            message = this.replacePlaceholders(message);
            Messenger.error(this.sender, message);
        }
    }

    protected final void tellQuestion(String message) {
        if (message != null) {
            message = this.replacePlaceholders(message);
            Messenger.question(this.sender, message);
        }
    }

    protected final void returnInvalidArgs() {
        this.tellError(SimpleLocalization.Commands.INVALID_ARGUMENT.replace("{label}", this.getLabel()));
        throw new CommandException(new String[0]);
    }

    protected final void returnTell(Collection<String> messages) throws CommandException {
        this.returnTell(messages.toArray(new String[messages.size()]));
    }

    protected final void returnTell(String ... messages) throws CommandException {
        throw new CommandException(this.replacePlaceholders(messages));
    }

    protected final void returnUsage() throws InvalidCommandArgException {
        throw new InvalidCommandArgException();
    }

    protected final String[] replacePlaceholders(String[] messages) {
        for (int i = 0; i < messages.length; ++i) {
            messages[i] = this.replacePlaceholders(messages[i]).replace("{prefix}", Common.getTellPrefix());
        }
        return messages;
    }

    protected String replacePlaceholders(String message) {
        message = this.replaceBasicPlaceholders0(message);
        for (int i = 0; i < this.args.length; ++i) {
            message = message.replace("{" + i + "}", Common.getOrEmpty(this.args[i]));
        }
        return message;
    }

    private String replaceBasicPlaceholders0(String message) {
        message = message.replace("{label}", this.getLabel()).replace("{sublabel}", this instanceof SimpleSubCommand ? ((SimpleSubCommand)this).getSublabels()[0] : (this.args != null && this.args.length > 0 ? this.args[0] : super.getLabel()));
        message = Variables.replace(message, null);
        return message;
    }

    protected final void setArg(int position, String value) {
        if (this.args.length <= position) {
            this.args = Arrays.copyOf(this.args, position + 1);
        }
        this.args[position] = value;
    }

    protected final String getLastArg() {
        return this.args.length > 0 ? this.args[this.args.length - 1] : "";
    }

    protected final String[] rangeArgs(int from) {
        return this.rangeArgs(from, this.args.length);
    }

    protected final String[] rangeArgs(int from, int to) {
        return Arrays.copyOfRange(this.args, from, to);
    }

    protected final String joinArgs(int from) {
        return this.joinArgs(from, this.args.length);
    }

    protected final String joinArgs(int from, int to) {
        String message = "";
        for (int i = from; i < this.args.length && i < to; ++i) {
            message = message + this.args[i] + (i + 1 == this.args.length ? "" : " ");
        }
        return message;
    }

    @Deprecated
    public final List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        return this.tabComplete(sender, alias, args);
    }

    public final List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        this.sender = sender;
        this.currentLabel = alias;
        this.args = args;
        if (this.hasPerm(this.getPermission())) {
            List<String> suggestions = this.tabComplete();
            if (suggestions == null) {
                suggestions = this.completeLastWordPlayerNames();
            }
            return suggestions;
        }
        return new ArrayList<String>();
    }

    protected List<String> tabComplete() {
        return null;
    }

    protected List<String> completeLastWordPlayerNames() {
        return TabUtil.complete(this.getLastArg(), this.isPlayer() ? Common.getPlayerNames(false) : Common.getPlayerNames());
    }

    protected List<String> completeLastWordWorldNames() {
        return this.completeLastWord((Iterable)Common.getWorldNames());
    }

    @SafeVarargs
    protected final <T> List<String> completeLastWord(T ... suggestions) {
        return TabUtil.complete(this.getLastArg(), suggestions);
    }

    protected final <T> List<String> completeLastWord(Iterable<T> suggestions) {
        ArrayList<T> list = new ArrayList<T>();
        for (T suggestion : suggestions) {
            list.add(suggestion);
        }
        return TabUtil.complete(this.getLastArg(), list.toArray());
    }

    protected final <T> List<String> completeLastWord(Iterable<T> suggestions, Function<T, String> toString) {
        ArrayList<String> list = new ArrayList<String>();
        for (T suggestion : suggestions) {
            list.add(toString.apply(suggestion));
        }
        return TabUtil.complete(this.getLastArg(), list.toArray());
    }

    protected final Player getPlayer() {
        return this.isPlayer() ? (Player)this.getSender() : null;
    }

    protected final boolean isPlayer() {
        return this.sender instanceof Player;
    }

    protected final void setTellPrefix(String tellPrefix) {
        this.tellPrefix = tellPrefix;
    }

    protected final void setMinArguments(int minArguments) {
        Valid.checkBoolean(minArguments >= 0, "Minimum arguments must be 0 or greater", new Object[0]);
        this.minArguments = minArguments;
    }

    protected final void setCooldown(int cooldown, TimeUnit unit) {
        Valid.checkBoolean(cooldown >= 0, "Cooldown must be >= 0 for /" + this.getLabel(), new Object[0]);
        this.cooldownSeconds = (int)unit.toSeconds(cooldown);
    }

    protected final void setCooldownMessage(String cooldownMessage) {
        this.cooldownMessage = cooldownMessage;
    }

    public final String getPermissionMessage() {
        return Common.getOrDefault(super.getPermissionMessage(), SimpleLocalization.NO_PERMISSION);
    }

    public final String getPermission() {
        return super.getPermission() == null ? null : this.replaceBasicPlaceholders0(super.getPermission());
    }

    @Deprecated
    protected final String getRawPermission() {
        return super.getPermission();
    }

    public final void setPermission(String permission) {
        super.setPermission(permission);
    }

    protected final CommandSender getSender() {
        Valid.checkNotNull(this.sender, "Sender cannot be null");
        return this.sender;
    }

    public final List<String> getAliases() {
        return super.getAliases();
    }

    public final String getDescription() {
        return super.getDescription();
    }

    public final String getName() {
        return super.getName();
    }

    public final String getUsage() {
        String bukkitUsage = super.getUsage();
        return bukkitUsage.equals("/" + this.getCurrentLabel()) ? "" : bukkitUsage;
    }

    public final String getLabel() {
        return this.label;
    }

    public final boolean setLabel(String label) {
        this.currentLabel = label;
        return super.setLabel(label);
    }

    public final String getCurrentLabel() {
        return Common.getOrDefault(this.currentLabel, this.label);
    }

    protected final void setAutoHandleHelp(boolean autoHandleHelp) {
        this.autoHandleHelp = autoHandleHelp;
    }

    protected final BukkitTask runLater(Runnable runnable) {
        return Common.runLater(() -> this.delegateTask(runnable));
    }

    protected final BukkitTask runLater(int delayTicks, Runnable runnable) {
        return Common.runLater(delayTicks, () -> this.delegateTask(runnable));
    }

    protected final BukkitTask runAsync(Runnable runnable) {
        return Common.runAsync(() -> this.delegateTask(runnable));
    }

    protected final BukkitTask runAsync(int delayTicks, Runnable runnable) {
        return Common.runLaterAsync(delayTicks, () -> this.delegateTask(runnable));
    }

    private void delegateTask(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (CommandException ex) {
            if (ex.getMessages() != null) {
                for (String message : ex.getMessages()) {
                    if (Messenger.ENABLED) {
                        Messenger.error(this.sender, message);
                        continue;
                    }
                    Common.tell(this.sender, message);
                }
            }
        }
        catch (Throwable t) {
            String errorMessage = SimpleLocalization.Commands.ERROR.replace("{error}", t.toString());
            if (Messenger.ENABLED) {
                Messenger.error(this.sender, errorMessage);
            } else {
                Common.tell(this.sender, errorMessage);
            }
            throw t;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof SimpleCommand ? ((SimpleCommand)((Object)obj)).getLabel().equals(this.getLabel()) && ((SimpleCommand)((Object)obj)).getAliases().equals(this.getAliases()) : false;
    }

    public String toString() {
        return "Command{label=/" + this.label + "}";
    }

    public int getMinArguments() {
        return this.minArguments;
    }

    public int getCooldownSeconds() {
        return this.cooldownSeconds;
    }
}

