/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.command;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import sk.adonikeoffice.epicchat.lib.command.SimpleSubCommand;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;
import sk.adonikeoffice.epicchat.lib.settings.YamlConfig;

public final class ReloadCommand
extends SimpleSubCommand {
    public ReloadCommand(String permission) {
        this();
        this.setPermission(permission);
    }

    public ReloadCommand() {
        super("reload|rl");
        this.setDescription(SimpleLocalization.Commands.RELOAD_DESCRIPTION);
    }

    @Override
    protected void onCommand() {
        try {
            this.tell(SimpleLocalization.Commands.RELOAD_STARTED);
            boolean syntaxParsed = true;
            ArrayList<File> yamlFiles = new ArrayList<File>();
            this.collectYamlFiles(SimplePlugin.getData(), yamlFiles);
            for (File file : yamlFiles) {
                try {
                    YamlConfig.fromFile(file);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    syntaxParsed = false;
                }
            }
            if (!syntaxParsed) {
                this.tell(SimpleLocalization.Commands.RELOAD_FILE_LOAD_ERROR);
                return;
            }
            SimplePlugin.getInstance().reload();
            this.tell(SimpleLocalization.Commands.RELOAD_SUCCESS);
        }
        catch (Throwable t) {
            this.tell(SimpleLocalization.Commands.RELOAD_FAIL.replace("{error}", t.getMessage() != null ? t.getMessage() : "unknown"));
            t.printStackTrace();
        }
    }

    private List<File> collectYamlFiles(File directory, List<File> list) {
        if (directory.exists()) {
            for (File file : directory.listFiles()) {
                if (file.getName().endsWith("yml")) {
                    list.add(file);
                }
                if (!file.isDirectory()) continue;
                this.collectYamlFiles(file, list);
            }
        }
        return list;
    }

    @Override
    protected List<String> tabComplete() {
        return NO_COMPLETE;
    }
}

