/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.command;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.command.SimpleSubCommand;
import sk.adonikeoffice.epicchat.lib.command.annotation.Permission;
import sk.adonikeoffice.epicchat.lib.command.annotation.PermissionGroup;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.model.ChatPaginator;
import sk.adonikeoffice.epicchat.lib.model.Replacer;
import sk.adonikeoffice.epicchat.lib.model.SimpleComponent;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;

public final class PermsCommand
extends SimpleSubCommand {
    private final Class<?> classToList;
    private final SerializedMap variables;

    public PermsCommand(@NonNull Class<?> classToList) {
        this(classToList, new SerializedMap());
        if (classToList == null) {
            throw new NullPointerException("classToList is marked non-null but is null");
        }
    }

    public PermsCommand(@NonNull Class<?> classToList, String permission) {
        this(classToList, new SerializedMap());
        if (classToList == null) {
            throw new NullPointerException("classToList is marked non-null but is null");
        }
        this.setPermission(permission);
    }

    public PermsCommand(@NonNull Class<?> classToList, SerializedMap variables) {
        super("permissions|perms");
        if (classToList == null) {
            throw new NullPointerException("classToList is marked non-null but is null");
        }
        this.classToList = classToList;
        this.variables = variables;
        if (!this.variables.containsKey("label") && SimplePlugin.getInstance().getMainCommand() != null) {
            this.variables.put("label", SimplePlugin.getInstance().getMainCommand().getLabel());
        }
        this.setPermission(SimplePlugin.getNamed().toLowerCase() + ".command.permissions");
        this.setDescription(SimpleLocalization.Commands.PERMS_DESCRIPTION);
        this.setUsage(SimpleLocalization.Commands.PERMS_USAGE);
        this.list();
    }

    @Override
    protected void onCommand() {
        String phrase = this.args.length > 0 ? this.joinArgs(0) : null;
        new ChatPaginator(15).setFoundationHeader(SimpleLocalization.Commands.PERMS_HEADER).setPages(this.list(phrase)).send(this.sender);
    }

    private List<SimpleComponent> list() {
        return this.list(null);
    }

    private List<SimpleComponent> list(String phrase) {
        ArrayList<SimpleComponent> messages = new ArrayList<SimpleComponent>();
        Class<?> iteratedClass = this.classToList;
        try {
            do {
                this.listIn(iteratedClass, messages, phrase);
            } while (!(iteratedClass = iteratedClass.getSuperclass()).isAssignableFrom(Object.class));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return messages;
    }

    private void listIn(Class<?> clazz, List<SimpleComponent> messages, String phrase) throws ReflectiveOperationException {
        PermissionGroup group = clazz.getAnnotation(PermissionGroup.class);
        if (!messages.isEmpty() && !clazz.isAnnotationPresent(PermissionGroup.class)) {
            throw new FoException("Please place @PermissionGroup over " + clazz);
        }
        messages.add(SimpleComponent.of("&7- " + (messages.isEmpty() ? SimpleLocalization.Commands.PERMS_MAIN : group.value()) + " " + SimpleLocalization.Commands.PERMS_PERMISSIONS).onClickOpenUrl(""));
        for (Field field : clazz.getDeclaredFields()) {
            boolean has;
            if (!field.isAnnotationPresent(Permission.class)) continue;
            Permission annotation = field.getAnnotation(Permission.class);
            String info = Replacer.replaceVariables(String.join((CharSequence)"\n", Common.split(annotation.value(), 50)), this.variables);
            boolean def = annotation.def();
            if (info.contains("{") && info.contains("}")) {
                throw new FoException("Forgotten unreplaced variable in " + info + " for field " + field + " in " + clazz);
            }
            String node = Replacer.replaceVariables((String)field.get(null), this.variables);
            boolean bl = has = this.sender == null ? false : this.hasPerm(node);
            if (phrase != null && !node.contains(phrase)) continue;
            messages.add(SimpleComponent.of("  " + (has ? "&a" : "&7") + node + (def ? " " + SimpleLocalization.Commands.PERMS_TRUE_BY_DEFAULT : "")).onClickOpenUrl("").onHover(SimpleLocalization.Commands.PERMS_INFO + info, SimpleLocalization.Commands.PERMS_DEFAULT + (def ? SimpleLocalization.Commands.PERMS_YES : SimpleLocalization.Commands.PERMS_NO), SimpleLocalization.Commands.PERMS_APPLIED + (has ? SimpleLocalization.Commands.PERMS_YES : SimpleLocalization.Commands.PERMS_NO)));
        }
        for (AnnotatedElement annotatedElement : clazz.getDeclaredClasses()) {
            messages.add(SimpleComponent.of("&r "));
            this.listIn((Class<?>)annotatedElement, messages, phrase);
        }
    }

    @Override
    protected List<String> tabComplete() {
        return NO_COMPLETE;
    }
}

