/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.command;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.FileUtil;
import sk.adonikeoffice.epicchat.lib.TimeUtil;
import sk.adonikeoffice.epicchat.lib.command.SimpleSubCommand;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;
import sk.adonikeoffice.epicchat.lib.settings.YamlConfig;

public final class DebugCommand
extends SimpleSubCommand {
    private static List<String> debugLines = new ArrayList<String>();

    public DebugCommand(String permission) {
        this();
        this.setPermission(permission);
    }

    public DebugCommand() {
        super("debug");
        this.setDescription("ZIP your settings for reporting bugs.");
    }

    @Override
    protected void onCommand() {
        this.tell(SimpleLocalization.Commands.DEBUG_PREPARING);
        File debugFolder = FileUtil.getFile("debug");
        List<File> files = this.listFilesRecursively(SimplePlugin.getData(), new ArrayList<File>());
        FileUtil.deleteRecursivelly(debugFolder);
        this.writeDebugInformation();
        this.copyFilesToDebug(files);
        this.zipAndRemoveFolder(debugFolder);
        this.tell(SimpleLocalization.Commands.DEBUG_SUCCESS.replace("{amount}", String.valueOf(files.size())));
    }

    private void writeDebugInformation() {
        ArrayList<String> lines = Common.toList(Common.consoleLine(), " Debug log generated " + TimeUtil.getFormattedDate(), Common.consoleLine(), "Plugin: " + SimplePlugin.getInstance().getDescription().getFullName(), "Server Version: " + Bukkit.getVersion(), "Java: " + System.getProperty("java.version") + " (" + System.getProperty("java.specification.vendor") + "/" + System.getProperty("java.vm.vendor") + ")", "OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version"), "Online mode: " + Bukkit.getOnlineMode(), "Players Online: " + Remain.getOnlinePlayers().size(), "Plugins: " + Common.join(Bukkit.getPluginManager().getPlugins(), ", ", plugin -> plugin.getDescription().getFullName()));
        lines.addAll(debugLines);
        FileUtil.write("debug/general.txt", lines);
    }

    private void copyFilesToDebug(List<File> files) {
        for (File file : files) {
            try {
                String path = file.getPath().replace("\\", "/").replace("plugins/" + SimplePlugin.getNamed(), "");
                File copy = FileUtil.createIfNotExists("debug/" + path);
                if (file.getName().endsWith(".yml")) {
                    YamlConfig config = YamlConfig.fromFile(file);
                    YamlConfig copyConfig = YamlConfig.fromFile(copy);
                    for (String key : config.getKeys(true)) {
                        Object value = config.getObject(key);
                        if (key.contains("MySQL")) continue;
                        copyConfig.set(key, value);
                    }
                    copyConfig.save(copy);
                    continue;
                }
                Files.copy(file.toPath(), copy.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.returnTell(SimpleLocalization.Commands.DEBUG_COPY_FAIL.replace("{file}", file.getName()));
            }
        }
    }

    private void zipAndRemoveFolder(File folder) {
        try {
            String path = folder.getPath();
            FileUtil.zip(path, path);
            FileUtil.deleteRecursivelly(folder);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.returnTell(SimpleLocalization.Commands.DEBUG_ZIP_FAIL);
        }
    }

    private List<File> listFilesRecursively(File folder, List<File> files) {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                if (file.getName().equals("logs") || file.getName().equals("debug")) continue;
                this.listFilesRecursively(file, files);
                continue;
            }
            if (file.getName().equals("debug.zip") || file.getName().equals("mysql.yml")) continue;
            files.add(file);
        }
        return files;
    }

    @Override
    protected List<String> tabComplete() {
        return NO_COMPLETE;
    }

    public static void addDebugLines(String ... lines) {
        for (String line : lines) {
            debugLines.add(line);
        }
    }

    public static void setDebugLines(List<String> debugLines) {
        DebugCommand.debugLines = debugLines;
    }
}

