/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.collection;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.SerializeUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.StrictCollection;

public final class StrictSet<E>
extends StrictCollection
implements Iterable<E> {
    private final Set<E> set = new LinkedHashSet();

    @SafeVarargs
    public StrictSet(E ... elements) {
        this();
        this.addAll(Arrays.asList(elements));
    }

    public StrictSet(Iterable<E> oldList) {
        this();
        this.addAll(oldList);
    }

    public StrictSet() {
        super("Cannot remove '%s' as it is not in the set!", "Value '%s' is already in the set!");
    }

    public void remove(E value) {
        Valid.checkNotNull(value, "Cannot remove null values");
        boolean removed = this.set.remove(value);
        Valid.checkBoolean(removed, String.format(this.getCannotRemoveMessage(), value), new Object[0]);
    }

    public void removeWeak(E value) {
        this.set.remove(value);
    }

    public void addAll(Iterable<E> collection) {
        for (E val : collection) {
            this.add(val);
        }
    }

    public void add(E key) {
        Valid.checkNotNull(key, "Cannot add null values");
        Valid.checkBoolean(!this.set.contains(key), String.format(this.getCannotAddMessage(), key), new Object[0]);
        this.set.add(key);
    }

    public void override(E key) {
        this.set.add(key);
    }

    @Nullable
    public E first() {
        return this.set.isEmpty() ? null : (E)this.set.iterator().next();
    }

    public boolean contains(E key) {
        return this.set.contains(key);
    }

    public void clear() {
        this.set.clear();
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public int size() {
        return this.set.size();
    }

    public Set<E> getSource() {
        return this.set;
    }

    public String join(String separator) {
        return Common.join(this.set, separator);
    }

    public E[] toArray(E[] e) {
        return this.set.toArray(e);
    }

    @Override
    public Iterator<E> iterator() {
        return this.set.iterator();
    }

    @Override
    public Object serialize() {
        return SerializeUtil.serialize(this.getMode(), this.set);
    }

    public String toString() {
        return "StrictSet{\n\t" + Common.join(this.set, "\n\t") + "\n}";
    }
}

