/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import sk.adonikeoffice.epicchat.lib.SerializeUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.StrictCollection;

public final class StrictMap<K, V>
extends StrictCollection {
    private final Map<K, V> map = new LinkedHashMap();

    public StrictMap() {
        super("Cannot remove '%s' as it is not in the map!", "Key '%s' is already in the map --> '%s'");
    }

    public StrictMap(String removeMessage, String addMessage) {
        super(removeMessage, addMessage);
    }

    public StrictMap(Map<K, V> copyOf) {
        this();
        this.putAll(copyOf);
    }

    public void removeByValue(V value) {
        for (Map.Entry<K, V> e : this.map.entrySet()) {
            if (!e.getValue().equals(value)) continue;
            this.map.remove(e.getKey());
            return;
        }
        throw new NullPointerException(String.format(this.getCannotRemoveMessage(), value));
    }

    public Object[] removeAll(Collection<K> keys) {
        ArrayList<V> removedKeys = new ArrayList<V>();
        for (K key : keys) {
            removedKeys.add(this.remove(key));
        }
        return removedKeys.toArray();
    }

    public V remove(K key) {
        V removed = this.removeWeak(key);
        Valid.checkNotNull(removed, String.format(this.getCannotRemoveMessage(), key));
        return removed;
    }

    public void put(K key, V value) {
        Valid.checkBoolean(!this.map.containsKey(key), String.format(this.getCannotAddMessage(), key, this.map.get(key)), new Object[0]);
        this.override(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            Valid.checkBoolean(!this.map.containsKey(e.getKey()), String.format(this.getCannotAddMessage(), e.getKey(), this.map.get(e.getKey())), new Object[0]);
        }
        this.override(m);
    }

    public V removeWeak(K value) {
        return this.map.remove(value);
    }

    public void override(K key, V value) {
        this.map.put(key, value);
    }

    public void override(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    public V getOrPut(K key, V defaultToPut) {
        if (this.containsKey(key)) {
            return this.get(key);
        }
        this.put(key, defaultToPut);
        return defaultToPut;
    }

    public K getKeyFromValue(V value) {
        for (Map.Entry<K, V> e : this.map.entrySet()) {
            if (!e.getValue().equals(value)) continue;
            return e.getKey();
        }
        return null;
    }

    public V get(K key) {
        return this.map.get(key);
    }

    public V getOrDefault(K key, V def) {
        return this.map.getOrDefault(key, def);
    }

    @Nullable
    public K firstKey() {
        return this.map.isEmpty() ? null : (K)this.map.keySet().iterator().next();
    }

    @Nullable
    public V firstValue() {
        return this.map.isEmpty() ? null : (V)this.map.values().iterator().next();
    }

    public boolean containsKey(K key) {
        return key == null ? false : this.map.containsKey(key);
    }

    public boolean containsValue(V value) {
        return value == null ? false : this.map.containsValue(value);
    }

    public void forEachIterate(BiConsumer<K, V> consumer) {
        for (Map.Entry<K, V> entry : this.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Collection<V> values() {
        return this.map.values();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Map<K, V> getSource() {
        return this.map;
    }

    public int size() {
        return this.map.size();
    }

    @Override
    public Object serialize() {
        if (!this.map.isEmpty()) {
            LinkedHashMap<Object, Object> copy = new LinkedHashMap<Object, Object>();
            for (Map.Entry<K, V> entry : this.entrySet()) {
                V val = entry.getValue();
                if (val == null) continue;
                copy.put(SerializeUtil.serialize(this.getMode(), entry.getKey()), SerializeUtil.serialize(this.getMode(), val));
            }
            return copy;
        }
        return this.getSource();
    }

    public String toString() {
        return this.map.toString();
    }
}

