/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.SerializeUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.StrictCollection;

public final class StrictList<E>
extends StrictCollection
implements Iterable<E> {
    private final List<E> list = new ArrayList();

    @SafeVarargs
    public StrictList(E ... elements) {
        this();
        this.addAll(Arrays.asList(elements));
    }

    public StrictList(Iterable<E> oldList) {
        this();
        this.addAll(oldList);
    }

    public StrictList() {
        super("Cannot remove '%s' as it is not in the list!", "Value '%s' is already in the list!");
    }

    public List<E> getSource() {
        return this.list;
    }

    public E getAndRemove(int index) {
        E e = this.list.get(index);
        this.remove(index);
        return e;
    }

    public void remove(E key) {
        boolean removed = this.removeWeak(key);
        Valid.checkBoolean(removed, String.format(this.getCannotRemoveMessage(), key), new Object[0]);
    }

    public E remove(int index) {
        E removed = this.list.remove(index);
        Valid.checkNotNull(removed, String.format(this.getCannotRemoveMessage(), "index: " + index));
        return removed;
    }

    public void addAll(Iterable<E> elements) {
        for (E key : elements) {
            this.add(key);
        }
    }

    public void addIfNotExist(E key) {
        if (!this.contains(key)) {
            this.add(key);
        }
    }

    public void add(E key) {
        Valid.checkNotNull(key, "Cannot add null values");
        Valid.checkBoolean(!this.list.contains(key), String.format(this.getCannotAddMessage(), key), new Object[0]);
        this.addWeak(key);
    }

    public StrictList<E> range(int startIndex) {
        Valid.checkBoolean(startIndex <= this.list.size(), "Start index out of range " + startIndex + " vs. list size " + this.list.size(), new Object[0]);
        StrictList<E> ranged = new StrictList<E>();
        for (int i = startIndex; i < this.list.size(); ++i) {
            ranged.add(this.list.get(i));
        }
        return ranged;
    }

    @Nullable
    public E first() {
        return this.list.isEmpty() ? null : (E)this.list.get(0);
    }

    @Nullable
    public E last() {
        return this.list.isEmpty() ? null : (E)this.list.get(this.list.size() - 1);
    }

    public boolean removeWeak(E value) {
        Valid.checkNotNull(value, "Cannot remove null values");
        return this.list.remove(value);
    }

    public void addWeakAll(Iterable<E> keys) {
        for (E key : keys) {
            this.addWeak(key);
        }
    }

    public void addWeak(E key) {
        this.list.add(key);
    }

    public void set(int index, E key) {
        this.list.set(index, key);
    }

    public E getOrDefault(int index, E def) {
        return index < this.list.size() ? this.list.get(index) : def;
    }

    public E get(int index) {
        return this.list.get(index);
    }

    public boolean contains(E key) {
        for (E other : this.list) {
            if (other instanceof String && key instanceof String && ((String)other).equalsIgnoreCase((String)key)) {
                return true;
            }
            if (!other.equals(key)) continue;
            return true;
        }
        return false;
    }

    public List<E> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public void clear() {
        this.list.clear();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int size() {
        return this.list.size();
    }

    public String join(String separator) {
        return Common.join(this.list, separator);
    }

    public E[] toArray(E[] e) {
        return this.list.toArray(e);
    }

    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object serialize() {
        return SerializeUtil.serialize(this.getMode(), this.list);
    }

    public String toString() {
        return this.list.toString();
    }
}

