/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.configuration.MemorySection;
import org.bukkit.inventory.ItemStack;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.SerializeUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.StrictCollection;
import sk.adonikeoffice.epicchat.lib.collection.StrictMap;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONObject;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONParser;
import sk.adonikeoffice.epicchat.lib.model.IsInList;
import sk.adonikeoffice.epicchat.lib.model.Tuple;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.lib.settings.ConfigSection;

public final class SerializedMap
extends StrictCollection
implements Iterable<Map.Entry<String, Object>> {
    private final StrictMap<String, Object> map = new StrictMap();
    private SerializeUtil.Mode mode;
    private boolean removeOnGet = false;

    private SerializedMap(String key, Object value) {
        this();
        this.put(key, value);
    }

    public SerializedMap() {
        this(SerializeUtil.Mode.YAML);
    }

    private SerializedMap(SerializeUtil.Mode mode) {
        super("Cannot remove '%s' as it is not in the map!", "Value '%s' is already in the map!");
        this.mode = mode;
    }

    public SerializedMap mergeFrom(SerializedMap anotherMap) {
        for (Map.Entry<String, Object> entry : anotherMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null || this.map.containsKey(key)) continue;
            this.map.put(key, value);
        }
        return this;
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public SerializedMap putArray(Object ... associativeArray) {
        boolean nextIsString = true;
        String lastKey = null;
        for (Object obj : associativeArray) {
            if (nextIsString) {
                Valid.checkBoolean(obj instanceof String, "Expected String, got " + obj.getClass().getSimpleName() + ": " + obj, new Object[0]);
                lastKey = (String)obj;
            } else {
                this.map.override(lastKey, obj);
            }
            nextIsString = !nextIsString;
        }
        return this;
    }

    public SerializedMap put(@NonNull SerializedMap anotherMap) {
        if (anotherMap == null) {
            throw new NullPointerException("anotherMap is marked non-null but is null");
        }
        this.map.putAll(anotherMap.asMap());
        return this;
    }

    public void putIfTrue(String key, boolean value) {
        if (value) {
            this.put(key, value);
        }
    }

    public void putIfNonZero(String key, Number value) {
        if (value != null && value.longValue() != 0L) {
            this.put(key, value);
        }
    }

    public void putIfExist(String key, Object value) {
        if (value != null) {
            this.put(key, value);
        }
    }

    public void putIf(String key, Map<?, ?> value) {
        if (value != null && !value.isEmpty()) {
            this.put(key, value);
        } else {
            this.map.getSource().put(key, null);
        }
    }

    public void putIf(String key, Collection<?> value) {
        if (value != null && !value.isEmpty()) {
            this.put(key, value);
        } else {
            this.map.getSource().put(key, null);
        }
    }

    public void putIf(String key, boolean value) {
        if (value) {
            this.put(key, value);
        } else {
            this.map.getSource().put(key, null);
        }
    }

    public void putIf(String key, Object value) {
        if (value != null) {
            this.put(key, value);
        } else {
            this.map.getSource().put(key, null);
        }
    }

    public void put(String key, Object value) {
        Valid.checkNotNull(value, "Value with key '" + key + "' is null!");
        this.map.put(key, value);
    }

    public void override(String key, Object value) {
        this.map.override(key, value);
    }

    public void overrideAll(SerializedMap map) {
        map.forEach(this::override);
    }

    public Object removeWeak(String key) {
        return this.map.removeWeak(key);
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    public void removeByValue(Object value) {
        this.map.removeByValue(value);
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String def) {
        return this.get(key, String.class, def, new Object[0]);
    }

    public UUID getUUID(String key) {
        return this.getUUID(key, null);
    }

    public UUID getUUID(String key, UUID def) {
        return this.get(key, UUID.class, def, new Object[0]);
    }

    public Location getLocation(String key) {
        return this.get(key, Location.class, null, new Object[0]);
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long def) {
        Number n = this.get(key, Long.class, def, new Object[0]);
        return n != null ? Long.valueOf(n.longValue()) : null;
    }

    public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    public Integer getInteger(String key, Integer def) {
        return this.get(key, Integer.class, def, new Object[0]);
    }

    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    public Double getDouble(String key, Double def) {
        return this.get(key, Double.class, def, new Object[0]);
    }

    public Float getFloat(String key) {
        return this.getFloat(key, null);
    }

    public Float getFloat(String key, Float def) {
        return this.get(key, Float.class, def, new Object[0]);
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean def) {
        return this.get(key, Boolean.class, def, new Object[0]);
    }

    public CompMaterial getMaterial(String key) {
        return this.getMaterial(key, null);
    }

    public CompMaterial getMaterial(String key, CompMaterial def) {
        String raw = this.getString(key);
        return raw != null ? CompMaterial.fromString(raw) : def;
    }

    public ItemStack getItemStack(String key) {
        return this.getItem(key, null);
    }

    public ItemStack getItem(String key, ItemStack def) {
        Object obj = this.get(key, Object.class, null, new Object[0]);
        if (obj == null) {
            return def;
        }
        return SerializeUtil.deserialize(this.mode, ItemStack.class, obj);
    }

    public <K, V> Tuple<K, V> getTuple(String key, Class<K> keyType, Class<V> valueType) {
        return this.getTuple(key, null, keyType, valueType);
    }

    public <K, V> Tuple<K, V> getTuple(String key, Tuple<K, V> def, Class<K> keyType, Class<V> valueType) {
        return this.get(key, Tuple.class, def, keyType, valueType);
    }

    public List<String> getStringList(String key) {
        return this.getStringList(key, null);
    }

    public List<String> getStringList(String key, List<String> def) {
        List<String> list = this.getList(key, String.class);
        return list == null ? def : list;
    }

    public List<SerializedMap> getMapList(String key) {
        return this.getList(key, SerializedMap.class);
    }

    public <T> Set<T> getSet(String key, Class<T> type) {
        List<T> list = this.getList(key, type);
        return new HashSet<T>(list);
    }

    public <T> IsInList<T> getIsInList(String path, Class<T> type) {
        List<String> stringList = this.getStringList(path);
        if (stringList.size() == 1 && "*".equals(stringList.get(0))) {
            return IsInList.fromStar();
        }
        return IsInList.fromList(this.getList(path, type));
    }

    public <K, V> List<Tuple<K, V>> getTupleList(String path, Class<K> tupleKey, Class<V> tupleValue) {
        ArrayList<Tuple<K, V>> list = new ArrayList<Tuple<K, V>>();
        for (Object object : this.getList(path, Object.class)) {
            if (object == null) {
                list.add(null);
                continue;
            }
            Tuple<K, V> tuple = Tuple.deserialize(SerializedMap.of(object, this.mode), tupleKey, tupleValue);
            list.add(tuple);
        }
        return list;
    }

    public <T> List<T> getList(String key, Class<T> type) {
        return this.getList(key, type, null);
    }

    public <T> List<T> getList(String key, Class<T> type, Object ... parameters) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (!this.map.containsKey(key)) {
            return list;
        }
        Object rawList = Remain.getRootOfSectionPathData(this.removeOnGet ? this.map.removeWeak(key) : this.map.get(key));
        if (type == String.class && rawList instanceof String) {
            list.add(rawList);
        } else {
            Valid.checkBoolean(rawList instanceof Collection, "Key '" + key + "' expected to have a list, got " + rawList.getClass().getSimpleName() + " instead! Try putting '' quotes around the message: " + rawList, new Object[0]);
            for (Object object : (Collection)rawList) {
                list.add(object == null ? null : (Object)SerializeUtil.deserialize(this.mode, type, object, parameters));
            }
        }
        return list;
    }

    public SerializedMap getMap(String key) {
        Object raw = this.get(key, Object.class);
        return raw != null ? SerializedMap.of(raw, this.mode) : new SerializedMap();
    }

    public <Key, Value> LinkedHashMap<Key, Value> getMap(@NonNull String path, Class<Key> keyType, Class<Value> valueType) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        LinkedHashMap<Key, Value> map = new LinkedHashMap<Key, Value>();
        Object raw = this.map.get(path);
        if (raw != null) {
            for (Map.Entry<String, Object> entry : SerializedMap.of(raw, this.mode).entrySet()) {
                Key key = SerializeUtil.deserialize(this.mode, keyType, (Object)entry.getKey());
                Value value = SerializeUtil.deserialize(this.mode, valueType, entry.getValue());
                this.checkAssignable(path, key, keyType);
                this.checkAssignable(path, value, valueType);
                map.put(key, value);
            }
        }
        return map;
    }

    public <Key, Value> LinkedHashMap<Key, Set<Value>> getMapSet(@NonNull String path, Class<Key> keyType, Class<Value> setType) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        LinkedHashMap map = new LinkedHashMap();
        Object raw = this.map.get(path);
        if (raw != null) {
            raw = SerializedMap.of(raw, this.mode);
            for (Map.Entry<String, Object> entry : ((SerializedMap)raw).entrySet()) {
                Key key = SerializeUtil.deserialize(this.mode, keyType, (Object)entry.getKey());
                List value = SerializeUtil.deserialize(this.mode, List.class, entry.getValue());
                this.checkAssignable(path, key, keyType);
                if (!value.isEmpty()) {
                    for (Object item : value) {
                        this.checkAssignable(path, item, setType);
                    }
                }
                map.put(key, new HashSet(value));
            }
        }
        return map;
    }

    private void checkAssignable(String path, Object value, Class<?> clazz) {
        if (!clazz.isAssignableFrom(value.getClass()) && !clazz.getSimpleName().equals(value.getClass().getSimpleName())) {
            throw new FoException("Malformed map! Key '" + path + "' in the map must be " + clazz.getSimpleName() + " but got " + value.getClass().getSimpleName() + ": '" + value + "'");
        }
    }

    public Object getObject(String key) {
        return this.get(key, Object.class);
    }

    public Object getObject(String key, Object def) {
        return this.get(key, Object.class, def, new Object[0]);
    }

    public <T> T get(String key, Class<T> type) {
        return this.get(key, type, null, new Object[0]);
    }

    public <T> T get(String key, Class<T> type, T def, Object ... deserializeParameters) {
        Object raw;
        Object object = raw = this.removeOnGet ? this.map.removeWeak(key) : this.map.get(key);
        if (raw == null) {
            raw = this.getValueIgnoreCase(key);
        }
        if ("".equals(raw) && Enum.class.isAssignableFrom(type)) {
            return def;
        }
        return raw == null ? def : SerializeUtil.deserialize(this.mode, type, raw, deserializeParameters);
    }

    public Object getValueIgnoreCase(String key) {
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public void forEach(BiConsumer<String, Object> consumer) {
        for (Map.Entry<String, Object> e : this.map.entrySet()) {
            consumer.accept(e.getKey(), e.getValue());
        }
    }

    public Map.Entry<String, Object> firstEntry() {
        return this.isEmpty() ? null : this.map.getSource().entrySet().iterator().next();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public Collection<Object> values() {
        return this.map.values();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public Map<String, Object> asMap() {
        return this.map.getSource();
    }

    @Override
    public Object serialize() {
        return this.map.serialize();
    }

    public String toJson() {
        try {
            JSONObject jsonMap = new JSONObject();
            for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                Object key = SerializeUtil.serialize(SerializeUtil.Mode.JSON, entry.getKey());
                Object value = SerializeUtil.serialize(SerializeUtil.Mode.JSON, entry.getValue());
                if (key == null || value == null) continue;
                jsonMap.put(key.toString(), value);
            }
            return jsonMap.toString();
        }
        catch (Throwable t) {
            Common.error(t, "Failed to serialize to json, unparsed data: " + this.map);
            return "{}";
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public <O, N> void convert(String path, Class<O> from, Class<N> to, Function<O, N> converter) {
        Object old = this.getObject(path);
        if (old != null) {
            if (old instanceof Collection) {
                Collection collection = (Collection)old;
                if (collection.isEmpty() || !from.isAssignableFrom(collection.iterator().next().getClass())) {
                    return;
                }
                ArrayList<N> newCollection = new ArrayList<N>();
                for (Object oldItem : collection) {
                    newCollection.add(converter.apply(oldItem));
                }
                this.override(path, newCollection);
                Common.logNoPrefix("[" + SimplePlugin.getNamed() + "] Converted '" + path + "' from " + from.getSimpleName() + "[] to " + to.getSimpleName() + "[]");
            } else if (from.isAssignableFrom(old.getClass())) {
                this.override(path, converter.apply(old));
                Common.logNoPrefix("[" + SimplePlugin.getNamed() + "] Converted '" + path + "' from '" + from.getSimpleName() + "' to '" + to.getSimpleName() + "'");
            }
        }
    }

    public String toStringFormatted() {
        Map map = (Map)this.serialize();
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("{");
        for (Map.Entry entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value == null || value.toString().equals("[]") || value.toString().equals("{}") || value.toString().isEmpty() || value.toString().equals("0.0") || value.toString().equals("false")) continue;
            lines.add("\t'" + entry.getKey() + "' = '" + entry.getValue() + "'");
        }
        lines.add("}");
        return String.join((CharSequence)"\n", lines);
    }

    public void setRemoveOnGet(boolean removeOnGet) {
        this.removeOnGet = removeOnGet;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.map.entrySet().iterator();
    }

    public String toString() {
        return this.serialize().toString();
    }

    public static SerializedMap of(String key, Object value) {
        return new SerializedMap(key, value);
    }

    public static SerializedMap ofArray(Object ... array) {
        if (array != null && array.length == 1) {
            Object firstArgument = array[0];
            if (firstArgument instanceof SerializedMap) {
                return (SerializedMap)firstArgument;
            }
            if (firstArgument instanceof Map) {
                return SerializedMap.of(firstArgument);
            }
            if (firstArgument instanceof StrictMap) {
                return SerializedMap.of(((StrictMap)firstArgument).getSource());
            }
        }
        SerializedMap map = new SerializedMap();
        map.putArray(array);
        return map;
    }

    public static SerializedMap of(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return SerializedMap.of(object, SerializeUtil.Mode.YAML);
    }

    private static SerializedMap of(@NonNull Object object, SerializeUtil.Mode mode) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (object instanceof SerializedMap) {
            ((SerializedMap)object).mode = mode;
            return (SerializedMap)object;
        }
        if (object instanceof MemorySection) {
            return SerializedMap.of(Common.getMapFromSection(object));
        }
        if (object instanceof ConfigSection) {
            return SerializedMap.of(((ConfigSection)object).getValues(false));
        }
        if (object instanceof Map) {
            LinkedHashMap copyOf = new LinkedHashMap();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                Object key = entry.getKey();
                if (key == null) {
                    copyOf.put(null, entry.getValue());
                    continue;
                }
                String stringKey = key.toString();
                Object value = entry.getValue();
                String[] split = stringKey.split("\\=");
                if (split.length == 2 && value == null) {
                    String actualKey = split[0];
                    String actualValue = split[1];
                    copyOf.put(actualKey, actualValue);
                    continue;
                }
                copyOf.put(stringKey, value);
            }
            SerializedMap serialized = new SerializedMap(mode);
            serialized.map.putAll(copyOf);
            return serialized;
        }
        if (object instanceof List && ((List)object).isEmpty()) {
            return new SerializedMap(mode);
        }
        throw new FoException("Cannot instantiate SerializedMap(" + (Object)((Object)mode) + ") from " + object.getClass().getSimpleName() + ": " + object);
    }

    public static SerializedMap fromJson(@NonNull String json) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        if (json.isEmpty() || "[]".equals(json) || "{}".equals(json)) {
            return new SerializedMap(SerializeUtil.Mode.JSON);
        }
        try {
            Object parsed = JSONParser.deserialize(json);
            if (parsed instanceof JSONObject) {
                return SerializedMap.of(parsed, SerializeUtil.Mode.JSON);
            }
            throw new FoException("Unable to deserialize " + (parsed != null ? parsed.getClass() : "unknown class") + " from json: " + json);
        }
        catch (Throwable secondThrowable) {
            Common.throwError(secondThrowable, "Failed to parse JSON from " + json);
            return null;
        }
    }

    @Override
    public SerializeUtil.Mode getMode() {
        return this.mode;
    }
}

