/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.bungee.message;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.bungee.BungeeListener;
import sk.adonikeoffice.epicchat.lib.bungee.BungeeMessageType;
import sk.adonikeoffice.epicchat.lib.bungee.message.Message;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public final class OutgoingMessage
extends Message {
    private final List<Object> queue = new ArrayList<Object>();

    public OutgoingMessage(UUID senderUid, BungeeMessageType action) {
        this(SimplePlugin.getInstance().getBungeeCord(), senderUid, action);
    }

    public OutgoingMessage(BungeeListener listener, UUID senderUid, BungeeMessageType action) {
        super(listener);
        this.setSenderUid(senderUid.toString());
        this.setServerName(Remain.getServerName());
        this.setAction(action);
        this.queue.add(senderUid);
        this.queue.add(this.getServerName());
        this.queue.add(this.getAction().name());
    }

    public void writeMap(SerializedMap map) {
        this.write(map.toJson(), String.class);
    }

    public void writeString(String ... messages) {
        for (String message : messages) {
            this.write(message, String.class);
        }
    }

    public void writeBoolean(boolean bool) {
        this.write(bool, Boolean.class);
    }

    public void writeByte(byte number) {
        this.write(number, Byte.class);
    }

    public void writeDouble(double number) {
        this.write(number, Double.class);
    }

    public void writeFloat(float number) {
        this.write(Float.valueOf(number), Float.class);
    }

    public void writeInt(int number) {
        this.write(number, Integer.class);
    }

    public void writeLong(long number) {
        this.write(number, Long.class);
    }

    public void writeShort(short number) {
        this.write(number, Short.class);
    }

    public void writeUUID(UUID uuid) {
        this.write(uuid, UUID.class);
    }

    private void write(Object object, Class<?> typeOf) {
        Valid.checkNotNull(object, "Added object must not be null!");
        this.moveHead(typeOf);
        this.queue.add(object);
    }

    public void send(Player player) {
        player.sendPluginMessage((Plugin)SimplePlugin.getInstance(), this.getChannel(), this.compileData());
    }

    private byte[] compileData() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        for (Object object : this.queue) {
            if (object instanceof String) {
                out.writeUTF((String)object);
                continue;
            }
            if (object instanceof Boolean) {
                out.writeBoolean(((Boolean)object).booleanValue());
                continue;
            }
            if (object instanceof Byte) {
                out.writeByte((int)((Byte)object).byteValue());
                continue;
            }
            if (object instanceof Double) {
                out.writeDouble(((Double)object).doubleValue());
                continue;
            }
            if (object instanceof Float) {
                out.writeFloat(((Float)object).floatValue());
                continue;
            }
            if (object instanceof Integer) {
                out.writeInt(((Integer)object).intValue());
                continue;
            }
            if (object instanceof Long) {
                out.writeLong(((Long)object).longValue());
                continue;
            }
            if (object instanceof Short) {
                out.writeShort((int)((Short)object).shortValue());
                continue;
            }
            if (object instanceof byte[]) {
                out.write((byte[])object);
                continue;
            }
            if (object instanceof UUID) {
                out.writeUTF(object.toString());
                continue;
            }
            throw new FoException("Unsupported write of " + object.getClass().getSimpleName() + " to channel " + this.getChannel() + " with action " + this.getAction().toString());
        }
        return out.toByteArray();
    }
}

