/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.bungee.message;

import java.util.UUID;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.bungee.BungeeListener;
import sk.adonikeoffice.epicchat.lib.bungee.BungeeMessageType;

abstract class Message {
    private final BungeeListener listener;
    private UUID senderUid;
    private String serverName;
    private BungeeMessageType action;
    private int actionHead = 0;

    protected final void setSenderUid(String raw) {
        if (raw != null) {
            try {
                this.senderUid = UUID.fromString(raw);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Expected UUID, got " + raw + " for packet " + this.action + " from server " + this.serverName);
            }
        }
    }

    protected final void setServerName(String serverName) {
        Valid.checkBoolean(this.serverName == null, "Server name already set", new Object[0]);
        Valid.checkNotNull(serverName, "Server name cannot be null!");
        this.serverName = serverName;
    }

    protected final void setAction(String actionName) {
        BungeeMessageType action = BungeeMessageType.getByName(this.listener, actionName);
        Valid.checkNotNull(action, "Unknown plugin action named: " + actionName + ". IF YOU UPDATED THE PLUGIN BY RELOADING, you need to stop your entire network, ensure all servers were updated and start it again.");
        this.setAction(action);
    }

    protected final void setAction(BungeeMessageType action) {
        Valid.checkBoolean(this.action == null, "Action already set", new Object[0]);
        this.action = action;
    }

    public <T extends BungeeMessageType> T getAction() {
        return (T)this.action;
    }

    protected final void moveHead(Class<?> typeOf) {
        Valid.checkNotNull(this.serverName, "Server name not set!");
        Valid.checkNotNull(this.action, "Action not set!");
        Class<?>[] content = this.action.getContent();
        Valid.checkBoolean(this.actionHead < content.length, "Head out of bounds! Max data size for " + this.action.name() + " is " + content.length, new Object[0]);
        ++this.actionHead;
    }

    public final String getChannel() {
        return this.listener.getChannel();
    }

    protected Message(BungeeListener listener) {
        this.listener = listener;
    }

    public UUID getSenderUid() {
        return this.senderUid;
    }

    public String getServerName() {
        return this.serverName;
    }
}

