/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.bungee.message;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.bungee.BungeeListener;
import sk.adonikeoffice.epicchat.lib.bungee.message.Message;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;

public final class IncomingMessage
extends Message {
    private final byte[] data;
    private ByteArrayDataInput input;
    private final ByteArrayInputStream stream;

    public IncomingMessage(byte[] data) {
        this(SimplePlugin.getInstance().getBungeeCord(), data);
    }

    public IncomingMessage(BungeeListener listener, byte[] data) {
        super(listener);
        this.data = data;
        this.stream = new ByteArrayInputStream(data);
        try {
            this.input = ByteStreams.newDataInput((ByteArrayInputStream)this.stream);
        }
        catch (Throwable t) {
            this.input = ByteStreams.newDataInput((byte[])data);
        }
        this.setSenderUid(this.input.readUTF());
        this.setServerName(this.input.readUTF());
        this.setAction(this.input.readUTF());
    }

    public String readString() {
        this.moveHead(String.class);
        return this.input.readUTF();
    }

    public UUID readUUID() {
        this.moveHead(UUID.class);
        return UUID.fromString(this.input.readUTF());
    }

    public SerializedMap readMap() {
        this.moveHead(String.class);
        return SerializedMap.fromJson(this.input.readUTF());
    }

    public <T extends Enum<T>> T readEnum(Class<T> typeOf) {
        this.moveHead(typeOf);
        return ReflectionUtil.lookupEnum(typeOf, this.input.readUTF());
    }

    public boolean readBoolean() {
        this.moveHead(Boolean.class);
        return this.input.readBoolean();
    }

    public byte readByte() {
        this.moveHead(Byte.class);
        return this.input.readByte();
    }

    public byte[] readBytes() {
        this.moveHead(byte[].class);
        byte[] array = new byte[this.stream.available()];
        try {
            this.stream.read(array);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return array;
    }

    public double readDouble() {
        this.moveHead(Double.class);
        return this.input.readDouble();
    }

    public float readFloat() {
        this.moveHead(Float.class);
        return this.input.readFloat();
    }

    public int writeInt() {
        this.moveHead(Integer.class);
        return this.input.readInt();
    }

    public long readLong() {
        this.moveHead(Long.class);
        return this.input.readLong();
    }

    public short readShort() {
        this.moveHead(Short.class);
        return this.input.readShort();
    }

    public void forward(Player player) {
        player.sendPluginMessage((Plugin)SimplePlugin.getInstance(), this.getChannel(), this.data);
    }

    public byte[] getData() {
        return this.data;
    }
}

