/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib.bungee;

import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.messaging.PluginMessageListener;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.bungee.BungeeMessageType;
import sk.adonikeoffice.epicchat.lib.bungee.message.IncomingMessage;

public abstract class BungeeListener
implements Listener,
PluginMessageListener {
    private final String channel;
    private final BungeeMessageType[] actions;

    protected BungeeListener(@NonNull String channel, Class<? extends BungeeMessageType> actionEnum) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        this.channel = channel;
        this.actions = BungeeListener.toActions(actionEnum);
    }

    private static BungeeMessageType[] toActions(@NonNull Class<? extends BungeeMessageType> actionEnum) {
        if (actionEnum == null) {
            throw new NullPointerException("actionEnum is marked non-null but is null");
        }
        Valid.checkBoolean(actionEnum.isEnum(), "BungeeListener expects BungeeMessageType to be an enum, given: " + actionEnum, new Object[0]);
        try {
            return (BungeeMessageType[])actionEnum.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            Common.throwError(ex, "Unable to get values() of " + actionEnum + ", ensure it is an enum!");
            return null;
        }
    }

    public final void onPluginMessageReceived(String channelName, Player player, byte[] data) {
        if (Bukkit.getName().contains("Cauldron")) {
            return;
        }
        this.onMessageReceived(player, new IncomingMessage(data));
    }

    public abstract void onMessageReceived(Player var1, IncomingMessage var2);

    public String getChannel() {
        return this.channel;
    }

    public BungeeMessageType[] getActions() {
        return this.actions;
    }
}

