/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.Vector;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.PlayerUtil;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.model.RangedValue;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;

public final class Valid {
    private static final Pattern PATTERN_INTEGER = Pattern.compile("-?\\d+");
    private static final Pattern PATTERN_DECIMAL = Pattern.compile("([0-9]+\\.?[0-9]*|\\.[0-9]+)");

    public static void checkNotNull(Object toCheck) {
        if (toCheck == null) {
            throw new FoException();
        }
    }

    public static void checkNotNull(Object toCheck, String falseMessage) {
        if (toCheck == null) {
            throw new FoException(falseMessage);
        }
    }

    public static void checkBoolean(boolean expression) {
        if (!expression) {
            throw new FoException();
        }
    }

    public static void checkBoolean(boolean expression, String falseMessage, Object ... replacements) {
        if (!expression) {
            String message = falseMessage;
            try {
                message = String.format(falseMessage, replacements);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new FoException(message);
        }
    }

    public static void checkInteger(String toCheck, String falseMessage, Object ... replacements) {
        if (!Valid.isInteger(toCheck)) {
            throw new FoException(String.format(falseMessage, replacements));
        }
    }

    public static void checkNotEmpty(Collection<?> collection, String message) {
        if (collection == null || collection.size() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkNotEmpty(String message, String emptyMessage) {
        if (message == null || message.length() == 0) {
            throw new IllegalArgumentException(emptyMessage);
        }
    }

    public static boolean checkPermission(CommandSender sender, String permission) {
        if (!PlayerUtil.hasPerm((Permissible)sender, permission)) {
            Common.tell(sender, SimpleLocalization.NO_PERMISSION.replace("{permission}", permission));
            return false;
        }
        return true;
    }

    public static void checkSync(String asyncErrorMessage) {
        Valid.checkBoolean(Bukkit.isPrimaryThread(), asyncErrorMessage, new Object[0]);
    }

    public static void checkAsync(String syncErrorMessage) {
        Valid.checkBoolean(!Bukkit.isPrimaryThread(), syncErrorMessage, new Object[0]);
    }

    public static boolean isInteger(String raw) {
        Valid.checkNotNull(raw, "Cannot check if null is an integer!");
        return PATTERN_INTEGER.matcher(raw).matches();
    }

    public static boolean isDecimal(String raw) {
        Valid.checkNotNull(raw, "Cannot check if null is a decimal!");
        return PATTERN_DECIMAL.matcher(raw).matches();
    }

    public static boolean isNumber(@NonNull String raw) {
        int i;
        int start;
        Valid.checkNotNull(raw, "Cannot check if null is a Number!");
        if (raw.isEmpty()) {
            return false;
        }
        char[] letters = raw.toCharArray();
        int length = letters.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = letters[0] == '-' ? 1 : 0;
        if (length > start + 1 && letters[start] == '0' && letters[start + 1] == 'x') {
            int i2 = start + 2;
            if (i2 == length) {
                return false;
            }
            while (i2 < letters.length) {
                if (!(letters[i2] >= '0' && letters[i2] <= '9' || letters[i2] >= 'a' && letters[i2] <= 'f' || letters[i2] >= 'A' && letters[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --length;
        for (i = start; i < length || i < length + 1 && allowSigns && !foundDigit; ++i) {
            if (letters[i] >= '0' && letters[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (letters[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (letters[i] == 'e' || letters[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (letters[i] == '+' || letters[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < letters.length) {
            if (letters[i] >= '0' && letters[i] <= '9') {
                return true;
            }
            if (letters[i] == 'e' || letters[i] == 'E') {
                return false;
            }
            if (letters[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || letters[i] != 'd' && letters[i] != 'D' && letters[i] != 'f' && letters[i] != 'F')) {
                return foundDigit;
            }
            if (letters[i] == 'l' || letters[i] == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public static boolean isNullOrEmpty(Collection<?> array) {
        return array == null || Valid.isNullOrEmpty(array.toArray());
    }

    public static boolean isNullOrEmptyValues(SerializedMap map) {
        return Valid.isNullOrEmptyValues(map == null ? null : map.asMap());
    }

    public static boolean isNullOrEmptyValues(Map<?, ?> map) {
        if (map == null) {
            return true;
        }
        for (Object value : map.values()) {
            if (value == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrEmpty(Object[] array) {
        if (array != null) {
            for (Object object : array) {
                if (!(object instanceof String ? !((String)object).isEmpty() : object != null)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNullOrEmpty(String message) {
        return message == null || message.isEmpty();
    }

    public static boolean isFinite(Vector vector) {
        return Double.isFinite(vector.getX()) && Double.isFinite(vector.getY()) && Double.isFinite(vector.getZ());
    }

    public static boolean isInRange(long value, RangedValue ranged) {
        return value >= ranged.getMinLong() && value <= ranged.getMaxLong();
    }

    public static boolean isInRange(double value, double min, double max) {
        return value >= min && value <= max;
    }

    public static boolean isInRange(long value, long min, long max) {
        return value >= min && value <= max;
    }

    public static boolean isUUID(Object object) {
        if (object instanceof String) {
            String[] components = object.toString().split("-");
            return components.length == 5;
        }
        return object instanceof UUID;
    }

    public static boolean locationEquals(Location first, Location sec) {
        if (first == null && sec == null) {
            return true;
        }
        if (first == null && sec == null || first != null && sec == null) {
            return false;
        }
        try {
            if (!first.getWorld().getName().equals(sec.getWorld().getName())) {
                return false;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return first.getBlockX() == sec.getBlockX() && first.getBlockY() == sec.getBlockY() && first.getBlockZ() == sec.getBlockZ();
    }

    public static <T> boolean listEquals(List<T> first, List<T> second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null) {
            return false;
        }
        if (second == null) {
            return false;
        }
        if (first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            T f = first.get(i);
            T s = second.get(i);
            if (f == null && s != null) {
                return false;
            }
            if (f != null && s == null) {
                return false;
            }
            if (f == null || f.equals(s) || Common.stripColors(f.toString()).equalsIgnoreCase(Common.stripColors(s.toString()))) continue;
            return false;
        }
        return true;
    }

    public static boolean colorlessEquals(String first, String second) {
        return Common.stripColors(first).equalsIgnoreCase(Common.stripColors(second));
    }

    public static boolean colorlessEquals(List<String> first, List<String> second) {
        return Valid.colorlessEquals(Common.toArray(first), Common.toArray(second));
    }

    public static boolean colorlessEquals(String[] firstArray, String[] secondArray) {
        for (int i = 0; i < firstArray.length; ++i) {
            String second;
            String first = Common.stripColors(firstArray[i]);
            String string = second = i < secondArray.length ? Common.stripColors(secondArray[i]) : "";
            if (first.equalsIgnoreCase(second)) continue;
            return false;
        }
        return true;
    }

    public static boolean valuesEqual(Collection<String> values) {
        ArrayList<String> copy = new ArrayList<String>(values);
        String lastValue = null;
        for (String value : copy) {
            if (lastValue == null) {
                lastValue = value;
            }
            if (!lastValue.equals(value)) {
                return false;
            }
            lastValue = value;
        }
        return true;
    }

    public static boolean isInList(String element, boolean isBlacklist, Iterable<String> list) {
        return isBlacklist == Valid.isInList(element, list);
    }

    public static boolean isInList(String element, Iterable<String> list) {
        try {
            for (String matched : list) {
                if (!Valid.removeSlash(element).equalsIgnoreCase(Valid.removeSlash(matched))) continue;
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isInListStartsWith(String element, Iterable<String> list) {
        try {
            for (String matched : list) {
                if (!Valid.removeSlash(element).toLowerCase().startsWith(Valid.removeSlash(matched).toLowerCase())) continue;
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isInListRegex(String element, Iterable<String> list) {
        try {
            for (String regex : list) {
                if (!Common.regExMatch(regex, element)) continue;
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isInListEnum(String element, Enum<?>[] enumeration) {
        for (Enum<?> constant : enumeration) {
            if (!constant.name().equalsIgnoreCase(element)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isInListContains(String element, Iterable<String> list) {
        try {
            for (String matched : list) {
                if (!Valid.removeSlash(element).toLowerCase().contains(Valid.removeSlash(matched).toLowerCase())) continue;
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    private static String removeSlash(String message) {
        return message.startsWith("/") ? message.substring(1) : message;
    }

    private Valid() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

