/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib;

import lombok.NonNull;
import sk.adonikeoffice.epicchat.lib.settings.SimpleSettings;

final class TimedCharSequence
implements CharSequence {
    private final CharSequence message;
    private final long futureTimestampLimit;

    private TimedCharSequence(@NonNull CharSequence message, long futureTimestampLimit) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.message = message;
        this.futureTimestampLimit = futureTimestampLimit;
    }

    @Override
    public char charAt(int index) {
        try {
            return this.message.charAt(index);
        }
        catch (StringIndexOutOfBoundsException ex) {
            return ' ';
        }
    }

    @Override
    public int length() {
        return this.message.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new TimedCharSequence(this.message.subSequence(start, end), this.futureTimestampLimit);
    }

    @Override
    public String toString() {
        return this.message.toString();
    }

    static TimedCharSequence withSettingsLimit(CharSequence message) {
        return new TimedCharSequence(message, System.currentTimeMillis() + (long)SimpleSettings.REGEX_TIMEOUT.intValue());
    }
}

