/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sk.adonikeoffice.epicchat.lib.Valid;

public final class TimeUtil {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static final DateFormat DATE_FORMAT_SHORT = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    private static final DateFormat DATE_FORMAT_MONTH = new SimpleDateFormat("dd.MM HH:mm");
    private static final Pattern TOKEN_PATTERN = Pattern.compile("(?:([0-9]+)\\s*y[a-z]*[,\\s]*)?(?:([0-9]+)\\s*mo[a-z]*[,\\s]*)?(?:([0-9]+)\\s*w[a-z]*[,\\s]*)?(?:([0-9]+)\\s*d[a-z]*[,\\s]*)?(?:([0-9]+)\\s*h[a-z]*[,\\s]*)?(?:([0-9]+)\\s*m[a-z]*[,\\s]*)?(?:([0-9]+)\\s*(?:s[a-z]*)?)?", 2);

    public static long currentTimeSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long currentTimeTicks() {
        return System.currentTimeMillis() / 50L;
    }

    public static String getFormattedDate() {
        return TimeUtil.getFormattedDate(System.currentTimeMillis());
    }

    public static String getFormattedDate(long time) {
        return DATE_FORMAT.format(time);
    }

    public static String getFormattedDateShort() {
        return DATE_FORMAT_SHORT.format(System.currentTimeMillis());
    }

    public static String getFormattedDateShort(long time) {
        return DATE_FORMAT_SHORT.format(time);
    }

    public static String getFormattedDateMonth(long time) {
        return DATE_FORMAT_MONTH.format(time);
    }

    public static long toTicks(String humanReadableTime) {
        Valid.checkNotNull(humanReadableTime, "Time is null");
        long seconds = 0L;
        String[] split = humanReadableTime.split(" ");
        if (split.length < 2) {
            throw new IllegalArgumentException("Expected human readable time like '1 second', got '" + humanReadableTime + "' instead");
        }
        for (int i = 1; i < split.length; ++i) {
            String sub = split[i].toLowerCase();
            int multiplier = 0;
            long unit = 0L;
            boolean isTicks = false;
            try {
                multiplier = Integer.parseInt(split[i - 1]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (sub.startsWith("tick")) {
                isTicks = true;
            } else if (sub.startsWith("second")) {
                unit = 1L;
            } else if (sub.startsWith("minute")) {
                unit = 60L;
            } else if (sub.startsWith("hour")) {
                unit = 3600L;
            } else if (sub.startsWith("day")) {
                unit = 86400L;
            } else if (sub.startsWith("week")) {
                unit = 604800L;
            } else if (sub.startsWith("month")) {
                unit = 2629743L;
            } else if (sub.startsWith("year")) {
                unit = 31556926L;
            } else if (sub.startsWith("potato")) {
                unit = 1337L;
            } else {
                throw new IllegalArgumentException("Must define date type! Example: '1 second' (Got '" + sub + "')");
            }
            seconds += (long)multiplier * (isTicks ? 1L : unit * 20L);
        }
        return seconds;
    }

    public static String formatTimeGeneric(long seconds) {
        long second = seconds % 60L;
        long minute = seconds / 60L;
        String hourMsg = "";
        if (minute >= 60L) {
            long hour = seconds / 60L / 60L;
            minute %= 60L;
            hourMsg = hour + (hour == 1L ? " hour" : " hours") + " ";
        }
        return hourMsg + (minute != 0L ? Long.valueOf(minute) : "") + (minute > 0L ? (minute == 1L ? " minute" : " minutes") + " " : "") + Long.parseLong(String.valueOf(second)) + (Long.parseLong(String.valueOf(second)) == 1L ? " second" : " seconds");
    }

    public static String formatTimeDays(long seconds) {
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        return days + " days " + hours % 24L + " hours " + minutes % 60L + " minutes " + seconds % 60L + " seconds";
    }

    public static String formatTimeShort(long seconds) {
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        return (days > 0L ? days + "d " : "") + (hours > 0L ? (hours %= 24L) + "h " : "") + (minutes > 0L ? (minutes %= 60L) + "m " : "") + (seconds %= 60L) + "s";
    }

    public static String formatTimeColon(long seconds) {
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        return (days > 0L ? (days < 10L ? "0" : "") + days + ":" : "") + (hours > 0L ? ((hours %= 24L) < 10L ? "0" : "") + hours + ":" : "") + (minutes > 0L ? ((minutes %= 60L) < 10L ? "0" : "") + minutes + ":" : "00") + ((seconds %= 60L) < 10L ? "0" : "") + seconds;
    }

    public static long parseToken(String text) {
        Matcher matcher = TOKEN_PATTERN.matcher(text);
        long years = 0L;
        long months = 0L;
        long weeks = 0L;
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        boolean found = false;
        while (matcher.find()) {
            int i;
            if (matcher.group() == null || matcher.group().isEmpty()) continue;
            for (i = 0; i < matcher.groupCount(); ++i) {
                if (matcher.group(i) == null || matcher.group(i).isEmpty()) continue;
                found = true;
                break;
            }
            if (!found) continue;
            for (i = 1; i < 8; ++i) {
                if (matcher.group(i) == null || matcher.group(i).isEmpty()) continue;
                long output = Long.parseLong(matcher.group(i));
                if (i == 1) {
                    TimeUtil.checkLimit("years", output, 10);
                    years = output;
                    continue;
                }
                if (i == 2) {
                    TimeUtil.checkLimit("months", output, 1200);
                    months = output;
                    continue;
                }
                if (i == 3) {
                    TimeUtil.checkLimit("weeks", output, 400);
                    weeks = output;
                    continue;
                }
                if (i == 4) {
                    TimeUtil.checkLimit("days", output, 3100);
                    days = output;
                    continue;
                }
                if (i == 5) {
                    TimeUtil.checkLimit("hours", output, 2400);
                    hours = output;
                    continue;
                }
                if (i == 6) {
                    TimeUtil.checkLimit("minutes", output, 6000);
                    minutes = output;
                    continue;
                }
                if (i != 7) continue;
                TimeUtil.checkLimit("seconds", output, 6000);
                seconds = output;
            }
        }
        if (!found) {
            throw new NumberFormatException("Date not found from: " + text);
        }
        return (seconds + minutes * 60L + hours * 3600L + days * 86400L + weeks * 7L * 86400L + months * 30L * 86400L + years * 365L * 86400L) * 1000L;
    }

    private static void checkLimit(String type, long value, int maxLimit) {
        if (value > (long)maxLimit) {
            throw new IllegalArgumentException("Value type " + type + " is out of bounds! Max limit: " + maxLimit + ", given: " + value);
        }
    }

    public static String toSQLTimestamp() {
        return TimeUtil.toSQLTimestamp(System.currentTimeMillis());
    }

    public static String toSQLTimestamp(long timestamp) {
        Date date = new Date(timestamp);
        return new Timestamp(date.getTime()).toString();
    }

    public static long fromSQLTimestamp(String timestamp) {
        return Timestamp.valueOf(timestamp).getTime();
    }

    private TimeUtil() {
    }
}

