/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import sk.adonikeoffice.epicchat.lib.SerializeUtil;

public final class TabUtil {
    @SafeVarargs
    public static <T> List<String> complete(String partialName, T ... elements) {
        ArrayList<String> clone = new ArrayList<String>();
        if (elements != null) {
            for (T element : elements) {
                if (element == null) continue;
                if (element instanceof Iterable) {
                    for (Object iterable : (Iterable)element) {
                        clone.add(iterable instanceof Enum ? iterable.toString().toLowerCase() : SerializeUtil.serialize(SerializeUtil.Mode.YAML, iterable).toString());
                    }
                    continue;
                }
                if (element instanceof Enum[]) {
                    for (Enum iterable : (Enum[])((Enum[])element)[0].getClass().getEnumConstants()) {
                        clone.add(iterable.toString().toLowerCase());
                    }
                    continue;
                }
                boolean lowercase = element instanceof Enum;
                String parsed = SerializeUtil.serialize(SerializeUtil.Mode.YAML, element).toString();
                if ("".equals(parsed)) continue;
                clone.add(lowercase ? parsed.toLowerCase() : parsed);
            }
        }
        return TabUtil.complete(partialName, clone);
    }

    public static List<String> complete(String partialName, Iterable<String> all) {
        ArrayList<String> tab = new ArrayList<String>();
        for (String s : all) {
            tab.add(s);
        }
        partialName = partialName.toLowerCase();
        Iterator iterator = tab.iterator();
        while (iterator.hasNext()) {
            String val = (String)iterator.next();
            if (val.toLowerCase().startsWith(partialName)) continue;
            iterator.remove();
        }
        Collections.sort(tab);
        return tab;
    }

    private TabUtil() {
    }
}

