/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib;

import java.awt.Color;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import lombok.NonNull;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import sk.adonikeoffice.epicchat.lib.ChatUtil;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.ItemUtil;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.collection.StrictCollection;
import sk.adonikeoffice.epicchat.lib.collection.StrictMap;
import sk.adonikeoffice.epicchat.lib.collection.StrictSet;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.exception.InvalidWorldException;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONArray;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONObject;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONParseException;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONParser;
import sk.adonikeoffice.epicchat.lib.jsonsimple.Jsonable;
import sk.adonikeoffice.epicchat.lib.menu.model.ItemCreator;
import sk.adonikeoffice.epicchat.lib.model.BoxedMessage;
import sk.adonikeoffice.epicchat.lib.model.ConfigSerializable;
import sk.adonikeoffice.epicchat.lib.model.IsInList;
import sk.adonikeoffice.epicchat.lib.model.RangedSimpleTime;
import sk.adonikeoffice.epicchat.lib.model.RangedValue;
import sk.adonikeoffice.epicchat.lib.model.SimpleSound;
import sk.adonikeoffice.epicchat.lib.model.SimpleTime;
import sk.adonikeoffice.epicchat.lib.remain.CompChatColor;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.remain.JsonItemStack;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.lib.settings.ConfigSection;

public final class SerializeUtil {
    private static Map<Class<Object>, Function<Object, String>> serializers = new HashMap<Class<Object>, Function<Object, String>>();

    public static <T> void addSerializer(Class<T> fromClass, Function<T, String> serializer) {
        serializers.put(fromClass, serializer);
    }

    @Deprecated
    public static Object serialize(Object object) {
        return SerializeUtil.serialize(Mode.YAML, object);
    }

    public static Object serialize(Mode mode, Object object) {
        if (object == null) {
            return null;
        }
        boolean isJson = mode == Mode.JSON;
        if (serializers.containsKey((object = Remain.getRootOfSectionPathData(object)).getClass())) {
            return serializers.get(object.getClass()).apply(object);
        }
        if (object instanceof ConfigSerializable) {
            return SerializeUtil.serialize(mode, ((ConfigSerializable)object).serialize().serialize());
        }
        if (object instanceof StrictCollection) {
            return SerializeUtil.serialize(mode, ((StrictCollection)object).serialize());
        }
        if (object instanceof org.bukkit.ChatColor) {
            return ((org.bukkit.ChatColor)object).name();
        }
        if (object instanceof CompChatColor) {
            return ((CompChatColor)object).toSaveableString();
        }
        if (object instanceof ChatColor) {
            ChatColor color = (ChatColor)object;
            return MinecraftVersion.atLeast(MinecraftVersion.V.v1_16) ? color.toString() : color.name();
        }
        if (object instanceof CompMaterial) {
            return object.toString();
        }
        if (object instanceof Location) {
            return SerializeUtil.serializeLoc((Location)object);
        }
        if (object instanceof BoxedMessage) {
            String message = ((BoxedMessage)object).getMessage();
            return message == null || "".equals(message) || "null".equals(message) ? null : message;
        }
        if (object instanceof UUID) {
            return object.toString();
        }
        if (object instanceof Enum) {
            return object.toString();
        }
        if (object instanceof CommandSender) {
            return ((CommandSender)object).getName();
        }
        if (object instanceof World) {
            return ((World)object).getName();
        }
        if (object instanceof Entity) {
            return Remain.getName((Entity)object);
        }
        if (object instanceof PotionEffectType) {
            return ((PotionEffectType)object).getName();
        }
        if (object instanceof PotionEffect) {
            return SerializeUtil.serializePotionEffect((PotionEffect)object);
        }
        if (object instanceof ItemCreator) {
            return SerializeUtil.serialize(mode, ((ItemCreator)object).make());
        }
        if (object instanceof SimpleTime) {
            return ((SimpleTime)object).getRaw();
        }
        if (object instanceof SimpleSound) {
            return ((SimpleSound)object).toString();
        }
        if (object instanceof Color) {
            return "#" + ((Color)object).getRGB();
        }
        if (object instanceof RangedValue) {
            return ((RangedValue)object).toLine();
        }
        if (object instanceof RangedSimpleTime) {
            return ((RangedSimpleTime)object).toLine();
        }
        if (object instanceof BaseComponent) {
            return Remain.toJson((BaseComponent)object);
        }
        if (object instanceof BaseComponent[]) {
            return Remain.toJson((BaseComponent[])object);
        }
        if (object instanceof HoverEvent) {
            HoverEvent event = (HoverEvent)object;
            SerializedMap map = SerializedMap.ofArray("Action", event.getAction(), "Value", event.getValue());
            return isJson ? SerializeUtil.serialize(mode, map.asMap()) : map.serialize();
        }
        if (object instanceof ClickEvent) {
            ClickEvent event = (ClickEvent)object;
            SerializedMap map = SerializedMap.ofArray("Action", event.getAction(), "Value", event.getValue());
            return isJson ? SerializeUtil.serialize(mode, map.asMap()) : map.serialize();
        }
        if (object instanceof Path) {
            throw new FoException("Cannot serialize Path " + object + ", did you mean to convert it into a name?");
        }
        if (object instanceof Iterable || object.getClass().isArray() || object instanceof IsInList) {
            if (isJson) {
                JSONArray jsonList = new JSONArray();
                if (object instanceof Iterable || object instanceof IsInList) {
                    for (Object element : object instanceof IsInList ? ((IsInList)object).getList() : (StrictSet)object) {
                        SerializeUtil.addJsonElement(element, jsonList);
                    }
                } else {
                    for (Object element : (Object[])object) {
                        SerializeUtil.addJsonElement(element, jsonList);
                    }
                }
                return jsonList;
            }
            ArrayList<Object> serialized = new ArrayList<Object>();
            if (object instanceof Iterable || object instanceof IsInList) {
                for (Object element : object instanceof IsInList ? ((IsInList)object).getList() : (StrictSet)object) {
                    serialized.add(SerializeUtil.serialize(mode, element));
                }
            } else {
                for (Object element : (Object[])object) {
                    serialized.add(SerializeUtil.serialize(mode, element));
                }
            }
            return serialized;
        }
        if (object instanceof Map || object instanceof StrictMap) {
            Map oldMap;
            Map map = oldMap = object instanceof StrictMap ? ((StrictMap)object).getSource() : (Map)object;
            if (isJson) {
                JSONObject json = new JSONObject();
                for (Map.Entry entry : oldMap.entrySet()) {
                    Object key = SerializeUtil.serialize(mode, entry.getKey());
                    Object value = SerializeUtil.serialize(mode, entry.getValue());
                    if (key != null) {
                        Valid.checkBoolean(key instanceof String || key instanceof Number, "JSON requires Map to be translated into keys that are String or Numbers, found " + key.getClass().getSimpleName() + " key: " + key + " with value '" + value + "'", new Object[0]);
                    }
                    if (value != null) {
                        Valid.checkBoolean(value instanceof String || value instanceof Boolean || value instanceof Character || value instanceof Number || value instanceof List || value instanceof JSONObject || value instanceof JSONArray, "JSON requires Map to be translated into values that are String or List only, found " + value.getClass().getSimpleName() + ": " + value + " for key " + key, new Object[0]);
                    }
                    if (value instanceof List) {
                        JSONArray array = new JSONArray();
                        for (Object listValue : (List)value) {
                            if (listValue == null || listValue instanceof Boolean || listValue instanceof Character || listValue instanceof String || listValue instanceof Number || listValue instanceof JSONArray || listValue instanceof JSONObject) {
                                array.add(listValue);
                                continue;
                            }
                            throw new FoException("JSON requires List to only contain primitive types or strings, found " + listValue.getClass().getSimpleName() + ": " + listValue);
                        }
                        json.put(key == null ? null : key.toString(), array);
                        continue;
                    }
                    json.put(key == null ? null : key.toString(), value == null ? null : value);
                }
                return json;
            }
            LinkedHashMap<Object, Object> newMap = new LinkedHashMap<Object, Object>();
            for (Map.Entry entry : oldMap.entrySet()) {
                newMap.put(SerializeUtil.serialize(mode, entry.getKey()), SerializeUtil.serialize(mode, entry.getValue()));
            }
            return newMap;
        }
        if (object instanceof MemorySection) {
            return SerializeUtil.serialize(mode, Common.getMapFromSection(object));
        }
        if (object instanceof ConfigSection) {
            return SerializeUtil.serialize(mode, ((ConfigSection)object).getValues(true));
        }
        if (object instanceof Pattern) {
            return ((Pattern)object).pattern();
        }
        if (object instanceof Integer || object instanceof Double || object instanceof Float || object instanceof Long || object instanceof Short || object instanceof String || object instanceof Boolean || object instanceof Character) {
            return object;
        }
        if (object instanceof BigDecimal) {
            BigDecimal big = (BigDecimal)object;
            return big.toPlainString();
        }
        if (object instanceof ConfigurationSerializable) {
            if (isJson) {
                if (object instanceof ItemStack) {
                    return JsonItemStack.toJson((ItemStack)object);
                }
                throw new FoException("serializing " + object.getClass().getSimpleName() + " to JSON is not implemented! Please serialize it to string manually first!");
            }
            return object;
        }
        throw new SerializeFailedException("Does not know how to serialize " + object.getClass().getSimpleName() + "! Does it extends ConfigSerializable? Data: " + object);
    }

    private static void addJsonElement(Object element, JSONArray jsonList) {
        if (element == null) {
            return;
        }
        if (element instanceof Jsonable) {
            jsonList.add(element);
        } else {
            element = SerializeUtil.serialize(Mode.JSON, element);
            try {
                jsonList.add(JSONParser.deserialize(element.toString()));
            }
            catch (JSONParseException ex) {
                String message = ex.getMessage();
                if (message.contains("The unexpected character") && (message.contains("was found at position 0") || message.contains("was found at position 1"))) {
                    jsonList.add(element.toString());
                }
                Common.error(ex, "Failed to deserialize JSON collection from string: " + element);
            }
        }
    }

    public static String serializeLoc(Location loc) {
        return loc.getWorld().getName() + " " + loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ() + (loc.getPitch() != 0.0f || loc.getYaw() != 0.0f ? " " + Math.round(loc.getYaw()) + " " + Math.round(loc.getPitch()) : "");
    }

    public static String serializeLocD(Location loc) {
        return loc.getWorld().getName() + " " + loc.getX() + " " + loc.getY() + " " + loc.getZ() + (loc.getPitch() != 0.0f || loc.getYaw() != 0.0f ? " " + loc.getYaw() + " " + loc.getPitch() : "");
    }

    private static String serializePotionEffect(PotionEffect effect) {
        return effect.getType().getName() + " " + effect.getDuration() + " " + effect.getAmplifier();
    }

    @Deprecated
    public static <T> T deserialize(@NonNull Class<T> classOf, @NonNull Object object) {
        if (classOf == null) {
            throw new NullPointerException("classOf is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return SerializeUtil.deserialize(Mode.YAML, classOf, object);
    }

    public static <T> T deserialize(@NonNull Mode mode, @NonNull Class<T> classOf, @NonNull Object object) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        if (classOf == null) {
            throw new NullPointerException("classOf is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return SerializeUtil.deserialize(mode, classOf, object, (Object[])null);
    }

    @Deprecated
    public static <T> T deserialize(@NonNull Class<T> classOf, @NonNull Object object, Object ... parameters) {
        if (classOf == null) {
            throw new NullPointerException("classOf is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return SerializeUtil.deserialize(Mode.YAML, classOf, object, parameters);
    }

    public static <T> T deserialize(@NonNull Mode mode, @NonNull Class<T> classOf, @NonNull Object object, Object ... parameters) {
        boolean isJson;
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        if (classOf == null) {
            throw new NullPointerException("classOf is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        boolean bl = isJson = mode == Mode.JSON;
        if (classOf == String.class) {
            object = object.toString();
        } else if (classOf == Integer.class) {
            object = Integer.parseInt(object.toString());
        } else if (classOf == Long.class) {
            object = Long.decode(object.toString());
        } else if (classOf == Double.class) {
            object = Double.parseDouble(object.toString());
        } else if (classOf == Float.class) {
            object = Float.valueOf(Float.parseFloat(object.toString()));
        } else if (classOf == Boolean.class) {
            object = Boolean.parseBoolean(object.toString());
        } else if (classOf == SerializedMap.class) {
            object = isJson ? SerializedMap.fromJson(object.toString()) : SerializedMap.of(object);
        } else if (classOf == BoxedMessage.class) {
            object = new BoxedMessage(object.toString());
        } else if (classOf == Location.class) {
            object = SerializeUtil.deserializeLocation(object);
        } else if (classOf == PotionEffectType.class) {
            object = PotionEffectType.getByName((String)object.toString());
        } else if (classOf == PotionEffect.class) {
            object = SerializeUtil.deserializePotionEffect(object);
        } else if (classOf == SimpleTime.class) {
            object = SimpleTime.from(object.toString());
        } else if (classOf == CompMaterial.class) {
            object = CompMaterial.fromStringStrict(object.toString());
        } else if (classOf == SimpleSound.class) {
            object = new SimpleSound(object.toString());
        } else if (classOf == RangedValue.class) {
            object = RangedValue.parse(object.toString());
        } else if (classOf == RangedSimpleTime.class) {
            object = RangedSimpleTime.parse(object.toString());
        } else {
            if (classOf == ChatColor.class) {
                throw new FoException("Instead of net.md_5.bungee.api.ChatColor, use our CompChatColor");
            }
            if (classOf == CompChatColor.class) {
                object = CompChatColor.of(object.toString());
            } else if (classOf == ItemStack.class) {
                object = SerializeUtil.deserializeItemStack(mode, object);
            } else if (classOf == UUID.class) {
                object = UUID.fromString(object.toString());
            } else if (classOf == BaseComponent.class) {
                BaseComponent[] deserialized = Remain.toComponent(object.toString());
                Valid.checkBoolean(deserialized.length == 1, "Failed to deserialize into singular BaseComponent: " + object, new Object[0]);
                object = deserialized[0];
            } else if (classOf == BaseComponent[].class) {
                object = Remain.toComponent(object.toString());
            } else if (classOf == HoverEvent.class) {
                SerializedMap serialized = isJson ? SerializedMap.fromJson(object.toString()) : SerializedMap.of(object);
                HoverEvent.Action action = serialized.get("Action", HoverEvent.Action.class);
                BaseComponent[] value = serialized.get("Value", BaseComponent[].class);
                object = new HoverEvent(action, value);
            } else if (classOf == ClickEvent.class) {
                SerializedMap serialized = isJson ? SerializedMap.fromJson(object.toString()) : SerializedMap.of(object);
                ClickEvent.Action action = serialized.get("Action", ClickEvent.Action.class);
                String value = serialized.getString("Value");
                object = new ClickEvent(action, value);
            } else if (Enchantment.class.isAssignableFrom(classOf)) {
                String name = object.toString().toLowerCase();
                Enchantment enchant = Enchantment.getByName((String)name);
                if (enchant == null) {
                    name = name.toUpperCase();
                    enchant = Enchantment.getByName((String)name);
                }
                if (enchant == null) {
                    enchant = Enchantment.getByName((String)(name = EnchantmentWrapper.toBukkit(name)));
                    if (enchant == null) {
                        enchant = Enchantment.getByName((String)name.toLowerCase());
                    }
                    if (enchant == null) {
                        enchant = Enchantment.getByName((String)name.toUpperCase());
                    }
                }
                Valid.checkNotNull(enchant, "Invalid enchantment '" + name + "'! For valid names, see: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/enchantments/Enchantment.html");
                object = enchant;
            } else if (PotionEffectType.class.isAssignableFrom(classOf)) {
                String name = PotionWrapper.getBukkitName(object.toString());
                PotionEffectType potion = PotionEffectType.getByName((String)name);
                Valid.checkNotNull(potion, "Invalid potion '" + name + "'! For valid names, see: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/potion/PotionEffectType.html");
                object = potion;
            } else if (Enum.class.isAssignableFrom(classOf)) {
                if ((object = ReflectionUtil.lookupEnum(classOf, object.toString())) == null) {
                    return null;
                }
            } else if (Color.class.isAssignableFrom(classOf)) {
                object = CompChatColor.of(object.toString()).getColor();
            } else if (!List.class.isAssignableFrom(classOf) || !(object instanceof List)) {
                if (Map.class.isAssignableFrom(classOf)) {
                    if (object instanceof Map) {
                        return (T)object;
                    }
                    if (object instanceof MemorySection) {
                        return (T)Common.getMapFromSection(object);
                    }
                    if (object instanceof ConfigSection) {
                        return (T)((ConfigSection)object).getValues(false);
                    }
                    if (isJson) {
                        return (T)SerializedMap.fromJson(object.toString()).asMap();
                    }
                    throw new SerializeFailedException("Does not know how to turn " + object.getClass().getSimpleName() + " into a Map! (Keep in mind we can only serialize into Map<String, Object> Data: " + object);
                }
                if (ConfigurationSerializable.class.isAssignableFrom(classOf) && object instanceof ConfigurationSerializable) {
                    if (isJson) {
                        throw new FoException("Deserializing JSON into " + classOf + " is not implemented, please do it manually");
                    }
                } else {
                    if (classOf.isArray()) {
                        Object[] array;
                        Class<?> arrayType = classOf.getComponentType();
                        if (object instanceof List) {
                            List rawList = (List)object;
                            array = (Object[])Array.newInstance(classOf.getComponentType(), rawList.size());
                            for (int i = 0; i < rawList.size(); ++i) {
                                Object element = rawList.get(i);
                                array[i] = element == null ? null : SerializeUtil.deserialize(mode, arrayType, element, (Object[])null);
                            }
                        } else {
                            Object[] rawArray = (Object[])object;
                            array = (Object[])Array.newInstance(classOf.getComponentType(), rawArray.length);
                            for (int i = 0; i < array.length; ++i) {
                                array[i] = rawArray[i] == null ? null : SerializeUtil.deserialize(mode, classOf.getComponentType(), rawArray[i], (Object[])null);
                            }
                        }
                        return (T)array;
                    }
                    if (ConfigSerializable.class.isAssignableFrom(classOf)) {
                        if (parameters != null && parameters.length > 0) {
                            ArrayList argumentClasses = new ArrayList();
                            ArrayList<SerializedMap> arguments = new ArrayList<SerializedMap>();
                            argumentClasses.add(SerializedMap.class);
                            for (Object param : parameters) {
                                argumentClasses.add(param.getClass());
                            }
                            arguments.add(isJson ? SerializedMap.fromJson(object.toString()) : SerializedMap.of(object));
                            Collections.addAll(arguments, parameters);
                            Method deserialize = ReflectionUtil.getMethod(classOf, "deserialize", argumentClasses.toArray(new Class[argumentClasses.size()]));
                            Valid.checkNotNull(deserialize, "Expected " + classOf.getSimpleName() + " to have a public static deserialize(SerializedMap, " + Common.join(argumentClasses) + ") method to deserialize: " + object + " when params were given: " + Common.join(parameters));
                            Valid.checkBoolean(argumentClasses.size() == arguments.size(), classOf.getSimpleName() + "#deserialize(SerializedMap, " + argumentClasses.size() + " args) expected, " + arguments.size() + " given to deserialize: " + object, new Object[0]);
                            return ReflectionUtil.invokeStatic(deserialize, arguments.toArray());
                        }
                        Method deserialize = ReflectionUtil.getMethod(classOf, "deserialize", SerializedMap.class);
                        if (deserialize != null) {
                            return ReflectionUtil.invokeStatic(deserialize, isJson ? SerializedMap.fromJson(object.toString()) : SerializedMap.of(object));
                        }
                        throw new SerializeFailedException("Unable to deserialize " + classOf.getSimpleName() + ", please write 'public static deserialize(SerializedMap map) or deserialize(SerializedMap map, X arg1, Y arg2, etc.) method to deserialize: " + object);
                    }
                    if (object instanceof String) {
                        Method method = ReflectionUtil.getMethod(classOf, "getByName", String.class);
                        if (method != null) {
                            return ReflectionUtil.invokeStatic(method, object);
                        }
                    } else if (classOf != Object.class) {
                        throw new SerializeFailedException("Does not know how to turn " + classOf + " into a serialized object from data: " + object);
                    }
                }
            }
        }
        return (T)object;
    }

    public static Location deserializeLocation(Object raw) {
        if (raw == null) {
            return null;
        }
        if (raw instanceof Location) {
            return (Location)raw;
        }
        String[] parts = (raw = raw.toString().replace("\"", "")).toString().contains(", ") ? raw.toString().split(", ") : raw.toString().split(" ");
        Valid.checkBoolean(parts.length == 4 || parts.length == 6, "Expected location (String) but got " + raw.getClass().getSimpleName() + ": " + raw, new Object[0]);
        String world = parts[0];
        World bukkitWorld = Bukkit.getWorld((String)world);
        if (bukkitWorld == null) {
            throw new InvalidWorldException("Location with invalid world '" + world + "': " + raw + " (Doesn't exist)", world);
        }
        int x = Integer.parseInt(parts[1]);
        int y = Integer.parseInt(parts[2]);
        int z = Integer.parseInt(parts[3]);
        float yaw = Float.parseFloat(parts.length == 6 ? parts[4] : "0");
        float pitch = Float.parseFloat(parts.length == 6 ? parts[5] : "0");
        return new Location(bukkitWorld, (double)x, (double)y, (double)z, yaw, pitch);
    }

    public static Location deserializeLocationD(Object raw) {
        if (raw == null) {
            return null;
        }
        if (raw instanceof Location) {
            return (Location)raw;
        }
        String[] parts = (raw = raw.toString().replace("\"", "")).toString().contains(", ") ? raw.toString().split(", ") : raw.toString().split(" ");
        Valid.checkBoolean(parts.length == 4 || parts.length == 6, "Expected location (String) but got " + raw.getClass().getSimpleName() + ": " + raw, new Object[0]);
        String world = parts[0];
        World bukkitWorld = Bukkit.getWorld((String)world);
        if (bukkitWorld == null) {
            throw new InvalidWorldException("Location with invalid world '" + world + "': " + raw + " (Doesn't exist)", world);
        }
        double x = Double.parseDouble(parts[1]);
        double y = Double.parseDouble(parts[2]);
        double z = Double.parseDouble(parts[3]);
        float yaw = Float.parseFloat(parts.length == 6 ? parts[4] : "0");
        float pitch = Float.parseFloat(parts.length == 6 ? parts[5] : "0");
        return new Location(bukkitWorld, x, y, z, yaw, pitch);
    }

    private static PotionEffect deserializePotionEffect(Object raw) {
        if (raw == null) {
            return null;
        }
        if (raw instanceof PotionEffect) {
            return (PotionEffect)raw;
        }
        String[] parts = raw.toString().split(" ");
        Valid.checkBoolean(parts.length == 3, "Expected PotionEffect (String) but got " + raw.getClass().getSimpleName() + ": " + raw, new Object[0]);
        String typeRaw = parts[0];
        PotionEffectType type = PotionEffectType.getByName((String)typeRaw);
        int duration = Integer.parseInt(parts[1]);
        int amplifier = Integer.parseInt(parts[2]);
        return new PotionEffect(type, duration, amplifier);
    }

    private static ItemStack deserializeItemStack(@NonNull Mode mode, @NonNull Object obj) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        try {
            if (obj instanceof ItemStack) {
                return (ItemStack)obj;
            }
            if (mode == Mode.JSON) {
                return JsonItemStack.fromJson(obj.toString());
            }
            SerializedMap map = SerializedMap.of(obj);
            ItemStack item = ItemStack.deserialize(map.asMap());
            SerializedMap meta = map.getMap("meta");
            if (meta != null) {
                try {
                    Class<?> cl = ReflectionUtil.getOBCClass("inventory." + (meta.containsKey("spawnedType") ? "CraftMetaSpawnEgg" : "CraftMetaItem"));
                    Constructor<?> c = cl.getDeclaredConstructor(Map.class);
                    c.setAccessible(true);
                    Object craftMeta = c.newInstance((Map)meta.serialize());
                    if (craftMeta instanceof ItemMeta) {
                        item.setItemMeta((ItemMeta)craftMeta);
                    }
                }
                catch (Throwable t) {
                    List<String> itemFlags;
                    SerializedMap enchants;
                    List<String> lore;
                    String display;
                    ItemMeta itemMeta = item.getItemMeta();
                    String string = display = meta.containsKey("display-name") ? meta.getString("display-name") : null;
                    if (display != null) {
                        itemMeta.setDisplayName(display);
                    }
                    List<String> list = lore = meta.containsKey("lore") ? meta.getStringList("lore") : null;
                    if (lore != null) {
                        itemMeta.setLore(lore);
                    }
                    SerializedMap serializedMap = enchants = meta.containsKey("enchants") ? meta.getMap("enchants") : null;
                    if (enchants != null) {
                        for (Map.Entry<String, Object> entry : enchants.entrySet()) {
                            Enchantment enchantment = Enchantment.getByName((String)entry.getKey());
                            int level = (Integer)entry.getValue();
                            itemMeta.addEnchant(enchantment, level, true);
                        }
                    }
                    List<String> list2 = itemFlags = meta.containsKey("ItemFlags") ? meta.getStringList("ItemFlags") : null;
                    if (itemFlags != null) {
                        for (String flag : itemFlags) {
                            try {
                                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)flag)});
                            }
                            catch (Exception exception) {}
                        }
                    }
                    item.setItemMeta(itemMeta);
                }
            }
            return item;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private SerializeUtil() {
    }

    public static enum Mode {
        JSON,
        YAML;

    }

    public static class SerializeFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SerializeFailedException(String reason) {
            super(reason);
        }
    }

    protected static enum EnchantmentWrapper {
        PROTECTION("PROTECTION_ENVIRONMENTAL"),
        FIRE_PROTECTION("PROTECTION_FIRE"),
        FEATHER_FALLING("PROTECTION_FALL"),
        BLAST_PROTECTION("PROTECTION_EXPLOSIONS"),
        PROJECTILE_PROTECTION("PROTECTION_PROJECTILE"),
        RESPIRATION("OXYGEN"),
        AQUA_AFFINITY("WATER_WORKER"),
        THORN("THORNS"),
        CURSE_OF_VANISHING("VANISHING_CURSE"),
        CURSE_OF_BINDING("BINDING_CURSE"),
        SHARPNESS("DAMAGE_ALL"),
        SMITE("DAMAGE_UNDEAD"),
        BANE_OF_ARTHROPODS("DAMAGE_ARTHROPODS"),
        LOOTING("LOOT_BONUS_MOBS"),
        SWEEPING_EDGE("SWEEPING"),
        EFFICIENCY("DIG_SPEED"),
        UNBREAKING("DURABILITY"),
        FORTUNE("LOOT_BONUS_BLOCKS"),
        POWER("ARROW_DAMAGE"),
        PUNCH("ARROW_KNOCKBACK"),
        FLAME("ARROW_FIRE"),
        INFINITY("ARROW_INFINITE"),
        LUCK_OF_THE_SEA("LUCK");

        private final String bukkitName;

        protected static String toBukkit(String name) {
            name = name.toUpperCase().replace(" ", "_");
            for (EnchantmentWrapper e : EnchantmentWrapper.values()) {
                if (!e.toString().equals(name)) continue;
                return e.bukkitName;
            }
            return name;
        }

        protected static String toMinecraft(String name) {
            name = name.toUpperCase().replace(" ", "_");
            for (EnchantmentWrapper e : EnchantmentWrapper.values()) {
                if (!name.equals(e.bukkitName)) continue;
                return ItemUtil.bountifyCapitalized(e);
            }
            return ChatUtil.capitalizeFully(name);
        }

        public String getBukkitName() {
            return this.bukkitName != null ? this.bukkitName : this.name();
        }

        private EnchantmentWrapper(String bukkitName) {
            this.bukkitName = bukkitName;
        }
    }

    protected static enum PotionWrapper {
        SLOW("SLOW", "Slowness"),
        STRENGTH("INCREASE_DAMAGE"),
        JUMP_BOOST("JUMP"),
        INSTANT_HEAL("INSTANT_HEALTH"),
        REGEN("REGENERATION");

        private final String bukkitName;
        private final String minecraftName;

        private PotionWrapper(String bukkitName) {
            this(bukkitName, null);
        }

        protected static String getLocalizedName(String name) {
            String localizedName = name;
            for (PotionWrapper e : PotionWrapper.values()) {
                if (!name.toUpperCase().replace(" ", "_").equals(e.bukkitName)) continue;
                localizedName = e.getMinecraftName();
                break;
            }
            return ChatUtil.capitalizeFully(localizedName.replace("_", " "));
        }

        protected static String getBukkitName(String name) {
            name = name.toUpperCase().replace(" ", "_");
            for (PotionWrapper wrapper : PotionWrapper.values()) {
                if (!wrapper.toString().equalsIgnoreCase(name) && (wrapper.minecraftName == null || !wrapper.minecraftName.equalsIgnoreCase(name))) continue;
                return wrapper.bukkitName;
            }
            return name;
        }

        public String getMinecraftName() {
            return Common.getOrDefault(this.minecraftName, this.bukkitName);
        }

        private PotionWrapper(String bukkitName, String minecraftName) {
            this.bukkitName = bukkitName;
            this.minecraftName = minecraftName;
        }
    }
}

