/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public final class ReflectionUtil {
    public static final String NMS = "net.minecraft.server";
    public static final String CRAFTBUKKIT = "org.bukkit.craftbukkit";
    private static final Map<Class<? extends Enum<?>>, Map<String, MinecraftVersion.V>> legacyEnumTypes;
    private static final Map<String, Class<?>> classCache;
    private static final Map<Class<?>, ReflectionData<?>> reflectionDataCache;
    private static final Map<Class<?>, Method[]> methodCache;
    private static final Collection<String> classNameGuard;
    private static final Map<Class<?>, Class<?>> primitiveWrapperMap;
    private static final Map<Class<?>, Class<?>> wrapperPrimitiveMap;

    public static Class<?> getNMSClass(String oldName, String fullName1_17) {
        return MinecraftVersion.atLeast(MinecraftVersion.V.v1_17) ? ReflectionUtil.lookupClass(fullName1_17) : ReflectionUtil.getNMSClass(oldName);
    }

    @Deprecated
    public static Class<?> getNMSClass(String name) {
        String version = MinecraftVersion.getServerVersion();
        if (!version.isEmpty()) {
            version = version + ".";
        }
        return ReflectionUtil.lookupClass("net.minecraft.server." + version + name);
    }

    public static Class<?> getOBCClass(String name) {
        String version = MinecraftVersion.getServerVersion();
        if (!version.isEmpty()) {
            version = version + ".";
        }
        return ReflectionUtil.lookupClass("org.bukkit.craftbukkit." + version + name);
    }

    public static Constructor<?> getConstructorNMS(@NonNull String nmsClassPath, Class<?> ... params) {
        if (nmsClassPath == null) {
            throw new NullPointerException("nmsClassPath is marked non-null but is null");
        }
        return ReflectionUtil.getConstructor(ReflectionUtil.getNMSClass(nmsClassPath), params);
    }

    public static Constructor<?> getConstructor(@NonNull String classPath, Class<?> ... params) {
        if (classPath == null) {
            throw new NullPointerException("classPath is marked non-null but is null");
        }
        Class clazz = ReflectionUtil.lookupClass(classPath);
        return ReflectionUtil.getConstructor(clazz, params);
    }

    public static Constructor<?> getConstructor(@NonNull Class<?> clazz, Class<?> ... params) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        try {
            Constructor<?> constructor;
            if (reflectionDataCache.containsKey(clazz)) {
                return reflectionDataCache.get(clazz).getConstructor(params);
            }
            try {
                constructor = clazz.getConstructor(params);
            }
            catch (NoSuchMethodException err) {
                constructor = clazz.getDeclaredConstructor(params);
            }
            constructor.setAccessible(true);
            return constructor;
        }
        catch (ReflectiveOperationException ex) {
            throw new FoException(ex, "Could not get constructor of " + clazz + " with parameters " + Common.join(params));
        }
    }

    public static <T> T getFieldContent(Object instance, String field) {
        return ReflectionUtil.getFieldContent(instance.getClass(), field, instance);
    }

    public static <T> T getFieldContent(Class<?> clazz, String field, Object instance) {
        String originalClassName = clazz.getSimpleName();
        do {
            for (Field f : clazz.getDeclaredFields()) {
                if (!f.getName().equals(field)) continue;
                return (T)ReflectionUtil.getFieldContent(f, instance);
            }
        } while (!(clazz = clazz.getSuperclass()).isAssignableFrom(Object.class));
        throw new ReflectionException("No such field " + field + " in " + originalClassName + " or its superclasses");
    }

    public static Object getFieldContent(Field field, Object instance) {
        try {
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (ReflectiveOperationException e) {
            throw new ReflectionException("Could not get field " + field.getName() + " in instance " + (instance != null ? instance : field).getClass().getSimpleName());
        }
    }

    public static Field[] getAllFields(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        ArrayList<Field> list = new ArrayList<Field>();
        try {
            do {
                list.addAll(Arrays.asList(clazz.getDeclaredFields()));
            } while (!(clazz = clazz.getSuperclass()).isAssignableFrom(Object.class));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return list.toArray(new Field[0]);
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) {
        try {
            if (reflectionDataCache.containsKey(clazz)) {
                return reflectionDataCache.get(clazz).getDeclaredField(fieldName);
            }
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (ReflectiveOperationException ex) {
            Remain.sneaky(ex);
            return null;
        }
    }

    public static void setDeclaredField(@NonNull Object instance, String fieldName, Object fieldValue) {
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        Field field = ReflectionUtil.getDeclaredField(instance.getClass(), fieldName);
        try {
            field.set(instance, fieldValue);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public static <T> T getStaticFieldContent(@NonNull Class<?> clazz, String field) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return ReflectionUtil.getFieldContent(clazz, field, null);
    }

    public static void setStaticField(@NonNull Class<?> clazz, String fieldName, Object fieldValue) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        try {
            Field field = ReflectionUtil.getDeclaredField(clazz, fieldName);
            field.set(null, fieldValue);
        }
        catch (Throwable t) {
            throw new FoException(t, "Could not set " + fieldName + " in " + clazz + " to " + fieldValue);
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... args) {
        try {
            Method method = clazz.getMethod(methodName, args);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException method) {
            Method[] methods;
            for (Method method2 : methods = methodCache.computeIfAbsent(clazz, k -> clazz.getMethods())) {
                if (!method2.getName().equals(methodName) || !ReflectionUtil.isClassListEqual(args, method2.getParameterTypes())) continue;
                method2.setAccessible(true);
                return method2;
            }
            return null;
        }
    }

    private static boolean isClassListEqual(Class<?>[] first, Class<?>[] second) {
        if (first.length != second.length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            if (first[i] == second[i]) continue;
            return false;
        }
        return true;
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... args) {
        Class<?> originalClass = clazz;
        while (!clazz.equals(Object.class)) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, args);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException ex) {
                clazz = clazz.getSuperclass();
            }
            catch (Throwable t) {
                throw new ReflectionException(t, "Error lookup up method " + methodName + " in class " + originalClass + " and her subclasses");
            }
        }
        throw new ReflectionException("Unable to find method " + methodName + " with params " + Common.join(args) + " in class " + originalClass + " and her subclasses");
    }

    public static <T> T invokeStatic(Class<?> cl, String methodName, Object ... params) {
        return ReflectionUtil.invokeStatic(ReflectionUtil.getMethod(cl, methodName), params);
    }

    public static <T> T invokeStatic(@NonNull Method method, Object ... params) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        try {
            Valid.checkBoolean(Modifier.isStatic(method.getModifiers()), "Method " + method.getName() + " must be static to be invoked through invokeStatic with params: " + Common.join(params), new Object[0]);
            return (T)method.invoke(null, params);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException(ex, "Could not invoke static method " + method + " with params " + Common.join(params, ", ", Common::simplify));
        }
    }

    public static <T> T invoke(String methodName, Object instance, Object ... params) {
        return ReflectionUtil.invoke(ReflectionUtil.getMethod(instance.getClass(), methodName), instance, params);
    }

    public static <T> T invoke(Method method, Object instance, Object ... params) {
        Valid.checkNotNull(method, "Method cannot be null for " + instance);
        try {
            return (T)method.invoke(instance, params);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException(ex, "Could not invoke method " + method + " on instance " + instance + " with params " + Common.join(params, ", "));
        }
    }

    public static <T> T instantiate(String classPath) {
        Class<T> clazz = ReflectionUtil.lookupClass(classPath);
        return ReflectionUtil.instantiate(clazz);
    }

    public static <T> T instantiate(Class<T> clazz) {
        try {
            Constructor<?> constructor = reflectionDataCache.containsKey(clazz) ? reflectionDataCache.get(clazz).getDeclaredConstructor(new Class[0]) : ReflectionUtil.getConstructor(clazz, new Class[0]);
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException(ex, "Could not make instance of: " + clazz);
        }
    }

    public static <T> T instantiateNMS(String nmsPath, Object ... params) {
        return (T)ReflectionUtil.instantiate(ReflectionUtil.getNMSClass(nmsPath), params);
    }

    public static <T> T instantiate(Class<T> clazz, Object ... params) {
        try {
            Constructor<Object> constructor;
            ArrayList classes = new ArrayList();
            for (Object param : params) {
                Valid.checkNotNull(param, "Argument cannot be null when instatiating " + clazz);
                Class<?> paramClass = param.getClass();
                classes.add(paramClass.isPrimitive() ? ReflectionUtil.wrapperToPrimitive(paramClass) : paramClass);
            }
            Class[] paramArr = classes.toArray(new Class[0]);
            if (reflectionDataCache.containsKey(clazz)) {
                constructor = reflectionDataCache.get(clazz).getDeclaredConstructor(paramArr);
            } else {
                classCache.put(clazz.getCanonicalName(), clazz);
                constructor = reflectionDataCache.computeIfAbsent(clazz, ReflectionData::new).getDeclaredConstructor(paramArr);
            }
            constructor.setAccessible(true);
            return (T)constructor.newInstance(params);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException(ex, "Could not make instance of: " + clazz);
        }
    }

    public static <T> T instantiate(Constructor<T> constructor, Object ... params) {
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(params);
        }
        catch (ReflectiveOperationException ex) {
            throw new FoException(ex, "Could not make new instance of " + constructor + " with params: " + Common.join(params));
        }
    }

    public static boolean isClassAvailable(String path) {
        try {
            if (classCache.containsKey(path)) {
                return true;
            }
            Class.forName(path);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static <T> Class<T> lookupClass(String path) {
        if (classCache.containsKey(path)) {
            return classCache.get(path);
        }
        if (classNameGuard.contains(path)) {
            while (classNameGuard.contains(path)) {
            }
            return ReflectionUtil.lookupClass(path);
        }
        try {
            classNameGuard.add(path);
            Class<?> clazz = Class.forName(path);
            classCache.put(path, clazz);
            reflectionDataCache.computeIfAbsent(clazz, ReflectionData::new);
            Class<?> clazz2 = clazz;
            return clazz2;
        }
        catch (ClassNotFoundException ex) {
            throw new ReflectionException("Could not find class: " + path);
        }
        finally {
            classNameGuard.remove(path);
        }
    }

    public static <T extends Enum<T>> T lookupLegacyEnum(Class<T> enumClass, String ... names) {
        for (String name : names) {
            T foundEnum = ReflectionUtil.lookupEnumSilent(enumClass, name);
            if (foundEnum == null) continue;
            return foundEnum;
        }
        return null;
    }

    @Nullable
    public static <E extends Enum<E>> E lookupEnum(Class<E> enumType, String name) {
        return ReflectionUtil.lookupEnum(enumType, name, "The enum '" + enumType.getSimpleName() + "' does not contain '" + name + "' on MC " + MinecraftVersion.getServerVersion() + "! Available values: {available}");
    }

    public static <E extends Enum<E>> E lookupEnum(Class<E> enumType, String name, String errMessage) {
        Valid.checkNotNull(enumType, "Type missing for " + name);
        Valid.checkNotNull(name, "Name missing for " + enumType);
        String rawName = name.toUpperCase().replace(" ", "_");
        if (enumType == ChatColor.class && name.contains("\u00a7")) {
            return (E)ChatColor.getByChar((char)name.charAt(1));
        }
        if (enumType == Biome.class && MinecraftVersion.atLeast(MinecraftVersion.V.v1_13) && rawName.equalsIgnoreCase("ICE_MOUNTAINS")) {
            name = "SNOWY_TAIGA";
        }
        if (enumType == EntityType.class) {
            if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_16) && rawName.equals("PIG_ZOMBIE")) {
                name = "ZOMBIFIED_PIGLIN";
            }
            if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_14) && rawName.equals("TIPPED_ARROW")) {
                name = "ARROW";
            }
            if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_16) && rawName.equals("ZOMBIFIED_PIGLIN")) {
                name = "PIG_ZOMBIE";
            }
            if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_9)) {
                if (rawName.equals("TRIDENT")) {
                    name = "ARROW";
                } else if (rawName.equals("DRAGON_FIREBALL")) {
                    name = "FIREBALL";
                }
            }
            if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_13)) {
                if (rawName.equals("DROWNED")) {
                    name = "ZOMBIE";
                } else if (rawName.equals("ZOMBIE_VILLAGER")) {
                    name = "ZOMBIE";
                }
            }
        }
        if (enumType == EntityDamageEvent.DamageCause.class) {
            if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_13) && rawName.equals("DRYOUT")) {
                name = "CUSTOM";
            }
            if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_11)) {
                if (rawName.equals("ENTITY_SWEEP_ATTACK")) {
                    name = "ENTITY_ATTACK";
                } else if (rawName.equals("CRAMMING")) {
                    name = "CUSTOM";
                }
            }
            if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_9)) {
                if (rawName.equals("FLY_INTO_WALL")) {
                    name = "SUFFOCATION";
                } else if (rawName.equals("HOT_FLOOR")) {
                    name = "LAVA";
                }
            }
            if (rawName.equals("DRAGON_BREATH")) {
                try {
                    EntityDamageEvent.DamageCause.valueOf((String)"DRAGON_BREATH");
                }
                catch (Throwable t) {
                    name = "ENTITY_ATTACK";
                }
            }
        }
        String oldName = name;
        E result = ReflectionUtil.lookupEnumSilent(enumType, name);
        if (result == null) {
            name = name.toUpperCase();
            result = ReflectionUtil.lookupEnumSilent(enumType, name);
        }
        if (result == null) {
            name = name.replace(" ", "_");
            result = ReflectionUtil.lookupEnumSilent(enumType, name);
        }
        if (result == null) {
            result = ReflectionUtil.lookupEnumSilent(enumType, name.replace("_", ""));
        }
        if (result == null) {
            MinecraftVersion.V since;
            Map<String, MinecraftVersion.V> legacyMap = legacyEnumTypes.get(enumType);
            if (legacyMap != null && (since = legacyMap.get(rawName)) != null && MinecraftVersion.olderThan(since)) {
                return null;
            }
            throw new MissingEnumException(oldName, errMessage.replace("{available}", Common.join((Enum[])enumType.getEnumConstants(), ", ")));
        }
        return result;
    }

    public static <E extends Enum<E>> E lookupEnumSilent(Class<E> enumType, String name) {
        try {
            CompMaterial material;
            if ((enumType == CompMaterial.class || enumType == Material.class) && (material = CompMaterial.fromString(name)) != null) {
                return (E)((Object)(enumType == CompMaterial.class ? material : material.getMaterial()));
            }
            boolean hasKey = false;
            Method method = null;
            try {
                method = enumType.getDeclaredMethod("fromKey", String.class);
                if (Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers())) {
                    hasKey = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (method == null && !enumType.getName().contains("org.bukkit")) {
                try {
                    method = enumType.getDeclaredMethod("fromName", String.class);
                    if (Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers())) {
                        hasKey = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (hasKey) {
                return (E)((Enum)method.invoke(null, name));
            }
            return Enum.valueOf(enumType, name);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        catch (ReflectiveOperationException ex) {
            return null;
        }
    }

    public static String getCallerMethods(int skipMethods, int count) {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        StringBuilder methods = new StringBuilder();
        int counted = 0;
        for (int i = 2 + skipMethods; i < elements.length && counted < count; ++i) {
            String[] clazz;
            StackTraceElement el = elements[i];
            if (el.getMethodName().equals("getCallerMethods") || el.getClassName().indexOf("java.lang.Thread") == 0) continue;
            methods.append(clazz[(clazz = el.getClassName().split("\\.")).length == 0 ? 0 : clazz.length - 1]).append("#").append(el.getLineNumber()).append("-").append(el.getMethodName()).append("()").append(i + 1 == elements.length ? "" : ".");
            ++counted;
        }
        return methods.toString();
    }

    public static List<Class<?>> getClasses(Plugin plugin) {
        ArrayList found = new ArrayList();
        found.addAll(ReflectionUtil.getClasses(plugin, null));
        return found;
    }

    public static <T> TreeSet<Class<T>> getClasses(@NonNull Plugin plugin, Class<T> extendingClass) {
        Valid.checkNotNull(plugin, "Plugin is null!");
        Valid.checkBoolean(JavaPlugin.class.isAssignableFrom(plugin.getClass()), "Plugin must be a JavaPlugin", new Object[0]);
        Method getFileMethod = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
        getFileMethod.setAccessible(true);
        File pluginFile = (File)getFileMethod.invoke((Object)plugin, new Object[0]);
        TreeSet<Class<T>> classes = new TreeSet<Class<T>>(Comparator.comparing(Class::toString));
        try (JarFile jarFile = new JarFile(pluginFile);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.endsWith(".class")) continue;
                name = name.replaceFirst("\\.class", "").replace("/", ".");
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(name, false, SimplePlugin.class.getClassLoader());
                    if (extendingClass != null && (!extendingClass.isAssignableFrom(clazz) || clazz == extendingClass)) continue;
                    classes.add(clazz);
                }
                catch (Throwable throwable) {
                    if (extendingClass == null || clazz == null || !extendingClass.isAssignableFrom(clazz) || clazz == extendingClass) continue;
                    Common.log("Unable to load class '" + name + "' due to error: " + throwable);
                }
            }
        }
        return classes;
    }

    public static Class<?> wrapperToPrimitive(Class<?> cls) {
        return wrapperPrimitiveMap.get(cls);
    }

    private ReflectionUtil() {
    }

    static {
        classCache = new ConcurrentHashMap();
        reflectionDataCache = new ConcurrentHashMap();
        methodCache = new ConcurrentHashMap();
        classNameGuard = ConcurrentHashMap.newKeySet();
        primitiveWrapperMap = new HashMap();
        wrapperPrimitiveMap = new HashMap();
        HashMap legacyEnums = new HashMap();
        HashMap<String, MinecraftVersion.V> entities = new HashMap<String, MinecraftVersion.V>();
        entities.put("TIPPED_ARROW", MinecraftVersion.V.v1_9);
        entities.put("SPECTRAL_ARROW", MinecraftVersion.V.v1_9);
        entities.put("SHULKER_BULLET", MinecraftVersion.V.v1_9);
        entities.put("DRAGON_FIREBALL", MinecraftVersion.V.v1_9);
        entities.put("SHULKER", MinecraftVersion.V.v1_9);
        entities.put("AREA_EFFECT_CLOUD", MinecraftVersion.V.v1_9);
        entities.put("LINGERING_POTION", MinecraftVersion.V.v1_9);
        entities.put("POLAR_BEAR", MinecraftVersion.V.v1_10);
        entities.put("HUSK", MinecraftVersion.V.v1_10);
        entities.put("ELDER_GUARDIAN", MinecraftVersion.V.v1_11);
        entities.put("WITHER_SKELETON", MinecraftVersion.V.v1_11);
        entities.put("STRAY", MinecraftVersion.V.v1_11);
        entities.put("DONKEY", MinecraftVersion.V.v1_11);
        entities.put("MULE", MinecraftVersion.V.v1_11);
        entities.put("EVOKER_FANGS", MinecraftVersion.V.v1_11);
        entities.put("EVOKER", MinecraftVersion.V.v1_11);
        entities.put("VEX", MinecraftVersion.V.v1_11);
        entities.put("VINDICATOR", MinecraftVersion.V.v1_11);
        entities.put("ILLUSIONER", MinecraftVersion.V.v1_12);
        entities.put("PARROT", MinecraftVersion.V.v1_12);
        entities.put("TURTLE", MinecraftVersion.V.v1_13);
        entities.put("PHANTOM", MinecraftVersion.V.v1_13);
        entities.put("TRIDENT", MinecraftVersion.V.v1_13);
        entities.put("COD", MinecraftVersion.V.v1_13);
        entities.put("SALMON", MinecraftVersion.V.v1_13);
        entities.put("PUFFERFISH", MinecraftVersion.V.v1_13);
        entities.put("TROPICAL_FISH", MinecraftVersion.V.v1_13);
        entities.put("DROWNED", MinecraftVersion.V.v1_13);
        entities.put("DOLPHIN", MinecraftVersion.V.v1_13);
        entities.put("CAT", MinecraftVersion.V.v1_14);
        entities.put("PANDA", MinecraftVersion.V.v1_14);
        entities.put("PILLAGER", MinecraftVersion.V.v1_14);
        entities.put("RAVAGER", MinecraftVersion.V.v1_14);
        entities.put("TRADER_LLAMA", MinecraftVersion.V.v1_14);
        entities.put("WANDERING_TRADER", MinecraftVersion.V.v1_14);
        entities.put("FOX", MinecraftVersion.V.v1_14);
        entities.put("BEE", MinecraftVersion.V.v1_15);
        entities.put("HOGLIN", MinecraftVersion.V.v1_16);
        entities.put("PIGLIN", MinecraftVersion.V.v1_16);
        entities.put("STRIDER", MinecraftVersion.V.v1_16);
        entities.put("ZOGLIN", MinecraftVersion.V.v1_16);
        entities.put("PIGLIN_BRUTE", MinecraftVersion.V.v1_16);
        entities.put("AXOLOTL", MinecraftVersion.V.v1_17);
        entities.put("GLOW_ITEM_FRAME", MinecraftVersion.V.v1_17);
        entities.put("GLOW_SQUID", MinecraftVersion.V.v1_17);
        entities.put("GOAT", MinecraftVersion.V.v1_17);
        entities.put("MARKER", MinecraftVersion.V.v1_17);
        legacyEnums.put(EntityType.class, entities);
        HashMap<String, MinecraftVersion.V> spawnReasons = new HashMap<String, MinecraftVersion.V>();
        spawnReasons.put("DROWNED", MinecraftVersion.V.v1_13);
        legacyEnums.put(CreatureSpawnEvent.SpawnReason.class, spawnReasons);
        legacyEnumTypes = legacyEnums;
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
        primitiveWrapperMap.put(Void.TYPE, Void.TYPE);
        for (Class<?> primitiveClass : primitiveWrapperMap.keySet()) {
            Class<?> wrapperClass;
            if (primitiveClass.equals(wrapperClass = primitiveWrapperMap.get(primitiveClass))) continue;
            wrapperPrimitiveMap.put(wrapperClass, primitiveClass);
        }
    }

    private static final class ReflectionData<T> {
        private final Class<T> clazz;
        private final Map<Integer, Constructor<?>> constructorCache = new ConcurrentHashMap();
        private final Map<String, Field> fieldCache = new ConcurrentHashMap<String, Field>();
        private final Collection<String> fieldGuard = ConcurrentHashMap.newKeySet();
        private final Collection<Integer> constructorGuard = ConcurrentHashMap.newKeySet();

        ReflectionData(Class<T> clazz) {
            this.clazz = clazz;
        }

        public void cacheConstructor(Constructor<T> constructor) {
            ArrayList classes = new ArrayList();
            for (Class<?> param : constructor.getParameterTypes()) {
                Valid.checkNotNull(param, "Argument cannot be null when instatiating " + this.clazz);
                classes.add(param);
            }
            this.constructorCache.put(Arrays.hashCode(classes.toArray(new Class[0])), constructor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Constructor<T> getDeclaredConstructor(Class<?> ... paramTypes) throws NoSuchMethodException {
            Integer hashCode = Arrays.hashCode(paramTypes);
            if (this.constructorCache.containsKey(hashCode)) {
                return this.constructorCache.get(hashCode);
            }
            if (this.constructorGuard.contains(hashCode)) {
                while (this.constructorGuard.contains(hashCode)) {
                }
                return this.getDeclaredConstructor(paramTypes);
            }
            this.constructorGuard.add(hashCode);
            try {
                Constructor<T> constructor = this.clazz.getDeclaredConstructor(paramTypes);
                this.cacheConstructor(constructor);
                Constructor<T> constructor2 = constructor;
                return constructor2;
            }
            finally {
                this.constructorGuard.remove(hashCode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Constructor<T> getConstructor(Class<?> ... paramTypes) throws NoSuchMethodException {
            Integer hashCode = Arrays.hashCode(paramTypes);
            if (this.constructorCache.containsKey(hashCode)) {
                return this.constructorCache.get(hashCode);
            }
            if (this.constructorGuard.contains(hashCode)) {
                while (this.constructorGuard.contains(hashCode)) {
                }
                return this.getConstructor(paramTypes);
            }
            this.constructorGuard.add(hashCode);
            try {
                Constructor<T> constructor = this.clazz.getConstructor(paramTypes);
                this.cacheConstructor(constructor);
                Constructor<T> constructor2 = constructor;
                return constructor2;
            }
            finally {
                this.constructorGuard.remove(hashCode);
            }
        }

        public void cacheField(Field field) {
            this.fieldCache.put(field.getName(), field);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Field getDeclaredField(String name) throws NoSuchFieldException {
            if (this.fieldCache.containsKey(name)) {
                return this.fieldCache.get(name);
            }
            if (this.fieldGuard.contains(name)) {
                while (this.fieldGuard.contains(name)) {
                }
                return this.getDeclaredField(name);
            }
            this.fieldGuard.add(name);
            try {
                Field field = this.clazz.getDeclaredField(name);
                this.cacheField(field);
                Field field2 = field;
                return field2;
            }
            finally {
                this.fieldGuard.remove(name);
            }
        }
    }

    public static final class ReflectionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ReflectionException(String message) {
            super(message);
        }

        public ReflectionException(Throwable ex, String message) {
            super(message, ex);
        }
    }

    public static final class MissingEnumException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final String enumName;

        public MissingEnumException(String enumName, String msg) {
            super(msg);
            this.enumName = enumName;
        }

        public MissingEnumException(String enumName, String msg, Exception ex) {
            super(msg, ex);
            this.enumName = enumName;
        }

        public String getEnumName() {
            return this.enumName;
        }
    }
}

