/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Valid;

public final class RandomUtil {
    private static final Random random = new Random();
    private static final char[] COLORS_AND_DECORATION = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'k', 'l', 'n', 'o'};
    private static final char[] CHAT_COLORS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] LETTERS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'y', 'z', '\u00f3'};

    public static Random getRandom() {
        return random;
    }

    public static boolean chance(long percent) {
        return RandomUtil.chance((int)percent);
    }

    public static boolean chance(int percent) {
        return random.nextDouble() * 100.0 < (double)percent;
    }

    public static boolean chanceD(double percent) {
        return random.nextDouble() < percent;
    }

    public static DyeColor nextDyeColor() {
        return DyeColor.values()[random.nextInt(DyeColor.values().length)];
    }

    public static String nextColorOrDecoration() {
        return "&" + COLORS_AND_DECORATION[RandomUtil.nextInt(COLORS_AND_DECORATION.length)];
    }

    public static String nextString(int length) {
        String text = "";
        for (int i = 0; i < length; ++i) {
            text = text + LETTERS[RandomUtil.nextInt(LETTERS.length)];
        }
        return text;
    }

    public static ChatColor nextChatColor() {
        char letter = CHAT_COLORS[RandomUtil.nextInt(CHAT_COLORS.length)];
        return ChatColor.getByChar((char)letter);
    }

    public static Color nextColor() {
        return RandomUtil.nextItem(Color.AQUA, Color.ORANGE, Color.WHITE, Color.YELLOW, Color.RED, Color.GREEN, Color.BLUE);
    }

    public static int nextBetween(int min, int max) {
        Valid.checkBoolean(min <= max, "Min !< max", new Object[0]);
        return min + RandomUtil.nextInt(max - min + 1);
    }

    public static int nextInt(int boundExclusive) {
        Valid.checkBoolean(boundExclusive > 0, "Getting a random number must have the bound above 0, got: " + boundExclusive, new Object[0]);
        return random.nextInt(boundExclusive);
    }

    public static boolean nextBoolean() {
        return random.nextBoolean();
    }

    public static <T> T nextItem(T ... items) {
        return items[RandomUtil.nextInt(items.length)];
    }

    public static <T> T nextItem(Iterable<T> items) {
        return RandomUtil.nextItem(items, null);
    }

    public static <T> T nextItem(Iterable<T> items, Predicate<T> condition) {
        List<Object> list;
        List<Object> list2 = list = items instanceof List ? new ArrayList((List)items) : Common.toList(items);
        if (condition != null) {
            Iterator<Object> it = list.iterator();
            while (it.hasNext()) {
                Object item = it.next();
                if (condition.test(item)) continue;
                it.remove();
            }
        }
        return (T)list.get(RandomUtil.nextInt(list.size()));
    }

    public static Location nextLocation(Location origin, double radius, boolean is3D) {
        double randomRadius = random.nextDouble() * radius;
        double theta = Math.toRadians(random.nextDouble() * 360.0);
        double phi = Math.toRadians(random.nextDouble() * 180.0 - 90.0);
        double x = randomRadius * Math.cos(theta) * Math.sin(phi);
        double z = randomRadius * Math.cos(phi);
        return origin.clone().add(x, is3D ? randomRadius * Math.sin(theta) * Math.cos(phi) : 0.0, z);
    }

    public static Location nextLocation(Location origin, double minRadius, double maxRadius, boolean is3D) {
        Valid.checkBoolean(maxRadius > 0.0 && minRadius > 0.0, "Max and min radius must be over 0", new Object[0]);
        Valid.checkBoolean(maxRadius > minRadius, "Max radius must be greater than min radius", new Object[0]);
        double randomRadius = minRadius + random.nextDouble() * (maxRadius - minRadius);
        double theta = Math.toRadians(random.nextDouble() * 360.0);
        double phi = Math.toRadians(random.nextDouble() * 180.0 - 90.0);
        double x = randomRadius * Math.cos(theta) * Math.sin(phi);
        double z = randomRadius * Math.cos(phi);
        return origin.clone().add(x, is3D ? randomRadius * Math.sin(theta) * Math.cos(phi) : 0.0, z);
    }

    public static int nextChunkX(Chunk chunk) {
        return RandomUtil.nextInt(16) + (chunk.getX() << 4) - 16;
    }

    public static int nextChunkZ(Chunk chunk) {
        return RandomUtil.nextInt(16) + (chunk.getZ() << 4) - 16;
    }

    private RandomUtil() {
    }
}

