/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib;

import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.EntityUtil;
import sk.adonikeoffice.epicchat.lib.ItemUtil;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONObject;
import sk.adonikeoffice.epicchat.lib.jsonsimple.JSONParser;
import sk.adonikeoffice.epicchat.lib.menu.Menu;
import sk.adonikeoffice.epicchat.lib.model.HookManager;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.CompAttribute;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.remain.CompProperty;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public final class PlayerUtil {
    public static final int USABLE_PLAYER_INV_SIZE = 36;
    private static final BlockFace[] FACE_AXIS = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    private static final BlockFace[] FACE_RADIAL = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    private static final Map<UUID, BukkitTask> titleRestoreTasks = new ConcurrentHashMap<UUID, BukkitTask>();
    private static final Map<UUID, SerializedMap> storedPlayerStates = new HashMap<UUID, SerializedMap>();

    public static void kick(Player player, String ... message) {
        Common.runLater(() -> player.kickPlayer(Common.colorize(message)));
    }

    public static int getPing(Player player) {
        return Remain.getPing(player);
    }

    public static BlockFace getFacing(Player player) {
        return PlayerUtil.getFacing(player.getLocation().getYaw(), false);
    }

    public static BlockFace getFacing(Player player, boolean useSubDirections) {
        return PlayerUtil.getFacing(player.getLocation().getYaw(), useSubDirections);
    }

    public static BlockFace getFacing(float yaw, boolean useSubDirections) {
        if (useSubDirections) {
            return FACE_RADIAL[Math.round(yaw / 45.0f) & 7].getOppositeFace();
        }
        return FACE_AXIS[Math.round(yaw / 90.0f) & 3].getOppositeFace();
    }

    public static int getFacing(BlockFace face, boolean useSubDirections) {
        return (useSubDirections ? face.ordinal() * 45 : face.ordinal() * 90) - 180;
    }

    public static float alignYaw(float yaw, boolean useSubDirections) {
        BlockFace face = PlayerUtil.getFacing(yaw, useSubDirections);
        return PlayerUtil.getFacing(face, useSubDirections);
    }

    public static long getPlayTimeTicksOrSeconds(OfflinePlayer player) {
        Statistic playTime = Remain.getPlayTimeStatisticName();
        return PlayerUtil.getStatistic(player, playTime);
    }

    public static TreeMap<Long, OfflinePlayer> getStatistics(Statistic statistic) {
        return PlayerUtil.getStatistics(statistic, null, null);
    }

    public static TreeMap<Long, OfflinePlayer> getStatistics(Statistic statistic, Material material) {
        return PlayerUtil.getStatistics(statistic, material, null);
    }

    public static TreeMap<Long, OfflinePlayer> getStatistics(Statistic statistic, EntityType entityType) {
        return PlayerUtil.getStatistics(statistic, null, entityType);
    }

    public static TreeMap<Long, OfflinePlayer> getStatistics(Statistic statistic, Material material, EntityType entityType) {
        TreeMap<Long, OfflinePlayer> statistics = new TreeMap<Long, OfflinePlayer>(Collections.reverseOrder());
        for (OfflinePlayer offline : Bukkit.getOfflinePlayers()) {
            long time = PlayerUtil.getStatistic(offline, statistic, material, entityType);
            statistics.put(time, offline);
        }
        return statistics;
    }

    public static long getStatistic(OfflinePlayer player, Statistic statistic) {
        return PlayerUtil.getStatistic(player, statistic, null, null);
    }

    public static long getStatistic(OfflinePlayer player, Statistic statistic, Material material) {
        return PlayerUtil.getStatistic(player, statistic, material, null);
    }

    public static long getStatistic(OfflinePlayer player, Statistic statistic, EntityType entityType) {
        return PlayerUtil.getStatistic(player, statistic, null, entityType);
    }

    private static long getStatistic(OfflinePlayer player, Statistic statistic, Material material, EntityType entityType) {
        if (player.isOnline()) {
            Player online = player.getPlayer();
            if (statistic.getType() == Statistic.Type.UNTYPED) {
                return online.getStatistic(statistic);
            }
            if (statistic.getType() == Statistic.Type.ENTITY) {
                return online.getStatistic(statistic, entityType);
            }
            return online.getStatistic(statistic, material);
        }
        return PlayerUtil.getStatisticFile(player, statistic, material, entityType);
    }

    private static long getStatisticFile(OfflinePlayer player, Statistic statistic, Material material, EntityType entityType) {
        File worldFolder = new File(((World)Bukkit.getServer().getWorlds().get(0)).getWorldFolder(), "stats");
        File statFile = new File(worldFolder, player.getUniqueId().toString() + ".json");
        if (statFile.exists()) {
            try {
                JSONObject json = (JSONObject)JSONParser.deserialize(new FileReader(statFile));
                String name = Remain.getNMSStatisticName(statistic, material, entityType);
                JSONObject section = json.getObject("stats");
                long result = 0L;
                for (String part : name.split("\\:")) {
                    part = part.replace(".", ":");
                    if (section == null) continue;
                    JSONObject nextSection = section.getObject(part);
                    if (nextSection == null) {
                        result = Long.parseLong(section.containsKey(part) ? section.get(part).toString() : "0");
                        break;
                    }
                    section = nextSection;
                }
                return result;
            }
            catch (Throwable t) {
                throw new FoException(t);
            }
        }
        return 0L;
    }

    public static boolean hasPerm(Permissible sender, String permission) {
        Valid.checkNotNull(sender, "cannot call hasPerm for null sender!");
        if (permission == null) {
            Common.log("THIS IS NOT AN ACTUAL ERROR, YOUR PLUGIN WILL WORK FINE");
            Common.log("Internal check got null permission as input, this is no longer allowed.");
            Common.log("We'll return true to prevent errors. Contact developers of " + SimplePlugin.getNamed());
            Common.log("to get it solved and include the fake error below:");
            new Throwable().printStackTrace();
            return true;
        }
        Valid.checkBoolean(!permission.contains("{plugin_name}") && !permission.contains("{plugin_name_lower}"), "Found {plugin_name} variable calling hasPerm(" + sender + ", " + permission + ").This is now disallowed, contact plugin authors to put " + SimplePlugin.getNamed().toLowerCase() + " in their permission.", new Object[0]);
        return sender.hasPermission(permission);
    }

    public static void normalize(Player player, boolean cleanInventory) {
        PlayerUtil.normalize(player, cleanInventory, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void normalize(Player player, boolean cleanInventory, boolean removeVanish) {
        Map<UUID, BukkitTask> map = titleRestoreTasks;
        synchronized (map) {
            HookManager.setGodMode(player, false);
            player.setGameMode(GameMode.SURVIVAL);
            if (cleanInventory) {
                PlayerUtil.cleanInventoryAndFood(player);
                try {
                    CompAttribute.GENERIC_MAX_HEALTH.set((LivingEntity)player, 20.0);
                }
                catch (Throwable t) {
                    try {
                        player.setMaxHealth(20.0);
                    }
                    catch (Throwable throwable) {
                        try {
                            player.resetMaxHealth();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                }
                try {
                    player.setHealth(20.0);
                }
                catch (Throwable t) {
                    try {
                        double d = CompAttribute.GENERIC_MAX_HEALTH.get((LivingEntity)player);
                        player.setHealth(d);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                player.setHealthScaled(false);
                for (PotionEffect potionEffect : player.getActivePotionEffects()) {
                    player.removePotionEffect(potionEffect.getType());
                }
            }
            player.setTotalExperience(0);
            player.setLevel(0);
            player.setExp(0.0f);
            player.resetPlayerTime();
            player.resetPlayerWeather();
            player.setFallDistance(0.0f);
            CompProperty.INVULNERABLE.apply(player, false);
            CompProperty.GLOWING.apply(player, false);
            CompProperty.SILENT.apply(player, false);
            player.setAllowFlight(false);
            player.setFlying(false);
            player.setFlySpeed(0.2f);
            player.setWalkSpeed(0.2f);
            player.setCanPickupItems(true);
            player.setVelocity(new Vector(0, 0, 0));
            player.eject();
            EntityUtil.removeVehiclesAndPassengers((Entity)player);
            if (removeVanish) {
                try {
                    if (player.hasMetadata("vanished")) {
                        Plugin plugin = ((MetadataValue)player.getMetadata("vanished").get(0)).getOwningPlugin();
                        player.removeMetadata("vanished", plugin);
                    }
                    for (Player player2 : Remain.getOnlinePlayers()) {
                        if (player2.getName().equals(player.getName()) || player2.canSee(player)) continue;
                        player2.showPlayer(player);
                    }
                }
                catch (NoSuchMethodError plugin) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static void cleanInventoryAndFood(Player player) {
        player.getInventory().setArmorContents(null);
        player.getInventory().setContents(new ItemStack[player.getInventory().getContents().length]);
        try {
            player.getInventory().setExtraContents(new ItemStack[player.getInventory().getExtraContents().length]);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        player.setFireTicks(0);
        player.setFoodLevel(20);
        player.setExhaustion(0.0f);
        player.setSaturation(10.0f);
        player.setVelocity(new Vector(0, 0, 0));
    }

    public static boolean hasEmptyInventory(Player player) {
        ItemStack[] everything;
        ItemStack[] inv = player.getInventory().getContents();
        ItemStack[] armor = player.getInventory().getArmorContents();
        for (ItemStack i : everything = (ItemStack[])Common.joinArrays(inv, armor)) {
            if (i == null || i.getType() == Material.AIR) continue;
            return false;
        }
        return true;
    }

    public static void storeState(Player player) {
        Valid.checkBoolean(!PlayerUtil.hasStoredState(player), "Player " + player.getName() + " already has a stored state!", new Object[0]);
        SerializedMap data = SerializedMap.ofArray("gameMode", player.getGameMode(), "content", player.getInventory().getContents(), "armorContent", player.getInventory().getArmorContents(), "maxHealth", Remain.getMaxHealth((LivingEntity)player), "health", Remain.getHealth((LivingEntity)player), "healthScaled", player.isHealthScaled(), "remainingAir", player.getRemainingAir(), "maximumAir", player.getMaximumAir(), "fallDistance", Float.valueOf(player.getFallDistance()), "fireTicks", player.getFireTicks(), "totalExp", player.getTotalExperience(), "level", player.getLevel(), "exp", Float.valueOf(player.getExp()), "foodLevel", player.getFoodLevel(), "exhaustion", Float.valueOf(player.getExhaustion()), "saturation", Float.valueOf(player.getSaturation()), "flySpeed", Float.valueOf(player.getFlySpeed()), "walkSpeed", Float.valueOf(player.getWalkSpeed()), "potionEffects", player.getActivePotionEffects());
        HashMap<CompAttribute, Double> attributes = new HashMap<CompAttribute, Double>();
        for (CompAttribute attribute : CompAttribute.values()) {
            Double value = attribute.get((LivingEntity)player);
            if (value == null) continue;
            attributes.put(attribute, value);
        }
        data.put("attributes", attributes);
        try {
            data.put("extraContent", player.getInventory().getExtraContents());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            data.put("invulnerable", player.isInvulnerable());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            data.put("silent", player.isSilent());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            data.put("glowing", player.isGlowing());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        storedPlayerStates.put(player.getUniqueId(), data);
    }

    public static void restoreState(Player player) {
        SerializedMap data = storedPlayerStates.remove(player.getUniqueId());
        Valid.checkNotNull(data, "Player " + player.getName() + " does not have a stored game state!");
        player.setGameMode(data.get("gameMode", GameMode.class));
        player.getInventory().setContents((ItemStack[])data.getObject("content"));
        player.getInventory().setArmorContents((ItemStack[])data.getObject("armorContent"));
        player.setMaxHealth((double)data.getInteger("maxHealth").intValue());
        player.setHealth((double)data.getInteger("health").intValue());
        player.setHealthScaled(data.getBoolean("healthScaled").booleanValue());
        player.setRemainingAir(data.getInteger("remainingAir").intValue());
        player.setMaximumAir(data.getInteger("maximumAir").intValue());
        player.setFallDistance(data.getFloat("fallDistance").floatValue());
        player.setFireTicks(data.getInteger("fireTicks").intValue());
        player.setTotalExperience(data.getInteger("totalExp").intValue());
        player.setLevel(data.getInteger("level").intValue());
        player.setExp(data.getFloat("exp").floatValue());
        player.setFoodLevel(data.getInteger("foodLevel").intValue());
        player.setExhaustion(data.getFloat("exhaustion").floatValue());
        player.setSaturation(data.getFloat("saturation").floatValue());
        player.setFlySpeed(data.getFloat("flySpeed").floatValue());
        player.setWalkSpeed(data.getFloat("walkSpeed").floatValue());
        for (PotionEffect effect : player.getActivePotionEffects()) {
            player.removePotionEffect(effect.getType());
        }
        for (PotionEffect effect : data.getList("potionEffects", PotionEffect.class)) {
            player.addPotionEffect(effect);
        }
        Map attributes = (Map)data.getObject("attributes");
        for (Map.Entry entry : attributes.entrySet()) {
            ((CompAttribute)((Object)entry.getKey())).set((LivingEntity)player, (Double)entry.getValue());
        }
        try {
            player.getInventory().setExtraContents((ItemStack[])data.getObject("extraContent"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            player.setInvulnerable(data.getBoolean("invulnerable").booleanValue());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            player.setSilent(data.getBoolean("silent").booleanValue());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            player.setGlowing(data.getBoolean("glowing").booleanValue());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean hasStoredState(Player player) {
        return storedPlayerStates.containsKey(player.getUniqueId());
    }

    public static boolean isVanished(Player player, Player otherPlayer) {
        if (otherPlayer != null && !otherPlayer.canSee(player)) {
            return true;
        }
        return PlayerUtil.isVanished(player);
    }

    public static boolean isVanished(Player player) {
        List list = player.getMetadata("vanished");
        for (MetadataValue meta : list) {
            if (!meta.asBoolean()) continue;
            return true;
        }
        return false;
    }

    public static void setVanished(Player player, boolean vanished) {
        HookManager.setVanished(player, vanished);
        for (MetadataValue meta : player.getMetadata("vanished")) {
            if (!meta.asBoolean()) continue;
            meta.invalidate();
        }
        if (vanished) {
            player.setMetadata("vanished", (MetadataValue)new FixedMetadataValue((Plugin)SimplePlugin.getInstance(), (Object)true));
        }
        Remain.setInvisible(player, vanished);
    }

    public static Player getPlayerByNickNoVanish(String name) {
        return PlayerUtil.getPlayerByNick(name, false);
    }

    public static Player getPlayerByNick(String name, boolean ignoreVanished) {
        Player found = PlayerUtil.lookupNickedPlayer0(name);
        if (ignoreVanished && found != null && PlayerUtil.isVanished(found)) {
            return null;
        }
        return found;
    }

    private static Player lookupNickedPlayer0(String name) {
        Player found = null;
        int delta = Integer.MAX_VALUE;
        for (Player player : Remain.getOnlinePlayers()) {
            if (player.getName().equalsIgnoreCase(name)) {
                return player;
            }
            String nick = HookManager.getNickColorless((CommandSender)player);
            if (!nick.toLowerCase().startsWith(name.toLowerCase())) continue;
            int curDelta = Math.abs(nick.length() - name.length());
            if (curDelta < delta) {
                found = player;
                delta = curDelta;
            }
            if (curDelta != 0) continue;
            break;
        }
        return found;
    }

    public static void lookupOfflinePlayerAsync(String name, Consumer<OfflinePlayer> syncCallback) {
        Common.runAsync(() -> {
            String parsedName = HookManager.getNameFromNick(name);
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)parsedName);
            Common.runLater(() -> syncCallback.accept(offlinePlayer));
        });
    }

    public static void updateInventoryTitle(Menu menu, Player player, String temporaryTitle, String oldTitle, int duration) {
        Valid.checkNotNull(menu, "Menu == null");
        Valid.checkNotNull(player, "Player == null");
        Valid.checkNotNull(temporaryTitle, "Title == null");
        Valid.checkNotNull(oldTitle, "Old Title == null");
        PlayerUtil.updateInventoryTitle(player, MinecraftVersion.atLeast(MinecraftVersion.V.v1_13) ? temporaryTitle.replace("%", "%%") : temporaryTitle);
        BukkitTask pending = titleRestoreTasks.get(player.getUniqueId());
        if (pending != null) {
            pending.cancel();
        }
        pending = Common.runLater(duration, () -> {
            Menu futureMenu = Menu.getMenu(player);
            if (futureMenu != null && futureMenu.getClass().getName().equals(menu.getClass().getName())) {
                PlayerUtil.updateInventoryTitle(player, oldTitle);
            }
        });
        UUID uid = player.getUniqueId();
        titleRestoreTasks.put(uid, pending);
        Common.runLater(duration + 1, () -> {
            if (titleRestoreTasks.containsKey(uid)) {
                titleRestoreTasks.remove(uid);
            }
        });
    }

    public static void updateInventoryTitle(Player player, String title) {
        Remain.updateInventoryTitle(player, title);
    }

    public static ItemStack getFirstItem(Player player, ItemStack item) {
        for (ItemStack otherItem : player.getInventory().getContents()) {
            if (otherItem == null || !ItemUtil.isSimilar(otherItem, item)) continue;
            return otherItem;
        }
        return null;
    }

    public static boolean take(Player player, CompMaterial material, int amount) {
        if (!PlayerUtil.containsAtLeast(player, amount, material)) {
            return false;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack[] content = inventory.getContents();
        for (int slot = 0; slot < content.length; ++slot) {
            ItemStack item = content[slot];
            if (item == null || !material.is(item)) continue;
            int itemAmount = item.getAmount();
            int newAmount = itemAmount - amount;
            if (newAmount < 0) {
                amount -= itemAmount;
                content[slot] = null;
                continue;
            }
            item.setAmount(newAmount);
            content[slot] = item;
            break;
        }
        inventory.setContents(content);
        return true;
    }

    public static boolean takeFirstOnePiece(Player player, CompMaterial material) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || !material.is(item)) continue;
            PlayerUtil.takeOnePiece(player, item);
            return true;
        }
        return false;
    }

    public static void takeOnePiece(Player player, ItemStack item) {
        Remain.takeItemOnePiece(player, item);
    }

    public static boolean containsAtLeast(Player player, int atLeastSize, CompMaterial material) {
        int foundSize = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material.getMaterial()) continue;
            foundSize += item.getAmount();
        }
        return foundSize >= atLeastSize;
    }

    public static boolean updateInvSlot(Inventory inv, ItemStack search, ItemStack replaceWith) {
        Valid.checkNotNull(inv, "Inv = null");
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack slot = inv.getItem(i);
            if (slot == null || !ItemUtil.isSimilar(slot, search)) continue;
            inv.setItem(i, replaceWith);
            return true;
        }
        return false;
    }

    public static boolean addItemsOrDrop(Player player, ItemStack ... items) {
        Map<Integer, ItemStack> leftovers = PlayerUtil.addItems((Inventory)player.getInventory(), items);
        World world = player.getWorld();
        Location location = player.getLocation();
        for (ItemStack leftover : leftovers.values()) {
            Item item = world.dropItem(location, leftover);
            item.setPickupDelay(40);
        }
        return leftovers.isEmpty();
    }

    public static Map<Integer, ItemStack> addItems(Inventory inventory, Collection<ItemStack> items) {
        return PlayerUtil.addItems(inventory, items.toArray(new ItemStack[items.size()]));
    }

    public static Map<Integer, ItemStack> addItems(Inventory inventory, ItemStack ... items) {
        return PlayerUtil.addItems(inventory, 0, items);
    }

    private static Map<Integer, ItemStack> addItems(Inventory inventory, int oversizedStacks, ItemStack ... items) {
        if (PlayerUtil.isCombinedInv(inventory)) {
            Inventory fakeInventory = PlayerUtil.makeTruncatedInv((PlayerInventory)inventory);
            Map<Integer, ItemStack> overflow = PlayerUtil.addItems(fakeInventory, oversizedStacks, items);
            for (int i = 0; i < fakeInventory.getContents().length; ++i) {
                inventory.setItem(i, fakeInventory.getContents()[i]);
            }
            return overflow;
        }
        HashMap<Integer, ItemStack> left = new HashMap<Integer, ItemStack>();
        ItemStack[] combined = new ItemStack[items.length];
        block1: for (ItemStack item : items) {
            if (item == null || item.getAmount() < 1) continue;
            for (int j = 0; j < combined.length; ++j) {
                if (combined[j] == null) {
                    combined[j] = item.clone();
                    continue block1;
                }
                if (!combined[j].isSimilar(item)) continue;
                combined[j].setAmount(combined[j].getAmount() + item.getAmount());
                continue block1;
            }
        }
        block3: for (int i = 0; i < combined.length; ++i) {
            ItemStack item = combined[i];
            if (item == null || item.getType() == Material.AIR) continue;
            while (true) {
                int partialAmount;
                int maxAmount;
                int firstPartial;
                if ((firstPartial = PlayerUtil.firstPartial(inventory, item, maxAmount = oversizedStacks > item.getType().getMaxStackSize() ? oversizedStacks : item.getType().getMaxStackSize())) == -1) {
                    int firstFree = inventory.firstEmpty();
                    if (firstFree == -1) {
                        left.put(i, item);
                        continue block3;
                    }
                    if (item.getAmount() > maxAmount) {
                        ItemStack stack = item.clone();
                        stack.setAmount(maxAmount);
                        inventory.setItem(firstFree, stack);
                        item.setAmount(item.getAmount() - maxAmount);
                        continue;
                    }
                    inventory.setItem(firstFree, item);
                    continue block3;
                }
                ItemStack partialItem = inventory.getItem(firstPartial);
                int amount = item.getAmount();
                if (amount + (partialAmount = partialItem.getAmount()) <= maxAmount) {
                    partialItem.setAmount(amount + partialAmount);
                    continue block3;
                }
                partialItem.setAmount(maxAmount);
                item.setAmount(amount + partialAmount - maxAmount);
            }
        }
        return left;
    }

    private static int firstPartial(Inventory inventory, ItemStack item, int maxAmount) {
        if (item == null) {
            return -1;
        }
        ItemStack[] stacks = inventory.getContents();
        for (int i = 0; i < stacks.length; ++i) {
            ItemStack cItem = stacks[i];
            if (cItem == null || cItem.getAmount() >= maxAmount || !cItem.isSimilar(item)) continue;
            return i;
        }
        return -1;
    }

    private static Inventory makeTruncatedInv(PlayerInventory playerInventory) {
        Inventory fake = Bukkit.createInventory(null, (int)36);
        fake.setContents(Arrays.copyOf(playerInventory.getContents(), fake.getSize()));
        return fake;
    }

    private static boolean isCombinedInv(Inventory inventory) {
        return inventory instanceof PlayerInventory && inventory.getContents().length > 36;
    }

    private PlayerUtil() {
    }
}

