/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import sk.adonikeoffice.epicchat.lib.ChatUtil;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.model.Replacer;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.lib.settings.SimpleSettings;

public final class Messenger {
    public static boolean ENABLED = true;
    private static String infoPrefix = "&8&l[&9&li&8&l]&7 ";
    private static String successPrefix = "&8&l[&2&l\u2714&8&l]&7 ";
    private static String warnPrefix = "&8&l[&6&l!&8&l]&6 ";
    private static String errorPrefix = "&8&l[&4&l\u2715&8&l]&c ";
    private static String questionPrefix = "&8&l[&a&l?&l&8]&7 ";
    private static String announcePrefix = "&8&l[&5&l!&l&8]&d ";

    public static void broadcastInfo(String message) {
        for (Player player : Remain.getOnlinePlayers()) {
            Messenger.tell((CommandSender)player, infoPrefix, message);
        }
    }

    public static void broadcastSuccess(String message) {
        for (Player player : Remain.getOnlinePlayers()) {
            Messenger.tell((CommandSender)player, successPrefix, message);
        }
    }

    public static void broadcastWarn(String message) {
        for (Player player : Remain.getOnlinePlayers()) {
            Messenger.tell((CommandSender)player, warnPrefix, message);
        }
    }

    public static void broadcastError(String message) {
        for (Player player : Remain.getOnlinePlayers()) {
            Messenger.tell((CommandSender)player, errorPrefix, message);
        }
    }

    public static void broadcastQuestion(String message) {
        for (Player player : Remain.getOnlinePlayers()) {
            Messenger.tell((CommandSender)player, questionPrefix, message);
        }
    }

    public static void broadcastAnnounce(String message) {
        for (Player player : Remain.getOnlinePlayers()) {
            Messenger.tell((CommandSender)player, announcePrefix, message);
        }
    }

    public static void info(CommandSender player, String message) {
        Messenger.tell(player, infoPrefix, message);
    }

    public static void success(CommandSender player, String message) {
        Messenger.tell(player, successPrefix, message);
    }

    public static void warn(CommandSender player, String message) {
        Messenger.tell(player, warnPrefix, message);
    }

    public static void error(CommandSender player, String ... messages) {
        for (String message : messages) {
            Messenger.error(player, message);
        }
    }

    public static void error(CommandSender player, String message) {
        Messenger.tell(player, errorPrefix, message);
    }

    public static void question(CommandSender player, String message) {
        Messenger.tell(player, questionPrefix, message);
    }

    public static void announce(CommandSender player, String message) {
        Messenger.tell(player, announcePrefix, message);
    }

    private static void tell(CommandSender player, String prefix, String message) {
        if (message.isEmpty() || "none".equals(message)) {
            return;
        }
        String colorless = Common.stripColors(message);
        boolean noPrefix = ChatUtil.isInteractive(colorless);
        if (colorless.startsWith("<actionbar>")) {
            message = message.replace("<actionbar>", "<actionbar>" + prefix);
        }
        if (colorless.startsWith("@noprefix")) {
            message = message.replace("@noprefix", "");
            noPrefix = true;
        }
        Common.tellNoPrefix(player, (noPrefix ? "" : prefix) + message);
    }

    public static String replacePrefixes(String message) {
        return Replacer.replaceArray(message, "plugin_prefix", SimpleSettings.PLUGIN_PREFIX, "info_prefix", infoPrefix, "prefix_info", infoPrefix, "success_prefix", successPrefix, "prefix_success", successPrefix, "warn_prefix", warnPrefix, "prefix_warn", warnPrefix, "error_prefix", errorPrefix, "prefix_error", errorPrefix, "question_prefix", questionPrefix, "prefix_question", questionPrefix, "announce_prefix", announcePrefix, "prefix_announce", announcePrefix);
    }

    private Messenger() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void setInfoPrefix(String infoPrefix) {
        Messenger.infoPrefix = infoPrefix;
    }

    public static String getInfoPrefix() {
        return infoPrefix;
    }

    public static void setSuccessPrefix(String successPrefix) {
        Messenger.successPrefix = successPrefix;
    }

    public static String getSuccessPrefix() {
        return successPrefix;
    }

    public static void setWarnPrefix(String warnPrefix) {
        Messenger.warnPrefix = warnPrefix;
    }

    public static String getWarnPrefix() {
        return warnPrefix;
    }

    public static void setErrorPrefix(String errorPrefix) {
        Messenger.errorPrefix = errorPrefix;
    }

    public static String getErrorPrefix() {
        return errorPrefix;
    }

    public static void setQuestionPrefix(String questionPrefix) {
        Messenger.questionPrefix = questionPrefix;
    }

    public static String getQuestionPrefix() {
        return questionPrefix;
    }

    public static void setAnnouncePrefix(String announcePrefix) {
        Messenger.announcePrefix = announcePrefix;
    }

    public static String getAnnouncePrefix() {
        return announcePrefix;
    }
}

