/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffectType;
import sk.adonikeoffice.epicchat.lib.ChatUtil;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.SerializeUtil;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.CompChatColor;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTItem;

public final class ItemUtil {
    private static final boolean LEGACY_MATERIALS = MinecraftVersion.olderThan(MinecraftVersion.V.v1_13);

    public static String bountifyCapitalized(@NonNull PotionEffectType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return SerializeUtil.PotionWrapper.getLocalizedName(type.getName());
    }

    public static String bountifyCapitalized(@NonNull CompChatColor color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        return ItemUtil.bountifyCapitalized(color.getName());
    }

    public static String bountifyCapitalized(@NonNull Enum<?> enumeration) {
        if (enumeration == null) {
            throw new NullPointerException("enumeration is marked non-null but is null");
        }
        return ChatUtil.capitalizeFully(ItemUtil.bountify(enumeration.toString().toLowerCase()));
    }

    public static String bountifyCapitalized(String name) {
        return ChatUtil.capitalizeFully(ItemUtil.bountify(name));
    }

    public static String bountify(@NonNull Enum<?> enumeration) {
        if (enumeration == null) {
            throw new NullPointerException("enumeration is marked non-null but is null");
        }
        return ItemUtil.bountify(enumeration.toString());
    }

    public static String bountify(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return name.toLowerCase().replace("_", " ");
    }

    public static String bountify(@NonNull PotionEffectType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return SerializeUtil.PotionWrapper.getLocalizedName(type.getName()).toLowerCase();
    }

    public static String bountify(@NonNull Enchantment enchant) {
        if (enchant == null) {
            throw new NullPointerException("enchant is marked non-null but is null");
        }
        return SerializeUtil.EnchantmentWrapper.toMinecraft(enchant.getName());
    }

    public static boolean isSimilar(ItemStack first, ItemStack second) {
        boolean metaMatch;
        if (first == null || second == null) {
            return false;
        }
        boolean firstAir = CompMaterial.isAir(first.getType());
        boolean secondAir = CompMaterial.isAir(second.getType());
        if (firstAir && !secondAir || !firstAir && secondAir) {
            return false;
        }
        if (firstAir && secondAir) {
            return true;
        }
        boolean idMatch = first.getType() == second.getType();
        boolean isSkull = CompMaterial.isSkull(first.getType()) && CompMaterial.isSkull(second.getType());
        boolean dataMatch = !LEGACY_MATERIALS || isSkull || first.getData().getData() == second.getData().getData();
        boolean bl = metaMatch = first.hasItemMeta() == second.hasItemMeta();
        if (!idMatch || !metaMatch || !dataMatch && !(dataMatch = first.getType() == Material.BOW)) {
            return false;
        }
        ItemMeta f = first.getItemMeta();
        ItemMeta s = second.getItemMeta();
        if (f == null && s != null || s == null && f != null) {
            return false;
        }
        if (f != null && s != null) {
            String fName = Common.stripColors(f.getDisplayName());
            String sName = Common.stripColors(s.getDisplayName());
            if (fName != null && !fName.equals(sName) || !ItemUtil.listMatch(f.getLore(), s.getLore())) {
                return false;
            }
        }
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_7)) {
            NBTItem firstNbt = new NBTItem(first);
            NBTItem secondNbt = new NBTItem(second);
            return ItemUtil.matchNbt(SimplePlugin.getNamed(), firstNbt, secondNbt) && ItemUtil.matchNbt(SimplePlugin.getNamed() + "_Item", firstNbt, secondNbt);
        }
        return true;
    }

    private static boolean listMatch(List<String> first, List<String> second) {
        if (first == null) {
            first = new ArrayList<String>();
        }
        if (second == null) {
            second = new ArrayList<String>();
        }
        if (first.isEmpty() && second.isEmpty()) {
            return true;
        }
        if (first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            String firstString = first.get(i);
            String secondString = second.get(i);
            if (Common.stripColors(firstString).equals(Common.stripColors(secondString))) continue;
            return false;
        }
        return true;
    }

    private static boolean matchNbt(String key, NBTItem firstNbt, NBTItem secondNbt) {
        boolean firstHas = firstNbt.hasKey(key);
        boolean secondHas = secondNbt.hasKey(key);
        if (!firstHas && !secondHas) {
            return true;
        }
        if (firstHas && !secondHas || !firstHas && secondHas) {
            return false;
        }
        return firstNbt.getString(key).equals(secondNbt.getString(key));
    }

    private ItemUtil() {
    }
}

