/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import sk.adonikeoffice.epicchat.lib.collection.expiringmap.ExpiringMap;

class HitTracking
implements Listener {
    private static volatile ExpiringMap<UUID, List<Consumer<ProjectileHitEvent>>> flyingProjectiles = ExpiringMap.builder().expiration(30L, TimeUnit.SECONDS).build();

    HitTracking() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onHit(ProjectileHitEvent event) {
        ExpiringMap<UUID, List<Consumer<ProjectileHitEvent>>> expiringMap = flyingProjectiles;
        synchronized (expiringMap) {
            List<Consumer<ProjectileHitEvent>> hitListeners = flyingProjectiles.remove(event.getEntity().getUniqueId());
            if (hitListeners != null) {
                for (Consumer<ProjectileHitEvent> listener : hitListeners) {
                    listener.accept(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addFlyingProjectile(Projectile projectile, Consumer<ProjectileHitEvent> hitTask) {
        ExpiringMap<UUID, List<Consumer<ProjectileHitEvent>>> expiringMap = flyingProjectiles;
        synchronized (expiringMap) {
            UUID uniqueId = projectile.getUniqueId();
            List listeners = flyingProjectiles.getOrDefault(uniqueId, new ArrayList());
            listeners.add(hitTask);
            flyingProjectiles.put(uniqueId, listeners);
        }
    }
}

