/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.ClosedByInterruptException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.NonNull;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.TimeUtil;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public final class FileUtil {
    public static String getFileName(File file) {
        return FileUtil.getFileName(file.getName());
    }

    public static String getFileName(String path) {
        Valid.checkBoolean(path != null && !path.isEmpty(), "The given path must not be empty!", new Object[0]);
        int pos = path.lastIndexOf("/");
        if (pos > 0) {
            path = path.substring(pos + 1);
        }
        if ((pos = path.lastIndexOf(".")) > 0) {
            path = path.substring(0, pos);
        }
        return path;
    }

    public static File getOrMakeFile(String path) {
        File file = FileUtil.getFile(path);
        return file.exists() ? file : FileUtil.createIfNotExists(path);
    }

    public static File createIfNotExists(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Throwable t) {
                Common.throwError(t, "Could not create new " + file + " due to " + t);
            }
        }
        return file;
    }

    public static File createIfNotExists(String path) {
        File datafolder = SimplePlugin.getData();
        int lastIndex = path.lastIndexOf(47);
        File directory = new File(datafolder, path.substring(0, lastIndex >= 0 ? lastIndex : 0));
        directory.mkdirs();
        File destination = new File(datafolder, path);
        try {
            destination.createNewFile();
        }
        catch (IOException ex) {
            Common.error(ex, "Failed to create a new file " + path);
        }
        return destination;
    }

    public static File getFile(String path) {
        return new File(SimplePlugin.getData(), path);
    }

    public static File[] getFiles(@NonNull String directory, @NonNull String extension) {
        File dataFolder;
        if (directory == null) {
            throw new NullPointerException("directory is marked non-null but is null");
        }
        if (extension == null) {
            throw new NullPointerException("extension is marked non-null but is null");
        }
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        if (!(dataFolder = new File(SimplePlugin.getData(), directory)).exists()) {
            dataFolder.mkdirs();
        }
        String finalExtension = extension;
        return dataFolder.listFiles(file -> !file.isDirectory() && file.getName().endsWith("." + finalExtension));
    }

    public static List<String> readLines(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.7) Gecko/20040803 Firefox/0.9.3");
        connection.setConnectTimeout(6000);
        connection.setReadTimeout(6000);
        connection.setDoOutput(true);
        return FileUtil.readLines(connection);
    }

    public static List<String> readLines(URLConnection connection) {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String inputLine;
            while ((inputLine = reader.readLine()) != null) {
                lines.add(inputLine);
            }
        }
        catch (IOException ex) {
            Remain.sneaky(ex);
        }
        return lines;
    }

    public static List<String> readLines(String fileName) {
        return FileUtil.readLines(FileUtil.getFile(fileName));
    }

    public static List<String> readLines(@NonNull File file) {
        ArrayList<String> arrayList;
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Valid.checkBoolean(file.exists(), "File: " + file + " does not exists!", new Object[0]);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            arrayList = lines;
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ee) {
                throw new FoException(ee, "Could not read lines from " + file.getName());
            }
        }
        br.close();
        return arrayList;
    }

    public static void writeFormatted(String to, String message) {
        FileUtil.writeFormatted(to, null, message);
    }

    public static void writeFormatted(String to, String prefix, String message) {
        if (!(message = Common.stripColors(message).trim()).equalsIgnoreCase("none") && !message.isEmpty()) {
            for (String line : message.split("\n")) {
                if (line.isEmpty()) continue;
                FileUtil.write(to, "[" + TimeUtil.getFormattedDate() + "] " + (prefix != null ? prefix + ": " : "") + line);
            }
        }
    }

    public static void write(String to, String ... lines) {
        FileUtil.write(to, Arrays.asList(lines));
    }

    public static void write(File to, String ... lines) {
        FileUtil.write(FileUtil.createIfNotExists(to), Arrays.asList(lines), StandardOpenOption.APPEND);
    }

    public static void write(String to, Collection<String> lines) {
        FileUtil.write(FileUtil.getOrMakeFile(to), lines, StandardOpenOption.APPEND);
    }

    public static void write(File to, Collection<String> lines, StandardOpenOption ... options) {
        try {
            Path path = Paths.get(to.toURI());
            try {
                if (!to.exists()) {
                    FileUtil.createIfNotExists(to);
                }
                Files.write(path, lines, StandardCharsets.UTF_8, (OpenOption[])options);
            }
            catch (ClosedByInterruptException ex) {
                try (BufferedWriter bw = new BufferedWriter(new FileWriter(to, true));){
                    for (String line : lines) {
                        bw.append(System.lineSeparator() + line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            Common.error(ex, "Failed to write to " + to);
        }
    }

    public static File extract(String path) {
        return FileUtil.extract(path, path);
    }

    public static File extract(String from, String to) {
        File file = new File(SimplePlugin.getData(), to);
        List<String> lines = FileUtil.getInternalFileContent(from);
        Valid.checkNotNull(lines, "Inbuilt " + file.getAbsolutePath() + " not found! Did you reload?");
        if (file.exists()) {
            return file;
        }
        file = FileUtil.createIfNotExists(to);
        try {
            String fileName = FileUtil.getFileName(file);
            for (int i = 0; i < lines.size(); ++i) {
                lines.set(i, FileUtil.replaceVariables(lines.get(i), fileName));
            }
            Files.write(file.toPath(), lines, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException ex) {
            Common.error(ex, "Failed to extract " + from + " to " + to, "Error: %error");
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File extractRaw(String path) {
        File file = new File(SimplePlugin.getData(), path);
        try (JarFile jarFile = new JarFile(SimplePlugin.getSource());){
            JarEntry entry;
            Enumeration<JarEntry> it = jarFile.entries();
            do {
                if (!it.hasMoreElements()) throw new FoException("Inbuilt file not found: " + path);
            } while (!(entry = it.nextElement()).toString().equals(path));
            InputStream is = jarFile.getInputStream(entry);
            if (file.exists()) {
                File file2 = file;
                return file2;
            }
            file = FileUtil.createIfNotExists(path);
            try {
                Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                Common.error(ex, "Failed to extract " + path, "Error: %error");
            }
            File file3 = file;
            return file3;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        throw new FoException("Inbuilt file not found: " + path);
    }

    private static String replaceVariables(String line, String fileName) {
        return line.replace("{plugin_name}", SimplePlugin.getNamed()).replace("{plugin_name_lower}", SimplePlugin.getNamed().toLowerCase()).replace("{file}", fileName).replace("{file_lowercase}", fileName);
    }

    public static void extractFolderFromJar(String folder, String destination) {
        Valid.checkBoolean(folder.endsWith("/"), "Folder must end with '/'! Given: " + folder, new Object[0]);
        Valid.checkBoolean(!folder.startsWith("/"), "Folder must not start with '/'! Given: " + folder, new Object[0]);
        if (FileUtil.getFile(folder).exists()) {
            return;
        }
        try (JarFile jarFile = new JarFile(SimplePlugin.getSource());){
            Enumeration<JarEntry> it = jarFile.entries();
            while (it.hasMoreElements()) {
                JarEntry jarEntry = it.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.startsWith(folder) || entryName.equals(folder)) continue;
                FileUtil.extract(entryName);
            }
        }
        catch (Throwable t) {
            Common.throwError(t, "Failed to copy folder " + folder + " to " + destination);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getInternalFileContent(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try (JarFile jarFile = new JarFile(SimplePlugin.getSource());){
            JarEntry entry;
            Enumeration<JarEntry> it = jarFile.entries();
            do {
                if (!it.hasMoreElements()) return null;
            } while (!(entry = it.nextElement()).toString().equals(path));
            InputStream is = jarFile.getInputStream(entry);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            List<String> lines = reader.lines().collect(Collectors.toList());
            reader.close();
            List<String> list = lines;
            return list;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void deleteRecursivelly(File file) {
        if (file.isDirectory()) {
            for (File subfolder : file.listFiles()) {
                FileUtil.deleteRecursivelly(subfolder);
            }
        }
        if (file.exists()) {
            Valid.checkBoolean(file.delete(), "Failed to delete file: " + file, new Object[0]);
        }
    }

    public static void zip(String sourceDirectory, String to) throws IOException {
        File parent = SimplePlugin.getData().getParentFile().getParentFile();
        File toFile = new File(parent, to + ".zip");
        if (toFile.exists()) {
            Valid.checkBoolean(toFile.delete(), "Failed to delete old file " + toFile, new Object[0]);
        }
        Path pathTo = Files.createFile(Paths.get(toFile.toURI()), new FileAttribute[0]);
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(pathTo, new OpenOption[0]));){
            Path pathFrom = Paths.get(new File(parent, sourceDirectory).toURI());
            Files.walk(pathFrom, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(pathFrom.relativize((Path)path).toString());
                try {
                    zs.putNextEntry(zipEntry);
                    Files.copy(path, zs);
                    zs.closeEntry();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            });
        }
    }

    private FileUtil() {
    }
}

