/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Wolf;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.HitTracking;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.model.HookManager;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public final class EntityUtil {
    private static volatile boolean registeredHitListener = false;

    public static <T extends LivingEntity> T findNearestEntity(Location center, double range3D, Class<T> entityClass) {
        ArrayList<LivingEntity> found = new ArrayList<LivingEntity>();
        for (Entity nearby : Remain.getNearbyEntities(center, range3D)) {
            if (!(nearby instanceof LivingEntity) || !entityClass.isAssignableFrom(nearby.getClass())) continue;
            found.add((LivingEntity)nearby);
        }
        Collections.sort(found, (first, second) -> Double.compare(first.getLocation().distance(center), second.getLocation().distance(center)));
        return (T)(found.isEmpty() ? null : (LivingEntity)found.get(0));
    }

    public static Player getTargetPlayer(Entity entity) {
        Entity target = EntityUtil.getTarget(entity);
        if (target == null) {
            return null;
        }
        return target instanceof Player && target.getLocation().getWorld().equals((Object)entity.getWorld()) && !HookManager.isNPC(target) ? (Player)target : null;
    }

    public static Entity getTarget(Entity entity) {
        LivingEntity target = null;
        if (entity instanceof Creature) {
            target = ((Creature)entity).getTarget();
        }
        if (target == null) {
            target = HookManager.getNPCTarget(entity);
        }
        return target;
    }

    public static double getDefaultHealth(EntityType type) {
        if (type == EntityType.PLAYER) {
            return 20.0;
        }
        Location location = ((World)Bukkit.getWorlds().get(0)).getSpawnLocation();
        location.setY(0.0);
        Entity entity = location.getWorld().spawnEntity(location, type);
        Valid.checkBoolean(entity instanceof LivingEntity, "Cannot use getDefaultHealth for non-living entity: " + type, new Object[0]);
        double health = Remain.getHealth((LivingEntity)entity);
        entity.remove();
        return health;
    }

    public static void rotateYaw(Location location, Location facing) {
        float yaw = (float)Math.toDegrees(Math.atan2(facing.getZ() - location.getZ(), facing.getX() - location.getX())) - 90.0f;
        location.setYaw(yaw);
    }

    public static void removeVehiclesAndPassengers(Entity entity) {
        block4: {
            for (Entity vehicle = entity.getVehicle(); vehicle != null; vehicle = vehicle.getVehicle()) {
                Entity copyOf = vehicle;
                copyOf.remove();
            }
            try {
                for (Entity passenger : entity.getPassengers()) {
                    passenger.remove();
                }
            }
            catch (NoSuchMethodError err) {
                Entity passenger = entity.getPassenger();
                if (passenger == null) break block4;
                passenger.remove();
            }
        }
    }

    public static boolean isAggressive(Entity entity) {
        if (entity instanceof Ghast || entity instanceof Slime) {
            return true;
        }
        if (entity instanceof Wolf && ((Wolf)entity).isAngry()) {
            return true;
        }
        if (entity instanceof Animals) {
            return false;
        }
        return entity instanceof Creature;
    }

    public static boolean isCreature(Entity entity) {
        return entity instanceof Slime || entity instanceof Wolf || entity instanceof Creature;
    }

    public static boolean canBeCleaned(Entity entity) {
        return entity instanceof FallingBlock || entity instanceof Item || entity instanceof Projectile || entity instanceof ExperienceOrb;
    }

    public static Item dropItem(Location location, ItemStack item, Consumer<Item> modifier) {
        return Remain.spawnItem(location, item, modifier);
    }

    public static void trackFalling(Entity entity, Runnable hitGroundListener) {
        EntityUtil.track(entity, 600, null, hitGroundListener);
    }

    public static void trackFlying(Entity entity, Runnable flyListener) {
        EntityUtil.track(entity, 600, flyListener, null);
    }

    public static void track(final Entity entity, final int timeoutTicks, final Runnable flyListener, final Runnable hitGroundListener) {
        if (flyListener == null && hitGroundListener == null) {
            throw new FoException("Cannot track entity with fly and hit listeners on null!");
        }
        Common.runTimer(1, (Runnable)new BukkitRunnable(){
            private int elapsedTicks = 0;

            public void run() {
                if (this.elapsedTicks++ > timeoutTicks) {
                    this.cancel();
                    return;
                }
                if (entity == null || entity.isDead() || !entity.isValid()) {
                    if (entity instanceof FallingBlock && hitGroundListener != null) {
                        hitGroundListener.run();
                    }
                    this.cancel();
                    return;
                }
                if (entity.isOnGround()) {
                    if (hitGroundListener != null) {
                        hitGroundListener.run();
                    }
                    this.cancel();
                } else if (flyListener != null) {
                    flyListener.run();
                }
            }
        });
    }

    public static void trackHit(Projectile projectile, Consumer<ProjectileHitEvent> hitTask) {
        HitTracking.addFlyingProjectile(projectile, hitTask);
        if (!registeredHitListener) {
            Common.registerEvents(new HitTracking());
            registeredHitListener = true;
        }
    }

    private EntityUtil() {
    }
}

