/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.NonNull;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.MemorySection;
import org.bukkit.conversations.Conversable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import sk.adonikeoffice.epicchat.lib.ChatUtil;
import sk.adonikeoffice.epicchat.lib.ItemUtil;
import sk.adonikeoffice.epicchat.lib.MathUtil;
import sk.adonikeoffice.epicchat.lib.Messenger;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.PlayerUtil;
import sk.adonikeoffice.epicchat.lib.ReflectionUtil;
import sk.adonikeoffice.epicchat.lib.TimeUtil;
import sk.adonikeoffice.epicchat.lib.TimedCharSequence;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.collection.StrictList;
import sk.adonikeoffice.epicchat.lib.collection.StrictMap;
import sk.adonikeoffice.epicchat.lib.constants.FoConstants;
import sk.adonikeoffice.epicchat.lib.debug.Debugger;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.exception.RegexTimeoutException;
import sk.adonikeoffice.epicchat.lib.model.DiscordSender;
import sk.adonikeoffice.epicchat.lib.model.HookManager;
import sk.adonikeoffice.epicchat.lib.model.Replacer;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.CompChatColor;
import sk.adonikeoffice.epicchat.lib.remain.CompMaterial;
import sk.adonikeoffice.epicchat.lib.remain.Remain;
import sk.adonikeoffice.epicchat.lib.remain.nbt.NBTItem;
import sk.adonikeoffice.epicchat.lib.settings.ConfigSection;
import sk.adonikeoffice.epicchat.lib.settings.SimpleLocalization;
import sk.adonikeoffice.epicchat.lib.settings.SimpleSettings;

public final class Common {
    private static final Pattern COLOR_AND_DECORATION_REGEX = Pattern.compile("(&|\u00a7)[0-9a-fk-orA-FK-OR]");
    public static final Pattern HEX_COLOR_REGEX = Pattern.compile("(?<!\\\\)(\\{|&|)#((?:[0-9a-fA-F]{3}){2})(\\}|)");
    private static final Pattern RGB_X_COLOR_REGEX = Pattern.compile("(\u00a7x)(\u00a7[0-9a-fA-F]){6}");
    private static final Map<String, Long> TIMED_TELL_CACHE = new HashMap<String, Long>();
    private static final Map<String, Long> TIMED_LOG_CACHE = new HashMap<String, Long>();
    private static String tellPrefix = "";
    private static String logPrefix = "[" + SimplePlugin.getNamed() + "]";

    public static void setTellPrefix(String prefix) {
        tellPrefix = prefix == null ? "" : Common.colorize(prefix);
    }

    public static void setLogPrefix(String prefix) {
        logPrefix = prefix == null ? "" : Common.colorize(prefix);
    }

    public static void broadcastReplaced(String message, Object ... replacements) {
        Common.broadcast(Replacer.replaceArray(message, replacements));
    }

    public static void broadcast(String message, CommandSender sender) {
        Common.broadcast(message, Common.resolveSenderName(sender));
    }

    public static void broadcast(String message, String playerReplacement) {
        Common.broadcast(message.replace("{player}", playerReplacement));
    }

    public static void broadcast(String ... messages) {
        if (!Valid.isNullOrEmpty(messages)) {
            for (String message : messages) {
                for (Player player : Remain.getOnlinePlayers()) {
                    Common.tellJson((CommandSender)player, message);
                }
                Common.log(message);
            }
        }
    }

    public static void broadcastTo(Iterable<? extends CommandSender> recipients, String ... messages) {
        for (CommandSender commandSender : recipients) {
            Common.tell(commandSender, messages);
        }
    }

    public static void broadcastWithPerm(String showPermission, String message, boolean log) {
        if (message != null && !message.equals("none")) {
            for (Player player : Remain.getOnlinePlayers()) {
                if (!PlayerUtil.hasPerm((Permissible)player, showPermission)) continue;
                Common.tellJson((CommandSender)player, message);
            }
            if (log) {
                Common.log(message);
            }
        }
    }

    public static void broadcastWithPerm(String permission, @NonNull TextComponent message, boolean log) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        String legacy = message.toLegacyText();
        if (!legacy.equals("none")) {
            for (Player player : Remain.getOnlinePlayers()) {
                if (!PlayerUtil.hasPerm((Permissible)player, permission)) continue;
                Remain.sendComponent((CommandSender)player, message);
            }
            if (log) {
                Common.log(legacy);
            }
        }
    }

    public static void tellTimedNoPrefix(int delaySeconds, CommandSender sender, String message) {
        String oldPrefix = Common.getTellPrefix();
        Common.setTellPrefix("");
        Common.tellTimed(delaySeconds, sender, message);
        Common.setTellPrefix(oldPrefix);
    }

    public static void tellTimed(int delaySeconds, CommandSender sender, String message) {
        if (!TIMED_TELL_CACHE.containsKey(message)) {
            Common.tell(sender, message);
            TIMED_TELL_CACHE.put(message, TimeUtil.currentTimeSeconds());
            return;
        }
        if (TimeUtil.currentTimeSeconds() - TIMED_TELL_CACHE.get(message) > (long)delaySeconds) {
            Common.tell(sender, message);
            TIMED_TELL_CACHE.put(message, TimeUtil.currentTimeSeconds());
        }
    }

    public static void tellLaterConversing(int delayTicks, Conversable conversable, String message) {
        Common.runLater(delayTicks, () -> Common.tellConversing(conversable, message));
    }

    public static void tellConversing(Conversable conversable, String message) {
        conversable.sendRawMessage(Common.colorize(Common.addLastSpace(tellPrefix) + Common.removeFirstSpaces(message)).trim());
    }

    public static void tellLater(int delayTicks, CommandSender sender, String ... messages) {
        Common.runLater(delayTicks, () -> {
            if (sender instanceof Player && !((Player)sender).isOnline()) {
                return;
            }
            Common.tell(sender, messages);
        });
    }

    public static void tellNoPrefix(CommandSender sender, Collection<String> messages) {
        Common.tellNoPrefix(sender, Common.toArray(messages));
    }

    public static void tellNoPrefix(CommandSender sender, String ... messages) {
        String oldPrefix = Common.getTellPrefix();
        Common.setTellPrefix("");
        Common.tell(sender, messages);
        Common.setTellPrefix(oldPrefix);
    }

    public static void tell(CommandSender sender, Collection<String> messages) {
        Common.tell(sender, Common.toArray(messages));
    }

    public static void tell(CommandSender sender, String ... messages) {
        for (String message : messages) {
            if (message == null || "none".equals(message)) continue;
            Common.tellJson(sender, message);
        }
    }

    public static void tellReplaced(CommandSender recipient, String message, Object ... replacements) {
        Common.tell(recipient, Replacer.replaceArray(message, replacements));
    }

    private static void tellJson(@NonNull CommandSender sender, String message) {
        block21: {
            String colorlessMessage;
            boolean hasPrefix;
            block24: {
                String subtitle;
                String title;
                block25: {
                    block23: {
                        block22: {
                            block20: {
                                if (sender == null) {
                                    throw new NullPointerException("sender is marked non-null but is null");
                                }
                                if (message.isEmpty() || "none".equals(message)) {
                                    return;
                                }
                                hasPrefix = message.contains("{prefix}");
                                boolean hasJSON = message.startsWith("[JSON]");
                                message = message.replace("{player}", Common.resolveSenderName(sender));
                                if (!hasJSON) {
                                    message = Common.colorize(message);
                                }
                                colorlessMessage = Common.stripColors(message);
                                if (!hasJSON) break block20;
                                String stripped = message.substring(6).trim();
                                if (!stripped.isEmpty()) {
                                    Remain.sendJson(sender, stripped);
                                }
                                break block21;
                            }
                            if (!colorlessMessage.startsWith("<actionbar>")) break block22;
                            String stripped = message.replace("<actionbar>", "");
                            if (!stripped.isEmpty()) {
                                if (sender instanceof Player) {
                                    Remain.sendActionBar((Player)sender, stripped);
                                } else {
                                    Common.tellJson(sender, stripped);
                                }
                            }
                            break block21;
                        }
                        if (!colorlessMessage.startsWith("<toast>")) break block23;
                        String stripped = message.replace("<toast>", "");
                        if (!stripped.isEmpty()) {
                            if (sender instanceof Player) {
                                Remain.sendToast((Player)sender, stripped);
                            } else {
                                Common.tellJson(sender, stripped);
                            }
                        }
                        break block21;
                    }
                    if (!colorlessMessage.startsWith("<title>")) break block24;
                    String stripped = message.replace("<title>", "");
                    if (stripped.isEmpty()) break block21;
                    String[] split = stripped.split("\\|");
                    title = split[0];
                    String string = subtitle = split.length > 1 ? Common.joinRange(1, split) : null;
                    if (!(sender instanceof Player)) break block25;
                    Remain.sendTitle((Player)sender, title, subtitle);
                    break block21;
                }
                Common.tellJson(sender, title);
                if (subtitle == null) break block21;
                Common.tellJson(sender, subtitle);
                break block21;
            }
            if (colorlessMessage.startsWith("<bossbar>")) {
                String stripped = message.replace("<bossbar>", "");
                if (!stripped.isEmpty()) {
                    if (sender instanceof Player) {
                        Remain.sendBossbarTimed((Player)sender, stripped, 10);
                    } else {
                        Common.tellJson(sender, stripped);
                    }
                }
            } else {
                for (String part : message.split("\n")) {
                    String prefixStripped = Common.removeSurroundingSpaces(tellPrefix);
                    String prefix = !hasPrefix && !prefixStripped.isEmpty() ? prefixStripped + " " : "";
                    String toSend = Common.stripColors(part).startsWith("<center>") ? ChatUtil.center(prefix + part.replace("<center>", "")) : prefix + part;
                    if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_9) && toSend.length() + 1 >= Short.MAX_VALUE) {
                        toSend = toSend.substring(0, 16383);
                        Common.warning("Message to " + sender.getName() + " was too large, sending the first 16,000 letters: " + toSend);
                    }
                    if (sender instanceof Conversable && ((Conversable)sender).isConversing()) {
                        ((Conversable)sender).sendRawMessage(toSend);
                        continue;
                    }
                    try {
                        sender.sendMessage(toSend);
                    }
                    catch (Throwable t) {
                        Bukkit.getLogger().severe("Failed to send message to " + sender.getName() + ", message: " + toSend);
                        t.printStackTrace();
                    }
                }
            }
        }
    }

    public static String resolveSenderName(CommandSender sender) {
        return sender instanceof Player || sender instanceof DiscordSender ? sender.getName() : SimpleLocalization.CONSOLE_NAME;
    }

    private static String removeFirstSpaces(String message) {
        message = Common.getOrEmpty(message);
        while (message.startsWith(" ")) {
            message = message.substring(1);
        }
        return message;
    }

    private static String addLastSpace(String message) {
        if (!(message = message.trim()).endsWith(" ")) {
            message = message + " ";
        }
        return message;
    }

    public static List<String> colorize(List<String> list) {
        ArrayList<String> copy = new ArrayList<String>();
        copy.addAll(list);
        for (int i = 0; i < copy.size(); ++i) {
            String message = (String)copy.get(i);
            if (message == null) continue;
            copy.set(i, Common.colorize(message));
        }
        return copy;
    }

    public static String colorize(String ... messages) {
        return Common.colorize(String.join((CharSequence)"\n", messages));
    }

    public static String[] colorizeArray(String ... messages) {
        for (int i = 0; i < messages.length; ++i) {
            messages[i] = Common.colorize(messages[i]);
        }
        return messages;
    }

    public static String colorize(String message) {
        if (message == null || message.isEmpty()) {
            return "";
        }
        char[] letters = message.toCharArray();
        for (int index = 0; index < letters.length - 1; ++index) {
            if (letters[index] != '&' || "0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx".indexOf(letters[index + 1]) <= -1) continue;
            letters[index] = 167;
            letters[index + 1] = Character.toLowerCase(letters[index + 1]);
        }
        String result = new String(letters).replace("{prefix}", message.startsWith(tellPrefix) ? "" : Common.removeSurroundingSpaces(tellPrefix.trim())).replace("{server}", SimpleLocalization.SERVER_PREFIX).replace("{plugin_name}", SimplePlugin.getNamed()).replace("{plugin_version}", SimplePlugin.getVersion());
        Matcher match = HEX_COLOR_REGEX.matcher(result);
        while (match.find()) {
            String matched = match.group();
            String colorCode = match.group(2);
            String replacement = "";
            try {
                replacement = CompChatColor.of("#" + colorCode).toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            result = result.replaceAll(Pattern.quote(matched), replacement);
        }
        result = result.replace("\\#", "#");
        return result;
    }

    private static String removeSurroundingSpaces(String message) {
        message = Common.getOrEmpty(message);
        while (message.endsWith(" ")) {
            message = message.substring(0, message.length() - 1);
        }
        return Common.removeFirstSpaces(message);
    }

    public static String[] revertColorizing(String[] messages) {
        for (int i = 0; i < messages.length; ++i) {
            messages[i] = Common.revertColorizing(messages[i]);
        }
        return messages;
    }

    public static String revertColorizing(String message) {
        return message.replaceAll("(?i)\u00a7([0-9a-fk-or])", "&$1");
    }

    public static String stripColors(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        Matcher matcher = COLOR_AND_DECORATION_REGEX.matcher(message);
        while (matcher.find()) {
            message = matcher.replaceAll("");
        }
        if (Remain.hasHexColors()) {
            matcher = HEX_COLOR_REGEX.matcher(message);
            while (matcher.find()) {
                message = matcher.replaceAll("");
            }
            matcher = RGB_X_COLOR_REGEX.matcher(message);
            while (matcher.find()) {
                message = matcher.replaceAll("");
            }
            message = message.replace("\u00a7x", "");
        }
        return message;
    }

    public static String stripColorsLetter(String message) {
        return message == null ? "" : message.replaceAll("&([0-9a-fk-orA-F-K-OR])", "");
    }

    public static boolean hasColors(String message) {
        return COLOR_AND_DECORATION_REGEX.matcher(message).find();
    }

    public static String lastColor(String message) {
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_16)) {
            int c = message.lastIndexOf(167);
            Matcher match = RGB_X_COLOR_REGEX.matcher(message);
            String lastColor = null;
            while (match.find()) {
                lastColor = match.group(0);
            }
            if (lastColor != null && (c == -1 || c < message.lastIndexOf(lastColor) + lastColor.length())) {
                return lastColor;
            }
        }
        String andLetter = Common.lastColorLetter(message);
        String colorChat = Common.lastColorChar(message);
        return !andLetter.isEmpty() ? andLetter : (!colorChat.isEmpty() ? colorChat : "");
    }

    public static String lastColorLetter(String message) {
        return Common.lastColor(message, '&');
    }

    public static String lastColorChar(String message) {
        return Common.lastColor(message, '\u00a7');
    }

    private static String lastColor(String msg, char colorChar) {
        int c = msg.lastIndexOf(colorChar);
        if (c != -1) {
            if (msg.length() > c + 1 && msg.substring(c + 1, c + 2).matches("([0-9a-fk-or])")) {
                return msg.substring(c, c + 2).trim();
            }
            return Common.lastColor(msg.substring(0, c), colorChar);
        }
        return "";
    }

    public static String consoleLine() {
        return "!-----------------------------------------------------!";
    }

    public static String consoleLineSmooth() {
        return "______________________________________________________________";
    }

    public static String chatLine() {
        return "*---------------------------------------------------*";
    }

    public static String chatLineSmooth() {
        return "&m-----------------------------------------------------";
    }

    public static String configLine() {
        return "-------------------------------------------------------------------------------------------";
    }

    public static String scoreboardLine(int length) {
        String fill = "";
        for (int i = 0; i < length; ++i) {
            fill = fill + "-";
        }
        return "&m|" + fill + "|";
    }

    public static <T> String plural(Collection<T> iterable, String ofWhat) {
        return Common.plural(iterable.size(), ofWhat) + ": " + Common.join(iterable);
    }

    public static String plural(long count, String ofWhat) {
        String exception = Common.getException(count, ofWhat);
        return exception != null ? exception : count + " " + ofWhat + (count == 0L || count > 1L && !ofWhat.endsWith("s") ? "s" : "");
    }

    public static String pluralEs(long count, String ofWhat) {
        String exception = Common.getException(count, ofWhat);
        return exception != null ? exception : count + " " + ofWhat + (count == 0L || count > 1L && !ofWhat.endsWith("es") ? "es" : "");
    }

    public static String pluralIes(long count, String ofWhat) {
        String exception = Common.getException(count, ofWhat);
        return exception != null ? exception : count + " " + (count == 0L || count > 1L && !ofWhat.endsWith("ies") ? ofWhat.substring(0, ofWhat.length() - 1) + "ies" : ofWhat);
    }

    @Deprecated
    private static String getException(long count, String ofWhat) {
        SerializedMap exceptions = SerializedMap.ofArray("life", "lives", "class", "classes", "wolf", "wolves", "knife", "knives", "wife", "wives", "calf", "calves", "leaf", "leaves", "potato", "potatoes", "tomato", "tomatoes", "hero", "heroes", "torpedo", "torpedoes", "veto", "vetoes", "foot", "feet", "tooth", "teeth", "goose", "geese", "man", "men", "woman", "women", "mouse", "mice", "die", "dice", "ox", "oxen", "child", "children", "person", "people", "penny", "pence", "sheep", "sheep", "fish", "fish", "deer", "deer", "moose", "moose", "swine", "swine", "buffalo", "buffalo", "shrimp", "shrimp", "trout", "trout", "spacecraft", "spacecraft", "cactus", "cacti", "axis", "axes", "analysis", "analyses", "crisis", "crises", "thesis", "theses", "datum", "data", "index", "indices", "entry", "entries", "boss", "bosses", "iron", "iron", "Iron", "Iron", "gold", "gold", "Gold", "Gold");
        return exceptions.containsKey(ofWhat) ? count + " " + (count == 0L || count > 1L ? exceptions.getString(ofWhat) : ofWhat) : null;
    }

    @Deprecated
    public static String article(String ofWhat) {
        Valid.checkBoolean(ofWhat.length() > 0, "String cannot be empty", new Object[0]);
        List<String> syllables = Arrays.asList("a", "e", "i", "o", "u", "y");
        return (syllables.contains(ofWhat.toLowerCase().trim().substring(0, 1)) ? "an" : "a") + " " + ofWhat;
    }

    public static String fancyBar(int min, char minChar, int max, char maxChar, org.bukkit.ChatColor delimiterColor) {
        int i;
        String formatted = "";
        for (i = 0; i < min; ++i) {
            formatted = formatted + minChar;
        }
        formatted = formatted + delimiterColor;
        for (i = 0; i < max - min; ++i) {
            formatted = formatted + maxChar;
        }
        return formatted;
    }

    public static String shortLocation(Vector vec) {
        return " [" + MathUtil.formatOneDigit(vec.getX()) + ", " + MathUtil.formatOneDigit(vec.getY()) + ", " + MathUtil.formatOneDigit(vec.getZ()) + "]";
    }

    public static String shortItemStack(ItemStack item) {
        if (item == null) {
            return "null";
        }
        if (CompMaterial.isAir(item.getType())) {
            return "Air";
        }
        String name = ItemUtil.bountifyCapitalized(item.getType());
        if (Remain.hasItemMeta() && item.hasItemMeta()) {
            NBTItem nbt;
            ItemMeta meta = item.getItemMeta();
            name = name + "{";
            if (meta.hasDisplayName()) {
                name = name + "name='" + Common.stripColors(meta.getDisplayName()) + "', ";
            }
            if (meta.hasLore()) {
                name = name + "lore=[" + Common.stripColors(String.join((CharSequence)", ", meta.getLore())) + "], ";
            }
            if ((nbt = new NBTItem(item)).hasTag(FoConstants.NBT.TAG)) {
                name = name + "tags=" + nbt.getCompound(FoConstants.NBT.TAG) + ", ";
            }
            if (name.endsWith(", ")) {
                name = name.substring(0, name.length() - 2);
            }
            name = name + "}";
        }
        return name;
    }

    public static String shortLocation(Location loc) {
        if (loc == null) {
            return "Location(null)";
        }
        if (loc.equals((Object)new Location(null, 0.0, 0.0, 0.0))) {
            return "Location(null, 0, 0, 0)";
        }
        Valid.checkNotNull(loc.getWorld(), "Cannot shorten a location with null world!");
        return Replacer.replaceArray(SimpleSettings.LOCATION_FORMAT, "world", loc.getWorld().getName(), "x", loc.getBlockX(), "y", loc.getBlockY(), "z", loc.getBlockZ());
    }

    public static String duplicate(String text, int nTimes) {
        if (nTimes == 0) {
            return "";
        }
        String toDuplicate = new String(text);
        for (int i = 1; i < nTimes; ++i) {
            text = text + toDuplicate;
        }
        return text;
    }

    public static String limit(String text, int maxLength) {
        int length = text.length();
        return maxLength >= length ? text : text.substring(0, maxLength) + "...";
    }

    public static boolean doesPluginExist(String pluginName) {
        Plugin found;
        Plugin lookup = null;
        for (Plugin otherPlugin : Bukkit.getPluginManager().getPlugins()) {
            if (!otherPlugin.getDescription().getName().equals(pluginName)) continue;
            lookup = otherPlugin;
            break;
        }
        if ((found = lookup) == null) {
            return false;
        }
        if (!found.isEnabled()) {
            Common.runLaterAsync(0, () -> Valid.checkBoolean(found.isEnabled(), SimplePlugin.getNamed() + " could not hook into " + pluginName + " as the plugin is disabled! (DO NOT REPORT THIS TO " + SimplePlugin.getNamed() + ", look for errors above and contact support of '" + pluginName + "')", new Object[0]));
        }
        return true;
    }

    public static void dispatchCommand(CommandSender playerReplacement, @NonNull String command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (command.isEmpty() || command.equalsIgnoreCase("none")) {
            return;
        }
        if (command.startsWith("@announce ")) {
            Messenger.announce(playerReplacement, command.replace("@announce ", ""));
        } else if (command.startsWith("@warn ")) {
            Messenger.warn(playerReplacement, command.replace("@warn ", ""));
        } else if (command.startsWith("@error ")) {
            Messenger.error(playerReplacement, command.replace("@error ", ""));
        } else if (command.startsWith("@info ")) {
            Messenger.info(playerReplacement, command.replace("@info ", ""));
        } else if (command.startsWith("@question ")) {
            Messenger.question(playerReplacement, command.replace("@question ", ""));
        } else if (command.startsWith("@success ")) {
            Messenger.success(playerReplacement, command.replace("@success ", ""));
        } else {
            command = command.startsWith("/") && !command.startsWith("//") ? command.substring(1) : command;
            if (!(command = command.replace("{player}", playerReplacement == null ? "" : Common.resolveSenderName(playerReplacement))).startsWith("tellraw")) {
                command = Common.colorize(command);
            }
            String finalCommand = command;
            Common.runLater(() -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)finalCommand));
        }
    }

    public static void dispatchCommandAsPlayer(@NonNull Player playerSender, @NonNull String command) {
        if (playerSender == null) {
            throw new NullPointerException("playerSender is marked non-null but is null");
        }
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (command.isEmpty() || command.equalsIgnoreCase("none")) {
            return;
        }
        if (command.startsWith("/") && !command.startsWith("//")) {
            command = command.substring(1);
        }
        String finalCommand = command;
        Common.runLater(() -> playerSender.performCommand(Common.colorize(finalCommand.replace("{player}", Common.resolveSenderName((CommandSender)playerSender)))));
    }

    public static void logTimed(int delaySec, String msg) {
        if (!TIMED_LOG_CACHE.containsKey(msg)) {
            Common.log(msg);
            TIMED_LOG_CACHE.put(msg, TimeUtil.currentTimeSeconds());
            return;
        }
        if (TimeUtil.currentTimeSeconds() - TIMED_LOG_CACHE.get(msg) > (long)delaySec) {
            Common.log(msg);
            TIMED_LOG_CACHE.put(msg, TimeUtil.currentTimeSeconds());
        }
    }

    public static void logF(String format, Object ... args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        String formatted = Common.format(format, args);
        Common.log(false, formatted);
    }

    public static String format(String format, Object ... args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) continue;
            args[i] = Common.simplify(arg);
        }
        return String.format(format, args);
    }

    public static void warning(String message) {
        Common.log("&cWarning: &f" + message);
    }

    public static void log(List<String> messages) {
        Common.log(Common.toArray(messages));
    }

    public static void log(String ... messages) {
        Common.log(true, messages);
    }

    public static void logNoPrefix(String ... messages) {
        Common.log(false, messages);
    }

    private static void log(boolean addLogPrefix, String ... messages) {
        if (messages == null) {
            return;
        }
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        if (console == null) {
            throw new FoException("Failed to initialize Console Sender, are you running Foundation under a Bukkit/Spigot server?");
        }
        for (String message : messages) {
            if (message == null || message.equals("none")) continue;
            if (Common.stripColors(message).replace(" ", "").isEmpty()) {
                console.sendMessage("  ");
                continue;
            }
            if ((message = Common.colorize(message)).startsWith("[JSON]")) {
                String stripped = message.replaceFirst("\\[JSON\\]", "").trim();
                if (stripped.isEmpty()) continue;
                Common.log(Remain.toLegacyText(stripped, false));
                continue;
            }
            for (String part : message.split("\n")) {
                String log = ((addLogPrefix && !logPrefix.isEmpty() ? Common.removeSurroundingSpaces(logPrefix) + " " : "") + Common.getOrEmpty(part).replace("\n", Common.colorize("\n&r"))).trim();
                console.sendMessage(log);
            }
        }
    }

    public static void logFramed(String ... messages) {
        Common.logFramed(false, messages);
    }

    public static void logFramed(boolean disablePlugin, String ... messages) {
        if (messages != null && !Valid.isNullOrEmpty(messages)) {
            Common.log("&7" + Common.consoleLine());
            for (String msg : messages) {
                Common.log(" &c" + msg);
            }
            if (disablePlugin) {
                Common.log(" &cPlugin is now disabled.");
            }
            Common.log("&7" + Common.consoleLine());
        }
        if (disablePlugin) {
            Bukkit.getPluginManager().disablePlugin((Plugin)SimplePlugin.getInstance());
        }
    }

    public static void error(@NonNull Throwable throwable, String ... messages) {
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        if (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (!(throwable instanceof FoException)) {
            Debugger.saveError(throwable, messages);
        }
        Debugger.printStackTrace(throwable);
        Common.logFramed(Common.replaceErrorVariable(throwable, messages));
    }

    public static void throwError(Throwable t, String ... messages) {
        if (t instanceof FoException) {
            throw (FoException)t;
        }
        if (messages != null) {
            Common.logFramed(false, Common.replaceErrorVariable(t, messages));
        }
        Debugger.saveError(t, messages);
        Remain.sneaky(t);
    }

    private static String[] replaceErrorVariable(Throwable throwable, String ... msgs) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        String throwableName = throwable == null ? "Unknown error." : throwable.getClass().getSimpleName();
        String throwableMessage = throwable == null || throwable.getMessage() == null || throwable.getMessage().isEmpty() ? "" : ": " + throwable.getMessage();
        for (int i = 0; i < msgs.length; ++i) {
            String error = throwableName + throwableMessage;
            msgs[i] = msgs[i].replace("%error%", error).replace("%error", error);
        }
        return msgs;
    }

    public static boolean regExMatch(String regex, String message) {
        return Common.regExMatch(Common.compilePattern(regex), message);
    }

    public static boolean regExMatch(Pattern regex, String message) {
        return Common.regExMatch(Common.compileMatcher(regex, message));
    }

    public static boolean regExMatch(Matcher matcher) {
        Valid.checkNotNull(matcher, "Cannot call regExMatch on null matcher");
        try {
            return matcher.find();
        }
        catch (RegexTimeoutException ex) {
            Common.handleRegexTimeoutException(ex, matcher.pattern());
            return false;
        }
    }

    public static Matcher compileMatcher(@NonNull Pattern pattern, String message) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        try {
            String strippedMessage = SimplePlugin.getInstance().regexStripColors() ? Common.stripColors(message) : message;
            strippedMessage = SimplePlugin.getInstance().regexStripAccents() ? ChatUtil.replaceDiacritic(strippedMessage) : strippedMessage;
            return pattern.matcher(TimedCharSequence.withSettingsLimit(strippedMessage));
        }
        catch (RegexTimeoutException ex) {
            Common.handleRegexTimeoutException(ex, pattern);
            return null;
        }
    }

    public static Matcher compileMatcher(String regex, String message) {
        return Common.compileMatcher(Common.compilePattern(regex), message);
    }

    public static Pattern compilePattern(String regex) {
        SimplePlugin instance = SimplePlugin.getInstance();
        Pattern pattern = null;
        regex = SimplePlugin.getInstance().regexStripColors() ? Common.stripColors(regex) : regex;
        regex = SimplePlugin.getInstance().regexStripAccents() ? ChatUtil.replaceDiacritic(regex) : regex;
        try {
            pattern = instance.regexCaseInsensitive() ? Pattern.compile(regex, instance.regexUnicode() ? 66 : 2) : (instance.regexUnicode() ? Pattern.compile(regex, 64) : Pattern.compile(regex));
        }
        catch (PatternSyntaxException ex) {
            Common.throwError(ex, "Your regular expression is malformed!", "Expression: '" + regex + "'", "", "IF YOU CREATED IT YOURSELF, we unfortunately", "can't provide support for custom expressions.", "Use online services like regex101.com to put your", "expression there (without '') and discover where", "the syntax error lays and how to fix it.");
            return null;
        }
        return pattern;
    }

    public static void handleRegexTimeoutException(RegexTimeoutException ex, Pattern pattern) {
        boolean caseInsensitive = SimplePlugin.getInstance().regexCaseInsensitive();
        Common.error(ex, "A regular expression took too long to process, and was", "stopped to prevent freezing your server.", " ", "Limit " + SimpleSettings.REGEX_TIMEOUT + "ms ", "Expression: '" + (pattern == null ? "unknown" : pattern.pattern()) + "'", "Evaluated message: '" + ex.getCheckedMessage() + "'", " ", "IF YOU CREATED THAT RULE YOURSELF, we unfortunately", "can't provide support for custom expressions.", " ", "Sometimes, all you need doing is increasing timeout", "limit in your settings.yml", " ", "Use services like regex101.com to test and fix it.", "Put the expression without '' and the message there.", "Ensure to turn flags 'insensitive' and 'unicode' " + (caseInsensitive ? "on" : "off"), "on there when testing: https://i.imgur.com/PRR5Rfn.png");
    }

    @SafeVarargs
    public static <T> Object[] joinArrays(T[] ... arrays) {
        ArrayList<T> all = new ArrayList<T>();
        T[][] TArray = arrays;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            T[] array;
            for (T element : array = TArray[i]) {
                all.add(element);
            }
        }
        return all.toArray();
    }

    @SafeVarargs
    public static <T> List<T> joinLists(Iterable<T> ... arrays) {
        ArrayList<T> all = new ArrayList<T>();
        for (Iterable<T> array : arrays) {
            for (T element : array) {
                all.add(element);
            }
        }
        return all;
    }

    public static <T extends CommandSender> String joinPlayersExcept(Iterable<T> array, String nameToIgnore) {
        Iterator<T> it = array.iterator();
        String message = "";
        while (it.hasNext()) {
            CommandSender next = (CommandSender)it.next();
            if (next.getName().equals(nameToIgnore)) continue;
            message = message + next.getName() + (it.hasNext() ? ", " : "");
        }
        return message.endsWith(", ") ? message.substring(0, message.length() - 2) : message;
    }

    public static String joinRange(int startIndex, String[] array) {
        return Common.joinRange(startIndex, array.length, array);
    }

    public static String joinRange(int startIndex, int stopIndex, String[] array) {
        return Common.joinRange(startIndex, stopIndex, array, " ");
    }

    public static String joinRange(int start, int stop, String[] array, String delimiter) {
        String joined = "";
        for (int i = start; i < MathUtil.range(stop, 0, array.length); ++i) {
            joined = joined + (joined.isEmpty() ? "" : delimiter) + array[i];
        }
        return joined;
    }

    public static <T> String join(T[] array) {
        return array == null ? "null" : Common.join(Arrays.asList(array));
    }

    public static <T> String join(Iterable<T> array) {
        return array == null ? "null" : Common.join(array, ", ");
    }

    public static <T> String join(T[] array, String delimiter) {
        return Common.join(array, delimiter, (T object) -> object == null ? "" : Common.simplify(object));
    }

    public static <T> String join(Iterable<T> array, String delimiter) {
        return Common.join(array, delimiter, (T object) -> object == null ? "" : Common.simplify(object));
    }

    public static <T> String join(T[] array, Stringer<T> stringer) {
        return Common.join(array, ", ", stringer);
    }

    public static <T> String join(T[] array, String delimiter, Stringer<T> stringer) {
        Valid.checkNotNull(array, "Cannot join null array!");
        return Common.join(Arrays.asList(array), delimiter, stringer);
    }

    public static <T> String join(Iterable<T> array, Stringer<T> stringer) {
        return Common.join(array, ", ", stringer);
    }

    public static <T> String join(Iterable<T> array, String delimiter, Stringer<T> stringer) {
        Iterator<T> it = array.iterator();
        String message = "";
        while (it.hasNext()) {
            T next = it.next();
            if (next == null) continue;
            message = message + stringer.toString(next) + (it.hasNext() ? delimiter : "");
        }
        return message;
    }

    public static String simplify(Object arg) {
        if (arg instanceof Entity) {
            return Remain.getName((Entity)arg);
        }
        if (arg instanceof CommandSender) {
            return ((CommandSender)arg).getName();
        }
        if (arg instanceof World) {
            return ((World)arg).getName();
        }
        if (arg instanceof Location) {
            return Common.shortLocation((Location)arg);
        }
        if (arg.getClass() == Double.TYPE || arg.getClass() == Float.TYPE) {
            return MathUtil.formatTwoDigits((Double)arg);
        }
        if (arg instanceof Collection) {
            return Common.join((Collection)arg, ", ", Common::simplify);
        }
        if (arg instanceof org.bukkit.ChatColor) {
            return ((Enum)arg).name().toLowerCase();
        }
        if (arg instanceof CompChatColor) {
            return ((CompChatColor)arg).getName();
        }
        if (arg instanceof Enum) {
            return ((Enum)arg).toString().toLowerCase();
        }
        try {
            if (arg instanceof ChatColor) {
                return ((ChatColor)arg).getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arg.toString();
    }

    public static <T> Map<Integer, List<T>> fillPages(int cellSize, Iterable<T> items) {
        List<T> allItems = Common.toList(items);
        HashMap<Integer, List<T>> pages = new HashMap<Integer, List<T>>();
        int pageCount = allItems.size() == cellSize ? 0 : allItems.size() / cellSize;
        for (int i = 0; i <= pageCount; ++i) {
            ArrayList<T> pageItems = new ArrayList<T>();
            int down = cellSize * i;
            int up = down + cellSize;
            for (int valueIndex = down; valueIndex < up && valueIndex < allItems.size(); ++valueIndex) {
                T page = allItems.get(valueIndex);
                pageItems.add(page);
            }
            pages.put(i, pageItems);
        }
        return pages;
    }

    public static <T> T last(List<T> list) {
        return list == null || list.isEmpty() ? null : (T)list.get(list.size() - 1);
    }

    public static <T> T last(T[] array) {
        return array == null || array.length == 0 ? null : (T)array[array.length - 1];
    }

    public static List<String> getWorldNames() {
        ArrayList<String> worlds = new ArrayList<String>();
        for (World world : Bukkit.getWorlds()) {
            worlds.add(world.getName());
        }
        return worlds;
    }

    public static List<String> getPlayerNames() {
        return Common.getPlayerNames(true, null);
    }

    public static List<String> getPlayerNames(boolean includeVanished) {
        return Common.getPlayerNames(includeVanished, null);
    }

    public static List<String> getPlayerNames(boolean includeVanished, Player otherPlayer) {
        ArrayList<String> found = new ArrayList<String>();
        for (Player player : Remain.getOnlinePlayers()) {
            if (PlayerUtil.isVanished(player, otherPlayer) && !includeVanished) continue;
            found.add(player.getName());
        }
        return found;
    }

    public static List<String> getPlayerNicknames(boolean includeVanished) {
        return Common.getPlayerNicknames(includeVanished, null);
    }

    public static List<String> getPlayerNicknames(boolean includeVanished, Player otherPlayer) {
        ArrayList<String> found = new ArrayList<String>();
        for (Player player : Remain.getOnlinePlayers()) {
            if (PlayerUtil.isVanished(player, otherPlayer) && !includeVanished) continue;
            found.add(HookManager.getNickColorless((CommandSender)player));
        }
        return found;
    }

    public static <OLD, NEW> List<NEW> convert(Iterable<OLD> list, TypeConverter<OLD, NEW> converter) {
        ArrayList<NEW> copy = new ArrayList<NEW>();
        for (OLD old : list) {
            NEW result = converter.convert(old);
            if (result == null) continue;
            copy.add(converter.convert(old));
        }
        return copy;
    }

    public static <OLD, NEW> Set<NEW> convertSet(Iterable<OLD> list, TypeConverter<OLD, NEW> converter) {
        HashSet<NEW> copy = new HashSet<NEW>();
        for (OLD old : list) {
            NEW result = converter.convert(old);
            if (result == null) continue;
            copy.add(converter.convert(old));
        }
        return copy;
    }

    public static <OLD, NEW> StrictList<NEW> convertStrict(Iterable<OLD> list, TypeConverter<OLD, NEW> converter) {
        StrictList<NEW> copy = new StrictList<NEW>();
        for (OLD old : list) {
            copy.add(converter.convert(old));
        }
        return copy;
    }

    public static <OLD_KEY, OLD_VALUE, NEW_KEY, NEW_VALUE> Map<NEW_KEY, NEW_VALUE> convert(Map<OLD_KEY, OLD_VALUE> oldMap, MapToMapConverter<OLD_KEY, OLD_VALUE, NEW_KEY, NEW_VALUE> converter) {
        HashMap newMap = new HashMap();
        oldMap.entrySet().forEach(e -> newMap.put(converter.convertKey(e.getKey()), converter.convertValue(e.getValue())));
        return newMap;
    }

    public static <OLD_KEY, OLD_VALUE, NEW_KEY, NEW_VALUE> StrictMap<NEW_KEY, NEW_VALUE> convertStrict(Map<OLD_KEY, OLD_VALUE> oldMap, MapToMapConverter<OLD_KEY, OLD_VALUE, NEW_KEY, NEW_VALUE> converter) {
        StrictMap newMap = new StrictMap();
        oldMap.entrySet().forEach(e -> newMap.put(converter.convertKey(e.getKey()), converter.convertValue(e.getValue())));
        return newMap;
    }

    public static <LIST_KEY, OLD_KEY, OLD_VALUE> StrictList<LIST_KEY> convertToList(Map<OLD_KEY, OLD_VALUE> map, MapToListConverter<LIST_KEY, OLD_KEY, OLD_VALUE> converter) {
        StrictList<LIST_KEY> list = new StrictList<LIST_KEY>();
        for (Map.Entry<OLD_KEY, OLD_VALUE> e : map.entrySet()) {
            list.add(converter.convert(e.getKey(), e.getValue()));
        }
        return list;
    }

    public static <OLD_TYPE, NEW_TYPE> List<NEW_TYPE> convert(OLD_TYPE[] oldArray, TypeConverter<OLD_TYPE, NEW_TYPE> converter) {
        ArrayList<NEW_TYPE> newList = new ArrayList<NEW_TYPE>();
        for (OLD_TYPE old : oldArray) {
            newList.add(converter.convert(old));
        }
        return newList;
    }

    public static String[] split(String input, int maxLineLength) {
        StringTokenizer tok = new StringTokenizer(input, " ");
        StringBuilder output = new StringBuilder(input.length());
        int lineLen = 0;
        while (tok.hasMoreTokens()) {
            String word = tok.nextToken();
            if (lineLen + word.length() > maxLineLength) {
                output.append("\n");
                lineLen = 0;
            }
            output.append(word + " ");
            lineLen += word.length() + 1;
        }
        return output.toString().split("\n");
    }

    public static <T> List<T> removeNullAndEmpty(T[] array) {
        return array != null ? Common.removeNullAndEmpty(Arrays.asList(array)) : new ArrayList();
    }

    public static <T> List<T> removeNullAndEmpty(List<T> list) {
        ArrayList<T> copy = new ArrayList<T>();
        for (T key : list) {
            if (key == null) continue;
            if (key instanceof String) {
                if (((String)key).isEmpty()) continue;
                copy.add(key);
                continue;
            }
            copy.add(key);
        }
        return copy;
    }

    public static String[] replaceNullWithEmpty(String[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (list[i] != null) continue;
            list[i] = "";
        }
        return list;
    }

    public static <T> T getOrDefault(T[] array, int index, T def) {
        return index < array.length ? array[index] : def;
    }

    public static String getOrEmpty(String input) {
        return input == null || "none".equalsIgnoreCase(input) ? "" : input;
    }

    public static String getOrNull(String input) {
        return input == null || "none".equalsIgnoreCase(input) || input.isEmpty() ? null : input;
    }

    public static <T> T getOrDefault(T value, T def) {
        if (value instanceof String && ("none".equalsIgnoreCase((String)value) || "".equals(value))) {
            return def;
        }
        return Common.getOrDefaultStrict(value, def);
    }

    public static <T> T getOrDefaultStrict(T value, T def) {
        return value != null ? value : def;
    }

    public static <T> T getNext(T given, List<T> list, boolean forward) {
        if (given == null && list.isEmpty()) {
            return null;
        }
        Object[] array = (Object[])Array.newInstance((given != null ? given : list.get(0)).getClass(), list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return (T)Common.getNext(given, array, forward);
    }

    public static <T> T getNext(T given, T[] array, boolean forward) {
        if (array.length == 0) {
            return null;
        }
        int index = 0;
        for (int i = 0; i < array.length; ++i) {
            T element = array[i];
            if (!element.equals(given)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            int nextIndex = index + (forward ? 1 : -1);
            return nextIndex >= array.length ? array[0] : (nextIndex < 0 ? array[array.length - 1] : array[nextIndex]);
        }
        return null;
    }

    public static String[] toArray(Collection<String> array) {
        return array == null ? new String[]{} : array.toArray(new String[array.size()]);
    }

    public static <T> ArrayList<T> toList(T ... array) {
        return array == null ? new ArrayList() : new ArrayList<T>(Arrays.asList(array));
    }

    public static <T> List<T> toList(Iterable<T> it) {
        ArrayList list = new ArrayList();
        if (it != null) {
            it.forEach(el -> {
                if (el != null) {
                    list.add(el);
                }
            });
        }
        return list;
    }

    public static <T> T[] reverse(T[] array) {
        if (array == null) {
            return null;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            T tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static <A, B> Map<A, B> newHashMap(A firstKey, B firstValue) {
        HashMap<A, B> map = new HashMap<A, B>();
        map.put(firstKey, firstValue);
        return map;
    }

    public static <T> Set<T> newSet(T ... keys) {
        return new HashSet<T>(Arrays.asList(keys));
    }

    public static <T> List<T> newList(T ... keys) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, keys);
        return list;
    }

    public static <T extends Runnable> BukkitTask runLater(T task) {
        return Common.runLater(1, task);
    }

    public static BukkitTask runLater(int delayTicks, Runnable task) {
        BukkitScheduler scheduler = Bukkit.getScheduler();
        SimplePlugin instance = SimplePlugin.getInstance();
        try {
            return Common.runIfDisabled(task) ? null : (delayTicks == 0 ? (task instanceof BukkitRunnable ? ((BukkitRunnable)task).runTask((Plugin)instance) : scheduler.runTask((Plugin)instance, task)) : (task instanceof BukkitRunnable ? ((BukkitRunnable)task).runTaskLater((Plugin)instance, (long)delayTicks) : scheduler.runTaskLater((Plugin)instance, task, (long)delayTicks)));
        }
        catch (NoSuchMethodError err) {
            return Common.runIfDisabled(task) ? null : (delayTicks == 0 ? (task instanceof BukkitRunnable ? ((BukkitRunnable)task).runTask((Plugin)instance) : Common.getTaskFromId(scheduler.scheduleSyncDelayedTask((Plugin)instance, task))) : (task instanceof BukkitRunnable ? ((BukkitRunnable)task).runTaskLater((Plugin)instance, (long)delayTicks) : Common.getTaskFromId(scheduler.scheduleSyncDelayedTask((Plugin)instance, task, (long)delayTicks))));
        }
    }

    public static BukkitTask runAsync(Runnable task) {
        return Common.runLaterAsync(0, task);
    }

    public static BukkitTask runLaterAsync(Runnable task) {
        return Common.runLaterAsync(0, task);
    }

    public static BukkitTask runLaterAsync(int delayTicks, Runnable task) {
        BukkitScheduler scheduler = Bukkit.getScheduler();
        SimplePlugin instance = SimplePlugin.getInstance();
        try {
            return Common.runIfDisabled(task) ? null : (delayTicks == 0 ? (task instanceof BukkitRunnable ? ((BukkitRunnable)task).runTaskAsynchronously((Plugin)instance) : scheduler.runTaskAsynchronously((Plugin)instance, task)) : (task instanceof BukkitRunnable ? ((BukkitRunnable)task).runTaskLaterAsynchronously((Plugin)instance, (long)delayTicks) : scheduler.runTaskLaterAsynchronously((Plugin)instance, task, (long)delayTicks)));
        }
        catch (NoSuchMethodError err) {
            return Common.runIfDisabled(task) ? null : (delayTicks == 0 ? Common.getTaskFromId(scheduler.scheduleAsyncDelayedTask((Plugin)instance, task)) : Common.getTaskFromId(scheduler.scheduleAsyncDelayedTask((Plugin)instance, task, (long)delayTicks)));
        }
    }

    public static BukkitTask runTimer(int repeatTicks, Runnable task) {
        return Common.runTimer(0, repeatTicks, task);
    }

    public static BukkitTask runTimer(int delayTicks, int repeatTicks, Runnable task) {
        try {
            return Common.runIfDisabled(task) ? null : (task instanceof BukkitRunnable ? ((BukkitRunnable)task).runTaskTimer((Plugin)SimplePlugin.getInstance(), (long)delayTicks, (long)repeatTicks) : Bukkit.getScheduler().runTaskTimer((Plugin)SimplePlugin.getInstance(), task, (long)delayTicks, (long)repeatTicks));
        }
        catch (NoSuchMethodError err) {
            return Common.runIfDisabled(task) ? null : Common.getTaskFromId(Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)SimplePlugin.getInstance(), task, (long)delayTicks, (long)repeatTicks));
        }
    }

    public static BukkitTask runTimerAsync(int repeatTicks, Runnable task) {
        return Common.runTimerAsync(0, repeatTicks, task);
    }

    public static BukkitTask runTimerAsync(int delayTicks, int repeatTicks, Runnable task) {
        try {
            return Common.runIfDisabled(task) ? null : (task instanceof BukkitRunnable ? ((BukkitRunnable)task).runTaskTimerAsynchronously((Plugin)SimplePlugin.getInstance(), (long)delayTicks, (long)repeatTicks) : Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)SimplePlugin.getInstance(), task, (long)delayTicks, (long)repeatTicks));
        }
        catch (NoSuchMethodError err) {
            return Common.runIfDisabled(task) ? null : Common.getTaskFromId(Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)SimplePlugin.getInstance(), task, (long)delayTicks, (long)repeatTicks));
        }
    }

    private static BukkitTask getTaskFromId(int taskId) {
        for (BukkitTask task : Bukkit.getScheduler().getPendingTasks()) {
            if (task.getTaskId() != taskId) continue;
            return task;
        }
        return null;
    }

    private static boolean runIfDisabled(Runnable run) {
        if (!SimplePlugin.getInstance().isEnabled()) {
            run.run();
            return true;
        }
        return false;
    }

    public static boolean callEvent(Event event) {
        Bukkit.getPluginManager().callEvent(event);
        return event instanceof Cancellable ? !((Cancellable)event).isCancelled() : true;
    }

    public static void registerEvents(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)SimplePlugin.getInstance());
    }

    public static Map<String, Object> getMapFromSection(@NonNull Object mapOrSection) {
        if (mapOrSection == null) {
            throw new NullPointerException("mapOrSection is marked non-null but is null");
        }
        Map map = (mapOrSection = Remain.getRootOfSectionPathData(mapOrSection)) instanceof ConfigSection ? ((ConfigSection)mapOrSection).getValues(false) : (mapOrSection instanceof Map ? (Map)mapOrSection : (mapOrSection instanceof MemorySection ? (Map)ReflectionUtil.getFieldContent(mapOrSection, "map") : null));
        Valid.checkNotNull(map, "Unexpected " + mapOrSection.getClass().getSimpleName() + " '" + mapOrSection + "'. Must be Map or MemorySection! (Do not just send config name here, but the actual section with get('section'))");
        LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            copy.put(key, Remain.getRootOfSectionPathData(value));
        }
        return copy;
    }

    public static boolean isDomainReachable(String url, int timeout) {
        url = url.replaceFirst("^https", "http");
        try {
            HttpURLConnection c = (HttpURLConnection)new URL(url).openConnection();
            c.setConnectTimeout(timeout);
            c.setReadTimeout(timeout);
            c.setRequestMethod("HEAD");
            int responseCode = c.getResponseCode();
            return 200 <= responseCode && responseCode <= 399;
        }
        catch (IOException exception) {
            return false;
        }
    }

    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private Common() {
    }

    public static String getTellPrefix() {
        return tellPrefix;
    }

    public static String getLogPrefix() {
        return logPrefix;
    }

    public static interface Stringer<T> {
        public String toString(T var1);
    }

    public static interface TypeConverter<Old, New> {
        public New convert(Old var1);
    }

    public static interface MapToMapConverter<A, B, C, D> {
        public C convertKey(A var1);

        public D convertValue(B var1);
    }

    public static interface MapToListConverter<O, K, V> {
        public O convert(K var1, V var2);
    }
}

