/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib;

import java.awt.Color;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.DefaultFontInfo;
import sk.adonikeoffice.epicchat.lib.MathUtil;
import sk.adonikeoffice.epicchat.lib.MinecraftVersion;
import sk.adonikeoffice.epicchat.lib.RandomUtil;
import sk.adonikeoffice.epicchat.lib.model.Whiteblacklist;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.CompChatColor;

public final class ChatUtil {
    public static final int CENTER_PX = 152;
    public static final int VISIBLE_CHAT_LINES = 20;

    public static String center(String message) {
        return ChatUtil.center(message, ' ');
    }

    public static String center(String message, int centerPx) {
        return ChatUtil.center(message, ' ', centerPx);
    }

    public static String center(String message, char space) {
        return ChatUtil.center(message, space, 152);
    }

    public static String center(String message, char space, int centerPx) {
        if (message == null || message.equals("")) {
            return "";
        }
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '&' || c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                if (c == 'l' || c == 'L') {
                    isBold = true;
                    continue;
                }
                isBold = false;
                continue;
            }
            DefaultFontInfo defaultFont = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? defaultFont.getBoldLength() : defaultFont.getLength();
            ++messagePxSize;
        }
        StringBuilder builder = new StringBuilder();
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = centerPx - halvedMessageSize;
        DefaultFontInfo font = DefaultFontInfo.getDefaultFontInfo(space);
        double spaceLength = isBold ? (double)font.getBoldLength() : (double)font.getLength();
        for (double compensated = 0.0; compensated < (double)toCompensate; compensated += spaceLength) {
            builder.append(" ");
        }
        return builder.toString() + " " + message + " " + builder.toString();
    }

    public static String[] verticalCenter(String ... messages) {
        return ChatUtil.verticalCenter(Arrays.asList(messages));
    }

    public static String[] verticalCenter(Collection<String> messages) {
        ArrayList<String> lines = new ArrayList<String>();
        long padding = MathUtil.ceiling((20 - messages.size()) / 2);
        int i = 0;
        while ((long)i < padding) {
            lines.add(RandomUtil.nextColorOrDecoration());
            ++i;
        }
        lines.addAll(messages);
        i = 0;
        while ((long)i < padding) {
            lines.add(RandomUtil.nextColorOrDecoration());
            ++i;
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static String insertDot(String message) {
        if (message.isEmpty()) {
            return "";
        }
        String lastChar = message.substring(message.length() - 1);
        String[] words = message.split("\\s");
        String lastWord = words[words.length - 1];
        if (!ChatUtil.isDomain(lastWord) && lastChar.matches("(?i)[a-z\u0400-\u04ff]")) {
            message = message + ".";
        }
        return message;
    }

    public static String capitalizeFirst(String message) {
        if (message.isEmpty()) {
            return "";
        }
        String[] sentences = message.split("(?<=[!?\\.])\\s");
        String tempMessage = "";
        for (String sentence : sentences) {
            try {
                String word = message.split("\\s")[0];
                if (!ChatUtil.isDomain(word)) {
                    sentence = sentence.substring(0, 1).toUpperCase() + sentence.substring(1);
                }
                tempMessage = tempMessage + sentence + " ";
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return tempMessage.trim();
    }

    public static String capitalizeFully(String str) {
        return ChatUtil.capitalizeFully(str, null);
    }

    private static String capitalizeFully(String str, char[] delimiters) {
        int delimLen;
        int n = delimLen = delimiters == null ? -1 : delimiters.length;
        if (str != null && str.length() != 0 && delimLen != 0) {
            str = str.toLowerCase();
            return ChatUtil.capitalize(str, delimiters);
        }
        return str;
    }

    public static String capitalize(String str) {
        return ChatUtil.capitalize(str, null);
    }

    private static String capitalize(String str, char[] delimiters) {
        int delimLen;
        int n = delimLen = delimiters == null ? -1 : delimiters.length;
        if (str != null && str.length() != 0 && delimLen != 0) {
            int strLen = str.length();
            StringBuffer buffer = new StringBuffer(strLen);
            boolean capitalizeNext = true;
            for (int i = 0; i < strLen; ++i) {
                char ch = str.charAt(i);
                if (ChatUtil.isDelimiter(ch, delimiters)) {
                    buffer.append(ch);
                    capitalizeNext = true;
                    continue;
                }
                if (capitalizeNext) {
                    buffer.append(Character.toTitleCase(ch));
                    capitalizeNext = false;
                    continue;
                }
                buffer.append(ch);
            }
            return buffer.toString();
        }
        return str;
    }

    private static boolean isDelimiter(char ch, char[] delimiters) {
        if (delimiters == null) {
            return Character.isWhitespace(ch);
        }
        int isize = delimiters.length;
        for (int i = 0; i < isize; ++i) {
            if (ch != delimiters[i]) continue;
            return true;
        }
        return false;
    }

    public static String lowercaseSecondChar(String message) {
        if (message.isEmpty()) {
            return "";
        }
        String[] sentences = message.split("(?<=[!?\\.])\\s");
        String tempMessage = "";
        for (String sentence : sentences) {
            try {
                if (sentence.length() > 2 && !ChatUtil.isDomain(message.split("\\s")[0]) && sentence.length() > 2 && Character.isUpperCase(sentence.charAt(0)) && Character.isLowerCase(sentence.charAt(2))) {
                    sentence = sentence.substring(0, 1) + sentence.substring(1, 2).toLowerCase() + sentence.substring(2);
                }
                tempMessage = tempMessage + sentence + " ";
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return tempMessage.trim();
    }

    public static String quoteReplacement(String message) {
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < message.length(); ++index) {
            char c = message.charAt(index);
            if (c == ' ' || c == '\\' || c == '$' || c == '(' || c == ')' || c == '+' || c == '.' || c == '-' || c == '_' || c == '^') {
                builder.append('\\');
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String removeEmoji(String message) {
        if (message == null) {
            return "";
        }
        String regex = "[^\\p{L}\\p{N}\\p{P}\\p{Z}]";
        Pattern pattern = Pattern.compile("[^\\p{L}\\p{N}\\p{P}\\p{Z}]", 256);
        Matcher matcher = pattern.matcher(message);
        return matcher.replaceAll("");
    }

    public static double getCapsPercentage(String message) {
        if (message.isEmpty()) {
            return 0.0;
        }
        String[] sentences = Common.stripColors(message).split(" ");
        String messageToCheck = "";
        double upperCount = 0.0;
        for (String sentence : sentences) {
            if (ChatUtil.isDomain(sentence)) continue;
            messageToCheck = messageToCheck + sentence + " ";
        }
        for (char ch : messageToCheck.toCharArray()) {
            if (!Character.isUpperCase(ch)) continue;
            upperCount += 1.0;
        }
        return upperCount / (double)messageToCheck.length();
    }

    public static int getCapsInRow(String message, List<String> ignored) {
        if (message.isEmpty()) {
            return 0;
        }
        int[] caps = ChatUtil.splitCaps(Common.stripColors(message), ignored);
        int sum = 0;
        int sumTemp = 0;
        for (int i : caps) {
            if (i == 1) {
                sum = Math.max(sum, ++sumTemp);
                continue;
            }
            sumTemp = 0;
        }
        return sum;
    }

    public static int getCapsInRow(String message, Whiteblacklist list) {
        if (message.isEmpty()) {
            return 0;
        }
        int[] caps = ChatUtil.splitCaps(Common.stripColors(message), list);
        int sum = 0;
        int sumTemp = 0;
        for (int i : caps) {
            if (i == 1) {
                sum = Math.max(sum, ++sumTemp);
                continue;
            }
            sumTemp = 0;
        }
        return sum;
    }

    public static double getSimilarityPercentage(String first, String second) {
        int longerLength;
        if (first.isEmpty() && second.isEmpty()) {
            return 1.0;
        }
        first = ChatUtil.removeSimilarity(first);
        second = ChatUtil.removeSimilarity(second);
        String longer = first;
        String shorter = second;
        if (first.length() < second.length()) {
            longer = second;
            shorter = first;
        }
        if ((longerLength = longer.length()) == 0) {
            return 0.0;
        }
        return (double)(longerLength - ChatUtil.editDistance(longer, shorter)) / (double)longerLength;
    }

    private static String removeSimilarity(String message) {
        if (SimplePlugin.getInstance().similarityStripAccents()) {
            message = ChatUtil.replaceDiacritic(message);
        }
        message = Common.stripColors(message);
        message = message.toLowerCase();
        return message;
    }

    public static boolean isDomain(String message) {
        return Common.regExMatch("(https?:\\/\\/(?:www\\.|(?!www))[^\\s\\.]+\\.[^\\s]{2,}|www\\.[^\\s]+\\.[^\\s]{2,})", message);
    }

    public static String replaceDiacritic(String message) {
        return Normalizer.normalize(message, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    public static boolean isInteractive(String msg) {
        return msg.startsWith("[JSON]") || msg.startsWith("<toast>") || msg.startsWith("<title>") || msg.startsWith("<actionbar>") || msg.startsWith("<bossbar>");
    }

    public static String generateGradient(String message, CompChatColor from, CompChatColor to) {
        if (!MinecraftVersion.atLeast(MinecraftVersion.V.v1_16)) {
            return message;
        }
        Color color1 = from.getColor();
        Color color2 = to.getColor();
        char[] letters = message.toCharArray();
        String gradient = "";
        ChatColor lastDecoration = null;
        for (int i = 0; i < letters.length; ++i) {
            char letter = letters[i];
            if (letter == '\u00a7' && i + 1 < letters.length) {
                char decoration = letters[i + 1];
                if (decoration == 'k') {
                    lastDecoration = ChatColor.MAGIC;
                } else if (decoration == 'l') {
                    lastDecoration = ChatColor.BOLD;
                } else if (decoration == 'm') {
                    lastDecoration = ChatColor.STRIKETHROUGH;
                } else if (decoration == 'n') {
                    lastDecoration = ChatColor.UNDERLINE;
                } else if (decoration == 'o') {
                    lastDecoration = ChatColor.ITALIC;
                } else if (decoration == 'r') {
                    lastDecoration = null;
                }
                ++i;
                continue;
            }
            float ratio = (float)i / (float)letters.length;
            int red = (int)((float)color2.getRed() * ratio + (float)color1.getRed() * (1.0f - ratio));
            int green = (int)((float)color2.getGreen() * ratio + (float)color1.getGreen() * (1.0f - ratio));
            int blue = (int)((float)color2.getBlue() * ratio + (float)color1.getBlue() * (1.0f - ratio));
            Color stepColor = new Color(red, green, blue);
            gradient = gradient + CompChatColor.of(stepColor).toString() + (lastDecoration == null ? "" : lastDecoration.toString()) + letters[i];
        }
        return gradient;
    }

    private static int editDistance(String first, String second) {
        first = first.toLowerCase();
        second = second.toLowerCase();
        int[] costs = new int[second.length() + 1];
        for (int i = 0; i <= first.length(); ++i) {
            int lastValue = i;
            for (int j = 0; j <= second.length(); ++j) {
                if (i == 0) {
                    costs[j] = j;
                    continue;
                }
                if (j <= 0) continue;
                int newValue = costs[j - 1];
                if (first.charAt(i - 1) != second.charAt(j - 1)) {
                    newValue = Math.min(Math.min(newValue, lastValue), costs[j]) + 1;
                }
                costs[j - 1] = lastValue;
                lastValue = newValue;
            }
            if (i <= 0) continue;
            costs[second.length()] = lastValue;
        }
        return costs[second.length()];
    }

    private static int[] splitCaps(String message, List<String> ignored) {
        int i;
        int[] editedMsg = new int[message.length()];
        CharSequence[] parts = message.split(" ");
        for (i = 0; i < parts.length; ++i) {
            for (String whitelisted : ignored) {
                if (!whitelisted.equalsIgnoreCase((String)parts[i])) continue;
                parts[i] = ((String)parts[i]).toLowerCase();
            }
        }
        for (i = 0; i < parts.length; ++i) {
            if (!ChatUtil.isDomain(parts[i])) continue;
            parts[i] = ((String)parts[i]).toLowerCase();
        }
        String msg = String.join((CharSequence)" ", parts);
        for (int i2 = 0; i2 < msg.length(); ++i2) {
            editedMsg[i2] = Character.isUpperCase(msg.charAt(i2)) && Character.isLetter(msg.charAt(i2)) ? 1 : 0;
        }
        return editedMsg;
    }

    private static int[] splitCaps(String message, Whiteblacklist list) {
        int i;
        int[] editedMsg = new int[message.length()];
        CharSequence[] parts = message.split(" ");
        for (i = 0; i < parts.length; ++i) {
            if (!list.isInList(parts[i])) continue;
            parts[i] = ((String)parts[i]).toLowerCase();
        }
        for (i = 0; i < parts.length; ++i) {
            if (!ChatUtil.isDomain(parts[i])) continue;
            parts[i] = ((String)parts[i]).toLowerCase();
        }
        String msg = String.join((CharSequence)" ", parts);
        for (int i2 = 0; i2 < msg.length(); ++i2) {
            editedMsg[i2] = Character.isUpperCase(msg.charAt(i2)) && Character.isLetter(msg.charAt(i2)) ? 1 : 0;
        }
        return editedMsg;
    }

    private ChatUtil() {
    }
}

