/*
 * Decompiled with CFR 0.152.
 */
package sk.adonikeoffice.epicchat.lib;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.UUID;
import lombok.NonNull;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.ChannelNotRegisteredException;
import org.bukkit.plugin.messaging.MessageTooLargeException;
import sk.adonikeoffice.epicchat.lib.Common;
import sk.adonikeoffice.epicchat.lib.Valid;
import sk.adonikeoffice.epicchat.lib.bungee.BungeeListener;
import sk.adonikeoffice.epicchat.lib.bungee.BungeeMessageType;
import sk.adonikeoffice.epicchat.lib.collection.SerializedMap;
import sk.adonikeoffice.epicchat.lib.debug.Debugger;
import sk.adonikeoffice.epicchat.lib.exception.FoException;
import sk.adonikeoffice.epicchat.lib.plugin.SimplePlugin;
import sk.adonikeoffice.epicchat.lib.remain.Remain;

public final class BungeeUtil {
    @SafeVarargs
    public static <T> void sendPluginMessage(BungeeMessageType action, T ... datas) {
        BungeeListener bungee = SimplePlugin.getInstance().getBungeeCord();
        Valid.checkNotNull(bungee, "Cannot call tellBungee() without channel name because " + ((Object)((Object)SimplePlugin.getInstance())).getClass() + " does not implement getBungeeCord()!");
        BungeeUtil.sendPluginMessage(bungee.getChannel(), action, datas);
    }

    @SafeVarargs
    public static <T> void sendPluginMessage(String channel, BungeeMessageType action, T ... data) {
        BungeeUtil.sendPluginMessage(null, channel, action, data);
    }

    @SafeVarargs
    public static <T> void sendPluginMessage(Player sender, String channel, BungeeMessageType action, T ... data) {
        Valid.checkBoolean(data.length == action.getContent().length, "Data count != valid values count in " + action + "! Given data: " + data.length + " vs needed: " + action.getContent().length, new Object[0]);
        Valid.checkBoolean(Remain.isServerNameChanged(), "Please configure your 'server-name' in server.properties according to mineacademy.org/server-properties first before using BungeeCord features", new Object[0]);
        if (!action.name().equals("PLAYERS_CLUSTER_DATA")) {
            Debugger.put("bungee", "Server '" + Remain.getServerName() + "' sent bungee message [" + channel + ", " + action + "]: ");
        }
        if (sender == null) {
            sender = BungeeUtil.findFirstPlayer();
        }
        if (sender == null) {
            Debugger.put("bungee", "Cannot send " + action + " bungee channel '" + channel + "' message because this server has no players");
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(sender.getUniqueId().toString());
        out.writeUTF(Remain.getServerName());
        out.writeUTF(action.toString());
        int actionHead = 0;
        for (Object datum : data) {
            try {
                Valid.checkNotNull(datum, "Bungee object in array is null! Array: " + Common.join(data, ", ", t -> t == null ? "null" : t.toString() + " (" + t.getClass().getSimpleName() + ")"));
                if (datum instanceof CommandSender) {
                    datum = ((CommandSender)datum).getName();
                }
                if (datum instanceof Integer) {
                    Debugger.put("bungee", datum.toString() + ", ");
                    BungeeUtil.moveHead(actionHead, action, Integer.class, data);
                    out.writeInt(((Integer)datum).intValue());
                } else if (datum instanceof Double) {
                    Debugger.put("bungee", datum.toString() + ", ");
                    BungeeUtil.moveHead(actionHead, action, Double.class, data);
                    out.writeDouble(((Double)datum).doubleValue());
                } else if (datum instanceof Long) {
                    Debugger.put("bungee", datum.toString() + ", ");
                    BungeeUtil.moveHead(actionHead, action, Long.class, data);
                    out.writeLong(((Long)datum).longValue());
                } else if (datum instanceof Boolean) {
                    Debugger.put("bungee", datum.toString() + ", ");
                    BungeeUtil.moveHead(actionHead, action, Boolean.class, data);
                    out.writeBoolean(((Boolean)datum).booleanValue());
                } else if (datum instanceof String) {
                    Debugger.put("bungee", datum.toString() + ", ");
                    BungeeUtil.moveHead(actionHead, action, String.class, data);
                    try {
                        out.writeUTF((String)datum);
                    }
                    catch (Throwable t2) {
                        if (t2.getMessage().contains("too long")) {
                            Common.throwError(t2, "Too long BungeeCord message to send (" + ((String)datum).length() + ")! Message: ", (String)datum);
                        }
                        throw t2;
                    }
                } else if (datum instanceof SerializedMap) {
                    Debugger.put("bungee", datum.toString() + ", ");
                    BungeeUtil.moveHead(actionHead, action, String.class, data);
                    out.writeUTF(((SerializedMap)datum).toJson());
                } else if (datum instanceof UUID) {
                    Debugger.put("bungee", datum.toString() + ", ");
                    BungeeUtil.moveHead(actionHead, action, UUID.class, data);
                    out.writeUTF(((UUID)datum).toString());
                } else if (datum instanceof Enum) {
                    Debugger.put("bungee", datum.toString() + ", ");
                    BungeeUtil.moveHead(actionHead, action, Enum.class, data);
                    out.writeUTF(((Enum)datum).toString());
                } else if (datum instanceof byte[]) {
                    Debugger.put("bungee", datum.toString() + ", ");
                    BungeeUtil.moveHead(actionHead, action, String.class, data);
                    out.write((byte[])datum);
                } else {
                    throw new FoException("Unknown type of data: " + datum + " (" + datum.getClass().getSimpleName() + ")");
                }
                ++actionHead;
            }
            catch (Throwable t3) {
                t3.printStackTrace();
                return;
            }
        }
        Debugger.push("bungee");
        byte[] byteArray = out.toByteArray();
        try {
            sender.sendPluginMessage((Plugin)SimplePlugin.getInstance(), channel, byteArray);
        }
        catch (ChannelNotRegisteredException ex) {
            Common.log("Cannot send Bungee '" + action + "' message because channel '" + channel + "' is not registered. Use @AutoRegister above your class extending BungeeListener and return its instance in getBungeeCord in your main plugin class.");
        }
        catch (MessageTooLargeException ex) {
            Common.log("Outgoing bungee message '" + action + "' was oversized, not sending. Max length: 32766 bytes, got " + byteArray.length + " bytes.");
        }
        actionHead = 0;
    }

    public static void connect(@NonNull Player player, @NonNull String serverName) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName is marked non-null but is null");
        }
        BungeeUtil.sendBungeeMessage(player, "Connect", serverName);
    }

    public static void sendBungeeMessage(@NonNull Player sender, Object ... data) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        Valid.checkBoolean(data != null && data.length >= 1, "", new Object[0]);
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        for (Object datum : data) {
            Valid.checkNotNull(datum, "Bungee object in array is null! Array: " + Common.join(data, ", ", t -> t == null ? "null" : t.toString() + "(" + t.getClass().getSimpleName() + ")"));
            if (datum instanceof Integer) {
                out.writeInt(((Integer)datum).intValue());
                continue;
            }
            if (datum instanceof Double) {
                out.writeDouble(((Double)datum).doubleValue());
                continue;
            }
            if (datum instanceof Boolean) {
                out.writeBoolean(((Boolean)datum).booleanValue());
                continue;
            }
            if (datum instanceof String) {
                out.writeUTF((String)datum);
                continue;
            }
            throw new FoException("Unknown type of data: " + datum + " (" + datum.getClass().getSimpleName() + ")");
        }
        sender.sendPluginMessage((Plugin)SimplePlugin.getInstance(), "BungeeCord", out.toByteArray());
    }

    private static Player findFirstPlayer() {
        return Remain.getOnlinePlayers().isEmpty() ? null : Remain.getOnlinePlayers().iterator().next();
    }

    private static void moveHead(int actionHead, BungeeMessageType action, Class<?> typeOf, Object[] data) throws Throwable {
        Valid.checkNotNull(action, "Action not set!");
        Class<?>[] content = action.getContent();
        Valid.checkBoolean(actionHead < content.length, "Head out of bounds! Max data size for " + action.name() + " is " + content.length + "! Set Debug to [bungee] in settings.yml and report. Data length: " + data.length + " data: " + Common.join(data), new Object[0]);
    }

    private BungeeUtil() {
    }
}

